<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class CMS extends CI_Controller {

	public function __construct() {
		parent::__construct();
        date_default_timezone_set("Asia/Riyadh");
		$this->load->model('Cms_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
		if($this->session->userdata['user_type'] != 1){
			$flashMsg = array('message'=>'Access Denied You don\'t have permission to access this Page',
							  'class'=>'error');
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url());
		}
 	}
	
	public function index() {

		$template['page'] = 'CMS/cms_management';
		$template['menu'] = "CMS Settings";
		$template['smenu'] = "Change CMS Data";
        $template['pTitle'] = "CMS";
        $template['page_head'] = "Booking Management";
        $template['pDescription'] = "Edit or View CMS Data";

		$template['cmsData'] = $this->Cms_model->getCMSdata();
		$this->load->view('template',$template);
	}

	public function changeCMSdata(){
		$url = 'CMS';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url($url));
		}
	    
	    if(!isset($_POST['faq_en']) || empty($_POST['faq_en'])){
			unset($_POST['faq_en']);
		}
	    if(!isset($_POST['faq_ar']) || empty($_POST['faq_ar'])){
			unset($_POST['faq_ar']);
		}
		if(!isset($_POST['instruction_en']) || empty($_POST['instruction_en'])){
			unset($_POST['instruction_en']);
		}
		if(!isset($_POST['instruction_ar']) || empty($_POST['instruction_ar'])){
			unset($_POST['instruction_ar']);
		}
		if(!isset($_POST['privacy_policy_en']) || empty($_POST['privacy_policy_en'])){
			unset($_POST['privacy_policy_en']);
		}
		if(!isset($_POST['privacy_policy_ar']) || empty($_POST['privacy_policy_ar'])){
			unset($_POST['privacy_policy_ar']);
		}
		if(!isset($_POST['terms_and_conditions_en']) || empty($_POST['terms_and_conditions_en'])){
			unset($_POST['terms_and_conditions_en']);
		}
		if(!isset($_POST['terms_and_conditions_ar']) || empty($_POST['terms_and_conditions_ar'])){
			unset($_POST['terms_and_conditions_ar']);
		}

        $status = $this->Cms_model->updateCMS($_POST);
 		if($status){
 			$flashMsg['class'] = 'success'; 
 			$flashMsg['message'] = 'Settings Successfully Updated..!';
 		}
 		$this->session->set_flashdata('message',$flashMsg);
        redirect(base_url($url));
	}
}
?>