<?php 
class Booking_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
 	}

 	public function getBookingData($booking_id='',$provider_id='',$view='0,1,2,3,5'){
 		$cond  = (!empty($view))?" BOK.status IN ($view) ":" BOK.status != '4' ";
 		$cond .= (!empty($booking_id))?" AND BOK.id='$booking_id' ":"";
 		$cond .= (!empty($provider_id))?" AND EVT.provider_id='$provider_id' ":"";

 		$sql = "SELECT BOK.id AS booking_id,CUST.customer_id,CUST.name AS customer_name,
					   CUST.phone AS customer_phone,CUST.email AS customer_email,CUST.gender,
					   CUST.dob,CUST.city,CUST.profile_image,BOK.event_id,BOK.bookId,BOK.event_date_id,
					   BOK.qrcode,BOK.no_of_ticket,BOK.ticket_details,BOK.amount,
					   BOK.reserved_by,BOK.status AS book_status,EVT.venue_id,EVT.category_id,
					   EVT.provider_id,EVT.event_name_en,EVT.event_description_en,EVT.has_payment,
					   EVT.max_booking,EVT.seat_pricing,EVT.custom_seat_layout,EVT.status AS evt_status,
					   HCAT.host_category,HCAT.show_layout,EDT.date,EDT.time,ECAT.category_en,
					   ECAT.category_description,ECAT.category_image_en,PRV.name AS provider_name,
					   PRV.email AS provider_email,PRV.phone AS provider_phone,
					   PRV.profile_image AS provider_image,VEN.venue_name_en,VEN.venue_details,VEN.location,
					   TRANS.transaction_id,TRANS.status AS trans_status
			    FROM booking AS BOK 
			    INNER JOIN events AS EVT ON (EVT.event_id=BOK.event_id)
			    INNER JOIN customer AS CUST ON (CUST.customer_id=BOK.customer_id)
			    INNER JOIN event_category AS ECAT ON (ECAT.cat_id=EVT.category_id)
			    INNER JOIN venue AS VEN ON (VEN.id=EVT.venue_id)
			    INNER JOIN host_categories AS HCAT ON (HCAT.host_cat_id=VEN.host_cat_id)
			    INNER JOIN event_date_time AS EDT ON (EDT.id=BOK.event_date_id)
			    LEFT JOIN transaction AS TRANS ON (TRANS.booking_id=BOK.bookId)
		   		LEFT JOIN provider AS PRV ON (PRV.provider_id=EVT.provider_id)
			    WHERE $cond";

	    $bookingData = $this->db->query($sql);

	    if(!empty($bookingData)){
	    	return (empty($booking_id))?$bookingData->result():$bookingData->row();
	    }
	    return 0;
 	}

 	function changeStatus($booking_id = '', $status = '0'){
 		if(empty($booking_id)){
 			return 0;
 		}

 		$status = $this->db->update('booking',array('status'=>$status),array('id'=>$booking_id));
 		return $status;
 	}

 	function getDetailBookData($fields=array(),$where_cond=array()){
 		if(empty($fields)){
 			return 0;
 		}
 		$where_clause = '';
 		if(!empty($where_cond)){
 			if(!empty($where_cond['provider_id'])){
 				$where_clause = " WHERE EVT.provider_id = '".$where_cond['provider_id']."' ";
 			}
 			if(!empty($where_cond['start_date']) && !empty($where_cond['end_date'])){
 				$where_clause .= (empty($where_clause))?' WHERE ':' AND ';

 				$end_date = date('Y-m-d',strtotime(trim($where_cond['end_date']).' 24:59'));
 				$start_date = date('Y-m-d',strtotime(trim($where_cond['start_date']).' 12:00'));
 				$where_clause .= " BOK.booking_date >= '".$start_date."' AND 
 								   BOK.booking_date <= '".$end_date."' ";
 			}
 			if(!empty($where_cond['start_date'])){
 				$where_clause .= (empty($where_clause))?' WHERE ':' AND ';

 				$start_date = date('Y-m-d',strtotime(trim($where_cond['start_date']).' 12:00'));
 				$where_clause .= " BOK.booking_date >= '".$start_date."' ";
 			}
 			if(!empty($where_cond['end_date'])){
 				$where_clause .= (empty($where_clause))?' WHERE ':' AND ';

 				$end_date = date('Y-m-d',strtotime(trim($where_cond['end_date']).' 23:59'));
 				$where_clause .= " BOK.booking_date <= '".$end_date."' ";
 			}
 			if(!empty($where_cond['status'])){
 				$where_clause .= (empty($where_clause))?' WHERE ':' AND ';

 				$where_clause .= " BOK.status = '".$where_cond['status']."' ";
 			}
 		}
 		$fields = 'BOK.id AS Booking_ID,TRANS.transaction_id,TRANS.status AS trans_status,
 				   EVT.has_payment,'.$fields;
 		$sql = "SELECT ".$fields."
				    FROM booking AS BOK 
				    INNER JOIN events AS EVT ON (EVT.event_id=BOK.event_id)
				    INNER JOIN customer AS CUST ON (CUST.customer_id=BOK.customer_id)
				    INNER JOIN event_category AS ECAT ON (ECAT.cat_id=EVT.category_id)
				    INNER JOIN venue AS VEN ON (VEN.id=EVT.venue_id)
				    INNER JOIN host_categories AS HCAT ON (HCAT.host_cat_id=VEN.host_cat_id)
				    INNER JOIN event_date_time AS EDT ON (EDT.id=BOK.event_date_id)
				    INNER JOIN region AS REG ON (REG.id=VEN.region_id)
				    LEFT JOIN provider AS PRV ON (PRV.provider_id=EVT.provider_id)
			    	LEFT JOIN transaction AS TRANS ON (TRANS.booking_id=BOK.bookId)
 				".$where_clause."
 				GROUP BY Booking_ID
 				ORDER BY BOK.id ASC";
 		$data = $this->db->query($sql);
 		if(!empty($data)){
 			$resData = $data->result_array();
 			if(empty($resData)){
 				return 2;
 			}
 			return $resData;
 		}
 		return 0;
 	}
}
?>