<?php 
class Category_model extends CI_Model {
	public function _consruct(){
		parent::_construct();
 	}

 	public function getCategoryData($category_id='',$view=''){
 		$cond  = (!empty($view))?" status IN ($view) ":" status != '2' ";
 		$cond .= (!empty($category_id))?" AND cat_id='$category_id' ":"";

 		$categoryData = $this->db->query("SELECT * FROM event_category WHERE $cond ORDER BY priority");
 		if(empty($categoryData)){
 			return 0;
 		}

 		if(empty($category_id)){
 			$categoryData = $categoryData->result_array();
 			foreach ($categoryData AS $key => $data) {
 				$rtlData = langTranslator($data['cat_id'],'CAT');
 				$categoryData[$key] = array_merge($categoryData[$key],$rtlData);
 			}
 		} else {
			$categoryData = $categoryData->row_array();
			$rtlData = langTranslator($category_id,'CAT');
			$categoryData = array_merge($categoryData,$rtlData);
 		}
 		return json_decode(json_encode($categoryData));
 	}

 	public function createCategory($categoryData = array()){
 		if(empty($categoryData)){
 			return 0;
 		}
 		$status = $this->db->insert('event_category',array(
 												'category_banner'=>$categoryData['category_banner']));

 		if($status){
 			$cat_id = $this->db->insert_id();
 			$languages = getLanguages();
	 		if(!empty($languages)){
	 			$insertArr = array();
	 			foreach ($languages AS $lang) {
	 				if((!isset($categoryData['category_name_'.$lang]) ||
	 				   empty($categoryData['category_name_'.$lang])) && 
	 				   (!isset($categoryData['category_image_'.$lang]) || 
	 				   empty($categoryData['category_image_'.$lang]))){
	 					continue;
	 				}
	 				$catName = (isset($categoryData['category_name_'.$lang]) && !empty($categoryData['category_name_'.$lang]))?$categoryData['category_name_'.$lang]:'';
	 				$catImage = (isset($categoryData['category_image_'.$lang]) && !empty($categoryData['category_image_'.$lang]))?$categoryData['category_image_'.$lang]:'';

	 				$insertArr[] = array('category_id'=>$cat_id,
	 									 'category_name'=>$catName,
	 									 'language_code'=>$lang,
	 					                 'category_image'=>$catImage);
	 			}
	 			if(!empty($insertArr)){
	 				$this->db->insert_batch('translator_category',$insertArr);
	 			}
	 		}
 		}
 		return $status;
 	}

 	public function updateCategory($category_id = '', $categoryData = array()){
 		if(empty($category_id) || empty($categoryData)){
 			return 0;
 		}
 		$status = $this->db->update('event_category',$categoryData,array('cat_id'=>$category_id));
 		return $status;
 	}

 	public function changeStatus($category_id = '', $status = '0'){
 		if(empty($category_id)){
 			return 0;
 		}
 		$status = $this->db->update('event_category',array('status'=>$status),array('cat_id'=>$category_id));
 		return $status;
 	}

 	public function catReorder($catArray = array()){
 		if(empty($catArray)){
 			return 0;
 		}
 		$priority = 1;
 		foreach($catArray AS $cat_id) {
 			$this->db->update('event_category',array('priority'=>$priority),array('cat_id'=>$cat_id));
 			$priority += 1;
 		}
 		return 1;
 	}
}
?>