<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class HotelBooking extends CI_Controller {

	public function __construct() {
		parent::__construct();
    	date_default_timezone_set("Asia/Riyadh");
		$this->load->model('HotelBooking_model');

		if(!$this->session->userdata('logged_in')) {
			redirect(base_url());
		}
	}

	public function encode($val = ''){
		echo encode_param($val);
	}

	public function decode($val = ''){
		echo decode_param($val);
	}

	public function viewBookings(){
		$template['page'] = 'HotelBooking/viewBooking';
        $template['menu'] = 'Hotel Booking Management';
        $template['smenu'] = 'View Hotel Bookings';
        $template['pTitle'] = "View Hotel Bookings";
        $template['pDescription'] = "View and Manage Hotel Bookings";
        $template['page_head'] = "Hotel Booking Management";

        $template['booking_data'] = $this->HotelBooking_model->getHotelBookingData();
        //pr($template['booking_data']);
		$this->load->view('template',$template);
	}

	public function getHotelBookingData(){
		$resArr = array('status'=>0);
		if(!isset($_POST)||empty($_POST)||!isset($_POST['booking_id'])||empty($_POST['booking_id'])){
			echo json_encode($resArr);exit;
		}
		$bookData['bookData'] = $this->HotelBooking_model->getHotelBookingData(decode_param($_POST['booking_id']));

        $viewPage = $this->load->view('HotelBooking/viewHotelBookingDetails',$bookData,true);

        echo $viewPage;exit;
	}
}
?>
