<?php
defined('BASEPATH') OR exit('No direct script access allowed');
if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400'); 
    }

  if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
      header("Access-Control-Allow-Methods: GET, POST, OPTIONS");         

    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
      header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

    exit(0);
  }
//test changes
class HotelServices extends CI_Controller {
  var $auth_token;

  public function __construct() {
    parent::__construct();
    date_default_timezone_set("Asia/Riyadh");
    $this->load->model('HotelServices_model');   
    $this->load->model('Validation_hotel_model');
    $method = $this->router->fetch_method();  
    $data = (array) json_decode(file_get_contents('php://input'));
    if (isset(apache_request_headers()['Auth']) || isset(apache_request_headers()['auth'])) {
      $this->auth_token = (isset(apache_request_headers()['Auth']))?apache_request_headers()['Auth']:apache_request_headers()['auth'];
      $data['auth_token'] = $this->auth_token;
    }
    $res = $this->Validation_hotel_model->validation_check($method, $data);
    if($res['state'] == 1) {
      $this->errorResponse($res['response']['code'], $res['response']['message']);
      die;
    }     
  }

  public function response($data) {
    $result =  array(
      'status' => 'success',
      'data' =>$data
    );
    print json_encode($result);
  }

  public function successResponse($data='') {
    $result =  array(
      'status' => 'success',
    );
    print json_encode($result);
  }

  public function errorResponse($errorCode, $errorDesc) {
    $result =  array(
      'status' => 'error',
      'error'=> $errorCode,
      'message'=> $errorDesc
    );
    print json_encode($result);
  }

  public function get_hotel_city_list(){
    $data = $_GET;
    $res = $this->HotelServices_model->get_hotel_city_list($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function hotel_search(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->HotelServices_model->hotel_search($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function get_specific_hotel_content(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->HotelServices_model->get_specific_hotel_content($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function get_room_rates(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->HotelServices_model->get_room_rates($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function get_rate_rules(){
    $data = (array) json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->HotelServices_model->get_rate_rules($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function hotel_book(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->HotelServices_model->hotel_book($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function trawex_cancel_booking(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->HotelServices_model->trawex_cancel_booking($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }
}
?>
