<?php
defined('BASEPATH') OR exit('No direct script access allowed');
if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400'); 
    }

	if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
			header("Access-Control-Allow-Methods: GET, POST, OPTIONS");         

		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
			header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

		exit(0);
	}

class Api extends CI_Controller {

	var $auth_token;

	public function __construct() {
		parent::__construct();
		$this->load->model('Api_model');		
		$this->load->model('Validation_model');
		$method = $this->router->fetch_method();				
		$data = (array) json_decode(file_get_contents('php://input'));
		if($method == 'profile') {
			$data = $_POST;
		}
		if (isset(apache_request_headers()['Auth'])) {
            $this->auth_token = apache_request_headers()['Auth'];
            $data['auth_token'] = $this->auth_token;
        }
		$res = $this->Validation_model->validation_check($method, $data);
		if($res['state'] == 1) {
 			$this->errorResponse($res['response']['code'], $res['response']['message']);
 			die;
 		}
 		
 	}

 	public function index() {
 		$res = $this->Validation_model->validation_check('login',array('email_id'=>'adarsh'));
 		
 	}

 	public function response($data) {
 		$result =  array(
 			'code' => 1,
 			'message' => 'Success',
 			'responseResult' =>$data
 		);
 		print json_encode($result);
 	}

 	public function errorResponse($errorCode, $errorDesc) {
 		$result =  array(
 			'code' => 0,
 			'message' => 'Failure',
 			'errorCode'=> $errorCode,
 			'errorDesc'=> $errorDesc
 		);
 		print json_encode($result);
 	}

 	public function login(){
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$res = $this->Api_model->login($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function register(){
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$res = $this->Api_model->register($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function forgot(){
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$res = $this->Api_model->forgot($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function popular() {
 		$res = $this->Api_model->popular();
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function category() {
 		$res = $this->Api_model->category();
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function locality() {
 		$res = $this->Api_model->locality();
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function favourite(){
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$data['auth_token'] = $this->auth_token;
 		$res = $this->Api_model->favourite($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function favouritelist() {
 		$data['auth_token'] = $this->auth_token;
 		$res = $this->Api_model->favouritelist($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function bookedlist() { 		
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$data['auth_token'] = $this->auth_token;
 		$res = $this->Api_model->bookedlist($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function bookingdetails() { 		
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$data['auth_token'] = $this->auth_token;
 		$res = $this->Api_model->bookingdetails($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function cancel() { 		
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$data['auth_token'] = $this->auth_token;
 		$res = $this->Api_model->cancel($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function confirm() {
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$data['auth_token'] = $this->auth_token;
 		$res = $this->Api_model->confirm($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function userinfo() {
 		$data['auth_token'] = $this->auth_token;
 		$res = $this->Api_model->userinfo($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function profile() {
 		$data = $_POST;
 		if(isset($_FILES['profile_picture'])) {
 			$data['file'] = $_FILES['profile_picture'];
 		} 		
 		$data['auth_token'] = $this->auth_token;
 		$res = $this->Api_model->update_profile($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function tempbooking() {
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$data['auth_token'] = $this->auth_token;
 		$res = $this->Api_model->tempbooking($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function recommend() {
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$data['auth_token'] = $this->auth_token;

 		$res = $this->Api_model->recommend($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function discover() {
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$data['auth_token'] = $this->auth_token;
 		$res = $this->Api_model->discover($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function event() {
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$data['auth_token'] = $this->auth_token;
 		$res = $this->Api_model->event($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	public function search() {
 		$data = (array) json_decode(file_get_contents('php://input'));
 		$data['auth_token'] = $this->auth_token;

 		$res = $this->Api_model->search($data);
 		if($res['status']!=0){
 			$this->response($res['data']);
 		}
 		else{
 			$this->errorResponse($res['code'],$res['message']);
 		}
 	}

 	

}