<?php
  $layoutDtls = '';
?>
<div class="content-wrapper">
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
            <button class="close" data-dismiss="alert" type="button">×</button>
            <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>

      <div class="col-md-12">
        <div class="box box-warning marginBottom-10">
          <div class="box-body">
            <form role="form" name="venueForm" action="<?= base_url('Event/addEvent')?>" method="post" 
                  class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <div class="col-md-12">
                <?php if(!empty($venueList)){ ?>
                  <div class="form-group">
                    <label>Choose Venue</label>
                    <select name="venue_id" class="form-control" 
                            placeholder="Select Venue" onchange="venueSubmitForm()">
                      <option selected disabled>Choose a Venue</option>
                      <?php 
                        foreach ($venueList as $venue) {
                          $select = (isset($venue->venue_id) && $venue->venue_id==$venue_id)?'selected':'';
                          echo '<option '.$select.' value="'.$venue->venue_id.'">'.
                                  $venue->venue_name.', '.$venue->region_name.' - '.$venue->location.
                               '</option>';
                        }
                      ?>
                    </select> 
                  </div>
                <?php } ?> 
              </div>
            </form>
          </div>
        </div>

        <?php if(!empty($venueData)){ ?>
          <div class="box">
            <form role="form" name="eventAddForm" action="<?= base_url('Event/createEvent')?>" method="post" class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <input type="hidden" name="venue_id" value="<?= $venue_id ?>">
              <div class="box-header with-border">
                <h3 class="box-title padLeft10 padTop5">Venue Details</h3>
              </div>
              <div class="box-body">
                <div class="col-sm-12">
                  <div class="col-sm-6">
                    <div class="col-sm-4">Venue Name</div>
                    <div class="col-sm-1"><span>:</span></div>
                    <div class="col-sm-7"><strong><?= $venueData->venue_name ?></strong></div>
                  </div>
                  <div class="col-sm-6">
                    <div class="col-sm-4">Venue Region</div>
                    <div class="col-sm-1"><span>:</span></div>
                    <div class="col-sm-7"><strong><?= $venueData->region_name ?></strong></div>
                  </div>
                </div>
                <div class="col-sm-12">
                  <div class="col-sm-6">
                    <div class="col-sm-4">Venue Location</div>
                    <div class="col-sm-1"><span>:</span></div>
                    <div class="col-sm-7"><strong><?= $venueData->location ?></strong></div>
                  </div>
                  <div class="col-sm-6">
                    <div class="col-sm-4">About Venue</div>
                    <div class="col-sm-1"><span>:</span></div>
                    <div class="col-sm-7"><strong><?= $venueData->venue_details ?></strong></div>
                  </div>
                </div>

                <?php if($venueData->show_layout == 1 && !empty($venueData->layout_details) && 
                         !empty($layoutDtls = json_decode($venueData->layout_details,true))){ ?>

                  <div class="box-header with-border padTop0">
                    <h3 class="box-title padLeft10 ">Layout Details</h3>
                  </div>

                  <div class="box-body">
                    <div class="col-sm-12 padBottom15">
                      <div class="col-sm-3 dropZoneContainer viewLayout">
                        <img class="dropZoneOverlay" id="image_id" src="<?= base_url($venueData->layout) ?>" 
                             onerror="this.src='<?=base_url("assets/images/no_image_text.png")?>';" 
                             height="75" width="75" />
                      </div>
                      <div class="col-md-9 padLeft40">
                        <div class="marginTop23" id="mapTypeCntr">
                          <input type="radio" name="fare_type" value="0" checked>
                            <label class="padAll-10">Use Default Fare</label>
                          <input class="marginLeft15" type="radio" name="fare_type" value="1">
                            <label class="padAll-10">Create Custome Fare</label>
                        </div>

                        <div class="col-sm-12" id="defaultFareSystem">
                          <?php foreach($layoutDtls AS $lyDtls){ ?>
                            <div class="col-sm-12 marginTop-8">
                              <div class="col-sm-3">
                                <strong><?= $lyDtls['color'] ?></strong> block 
                              </div>
                              <div class="col-sm-9">
                                <strong><?= $lyDtls['price'] ?></strong> / Seat
                              </div>
                            </div>
                          <?php } ?>
                        </div>

                        <div class="col-sm-12 hide" id="customFareSystem">
                          <?php foreach($layoutDtls AS $lyDtls){ ?>
                            <div class="col-sm-12">
                              <div class="col-sm-3 padTop15">
                                <strong><?= $lyDtls['color'] ?></strong> block 
                              </div>
                              <div class="col-sm-9">
                                <input type="hidden" name="seat_color[]" value="<?= $lyDtls['color'] ?>"> 
                                <input id="custFareInput_<?= $lyDtls['color'] ?>" type="text" 
                                  class="form-control marginTop-8 width200" disabled
                                  data-parsley-trigger="change" data-parsley-minlength="1" name="seat_price[]" data-parsley-pattern="^[0-9\ . \/]+$" placeholder="Custom Fare / Seat"> 
                              </div>
                            </div>
                        <?php } ?>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php } ?>

                <div class="box-header with-border">
                  <h3 class="box-title padLeft10 ">Event Details</h3>
                </div>

                <div class="box-body">
                  <div class="col-sm-12">
                    <div class="col-sm-6">
                      <div class="form-group">
                        <label>Event Name</label>
                        <input type="text" class="form-control required" data-parsley-trigger="change"
                        data-parsley-minlength="2" name="event_name" required="" 
                        placeholder="Enter Venue Title" value="<?= (isset($venue_data->venue_name))?$venue_data->venue_name:'' ?>">
                      </div>
                      
                      <?php if(!empty($category_data)){ ?>
                        <div class="form-group">
                          <label>Category</label>
                          <select name="category_id" class="form-control required" 
                                  placeholder="Select Event Category" required>
                            <option selected disabled>Choose Event Category</option>
                            <?php 
                              foreach ($category_data as $category) {
                                echo '<option value="'.$category->cat_id.'">'.
                                        $category->category.
                                     '</option>';
                              }
                            ?>
                          </select> 
                        </div>
                      <?php } ?> 
                    </div>
                    <div class="col-sm-6">
                      <div class="form-group">
                        <label>Event Description</label>
                        <textarea type="text" class="ip_reg_form_input form-control reset-form-custom required" placeholder="Venue Description" name="event_discription" required 
                        style="height:108px;" data-parsley-trigger="change" data-parsley-minlength="2"></textarea>
                      </div>
                    </div>
                    <div class="col-md-12">  
                      <div class="form-group">
                        <label>Event Images</label>
                        <div id="multipleImageInputCntr">
                          <div class="dropZoneContainer" id="multiImageCntr_1">
                            <div id="multiImageClose_1" class="close_custom hide" onclick="removeImage('1');">&times;</div>
                            <input type="file" name="event_image[]" class="multiFileUpload" accept="image/*" onchange="setMultiImg(this,jQuery(this));" count="1" />
                            <img class="multiDropZoneOverlay" id="multiImageImg_1" src="<?=base_url("assets/images/add-image.png")?>" />
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <?php if($venueData->show_layout != 1){ ?>
                  <div class="box-header with-border">
                    <h3 class="box-title padLeft10 ">Pricing Details</h3>
                  </div>

                  <div class="box-body">
                    <div class="col-sm-12">
                      <div class="col-sm-2">
                        <div class="form-group">
                          <label>Price</label>
                          <input type="text" class="form-control required" placeholder="Price" 
                                 data-parsley-trigger="change" data-parsley-minlength="2" data-parsley-pattern="^[0-9\ . \/]+$" name="price"
                                 required>
                        </div>
                      </div>
                      <div class="col-sm-10">
                        <div class="form-group">
                          <label>About Price Division</label>
                          <textarea type="text" class="ip_reg_form_input form-control reset-form-custom required" placeholder="Price Division" name="price_details" required 
                          style="height:35px;" data-parsley-trigger="change" data-parsley-minlength="2"></textarea>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php } ?>

                <div class="box-header with-border">
                  <h3 class="box-title padLeft10 ">Scheduler and Tags</h3>
                </div>

                <div class="box-body">
                  <div class="col-sm-12">
                    <div class="col-sm-6">

                      <div id="scheduleTypeCntr">
                        <input type="radio" name="schedule_type" value="0" checked>
                          <label class="padAll-10">For Single Show</label>
                        <input class="marginLeft15" type="radio" name="schedule_type" value="1">
                          <label class="padAll-10">For Multiple Show</label>
                      </div>

                      <div class="col-sm-6">
                        <div class="input-group date" data-provide="datepicker">
                          <input id="date" type="text" class="form-control required" required 
                            data-parsley-trigger="change" data-parsley-minlength="5"
                            name="event_start_date" placeholder="Event Start Date" autocomplete="off">
                          <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                          </div>
                        </div>

                        <div class="input-group date padTop10 hide" data-provide="datepicker" 
                             id="eventEndDate">
                          <input id="date" type="text" class="form-control" disabled 
                            data-parsley-trigger="change" data-parsley-minlength="5"
                            name="event_end_date" placeholder="Event End Date" autocomplete="off">
                          <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                          </div>
                        </div>
                      </div>

                      <div class="col-sm-4" style="padding-left: initial;">
                        <div class="col-sm-10 clockpicker" data-autoclose="true">
                          <input type="text" class="form-control required" data-parsley-minlength="2" 
                          data-parsley-trigger="change" required name="event_time[]" autocomplete="off" 
                          placeholder="Show Time" id="start_time">
                        </div>
                        <div class="col-sm-2" style="padding-left: initial;">
                          <i class="fa fa-plus-circle cpoint fav-add-icon" onclick="addTimePicker(jQuery(this))" count="1"></i>
                        </div>
                        <div id="scheduleTimerCntr"></div>
                      </div>
                    </div>

                    <?php if(!empty($tag_data)){ ?>
                      <div class="col-sm-6">
                        <div class="box-header with-border">
                          <h3 class="box-title padLeft10 ">Tags</h3>
                        </div>
                        <div type="parent" class="header-tag-box marginTop10">
                          <?php foreach($tag_data AS $tag){ ?>
                            <div id="tag_<?= $tag->tag_id ?>" class="header-tag cpoint" tag_id="<?= $tag->tag_id ?>" select="0" onclick="manageTags(jQuery(this))">
                              <?= $tag->tag_name ?>
                            </div>
                          <?php } ?>
                        </div>
                        <div id="selected_tags" class="hide"></div>
                      </div>
                    <?php }  ?>
                  </div>
                </div>

                <div class="col-md-12 padTop10">      
                  <div class="box-footer textCenterAlign">
                    <button type="submit" class="btn btn-primary" id="addEventButton">Submit</button>
                    <a href="<?= base_url('Event/listEvents') ?>" class="btn btn-primary">Cancel</a>
                  </div>        
                </div> 
              </div>
            </form>
          </div>
        </div>
      <?php } ?>
    </div>
  </section>
</div>

<div class="hide" id="scheduleTimerHtml">
  <div style="padding-left: initial;" id="timePicker_{:count}">
    <div class="col-sm-10 padTop10 clockpicker" data-autoclose="true" id="timePickerEnable_{:count}">
      <input type="text" class="form-control required" data-parsley-minlength="2" 
      data-parsley-trigger="change" required name="event_time[]" autocomplete="off" 
      placeholder="Show Time" id="start_time">
    </div>
    <div class="col-sm-2" style="padding-left: initial;">
      <i class="padTop12 fa fa-times-circle-o cpoint fav-rem-icon" onclick="remTimePicker({:count})"></i>
    </div>
  </div>
</div>

<div id="multipleImageInput" class="hide">
  <div class="dropZoneContainer" id="multiImageCntr_{:count}">
    <div id="multiImageClose_{:count}" class="close_custom hide" onclick="removeImage('{:count}');">&times;</div>
    <input type="file" name="event_image[]" class="multiFileUpload" accept="image/*"
           onchange="setMultiImg(this,jQuery(this));" count="{:count}" />
    <img class="multiDropZoneOverlay" id="multiImageImg_{:count}" src="" 
           onerror="this.src='<?=base_url("assets/images/add-image.png")?>';" />
  </div>
</div>