<div class="content-wrapper" >
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
      <li><?= $menu ?></li>
      <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
             <button class="close" data-dismiss="alert" type="button">×</button>
             <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-xs-12">
        <div class="box box-warning">
          <div class="box-header with-border">
            <div class="col-md-6"><h3 class="box-title">Tag List</h3></div>
            <div class="col-md-6" align="right">
              <a class="btn btn-sm btn-primary" href="<?= base_url('Tag/addTags') ?>">
                Add New Tag
              </a>
              <a class="btn btn-sm btn-primary" href="<?= base_url() ?>">Back</a>
           </div>
          </div>
          <div class="box-body">
            <table id="mechanicUsers" class="table table-bordered table-striped datatable ">
              <thead>
                <tr>
                  <th class="hidden">ID</th>
                  <th width="500px;">Tag Name</th>
                  <th width="100px;">Status</th>
                  <th width="200px;">Action</th>
               </tr>
              </thead> 
              <tbody>
                <?php
                if(!empty($tag_data)){
                  foreach($tag_data as $tag) { ?>
                    <tr>
                      <th class="hidden"><?= $tag->tag_id ?></th>
                      <th class="center"><?= $tag->tag_name ?></th>
                      <th class="center"><?= ($tag->status == 1)?'Active':'De-activate' ?></th>
                      <td class="center">
                        <a class="btn btn-sm btn-primary" 
                           href="<?= base_url('Tag/editTags/'.encode_param($tag->tag_id))?>">
                          <i class="fa fa-fw fa-edit"></i>Edit
                        </a> 
                        <a class="btn btn-sm btn-danger" 
                        href="<?= base_url("Tag/changeStatus/".encode_param($tag->tag_id))."/2" ?>" 
                            onClick="return doconfirm()">
                          <i class="fa fa-fw fa-trash"></i>Delete
                        </a>    
                        <?php if($tag->status == 1){ ?>
                          <a class="btn btn-sm btn-success" style="background-color:#ac2925" href="<?= base_url("Tag/changeStatus/".encode_param($tag->tag_id))."/0" ?>">
                            <i class="fa fa-cog"></i> De-activate
                          </a>
                        <?php } else { ?>
                          <a class="btn btn-sm btn-success" href="<?= base_url("Tag/changeStatus/".encode_param($tag->tag_id))."/1" ?>">
                            <i class="fa fa-cog"></i> Activate
                          </a>
                        <?php } ?>
                      </td>
                    </tr>
                <?php } } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>