<?php 
class Vehicle_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
 	}

 	function addVehicle($vehicle_data = array()){
 		if(empty($vehicle_data)){
 			return 0;
 		}
 		$status = $this->db->insert('customer_vehicle',$vehicle_data);
 		return ($status)?$this->db->insert_id():'0';
 	}

 	function changeStatus($vehicle_id = '', $action = '0'){
 		if(empty($vehicle_id)){
 			return 0;
 		}
 		if($action == 3){
			$status = $this->db->delete('customer_vehicle',array('customer_veh_id'=>$vehicle_id));
 		} else {
 			$status = $this->db->update('customer_vehicle',array('status'=>$action),
 														   array('customer_veh_id'=>$vehicle_id));
 		}
 		return $status;
 	}

    function getCustVechiles($searchData = array()){
        if(empty($searchData)){
        	return 0;
        }
        $cond = array();

        $cond['status'] = 1;
        if(isset($searchData['customer_id']) && !empty($searchData['customer_id'])){
        	$cond['customer_id'] = $searchData['customer_id'];
        }
		$vehData = $this->db->get_where('customer_vehicle',$cond);
		
		if(!empty($vehData)){
            $vehData = $vehData->result();
            foreach ($vehData as $key => $value) {
                $result = $this->db->query("SELECT VEH.veh_brand_id,VEH.model_id
                                            FROM vehicles AS VEH 
                                            INNER JOIN vehicle_models AS VEHM ON VEHM.veh_model_id = VEH.model_id
                                            WHERE VEHM.model_name='".$value->car_model."'")->row();
                if(!empty($result)){
                    $vehData[$key]->veh_brand_id = $result->veh_brand_id;
                    $vehData[$key]->veh_model_id = $result->model_id;
                }
            }
			return $vehData;
		}
		return 0;
    }

    function changeCustomerCarStatus($customer_id = '', $customer_veh_id = '', $status = ''){
    	if(empty($customer_id) || empty($customer_veh_id) || $status == ''){
    		return 0;
    	}

    	$upStatus = $this->db->update('customer_vehicle',
    								array('status'=>$status),
    								array('customer_id'=>$customer_id,'customer_veh_id'=>$customer_veh_id));

    	return $upStatus;
    }
    public function addBrand($veh_data = array()){
        if(empty($veh_data)){
            return 0;
        }
        $result = $this->db->get_where('vehicles_brand',array('vehicles_brand.maker'=>$veh_data['maker']))->row();
        if($result){
            return 0;
        }
        $status = $this->db->insert('vehicles_brand',$veh_data);
        $last_id = $this->db->insert_id();
        return $last_id;
    }

    function getVehBrand($veh_brand_id = '',$view_all = 0){
        $cond = ($view_all != 0)?' vehicles_brand.status IN (0,1) ':' vehicles_brand.status IN (1) ';
        $cond .= (!empty($veh_brand_id))?" AND vehicles_brand.veh_brand_id = '$veh_brand_id'":"";

        $result = $this->db->query("SELECT * FROM vehicles_brand
                                    WHERE $cond ORDER BY vehicles_brand.maker");
        if(empty($result)){
            return;
        }
        return (empty($veh_brand_id))?$result->result():$result->row();
    }

    function changeVehicleStatus($brand_id = '', $status = '0',$type=''){
        if(empty($brand_id)){
            return 0;
        }
        if($type == '2'){
            $status = $this->db->update('vehicles',array('status'=>$status), array('veh_id'=>$brand_id));
        }else{
            $status = $this->db->update('vehicles_brand',array('status'=>$status), array('veh_brand_id'=>$brand_id));   
        }
        return $status;
    }

    function updateVehBrand($brand_id = '', $brand_data = array()){
        if(empty($brand_id) || empty($brand_data)){
            return 0;
        }
        $status = $this->db->update('vehicles_brand',$brand_data,array('veh_brand_id'=>$brand_id));
        return ($status)?1:0;
    }


    function getVehModel($veh_model_id = '',$view_all = 0,$vehData=array(),$veh_id=''){
        $cond = ($view_all != 0)?' vehicles.status IN (0,1) ':' vehicles.status IN (1) ';
        $cond .= (!empty($veh_model_id))?" AND vehicles.model_id = '$veh_model_id'":"";
        $cond .= (!empty($vehData['id']))?" AND vehicles.veh_brand_id = '".$vehData['id']."'":"";
        $cond .= (!empty($vehData['year']))?" AND vehicles.year = '".$vehData['year']."'":"";
        $cond .= (!empty($veh_id))?" AND vehicles.veh_id = '".$veh_id."'":"";
        $result = $this->db->query("SELECT vehicles.*,vehicles_brand.maker,vehicle_models.model_name AS model,vehicle_models.veh_model_id
                                    FROM vehicles
                                    JOIN vehicles_brand ON vehicles_brand.veh_brand_id = vehicles.veh_brand_id
                                    JOIN vehicle_models ON vehicle_models.veh_model_id = vehicles.model_id
                                    WHERE $cond ORDER BY model");
        if(empty($result)){
            return;
        }

        if(isset($vehData['id']) && !empty($vehData['id'])){
            return $result->result(); 
        }
        if(isset($veh_id) && !empty($veh_id)){
            return $result->row(); 
        }
        return (empty($veh_model_id))?$result->result():$result->row();
    }

    function get_activity($filter=null){
        if($filter) {
            if($filter['length']!=-1)
                $this->db->limit($filter['length'], $filter['start']);
            $this->db->order_by("model", $filter['order_type']);
            
            if(!empty($filter['where'])) {
                $this->db->where($filter['where']);
            }
        }
        $this->db->select('vehicles.*,vehicles_brand.maker,vehicle_models.model_name AS model');
        $this->db->from('vehicles');
        $this->db->join('vehicles_brand','vehicles_brand.veh_brand_id = vehicles.veh_brand_id');
        $this->db->join('vehicle_models','vehicle_models.veh_model_id = vehicles.model_id');
        $this->db->where('vehicles.status !=','2');
        $query = $this->db->get();
        if(!empty($query) && !empty($query = $query->result())){
            return $query;
        }
        return 0;
    }

    public function addModel($veh_data = array()){
        if(empty($veh_data)){
            return 0;
        }
        $trim = (isset($veh_data['trim']) && !empty($veh_data['trim']))?$veh_data['trim']:'';
        $engine = (isset($veh_data['engine']) && !empty($veh_data['engine']))?$veh_data['engine']:'';

        $result = $this->db->get_where('vehicles',array('vehicles.model_id'=>$veh_data['model'],'vehicles.veh_brand_id'=>$veh_data['veh_brand_id'],'vehicles.trim'=>$trim,'vehicles.engine'=>$engine,'vehicles.year'=>$veh_data['vehYear']))->row();
        if($result){
            return 0;
        }

       $status = $this->db->insert("vehicles",array('veh_brand_id'=>$veh_data['veh_brand_id'],'year'=>$veh_data['vehYear'],'model_id'=>$veh_data['model'],'trim'=>$trim,'engine'=>$engine));
       return ($status)?1:0;
    }

    public function updateVehModel($vehicle_id = '', $model_data = array()){
        if(empty($vehicle_id) || empty($model_data)){
            return 0;
        }
        $status = $this->db->update('vehicles',array('veh_brand_id'=>$model_data['veh_brand_id'],'year'=>$model_data['vehYear'],'model_id'=>$model_data['model'],'trim'=>(isset($model_data['trim']) && !empty($model_data['trim']))?$model_data['trim']:'','engine'=>(isset($model_data['engine']) && !empty($model_data['engine']))?$model_data['engine']:''),array('veh_id'=>$vehicle_id));
        return ($status)?1:0;
    }

    public function changeReminderStatus($postData = array()){
        $respArr = array('status'=>'error');
        if(empty($postData)){
            $respArr['message'] = 'All Field is Required';
        }
        if($this->db->update('customer_vehicle',array('enable_notification'=>$postData['status']),array('customer_veh_id'=>$postData['customer_veh_id']))){
            $respArr['status'] = 'success';
        }
        return $respArr;
        
    }
}
?>