<div class="content-wrapper">
  <section class="content-header">
    <h1><?= $pTitle ?><small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-sm-12">
        <?php if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
           <button class="close" data-dismiss="alert" type="button">×</button>
           <?= $flashdata['message'] ?>
         </div>
       <?php } ?>
      </div>
        <div class="col-xs-12">
          <div class="box box-warning"> 
            <div class="box-header with-border">
              <div class="col-md-6"><h3 class="box-title">Order List</h3></div>
              <div class="col-md-6" align="right">
                <?php if(!empty($orderData)){ ?>
                  <a class="btn btn-sm btn-success" href="<?= base_url('Orders/exportOrderData')?>">Generate Report</a>
                <?php } ?>
                <a class="btn btn-sm btn-primary" href="<?= base_url() ?>">Back</a>
              </div>
            </div>    
            <div class="box-body">
              <table id="mechanicUsers" class="table table-bordered table-striped datatable ">
                <thead>
                  <tr>
                    <th class="hidden">ID</th>
                    <th width="12%;">Order ID</th>
                    <th width="22%;">Product</th>
                    <th width="15%;">Customer</th>
                    <th width="9%;">Quantity</th>
                    <th width="9%;">Amount</th>
                    <th width="17%;">Status</th>
                    <th width="16%;">Action</th>
                 </tr>
                </thead> 
                <tbody>
                  <?php if(!empty($orderData)){
                    foreach($orderData as $odrData) { ?>
                      <tr>
                        <th class="hidden"><?= $odrData->order_id ?></th>
                        <th class="center"><?= $odrData->format_order_id ?></th>
                        <th class="center"><?= $odrData->product_name ?></th>
                        <th class="center"><?= $odrData->customer_name ?></th>
                        <th class="center"><?= $odrData->quantity ?></th>
                        <th class="center"><?= $odrData->amount ?></th>
                        <th class="center" id="orderStatus_<?= encode_param($odrData->order_id) ?>">
                          <?php
                              switch($odrData->status){
                                case 0: echo 'Inactive'; break;
                                case 1: echo 'Payment Processing'; break;
                                case 2: echo 'Order Places'; break;
                                case 3: echo 'Order Packed <br>
                                              (Deliver by '.$odrData->expected_delivery.')'; break;
                                case 4: echo 'Order Shipped <br> 
                                              (Deliver by '.$odrData->expected_delivery.')'; break;
                                case 5: echo 'Ordered Delivered <br>
                                              (Deliver by '.$odrData->delivered.')'; break;
                                case 6: echo 'Returned'; break;
                                case 7: echo 'Cancelled'; break;
                                case 8: echo 'Deleted'; break;
                                case 9: echo 'Payment Failed'; break;
                              }
                          ?>
                        </th>
                        <td class="center">
                          <a class="btn btn-sm btn-info" id="viewOrderDetails" 
                            order_id="<?= encode_param($odrData->order_id) ?>">
                            <i class="fa fa-fw fa-eye"></i>View
                          </a>
                          <?php if($odrData->status == '2' || $odrData->status == '3' || $odrData->status == '4'){ ?>
                          <a class="btn btn-sm btn-success" order_status="<?= $odrData->status ?>" id="changeOrderStatus" style="background-color:#4CAF50;" order_id="<?= encode_param($odrData->order_id) ?>"><i class="fa fa-cog"></i>Status</a>
                          <?php } ?>
                        </td>
                      </tr>
                  <?php } }?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
    </div>
  </section>
</div>