<?php 
class Product_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
 	}

 	public function addProduct($product_data = array()){
 		if(empty($product_data)){
 			return 0;
 		}
 		$cardata = $this->db->get_where('vehicles_model',array('veh_brand_id'=>$product_data['vehMake'],'veh_modal_id'=>$product_data['vehModel']))->row();

		if(isset($product_data['cardetail_id']) && !empty($product_data['cardetail_id'])){
			$this->db->update('cardetails',array('year'=>$product_data['vehYear'],'	veh_modal_id'=>$cardata->veh_modal_id),array('id'=>$product_data['cardetail_id']));
		}else{
			$this->db->insert('cardetails',array('year'=>$product_data['vehYear'],'	veh_modal_id'=>$cardata->veh_modal_id));
			$product_data['cardetail_id'] = $this->db->insert_id();
		}
 		unset($product_data['vehYear'],$product_data['vehMake'],$product_data['vehModel']);
 		$status = $this->db->insert('products',$product_data);
 		$last_id = $this->db->insert_id();
		return $last_id;
 	}

 	function getProduct($product_id = '',$view_all = 0,$mechanic_id = ''){
 		$cond = ($view_all != 0)?' products.status IN (0,1) ':' products.status IN (1) ';
 		$cond .= (!empty($product_id))?" AND products.product_id = '$product_id'":"";
 		$cond .= (!empty($mechanic_id))?" AND products.created_by = '$mechanic_id'":"";

		$result = $this->db->query("SELECT cardetails.veh_modal_id,cardetails.year,vehicles_model.*								,products.*,product_brand.brand_name
									FROM products
									JOIN product_brand on product_brand.brand_id = products.brand_id
									LEFT JOIN cardetails on cardetails.id = products.cardetail_id
									LEFT JOIN vehicles_model on cardetails.veh_modal_id = vehicles_model.veh_modal_id
									WHERE $cond");
		if(empty($result)){
			return;
		}
		return (empty($product_id))?$result->result():$result->row();
 	}

 	function changeStatus($product_id = '', $status = '0'){
 		if(empty($product_id)){
 			return 0;
 		}
 		$this->db->update('product_images',array('status'=>$status),array('product_id'=>$product_id));
 		$status = $this->db->update('products',array('status'=>$status), array('product_id'=>$product_id));
 		return $status;
 	}

 	function updateProduct($product_id = '', $product_data = array()){
 		if(empty($product_id) || empty($product_data)){
 			return 0;
 		}
		$cardata = $this->db->get_where('vehicles_model',array('veh_brand_id'=>$product_data['vehMake'],'veh_modal_id'=>$product_data['vehModel']))->row();
		if(isset($product_data['cardetail_id']) && !empty($product_data['cardetail_id'])){
			$this->db->update('cardetails',array('year'=>$product_data['vehYear'],'	veh_modal_id'=>$cardata->veh_modal_id),array('id'=>$product_data['cardetail_id']));
		}else{
			$this->db->insert('cardetails',array('year'=>$product_data['vehYear'],'	veh_modal_id'=>$cardata->veh_modal_id));
			$product_data['cardetail_id'] = $this->db->insert_id();
		}
 		unset($product_data['vehYear'],$product_data['vehMake'],$product_data['vehModel']);
 		$status = $this->db->update('products',$product_data,array('product_id'=>$product_id));
		return ($status)?1:0;
 	}

 	function addProductImage($imagearray = array()){
 		if(empty($imagearray)){
 			return 0;
 		}
 		$status = $this->db->insert_batch('product_images',$imagearray);
 		return ($status)?1:0;
 	}

 	function updateProductImage($product_id = '', $imagearray = array(), $existingImages = array()){
 		if(empty($product_id)){
 			return 0;
 		}
 		if(!empty($existingImages)){
 			$this->db->query("DELETE FROM product_images 
 							  WHERE id NOT IN (".implode(",",$existingImages).") AND product_id=$product_id");
 		} else {
 			$this->db->query("DELETE FROM product_images WHERE product_id='$product_id'");
 		}

 		if(!empty($imagearray)){
			$status = $this->db->insert_batch('product_images',$imagearray);
 		}
		return $status;
 	}

 	function getProductImage($product_id = ''){
 		if(empty($product_id)){
 			return 0;
 		}
 		$status = $this->db->get_where('product_images',array('product_id'=>$product_id))->result_array();
 		return $status;
 	}

}
?>