<?php 
class Issue_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
 	}

 	public function addIssue($issue_data = array(), $issueTyp = array()){
 		if(empty($issue_data) || empty($issueTyp))
 			return 0;

 		$status = $this->db->insert('issues',$issue_data);
 		if(!$status)
 			return 0;

 		$issue_id = $this->db->insert_id();

 		foreach ($issueTyp AS $key => $value) {
 			$issueTyp[$key]['issue_id'] = $issue_id;
 		}
 		$status = $this->db->insert_batch('issues_category',$issueTyp);
		return ($status)?1:0;
 	}

 	function getIssues($issue_id = '',$view_all = 0){
 		$cond = ($view_all != 0)?' ISS.status IN (0,1) ':' ISS.status IN (1) ';
 		$cond .= (!empty($issue_id))?" AND ISS.issue_id = '$issue_id' ":"";

		$result = $this->db->query("SELECT ISS.*,IC.issue_cat_id FROM issues AS ISS 
									LEFT JOIN issues_category AS IC ON 
										(ISS.issue_id=IC.issue_id AND IC.status='1')
									WHERE $cond
									GROUP BY ISS.issue_id");
		if(empty($result)){
			return;
		}
		return (empty($issue_id))?$result->result():$result->row();
 	}

 	function getUnMappedIssues($mechanic_id = '',$view_all = 0){
 		if(empty($mechanic_id)){
 			return 0;
 		}

 		$cond = ($view_all != 0)?' status IN (0,1) ':' status IN (1) ';

		$result = $this->db->query("SELECT * FROM issues 
									WHERE $cond AND issue_id NOT IN 
									    (SELECT issue_id FROM mechanic_issues 
									     WHERE mechanic_id='$mechanic_id' AND status<>'2')");
		if(empty($result)){
			return;
		}
		return (empty($issue_id))?$result->result():$result->row();
 	}

 	function getIssueDetails($issue_id = '',$view_all = 0){
 		$cond = ($view_all != 0)?' status IN (0,1) ':' status IN (1) ';
 		$cond .= (!empty($issue_id))?" AND issue_id = '$issue_id' ":"";

		$result = $this->db->query("SELECT * FROM issues WHERE $cond");
		if(empty($result)){
			return;
		}
		if(empty($issue_id)){
			$issue_data = $result->result();
			foreach ($issue_data AS $key => $issue) {
				$result = $this->db->query("SELECT * FROM issues_category 
											WHERE issue_id='$issue->issue_id' AND status='1'");
				if(empty($result)){
					return;
				}
				$issue_data[$key]->sub_issue = $result->result();
			}
		} else {
			$issue_data = $result->row();
			$result = $this->db->query("SELECT * FROM issues_category 
										WHERE issue_id='$issue_data->issue_id' AND status='1'");
			$issue_data->sub_issue = $result->result();
		}
		return $issue_data;
 	}

 	function changeStatus($issue_id = '', $status = '0'){
 		if(empty($issue_id)){
 			return 0;
 		}
 		$status = $this->db->update('issues',array('status'=>$status), array('issue_id'=>$issue_id));
 		return $status;
 	}

 	function updateIssue($issue_id='',$issue_data=array(),$updateSubTyp=array(),$insertSubTyp=array()){
 		if(empty($issue_id) || empty($issue_data)){
 			return 0; 
 		}
 		$status = $this->db->update('issues',$issue_data,array('issue_id'=>$issue_id));

		$scat_ids = array();	
 		if(!empty($updateSubTyp)){
			foreach ($updateSubTyp AS $scat_id => $scat_data) {
				$scat_ids[] = $scat_id;
				$this->db->update('issues_category',$scat_data,array('issue_cat_id'=>$scat_id));
			}
 		}
 		if(!empty($scat_ids)){
			$this->db->where_not_in('issue_cat_id',$scat_ids);
 		}
		$this->db->where('issue_id',$issue_id);
		$this->db->delete('issues_category'); 

		if(!empty($insertSubTyp)){
	 		$this->db->insert_batch('issues_category',$insertSubTyp);
	 	}
		return ($status)?1:0;
 	}

 	function addMechIssue($issueMechData = array()){
 		if(empty($issueMechData)){
 			return 0;
 		}
 		$status = $this->db->insert_batch('mechanic_issues',$issueMechData);
 		return ($status)?1:0;
 	}

 	function getMechanicIssues($mechanic_id = '',$issue_id = '',$view_all = '0'){
 		if(empty($mechanic_id)){
 			return 0;
 		}
 		$cond = ($view_all != 0)?' MI.status IN (0,1) ':' MI.status IN (1) ';
 		$cond .= (!empty($issue_id))?" AND MI.issue_id = '$issue_id' ":"";

 		$sql = "SELECT MI.issue_id,MI.issue_cat_id,MI.mechanic_id,MI.custom_description,MI.custom_service_fee,
 					   MI.status,ISS.issue,ISS.issue_image
 				FROM mechanic_issues AS MI
				INNER JOIN issues AS ISS ON (ISS.issue_id=MI.issue_id)
				WHERE MI.mechanic_id='$mechanic_id' AND ISS.status='1' AND $cond
				GROUP BY MI.issue_id,MI.issue_cat_id";
	  	$mechIssueData = $this->db->query($sql);

		if(empty($mechIssueData) || empty($mechIssueData = $mechIssueData->result_array()))
			return 0;

		$cstFlag = 0;
		$customIssues = array();
		foreach ($mechIssueData AS $mechIsssue) {
			$issue_id = $mechIsssue['issue_id'];
		  	if(!isset($customIssues[$issue_id])){
		  		$customIssues[$issue_id] = array('issue'=>$mechIsssue['issue'],
						  					     'issue_id'=>$mechIsssue['issue_id'],
											     'mechanic_id'=>$mechIsssue['mechanic_id'],
											     'issue_image'=>$mechIsssue['issue_image'],
										  	     'status'=>$mechIsssue['status'],
										  	     'custom_enable'=>'0');
		  	}

			if(!empty($issCat_id = $mechIsssue['issue_cat_id'])){

				$sIssData = $this->db->get_where('issues_category',array('issue_cat_id'=>$issCat_id));
				if(empty($sIssData) || empty($sIssData = $sIssData->row_array())){
					continue;
				}
				$subIssueDtls['description'] = $sIssData['default_description'];
			  	$subIssueDtls['service_fee'] = $sIssData['default_service_fee'];
				$subIssueDtls['issue_category'] = $sIssData['issue_category'];
				$subIssueDtls['issue_cat_image'] = $sIssData['issue_cat_image'];

			  	if(!empty($mechIsssue['custom_description'])){
			  		$cstFlag = 1;
			  		$subIssueDtls['description'] = $mechIsssue['custom_description'];
			  	}
			  	if(!empty($mechIsssue['custom_service_fee'])){
			  		$cstFlag = 1;
			  		$subIssueDtls['service_fee'] = $mechIsssue['custom_service_fee'];
			  	}

			  	$customIssues[$issue_id]['sub_issue'][$issCat_id] = $subIssueDtls;
			  	$customIssues[$issue_id]['custom_enable'] = $cstFlag;
			}
		}
		return $customIssues;
 	}

 	function changeMappedIssueStatus($mechanic_id = '', $issue_id = '', $status = '0'){
 		if(empty($mechanic_id) || empty($issue_id)){
 			return 0;
 		}
 		$status = $this->db->update('mechanic_issues',
 											array('status'=>$status), 
 											array('issue_id'=>$issue_id,'mechanic_id'=>$mechanic_id));
 		return $status;
 	}

 	function updateMechIssue($mechanic_id = '',$issue_id = '',$custom_issue = ''){
 		if(empty($mechanic_id) || empty($issue_id) || empty($custom_issue)){
 			return 0;
 		}

 		$status = $this->db->delete('mechanic_issues',array('mechanic_id'=>$mechanic_id,'issue_id'=>$issue_id));

 		if(!$status){
 			return ($status)?1:0;
 		}

 		return $this->addMechIssue($custom_issue);
 	}

	function getGeneralIssues($issue_id = '', $view_all = '0'){
 		$cond  = ($view_all != 0)?' ISS.status IN (0,1) ':' ISS.status IN (1) ';
 		$cond .= (!empty($issue_id))?" AND ISS.issue_id='".$issue_id."' ":'';

		$sql = "SELECT ISS.*, IC.* 
				FROM issues AS ISS 
				LEFT JOIN issues_category AS IC ON (IC.issue_id=ISS.issue_id AND IC.status='1')
				WHERE ".$cond;

		if(empty($issueData = $this->db->query($sql)) || empty($issueData = $issueData->result_array()))
			return 0;

		$genIssueData = array();
		foreach($issueData AS $issueData){
			$issue_id = $issueData['issue_id'];

			if(!isset($genIssueData[$issue_id])){
				$iData = array('issue'=>$issueData['issue'],'issue_id'=>$issue_id,
							   'issue_image'=>$issueData['issue_image']);
				$genIssueData[$issue_id] = $iData;
							
			}

			if(isset($issueData['issue_cat_id']) && !empty($issueData['issue_cat_id'])){
				$sIssueId = $issueData['issue_cat_id'];

				$isData = array('issue_cat_id'=>$issueData['issue_cat_id'],
							    'issue_category'=>$issueData['issue_category'],
							    'issue_cat_image'=>$issueData['issue_cat_image'],
							    'default_service_fee'=>$issueData['default_service_fee'],
					            'default_description'=>$issueData['default_description']);

				$genIssueData[$issue_id]['sub_categories'][] = $isData;
			}
		}
		$respArr = array();
		if(!empty($genIssueData)){
			foreach ($genIssueData AS $value) {
				$respArr[] = $value;
			}
		}

		return $respArr;
	}
}
?>