<div class="content-wrapper">
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php 
        $url = 'Issue/createIssue';
        $reqFlag = 'required';
        if(isset($issue_id) && !empty($issue_id)){
          $url = 'Issue/updateIssue/'.$issue_id;
          $reqFlag = '';
        }
        if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
            <button class="close" data-dismiss="alert" type="button">×</button>
            <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-body">
            <form role="form" action="<?= base_url($url) ?>" method="post" 
              class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <div class="col-md-12">
                <div class="col-md-4">
                  <div class="form-group">
                    <label>Issue</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change"
                    data-parsley-minlength="2" name="issue" required="" value="<?= (isset($issue_data->issue))?$issue_data->issue:'' ?>"placeholder="Issue Shot Discription">
                    <span class="glyphicon form-control-feedback"></span>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label>Issue Icon</label>
                    <div class="col-md-12" style="padding-bottom:10px;">
                      <div class="col-md-5">
                        <img class="small-icon" id="issue_image" src="<?= (isset($issue_data->issue_image))?base_url($issue_data->issue_image):'' ?>" onerror="this.src='<?=base_url("assets/images/no_image.png")?>';" />
                      </div>
                      <div class="col-md-7" style="padding-top: 12px;">
                        <input name="issue_image" type="file" accept="image/*" 
                          onchange="setImg(this,'issue_image');" <?= $reqFlag ?> />
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-12">  
                <div class="row" style="padding-left:30px;">
                  <label>Issue Sub Types</label>
                </div>   
                <div id="subIssueCntr"> 
                  <?php
                  $count = 1;
                  if(isset($issue_id) && !empty($issue_id) && isset($issue_data->sub_issue) && 
                     !empty($issue_data->sub_issue)){
                    foreach($issue_data->sub_issue AS $sub_issue){ ?>
                      <input type="hidden" name="extSubTypes[]" value="<?= $sub_issue->issue_cat_id ?>">
                      <div <div id="newSubIssue_<?= $count ?>">
                        <div class="col-md-1">
                          <div class="row marginTop10">
                            <div class="col-md-6"></div>
                            <div class="col-md-6">
                              <?php if($count == 1) { ?>
                                <i class="fa fa-plus-circle cpoint fav-add-icon" id="addSubIssue_1" 
                                 count="<?= count($issue_data->sub_issue) ?>"></i>
                              <?php } else { ?>
                                <i class="fa fa-times-circle-o cpoint fav-rem-icon" 
                                   onclick="remSubIssue(<?= $count ?>);"></i>
                              <?php } ?>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-2">    
                          <input type="text" class="form-control required marginTop-8" required data-parsley-trigger="change" data-parsley-minlength="2" name="issue_category_<?= $sub_issue->issue_cat_id ?>" 
                           placeholder="Issue Type" value="<?= $sub_issue->issue_category ?>">       
                        </div> 
                        <div class="col-md-3">    
                          <textarea type="text" class="form-control required marginTop-8" data-parsley-trigger="change" required data-parsley-minlength="2" name="default_description_<?= $sub_issue->issue_cat_id ?>" placeholder="Description" style="height:34px;"><?= $sub_issue->default_description ?></textarea>
                        </div>
                        <div class="col-md-2">    
                          <input type="text" class="form-control required marginTop-8" 
                          data-parsley-trigger="change" name="default_service_fee_<?= $sub_issue->issue_cat_id ?>" 
                          required data-parsley-minlength="2" placeholder="Default Service Fee" data-parsley-pattern="^[0-9\ . \/]+$" value="<?= $sub_issue->default_service_fee ?>" >  
                        </div>
                        <div class="col-md-4" style="padding-bottom:10px;">
                          <div class="col-md-4">
                            <img id="issue_cat_image_<?= $count ?>" src="<?= base_url($sub_issue->issue_cat_image) ?>" onerror="this.src='<?=base_url("assets/images/no_image.png")?>';" height="50" width="auto" />
                          </div>
                          <div class="col-md-8" style="padding-top: 12px;">
                            <input name="issue_cat_image_<?= $sub_issue->issue_cat_id ?>" 
                              type="file" accept="image/*" onchange="setImg(this,'issue_cat_image_<?= $count ?>');" <?= $reqFlag ?> />
                          </div>
                        </div>
                      </div>
                    <?php $count+=1; } 
                  } else { ?>
                  <div class="col-md-1">
                    <div class="row marginTop10">
                      <div class="col-md-6"></div>
                      <div class="col-md-6">
                        <i class="fa fa-plus-circle cpoint fav-add-icon" id="addSubIssue_1" count="1"></i>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-2">    
                    <input type="text" class="form-control required marginTop-8" data-parsley-trigger="change" data-parsley-minlength="2" name="issue_category[]"  placeholder="Issue Type" 
                    value="<?= (isset($sub_issue->issue_category))?$sub_issue->issue_category:'' ?>" required>
                  </div> 
                  <div class="col-md-3">    
                    <textarea type="text" class="form-control required marginTop-8" data-parsley-trigger="change" required="" data-parsley-minlength="2" name="default_description[]" 
                    placeholder="Description" style="height:34px;"><?= (isset($sub_issue->default_description))?$sub_issue->default_description:'' ?></textarea>
                  </div>
                  <div class="col-md-2">    
                    <input type="text" class="form-control required marginTop-8" required
                    data-parsley-trigger="change" data-parsley-minlength="2" name="default_service_fee[]"data-parsley-pattern="^[0-9\ . \/]+$" placeholder="Default Service Fee" 
                    value="<?= (isset($sub_issue->default_service_fee))?$sub_issue->default_service_fee:'' ?>">
                  </div>
                  <div class="col-md-4" style="padding-bottom:10px;">
                    <div class="col-md-4">
                      <img class="small-icon" id="issue_cat_image" src="<?= (isset($sub_issue->issue_cat_image))?base_url($sub_issue->issue_cat_image):'' ?>" onerror="this.src='<?=base_url("assets/images/no_image.png")?>';" />
                    </div>
                    <div class="col-md-8" style="padding-top: 12px;">
                      <input name="issue_cat_image[]" type="file" accept="image/*" 
                        onchange="setImg(this,'issue_cat_image');" <?= $reqFlag ?> />
                    </div>
                  </div>
                  <?php } ?>
                </div>
              </div> 
              <div class="col-md-12">      
                <div class="box-footer textCenterAlign">
                  <button type="submit" class="btn btn-primary">Submit</button>
                  <a href="<?= base_url('Issue/viewIssues') ?>" class="btn btn-primary">Cancel</a>
                </div>        
              </div>        
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>


<!-- ADD SUB ITEM HTML -->
  
<div id="subIssueAdd" class="hide"> 
  <div class="col-md-1">
    <div class="row marginTop10">
      <div class="col-md-6"></div>
      <div class="col-md-6">
        <i class="fa fa-times-circle-o cpoint fav-rem-icon" onclick="remSubIssue({:count});"></i>
      </div>
    </div>
  </div>
  <div class="col-md-2">    
    <input type="text" class="form-control required marginTop-8" data-parsley-trigger="change"
    data-parsley-minlength="2" name="issue_category[]" required="" placeholder="Issue Type">       
  </div> 
  <div class="col-md-3">    
    <textarea type="text" class="form-control required marginTop-8" data-parsley-trigger="change" required data-parsley-minlength="2" name="default_description[]" placeholder="Description" style="height:34px;"></textarea>
  </div>
  <div class="col-md-2">    
    <input type="text" class="form-control required marginTop-8" data-parsley-trigger="change" 
    required data-parsley-minlength="2" name="default_service_fee[]" placeholder="Default Service Fee" data-parsley-pattern="^[0-9\ . \/]+$" >  
  </div>
  <div class="col-md-4" style="padding-bottom:10px;">
    <div class="col-md-4">
      <img class="small-icon" id="issue_cat_image_{:count}" src="" onerror="this.src='<?=base_url("assets/images/no_image.png")?>';" />
    </div>
    <div class="col-md-8" style="padding-top: 12px;">
      <input name="issue_cat_image[]" type="file" accept="image/*" 
        onchange="setImg(this,'issue_cat_image_{:count}');" required />
    </div>
  </div>
</div>