<div class="content-wrapper">
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php 
        $url = (!isset($product_id) || empty($product_id))?'Product/createproduct':'Product/updateproduct/'.$product_id;
        if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
            <button class="close" data-dismiss="alert" type="button">×</button>
            <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-body">
            <form name="productAddForm" role="form" action="<?= base_url($url) ?>" method="post" 
              class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <!-- Basic Details -->
              <div class="col-md-12">  
                <div class="box-header with-border padUnset">
                  <h3 class="box-title">Basic Details</h3>
                </div><br>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Choose Brand</label>
                  <select name="brand_id" class="form-control required" placeholder="Select Brand" required="">
                    <option selected disabled>Choose a Brand</option>
                    <?php 
                      foreach ($brand_data as $brand) {
                        $select = (isset($brand->brand_id) && $brand->brand_id==$brand_id)?'selected':'';
                        echo '<option '.$select.' value="'.$brand->brand_id.'">'.
                                $brand->brand_name.
                             '</option>';
                      }
                    ?>
                  </select> 
                </div>
                <div class="form-group">
                  <label>Short Description</label>
                  <textarea type="text" class="form-control required" data-parsley-trigger="change"
                  data-parsley-minlength="2" name="short_description" required="" value="<?= (isset($product_data->short_description))?$product_data->short_description:'' ?>"
                  data-parsley-pattern="^[a-zA-Z0-9\ . _ @  \/]+$" placeholder="Enter Short Description"><?= (isset($product_data->short_description))?$product_data->short_description:'' ?></textarea>
                  <span class="glyphicon form-control-feedback"></span>
                </div>
                
                <div class="form-group">
                  <label>Part ID</label>
                  <input type="text" class="form-control" data-parsley-trigger="change" data-parsley-minlength="2" name="part_id"
                  placeholder="Enter Part ID" value="<?= (isset($product_data->part_id))?$product_data->part_id:'' ?>">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Product Name</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change" data-parsley-minlength="2" name="product_name" required="" 
                  placeholder="Enter Product Name" value="<?= (isset($product_data->product_name))?$product_data->product_name:'' ?>">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
                <div class="form-group">
                  <label>Amount</label>
                  <input type="number" class="form-control required" data-parsley-trigger="change"
                  data-parsley-minlength="2" name="amount" required="" value="<?= (isset($product_data->amount))?$product_data->amount:'' ?>"
                  data-parsley-pattern="^[0-9\ . \/]+$" placeholder="Enter Amount">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <!-- Mechanic Data -->
              <div class="col-md-12">  
                <div class="box-header with-border padUnset">
                  <h3 class="box-title">Product Details</h3>
                </div><br>
              </div>
              <div class="col-md-12">
                <div class="form-group">
                  <label>Product Images</label>
                  <div id="multipleImageInputCntr">
                    <?php 
                      $count = 1;
                      if(isset($product_image) && !empty($product_image)){ 
                        foreach($product_image AS $photos){ ?>
                          <div class="dropZoneContainer" id="multiImageCntr_<?= $count ?>">
                            <input type="hidden" name="existingImages[]" value="<?= $photos['id'] ?>">
                            <div id="multiImageClose_<?= $count ?>" class="close_custom cpoint" 
                                 onclick="removeImage('<?= $count ?>');">&times;</div>
                            <input disabled type="file" name="product_image[]" class="multiFileUpload" 
                                   accept="image/*" onchange="setMultiImg(this,jQuery(this));" 
                                   count="<?= $count ?>" />
                            <img class="multiDropZoneOverlay" id="multiImageImg_<?= $count ?>" 
                                 src="<?= base_url($photos['image']) ?>" onerror="this.src='<?=base_url("assets/images/add-image.png")?>';" />
                          </div>
                    <?php 
                          $count += 1; 
                        } 
                      }
                    ?>
                    <div class="dropZoneContainer" id="multiImageCntr_<?= $count ?>">
                      <div id="multiImageClose_<?= $count ?>" class="close_custom cpoint hide" 
                           onclick="removeImage('<?= $count ?>');">&times;</div>
                      <input type="file" name="product_image[]" class="multiFileUpload" accept="image/*" 
                             onchange="setMultiImg(this,jQuery(this));" count="<?= $count ?>" />
                      <img class="multiDropZoneOverlay" id="multiImageImg_<?= $count ?>" 
                           src="<?=base_url("assets/images/add-image.png")?>" />
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-12">
              <div class="form-group">
                <div class="row">
                  <div class="col-md-12">  
                    <div class="box-header with-border padUnset">
                      <h3 class="box-title">Product Details</h3>
                    </div>
                  </div>
                </div>
              </div>
              <div class="form-group">
                <div class="row">
                  <div class="col-md-3">
                  <label>Vehicle Model Year</label>
                  <select name="vehYear" class="form-control" input="search_params" 
                    data-parsley-trigger="change">
                    <option selected disabled value="">Choose Vehicle Model Year</option>
                    <?php 
                      for($year=date('Y'); $year>=1950; $year--){
                        $cond = (isset($product_data) && isset($product_data->year) && 
                                 !empty($product_data->year) && 
                                 $product_data->year == $year)?'selected':'';
                        echo '<option '.$cond.' value="'.$year.'">'.$year.'</option>'; 
                      }
                    ?>
                  </select>
                </div>
                <div class="col-md-4">
                  <label>Vehicle Make</label>
                  <select name="vehMake" class="form-control" data-parsley-trigger="change" id="veh_make">
                    <option selected disabled value="">Choose Vehicle Make</option>
                    <?php
                      foreach ($veh_data['make'] as $key => $value) {
                        $cond = (isset($product_data) && isset($product_data->veh_brand_id) && 
                                 !empty($product_data->veh_brand_id) && 
                                 $product_data->veh_brand_id == $value->veh_brand_id)?'selected':'';

                         echo '<option '.$cond.' maker="'.$value->veh_brand_id.'" value="'.$value->veh_brand_id.'">'.$value->maker.'</option>'; 
                      }
                    ?>
                  </select>
                </div>
                <div class="col-md-4">
                  <label>Vehicle Model</label>
                  <select name="vehModel" class="form-control" data-parsley-trigger="change" id="veh_model">
                    <option selected="" disabled="" value="">Choose Vehicle Model</option>
                    <?php
                      if((isset($product_id) || !empty($product_id))){
                        foreach ($veh_data['model'] as $key => $value) { 
                          $cond = (isset($product_data) && isset($product_data->veh_modal_id) && 
                                   !empty($product_data->veh_modal_id) && 
                                   $product_data->veh_modal_id == $value->veh_modal_id)?'selected':'';

                          echo '<option '.$cond.' value="'.$value->veh_modal_id.'">'.$value->model.' '.$value->trim.' '.$value->engine.'</option>'; 
                        }
                      }
                    ?>
                  </select>
                </div>
                <div class="col-md-1">
                  <div class="col-md-1">
                    <div class="row" style="margin-top: 28px !important;">
                      <div class="col-md-6"></div>
                      <div class="col-md-6">

                      <?php
                        $tot = (isset($product_data->carData) && !empty($product_data->carData))?count($product_data->carData):'0';
                        $count=0;
                      ?>
                        <i class="fa fa-plus-circle cpoint fav-add-icon" id="addPrdtCar" count="<?= $tot?>"></i>
                      </div>
                    </div>
                  </div>
                </div>
                </div>
                </div>
                <div class="row">
                  <div class="">
                    <div class="<?php (isset($product_data->carData) && !empty($product_data->carData))?'':'hide'?>" id="addCarResult">
                      <?php
                        if(isset($product_data->carData) && !empty($product_data->carData)){
                          $count = 0;
                          foreach ($product_data->carData as $key => $value) {
                      ?>
                      <div id="add_result_<?= $key+1; ?>" class="col-md-6 form-group">
                        <span class="disp-block" style="border:1px solid #e2e2e2;padding: 12px;">
                          <?php
                            $carName  = $value->year.' '.$value->maker.' '.$value->model;
                            $carName .= (!empty($value->trim))?' '.$value->trim:'';
                            $carName .= (!empty($value->engine))?', '.$value->engine:'';
                            echo $carName;
                          ?>
                          <div class="float-right">
                            <div class="float-right margin-all" style="margin-top:0px;">
                              <i class="fa fa-fw fa-close cpoint" onclick="removeProduct(<?= $key+1 ?>)"></i>
                            </div>
                          </div>
                          <input type="hidden" value="<?= $value->year ?>" name="prdVehYear[]">
                          <input type="hidden" value="<?= $value->veh_modal_id ?>" name="prdVehModel[]">
                        </span>
                      </div>
                      <?php
                        } }
                      ?>
                    </div>
                  </div>
                </div>
              <div class="row">
              <div class="col-md-6 padTop20">
                <div class="form-group">
                 <label>Product Description</label>
                  <textarea id="rich_editor" type="text" class="ip_reg_form_input form-control reset-form-custom" placeholder="Product Description" name="description" 
                  style="height:108px;" data-parsley-trigger="change" data-parsley-minlength="2"><?= (isset($product_data->description))?$product_data->description:'' ?></textarea>
                </div> 
              </div>
              <div class="col-md-6 padTop20">
                <div class="form-group">
                  <label>About</label>
                  <textarea id="rich_editor1" type="text" class="ip_reg_form_input form-control reset-form-custom" placeholder="About" name="about" 
                  style="height:108px;" data-parsley-trigger="change" data-parsley-minlength="2"><?= (isset($product_data->about))?$product_data->about:'' ?></textarea>
                </div>
              </div>
            </div>
          </div>
              <div class="col-md-12">      
                <div class="box-footer textCenterAlign">
                  <button id="addProductButton" type="submit" class="btn btn-primary">Submit</button>
                  <a href="<?= base_url('Product/viewProducts') ?>" class="btn btn-primary">Cancel</a>
                </div>        
              </div>        
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>


<div id="multipleImageInput" class="hide">
  <div class="dropZoneContainer" id="multiImageCntr_{:count}"  count="{:count}">
    <div id="multiImageClose_{:count}" class="close_custom hide" onclick="removeImage('{:count}');">&times;</div>
    <input id="event_image_{:count}" type="file" name="product_image[]" class="multiFileUpload" accept="image/*"
           onchange="setMultiImg(this,jQuery(this));" count="{:count}" />
    <img class="multiDropZoneOverlay" id="multiImageImg_{:count}" src="" 
           onerror="this.src='<?=base_url("assets/images/add-image.png")?>';" />
  </div>
</div>