<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mailtemplate extends CI_Controller {

	public function __construct() {
		parent::__construct();
        date_default_timezone_set("Asia/Riyadh");
		$this->load->model('Mailtemplate_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
		if($this->session->userdata['user_type'] != 1){
			$flashMsg = array('message'=>'Access Denied You don\'t have permission to access this Page',
							  'class'=>'error');
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url());
		}
 	}

	public function index() {

		$template['page'] = 'Notification/notification';
		$template['menu'] = "Notification Templates";
		$template['smenu'] = "Change Notification Templates";
        $template['pTitle'] = "Notification Templates";
        $template['page_head'] = "Notification Templates";
        $template['pDescription'] = "Change Notification Templates";

		$template['notificationData'] = $this->Mailtemplate_model->getNotifData();
		$this->load->view('template',$template);
	}

	public function changeNotifData(){
		$url = 'Mailtemplate/index';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url($url));
		}
	    
		if(!isset($_POST['customer_registration_mail']) || empty($_POST['customer_registration_mail'])){
			unset($_POST['customer_registration_mail']);
		}
		if(!isset($_POST['cancel_booking']) || empty($_POST['cancel_booking'])){
			unset($_POST['cancel_booking']);
		}
		if(!isset($_POST['mechanic_activation_mail']) || empty($_POST['mechanic_activation_mail'])){
			unset($_POST['mechanic_activation_mail']);
		}
		if(!isset($_POST['success_booking']) || empty($_POST['success_booking'])){
			unset($_POST['success_booking']);
		}

        $status = $this->Mailtemplate_model->updateNotif($_POST);
 		if($status){
 			$flashMsg['class'] = 'success'; 
 			$flashMsg['message'] = 'Settings Successfully Updated..!';
 		}
 		$this->session->set_flashdata('message',$flashMsg);
        redirect(base_url($url));
	}
}
?>