<?php
	defined('BASEPATH')OR exit('No direct script access allowed');
	header('Content-Type: text/html; charset=utf-8');
	
	// Allow from any origin
	if(isset($_SERVER['HTTP_ORIGIN'])) {
		header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
		header('Access-Control-Allow-Credentials: true');
		header('Access-Control-Max-Age: 86400'); // cache for 1 day
	}
	
	// Access-Control headers are received during OPTIONS requests
	if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
		header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
		exit(0);
	}
	
	class Webservices extends CI_Controller {
		
		public function __construct() {
			parent::__construct();
			$this->load->model('Webservice_model');
			$this->load->library('form_validation');
			
			$auth = '';
			$class = $this->router->fetch_class();
			$method = $this->router->fetch_method();
			
			if($this->input->server('REQUEST_METHOD') == 'GET')
			$postdata = json_encode($_GET);
			
			else if ($this->input->server('REQUEST_METHOD') == 'POST')
			$postdata = file_get_contents("php://input");
			
			if (isset(apache_request_headers()['Auth'])) {
				$auth = apache_request_headers()['Auth'];
			}

			define("PAYSTACK_SECRET_KEY", "sk_test_36658e3260b1d1668b563e6d8268e46ad6da3273");
		}
		
		// customer_login
		public function customer_login(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Customer_model');
			
			$respArr = array('status'=>'0','message'=>'Required Fields are empty.');
			if(!isset($postData['email']) || empty($postData['email']) || 
			!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
				echo json_encode($respArr);exit;
			}
			
			$custResp = $this->Customer_model->checkCustomerLogin($postData);
			if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
				echo json_encode($respArr);exit;
			}
			
			if($custResp['status'] == '1'){
				$respArr['data'] = $custResp['data'];
				$respArr['status'] = '1';
				$respArr['message'] = 'Success';
				echo json_encode($respArr);exit;
			}
			
			if($custResp['status'] == '2'){
				$respArr['status'] = '2';
				$respArr['message'] = 'Invalid Email Address';
				echo json_encode($respArr);exit;
			}
			
			if($custResp['status'] == '3'){
				$respArr['status'] = '3';
				$respArr['message'] = 'Invalid Password';
				echo json_encode($respArr);exit;
			}
			echo json_encode($respArr); exit;
		}
		
		// customer_forgot_password
		public function customer_forgot_password(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Customer_model');
			
			$respArr = array('status'=>'0','message'=>'Required Fields are empty.');
			if(empty($postData) || !isset($postData['email']) || empty($postData['email'])){
				echo json_encode($respArr);exit;
			}
			
			$custResp = $this->Customer_model->genCustForgotPassLink($postData);
			if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
				echo json_encode($respArr);exit;
			}
			
			if($custResp['status'] == '2'){
				$respArr['status'] = '2';
				$respArr['message'] = 'Invalid Email Address';
				echo json_encode($respArr);exit;
			}
			
			if($custResp['status'] == '1'){
				/*
					MAIL SENT CONFIGARATION -- TODO
				*/
				
				$respArr['status'] = '1';
				$respArr['message'] = 'Password Reset Email has been sent';
			}
			echo json_encode($respArr); exit;
		}
		
		// customer_registration
		public function customer_registration(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Customer_model');
			
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData)){
				echo json_encode($respArr);exit;
			}
			
			$err = 0;
			$msg = '';
			if(!isset($postData['email']) || empty($postData['email'])){
				$err = 1;
				$msg = 'Provide a valid Email ID';
			} 
			else if(!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
				$err = 1;
				$msg = 'Provide a Password';
			}
			else if(!isset($postData['first_name']) || empty($postData['first_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['last_name']) || empty($postData['last_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			
			if(isset($postData['phone']) && empty($postData['phone'])){
				unset($postData['phone']);
			}
			unset($postData['promocode']);
			
			$custResp = $this->Customer_model->createCustomer($postData);
			if(empty($custResp)){
				echo json_encode($respArr);exit;
			}
			
			if($custResp == '1'){
				$custResp = $this->Customer_model->checkCustomerLogin($postData);
				
				if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
					echo json_encode($respArr);exit;
				}
				
				if($custResp['status'] == '1'){
					$respArr['data'] = $custResp['data'];
					$respArr['status'] = '1';
					$respArr['message'] = 'Success';
					echo json_encode($respArr);exit;
				}
				} else if($custResp == '2'){
				$respArr['status'] = '2';
				$respArr['message'] = 'Email Address already in use';
				echo json_encode($respArr);exit;
				} else if($custResp == '3'){
				$respArr['status'] = '2';
				$respArr['message'] = 'Phone already in use';
				echo json_encode($respArr);exit;
			}
			
			
			echo json_encode($respArr); exit;
		}

			// Service Provider registration
		public function service_provider_registration(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData)){
				echo json_encode($respArr);exit;
			}
			
			$err = 0;
			$msg = '';
			if(!isset($postData['email']) || empty($postData['email'])){
				$err = 1;
				$msg = 'Provide a valid Email ID';
			} 
			else if(!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
				$err = 1;
				$msg = 'Provide a Password';
			}
			else if(!isset($postData['first_name']) || empty($postData['first_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['last_name']) || empty($postData['last_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['phone']) || empty($postData['phone'])){
				$err = 1;
				$msg = 'Provide valid Phone Number';
			}
			
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			
			$custResp = $this->Webservice_model->createServiceProvider($postData);
				
			if($custResp == '0'){
				$respArr['message'] = 'Something went wrong.';
			} else if($custResp == '1'){
				$respArr['status'] = '1';
				$respArr['message'] = 'Success';
			} else if($custResp == '2'){
				$respArr['message'] = 'Email Address already in use';
			} else if($custResp == '3'){
				$respArr['message'] = 'Phone already in use';
			}
			echo json_encode($respArr); exit;
		}
		
		// getGeneralIssues
		public function getGeneralIssues(){
			header('Content-type: application/json');
			
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			$this->load->model('Issue_model');
			$issue_data = $this->Issue_model->getGeneralIssues();
			
			if(!empty($issue_data)){
				$respArr['status'] = '1';
				$respArr['message'] = 'Success';
				$respArr['issue_data'] = $issue_data;
			}
			
			echo json_encode($respArr); exit;
		}
		
		// getNearByMechanics
		public function getNearByMechanics(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Mechanic_model');
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			
			if(empty($postData) || !isset($postData['pickup_data']) || !isset($postData['sub_issues']) || 
			empty($postData['pickup_data']) || empty($postData['sub_issues']) ){
				echo json_encode($respArr); exit;
			}
			
			$mechanic_data = $this->Mechanic_model->getNearByMechanics($postData['pickup_data'],$postData['sub_issues']);
			
			if(!empty($mechanic_data)){
				$respArr['status'] = '1';
				$respArr['message'] = 'Success';
				$respArr['mechanic_data'] = $mechanic_data;
			}
			echo json_encode($respArr); exit;
		}
		
		// scheduleNow
		public function scheduleNow(){
			header('Content-type: application/json');
			
			$postData = $_POST;
			$optionalData=array('optionlaDescription'=>'','optionalImages'=>array(),'optionalVideos'=>array());
			$respArr = array('status'=>'0','message'=>'Something went wrong.');

			if(empty($postData) || empty($postData = json_decode($postData['data'],true)) || 
			!isset($postData['cost']) || empty($postData['cost']) || 
			!isset($postData['customer_id']) || empty($postData['customer_id']) || 
			!isset($postData['mechanic_id']) || empty($postData['mechanic_id']) || 
			!isset($postData['pickup_data']) || empty($postData['pickup_data']) || 
			!isset($postData['vechile_info']) || empty($postData['vechile_info']) || 
			!isset($postData['schedule_date']) || empty($postData['schedule_date']) || 
			!isset($postData['selected_issues']) || empty($postData['selected_issues'])){
				echo json_encode($respArr);exit;
			}
			
			$optionalData['optionlaDescription'] = (isset($postData['optionalDescription']) && 
			!empty($postData['optionalDescription']))?
			$postData['optionalDescription']:'';
			
			if(isset($_FILES) && !empty($_FILES)){
				foreach ($_FILES as $fileIndex => $optImgs) {
					if(empty($optImgs) || !isset($optImgs['name']) || empty($optImgs['name'])){
						continue;
					}
					$this->load->library('upload');
					$config = set_upload_service("assets/uploads/services");
					$config['file_name'] = 'optionalImages'.$postData['customer_id'].date('dmYHis');
					$this->upload->initialize($config);
					if($this->upload->do_upload($fileIndex)){
						$upload_data = $this->upload->data();
						$optionalData['optionalImages'][] = $config['upload_path']."/".$upload_data['file_name'];
					}
				}
			}
			$this->load->model('Booking_model');
			
			$postData['optionalData'] = $optionalData;
			$status = $this->Booking_model->scheduleBooking($postData);

			if($status){
				$respArr['status'] = '1';
				$respArr['message'] = 'Success';
			}
			echo json_encode($respArr); exit;
		}
		
		// edit_customer_profile
		public function edit_customer_profile(){
			header('Content-type: application/json');
			
			$postData = $_POST;
			$this->load->model('Customer_model');
			
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || empty($postData = json_decode($postData['data'],true)) || 
			!isset($postData['customer_id']) || empty($postData['customer_id'])){
				echo json_encode($respArr);exit;
			}
			
			$err = 0;
			$msg = '';
			if(!isset($postData['email']) || empty($postData['email'])){
				$err = 1;
				$msg = 'Provide a valid Email ID';
			}
			else if(!isset($postData['first_name']) || empty($postData['first_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['last_name']) || empty($postData['last_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['phone']) || empty($postData['phone'])){
				$err = 1;
				$msg = 'Provide valid Phone';
			}
			else if(!isset($postData['address']) || empty($postData['address'])){
				$err = 1;
				$msg = 'Provide valid Address';
			}
			
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			
			if(isset($_FILES) && !empty($_FILES) && 
			isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])){
				$config = set_upload_service("assets/uploads/services");
				$this->load->library('upload');
				$config['file_name'] = $postData['customer_id']."_".$_FILES['profile_image']['name'];
				$this->upload->initialize($config);
				if($this->upload->do_upload('profile_image')){
					$upload_data = $this->upload->data();
					$postData['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
				}
			}
			
			$customer_id = $postData['customer_id'];
			if(isset($postData['password']) && !empty($postData['password']) && 
			isset($postData['cpassword']) && !empty($postData['cpassword']) && 
			$postData['password'] == $postData['cpassword']){
				$postData['password'] = md5($postData['password']);
				} else {
				unset($postData['password']);
			}
			unset($postData['cpassword']);
			unset($postData['customer_id']);
			
			$custResp = $this->Customer_model->updateCustomer($customer_id,$postData);
			if(empty($custResp)){
				echo json_encode($respArr);exit;
			}
			
			if($custResp == '1'){
				$respArr['status'] = '1';
				$respArr['message'] = 'Profile successfully updated';
				$respArr['profile_image'] = (isset($postData['profile_image']) && !empty($postData['profile_image']))?$postData['profile_image']:'';
				echo json_encode($respArr);exit;
				} else if($custResp == '2'){
				$respArr['status'] = '2';
				$respArr['message'] = 'Email Address already in use';
				echo json_encode($respArr);exit;
				} else if($custResp == '3'){
				$respArr['status'] = '3';
				$respArr['message'] = 'Phone Number already in use';
				echo json_encode($respArr);exit;
			}
			
			echo json_encode($respArr); exit;
		}
		
		// customerVechiles
		function customerVechiles(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Vehicle_model');
			
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
				echo json_encode($respArr);exit;
			}
			
			$vehData = $this->Vehicle_model->getCustVechiles($postData);
			if($vehData != '0'){
				$respArr['status'] = 1;
				$respArr['message'] = 'success';
				$respArr['vehData'] = $vehData;
			}
			echo json_encode($respArr);exit;
		}
		
		// getCustBookDetails
		function getCustBookDetails(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Booking_model');
			
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
				echo json_encode($respArr);exit;
			}
			
			$status = (isset($postData['status']) && !empty($postData['status']))?$postData['status']:'';
			$bookingDetails = $this->Booking_model->getCustBookDetails($postData,$status);
			if($bookingDetails != '0'){
				$respArr['status'] = 1;
				$respArr['message'] = 'success';
				$respArr['bookData'] = $bookingDetails;
			}
			echo json_encode($respArr);exit;
		}
		
		// cancelBooking
		function cancelBooking(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Booking_model');
			
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id']) || 
			!isset($postData['booking_id']) || empty($postData['booking_id'])){
				echo json_encode($respArr);exit;
			}
			
			$status=$this->Booking_model->changeBookStatus($postData['customer_id'],$postData['booking_id'],'4');
			
			if($status){
				$respArr['status'] = 1;
				$respArr['message'] = 'success';
			}
			echo json_encode($respArr);exit;
		}
		
		// deleteCustomerCar
		function deleteCustomerCar(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Vehicle_model');
			
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id']) || 
			!isset($postData['customer_veh_id']) || empty($postData['customer_veh_id'])){
				echo json_encode($respArr);exit;
			}
			
			$status = $this->Vehicle_model->changeCustomerCarStatus($postData['customer_id'],
			$postData['customer_veh_id'],'2');
			
			if($status){
				$respArr['status'] = 1;
				$respArr['message'] = 'success';
			}
			echo json_encode($respArr);exit;
		}
		
		// addCustomerCar
		function addCustomerCar(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Vehicle_model');
			
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
				echo json_encode($respArr);exit;
			}
			
			$param = "";
			$searchType = $postData['type'];
			$searchData = $postData['vehicleData'];
			$locationData = $postData['location'];
			
			$vehicle_data['status'] = '1';
			$vehicle_data['customer_id'] = $postData['customer_id'];
			$vehicle_data['car_loc_lat'] = $locationData['location_lat'];
			$vehicle_data['car_loc_lng'] = $locationData['location_lng'];
			$vehicle_data['car_location'] = $locationData['location'];

			$this->load->model('Settings_model');
			$settings = $this->Settings_model->settings_viewing();
			
			$searchData = $postData['vehicleData'];
			
			if($searchType == 1 && 
			isset($searchData['car_maker']) && !empty($searchData['car_maker']) && 
			isset($searchData['modelName']) && !empty($searchData['modelName']) && 
			isset($searchData['modelYear']) && !empty($searchData['modelYear'])){
				$vehicle_data['car_maker'] = $searchData['car_maker'];
				$vehicle_data['car_model'] = $searchData['modelName'];
				$vehicle_data['car_model_year'] = $searchData['modelYear'];
				
				$param = "?format=json&key=".urlencode($settings['vin_audit_api'])."&year=".
				urlencode($searchData['modelYear'])."&make=".urlencode($searchData['car_maker']).
				"&model=".urlencode($searchData['modelName']);
			}
			else if($searchType == 2 && isset($searchData['vin']) && !empty($searchData['vin'])){
				$vehicle_data['car_vin'] = $searchData['vin'];
				
				$param = "?format=json&key=".urlencode($settings['vin_audit_api']).
				"&vin=".urlencode($searchData['vin']);
			}
			
			if(!empty($param)){
				$vehData=file_get_contents("https://specifications.vinaudit.com/getspecifications.php".$param);
				if(empty($vehData) || empty($vehData = json_decode($vehData,true))){
					echo json_encode($return_arr);exit;
				}
				
				if(!isset($vehData['success']) || empty($vehData['success']) || $vehData['success'] == false){
					$return_arr['status'] = 2;
					$return_arr['message'] = 'No Data Found.';
					echo json_encode($return_arr);exit;
				}
				
				if($searchType == 2){
					$vehicle_data['car_model'] = $vehData['attributes']['Model'];
					$vehicle_data['car_maker'] = $vehData['attributes']['Make'];
					$vehicle_data['car_model_year'] = $vehData['attributes']['Year'];
					$vehData['vehicle']= $vehData['attributes']['Year'].' '.$vehData['attributes']['Make'].' '.
					$vehData['attributes']['Model'].' '.$vehData['attributes']['Trim'];
				}
				
				$vehicle_data['car_name'] = $vehData['vehicle'];
				$vehicle_data['vehicle_data'] = json_encode($vehData);
				
				$car_id = $this->Vehicle_model->addVehicle($vehicle_data);
				if(!empty($car_id)){
					$return_arr['status'] = '1';
					$return_arr['car_id'] = $car_id;
					$return_arr['veh_data'] = $vehData;
				}
			}
			echo json_encode($return_arr);exit;
		}
		

		/*********************************************************************************/
		/************************************Mobile API's*********************************/
		
	//Mobile Number Availability	
		public function mobile_number_availability(){
			header('Content-type: application/json');
			
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			
			$respArr = array('status'=>'error','error'=>'901','message'=>'Something went wrong.');
			
			if(!isset($postData['phone']) || empty($postData['phone']) && !isset($postData['country_code']) || empty($postData['country_code'])){
				$respArr = array('status'=>'0','error'=>'903','message'=>'Required Fields are empty.');
				echo json_encode($respArr);exit;
			}
			
			$custResp = $this->Webservice_model->checkMobAvailability($postData);
			if(!empty($custResp)){
				$respArr = $custResp;
			}
			echo json_encode($respArr);exit;
		}
	
	//User Login	
		public function user_login(){
			header('Content-type: application/json');
			
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			
			$respArr = array('status'=>'0','message'=>'Required Fields are empty.');
			
			if(!isset($postData['email']) || empty($postData['email']) || 
			!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
				echo json_encode($respArr);exit;
			}
			
			$custResp = $this->Webservice_model->checkCustomerLogin($postData);
			if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
				echo json_encode($respArr);exit;
			}
			
			if($custResp['status'] == '1'){
				$respArr['data'] = $custResp['data'];
				$respArr['status'] = 'success';
				$respArr['message'] = 'Success';
				echo json_encode($respArr);exit;
			}
			
			if($custResp['status'] == '2'){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Invalid Email Address';
				echo json_encode($respArr);exit;
			}
			
			if($custResp['status'] == '3'){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Invalid Password';
				echo json_encode($respArr);exit;
			}
			echo json_encode($respArr); exit;
		}
		
	// customer_registration
		public function user_registration(){
			header('Content-type: application/json');
			
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			
			if(empty($postData)){
				echo json_encode($respArr);exit;
			}
			
			$err = 0;
			$msg = '';
			if(!isset($postData['email']) || empty($postData['email'])){
				$err = 1;
				$msg = 'Provide a valid Email ID';
			} 
			else if(!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
				$err = 1;
				$msg = 'Provide a Password';
			}
			else if(!isset($postData['name']) || empty($postData['name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['country_code']) || empty($postData['country_code'])){
				$err = 1;
				$msg = 'Provide a Country Code';
			}
			
			else if(!isset($postData['phone']) && empty($postData['phone'])){
				$err = 1;
				$msg = 'Provide a Phone Number';
			}
			
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			
			$custResp = $this->Webservice_model->createCustomer($postData);
			if(empty($custResp)){
				echo json_encode($respArr);exit;
			}
			
			if($custResp['status'] == '1'){
				$respArr['data'] = $custResp['data'];
				$respArr['status'] = 'success';
				$respArr['message'] = 'Success';
				echo json_encode($respArr);exit;
			} else if($custResp['status'] == '2'){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Email Address already in use';
				echo json_encode($respArr);exit;
			} else if($custResp['status'] == '3'){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Phone already in use';
				echo json_encode($respArr);exit;
			}
			echo json_encode($respArr); exit;
		}
	
	//Get Booked Services	
		public function get_booked_services(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$bookData = $this->Webservice_model->getBookedService($authRes['data']['customer_id']);
			echo json_encode($bookData);exit;
		}
	
	//Add Vehicle Details	
		public function add_vehicle_details(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			
			$err = 0;$msg = '';
			if(empty($postData)){
				$respArr = array('status'=>0,'error'=>'901','message'=>'All Field is Required');
				echo json_encode($respArr);exit;
			}
			
			if(!isset($postData['vehicle_year']) || empty($postData['vehicle_year'])){
				$err = 1;
				$msg = 'Provide a Vehicle year';
			} 
			else if(!isset($postData['vehicle_make']) || empty($postData['vehicle_make'])){
				$err = 1;
				$msg = 'Provide a Vehicle Make';
			}
			else if(!isset($postData['vehicle_model']) || empty($postData['vehicle_model'])){
				$err = 1;
				$msg = 'Provide a Vehicle Model';
			}
			else if(!isset($postData['engine_no']) || empty($postData['engine_no'])){
				$err = 1;
				$msg = 'Provide an Engine Number';
			}
			else if(!isset($postData['vehicle_trim']) && empty($postData['vehicle_trim'])){
				$err = 1;
				$msg = 'Provide a Vehicle Trim';
			}
			else if(!isset($postData['mileage']) && empty($postData['mileage'])){
				$err = 1;
				$msg = 'Provide a Mileage';
			}
			else if(!isset($postData['car_loc_lat']) && empty($postData['car_loc_lat'])){
				$err = 1;
				$msg = 'Car Location is Required';
			}
			else if(!isset($postData['car_loc_lng']) && empty($postData['car_loc_lng'])){
				$err = 1;
				$msg = 'Car Location is Required';
			}
			else if(!isset($postData['car_location']) && empty($postData['car_location'])){
				$err = 1;
				$msg = 'Car Location is Required';
			}
			
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			
			$respData = $this->Webservice_model->addVehicleDetails($postData,$authRes['data']['customer_id']);
			echo json_encode($respData);exit;
		}
	
	//Get Services
		public function get_services(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			
			$postData = $_GET;
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']);
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			
			$currentpage = 0;
			$start = 0;
			$per_page = 10;
			
			if(isset($postData['page']) && strlen(trim($postData['page']," ")) > 0 ) {
				$currentpage =  (int)$postData['page'];
				$currentpage = $currentpage==0 ? $currentpage : $currentpage-1;
				$start = $currentpage * $per_page;
			}
			
			$serviceresult = $this->Webservice_model->get_service_list($postData,0,0);
			$serviceList = $this->Webservice_model->get_service_list($postData,$start,$per_page);
			
			$service = array();
			$total = 0;
			
			if($serviceresult['status'] == 'success'){
				$total = count($serviceresult['data']);	
			}
			
			if($total >= $per_page){
				$totalPages = (int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			
			if($serviceList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'services' => $serviceList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'services' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}
	
	//Get Vehicle Details
		public function get_vehicle_details(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			
			$respArr = array('status'=>'error','message'=>'Something Went Wrong.');
			
			if(empty($postData)){
				echo json_encode($respArr);exit;
			}
			else if(!isset($postData['bar_code']) && !empty($postData['bar_code'])){
				$respArr['message'] = 'Barcode is Required.';
				echo json_encode($respArr);exit;
			}
			
			$settings = getSettings();
			$param = "?format=json&key=".urlencode($settings['vin_audit_api']).
			"&vin=".urlencode($postData['bar_code']);
			
			$vehData=file_get_contents("https://specifications.vinaudit.com/getspecifications.php".$param);
			
			if(empty($vehData) || empty($vehData = json_decode($vehData,true))){
				echo json_encode($respArr);exit;
			}
			
			if(!isset($vehData['success']) || empty($vehData['success']) || $vehData['success'] == false || !isset($vehData['attributes']) || empty($vehData['attributes'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Invalid Vin Number.';
				echo json_encode($respArr);exit;
			}
			$respArr['status'] = 'success';
			$respArr['data'] = $vehData['attributes'];
			$respArr['message'] = 'Success';
			echo json_encode($respArr);exit;
		}
		
	//Search Sub Services
		public function search_sub_services(){
			header('Content-type: application/json');
			$headers = apache_request_headers();

			$postData = $_GET;
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			
			$currentpage = 0;
			$start = 0;
			$per_page = 10;
			
			if(isset($postData['page']) && strlen(trim($postData['page']," ")) > 0 ) {
				$currentpage =  (int)$postData['page'];
				$currentpage = $currentpage==0 ? $currentpage : $currentpage-1;
				$start = $currentpage * $per_page;
			}
			
			$subserviceresult = $this->Webservice_model->search_sub_services($postData,0,0);
			$subserviceList = $this->Webservice_model->search_sub_services($postData,$start,$per_page);
			
			$service = array();
			$total = 0;
			
			if($subserviceresult['status'] == 'success'){
				$total = count($subserviceresult['data']);	
			}
			
			if($total >= $per_page){
				$totalPages = (int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			
			if($subserviceList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'sub_services' => $subserviceList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page
					)
				);
			}else if($subserviceList['status'] == 'error'){
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'sub_services' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = $subserviceList;
				$respArr['status'] = 'error';
			}
			echo json_encode($respArr);exit;
		}
	
	//Book Service
		public function book_service(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			
			
			if(empty($postData)){
				$respArr = array('status'=>'error','message'=>'All Field is Required');
				echo json_encode($respArr);exit;
			}
			$err = 0;
			
			if(!isset($postData['booking_id']) || empty($postData['booking_id'])){
				$err = 1;
				$msg = 'Booking Id is Required';
			} 
			else if(!isset($postData['total_cost']) || empty($postData['total_cost'])){
				$err = 1;
				$msg = 'Total Cost is Required';
			}
			else if(!isset($postData['mechanic_id']) || empty($postData['mechanic_id'])){
				$err = 1;
				$msg = 'Mechanic Id is Required';
			}
			else if(!isset($postData['date']) || empty($postData['date'])){
				$err = 1;
				$msg = 'Date is Required';
			}
			else if(!isset($postData['time']) && empty($postData['time'])){
				$err = 1;
				$msg = 'Time is Required';
			}
			
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			
			$respData = $this->Webservice_model->book_service($postData);
			echo json_encode($respData);exit;
			
		}
		
	//Get Booking Summary
		public function get_booking_summary(){
			header('Content-type: application/json');
			$headers = apache_request_headers();

			$postData = $_GET;
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$res = $this->Webservice_model->get_booking_summary($postData);
			echo json_encode($res);exit;
		}
	
	//Get Mechanics	
		public function get_mechanics(){
			header('Content-type: application/json');
			$headers = apache_request_headers();

			$postData = $_GET;
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			
			$err = 0;
			if(!isset($postData['service_id']) || empty($postData['service_id'])){
				$err = 1;
				$msg = 'Service Id is Required';
			} 
			else if(!isset($postData['location']) || empty($postData['location'])){
				$err = 1;
				$msg = 'Location is Required';
			}
			else if(!isset($postData['location_lat']) || empty($postData['location_lat'])){
				$err = 1;
				$msg = 'Location is Required';
			}
			else if(!isset($postData['location_lng']) || empty($postData['location_lng'])){
				$err = 1;
				$msg = 'Location is Required';
			}
			
			if($err == 1){
				$respArr['status'] = 'error';
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			
			$currentpage = 0;
			$start = 0;
			$per_page = 10;
			
			if(isset($postData['page']) && strlen(trim($postData['page']," ")) > 0 ) {
				$currentpage =  (int)$postData['page'];
				$currentpage = $currentpage==0 ? $currentpage : $currentpage-1;
				$start = $currentpage * $per_page;
			}
			
			$mechanicsListcount = $this->Webservice_model->getNearMechanics($postData,0,0);
			$mechanicsList = $this->Webservice_model->getNearMechanics($postData,$start,$per_page);
			$total = 0;
			
			if($mechanicsList['status'] == 'success'){
				$total = count($mechanicsListcount['data']);	
			}
			
			if($total >= $per_page){
				$totalPages = (int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			
			if($mechanicsList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'mechanics' => $mechanicsList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page)
					);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'mechanics' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page)
					);
			}
			echo json_encode($respArr);exit;
		}
	
	//Add Service Details
		public function add_service_details(){
			header('Content-type: application/json');
			$headers = apache_request_headers();

			$postData = $_POST;
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			if(isset($_FILES['images']) && !empty($_FILES['images'])){
				$files = $_FILES;
				$config = set_upload_service('assets/uploads/services'); 
				$this->load->library('upload');
				for ($i=0; $i < count($files['images']['name']) ; $i++){ 

					$config['file_name'] = 'optionalImages'.date('dmYHis').$files['images']['name'][$i];
					$this->upload->initialize($config);
					$_FILES['images']['name'] = $files['images']['name'][$i];
					$_FILES['images']['type'] = $files['images']['type'][$i];
					$_FILES['images']['tmp_name'] = $files['images']['tmp_name'][$i];
					$_FILES['images']['error'] = $files['images']['error'][$i];
					$_FILES['images']['size'] = $files['images']['size'][$i];    
					if($this->upload->do_upload('images'))
					{
						$imagedata= $this->upload->data();
						$new[$i] = 'assets/uploads/services/'.$imagedata['file_name'];
					}
					else
					{
						$display_error = array('error' => $this->upload->display_errors('', '')); 
						$res = array(
						"status"=> "error",
						"error"=> "Upload Error",
						"msg"=> "Sorry! Images not uploaded. ".$display_error['error']
						);	
						print json_encode($res);
						exit();
					}
				}
				
				$postData['image'] = $new;
			}
			
			if(isset($_FILES['videos']) && !empty($_FILES['videos'])){
				$files = $_FILES;
				
				$config = set_upload_service('assets/uploads/services'); 
				$this->load->library('upload');
				for ($i=0; $i < count($files['videos']['name']) ; $i++){ 

					$config['file_name'] = 'optionalImages'.date('dmYHis').$_FILES['videos']['name'][$i];
					$this->upload->initialize($config);
					$_FILES['videos']['name'] = $files['videos']['name'][$i];
					$_FILES['videos']['type'] = $files['videos']['type'][$i];
					$_FILES['videos']['tmp_name'] = $files['videos']['tmp_name'][$i];
					$_FILES['videos']['error'] = $files['videos']['error'][$i];
					$_FILES['videos']['size'] = $files['videos']['size'][$i];    
					if($this->upload->do_upload('videos'))
					{
						$imagedata= $this->upload->data();
						$video[$i] = 'assets/uploads/services/'.$imagedata['file_name'];
					}
					else
					{
						$display_error = array('error' => $this->upload->display_errors('', '')); 
						$res = array(
						"status"=> "error",
						"error"=> "Upload Error",
						"msg"=> "Sorry! Images not uploaded. ".$display_error['error']
						);	
						echo json_encode($res);
						exit();
					}
				}
				$postData['video'] = $video;
			}
			$addServiceDetails = $this->Webservice_model->add_service_details($postData);
			echo json_encode($addServiceDetails);exit();
		}

	//Remove Booking
		public function remove_booking(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);

			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$removed = $this->Webservice_model->remove_booking($postData);
			echo json_encode($removed);
		}

	//Get Service
		public function get_service(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}

			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']);
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			
			$getServices = $this->Webservice_model->get_service($postData);
			echo json_encode($getServices);exit;
		}

		//Mechanic Rating
		public function rate_mechanic(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']);
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$postData['customer_id'] = $authRes['data'];
			$result = $this->Webservice_model->rate_mechanic($postData);
			echo json_encode($result);exit;
		}

		//Accept Mechanic Quote
		public function acceptMechanicQuote(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->acceptMechanicQuote($postData);
			echo json_encode($result);exit;
		}

		//Payment Integration of Mechanic Booking
		public function payNow($transId=''){
			if(empty($transId)){
				$this->fail();
			}

            $mechData = $this->Webservice_model->getMechAmount($transId);
            $amount   = $mechData['data']['amount'] * 100;
            $callback = base_url().'Webservices/verify_payment/'.$transId.'/1';
            $postdata = array('email' => $mechData['emailId'], 
            				  'amount' => $amount,
            				  'reference' => $transId, 
            				  'callback_url' => $callback);

            $this->payStackPayment($postdata);
		}

		//Payment Integration of Order Booking
		public function orderPayNow($orderId=''){
			if(empty($orderId)){
				$this->fail();
			}

			$orderData = $this->Webservice_model->getOrderPayDetails($orderId);
			if($orderData['status'] == 'success'){
				$amount   = $orderData['data']->amount * 100;
	            $callback = base_url().'Webservices/verify_payment/'.$orderId.'/2';
	            $postdata = array('email' => $orderData['data']->email, 
	            				  'amount' => $amount,
	            				  'reference' => $orderId, 
	            				  'callback_url' => $callback);

	            $this->payStackPayment($postdata);
			}
		}

	    public function payStackPayment($postdata=array()) {
            $url = "https://api.paystack.co/transaction/initialize";
            $ch  = curl_init();
            curl_setopt($ch, CURLOPT_URL,$url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            $headers = [
                'Authorization: Bearer '.PAYSTACK_SECRET_KEY,
                'Content-Type: application/json',
            ];

            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $request = curl_exec ($ch);
            curl_close ($ch);

            $result = array();
            if ($request) {
                $result = json_decode($request, true);
            }
            $redir = $result['data']['authorization_url'];
            header("Location: ".$redir);
		}

		public function verify_payment($ref='',$payFor='1') {
			if(empty($ref)){
				$this->fail();
			}

	        $result = array();
	        $url = 'https://api.paystack.co/transaction/verify/'.$ref;
	        $ch = curl_init();
	        curl_setopt($ch, CURLOPT_URL, $url);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	        curl_setopt(
	            $ch, CURLOPT_HTTPHEADER, [
	            'Authorization: Bearer '.PAYSTACK_SECRET_KEY]
	        );
	        $request = curl_exec($ch);
	        curl_close($ch);

	        if ($request) {
	            $result = json_decode($request, true);
	            $status = $this->Webservice_model->transactionResp($ref,$result,$payFor);
	            if($status){
	            	if($result){
		                if($result['data']){
		                    if($result['data']['status'] == 'success'){
		                        header("Location:".base_url('Webservices/success/'.$ref.'/'.$payFor));
		                    }else{
		                        header("Location:".base_url('Webservices/fail/'.$ref.'/'.$payFor));
		                    }
		                }
		                else{
		                    header("Location: ".base_url('Webservices/fail/'.$ref.'/'.$payFor));
		                }
		            }else{
		                header("Location: ".base_url('Webservices/fail/'.$ref.'/'.$payFor));
		            }
	            }
	        }else{
	            header("Location: ".base_url('Webservices/fail/'.$ref.'/'.$payFor));
	        }
	    }

		public function fail($ref='',$payFor='1'){
			$settings = getSettings();
			if($payFor == '1'){
				$url = $settings['web_url']."/dashboard?status=failure&tab=appointment&ref=".$ref;
				header("Location:".$url);
			}else{
				$url = $settings['web_url']."/purchaseHome?status=failure&ref=".$ref;
				header("Location:".$url);
			}
		}

		public function success($ref='',$payFor='1'){
			if($payFor == '1'){
				$this->serviceBookSuccess($ref);
			}else{
				$this->orderPlacedSuccess($ref);
			}
		}

		public function serviceBookSuccess($ref=''){
			$this->db->select('customer_vehicle.car_name,bookings.scheduled_date,bookings.scheduled_time,
							   customers.email,bookings.cost');
		    $this->db->from('transaction');
		    $this->db->join('bookings','transaction.booking_id = bookings.booking_id');
		    $this->db->join('customer_vehicle','customer_vehicle.customer_veh_id = bookings.customer_veh_id');
		    $this->db->join('customers','customers.customer_id = bookings.customer_id');
		    $this->db->where('transaction.id',$ref);
		    $bookData = $this->db->get()->row();
			$subject    = "DcarFixxers, Payment Successfull";
			$email_id   = $bookData->email;
			$message    = "<html>
							<body>
							  Hi,\n\r Welcome to DcarFixxers. \r\n Your Payment for the vehicle ".$bookData->car_name." on date ".$bookData->scheduled_date." at ".$bookData->scheduled_time." for amount ".$bookData->cost." is Success
							</body>
						   </html>";

			$template = getNotifTemplate();
	        if(isset($template['success_booking']) && !empty($template['success_booking'])){
	            $message = str_replace(array('{:car_name}','{:book_date}','{:amount}'),array($bookData->car_name,$bookData->scheduled_date,$bookData->cost),$template['success_booking']);
	        }
			send_mail($subject,$email_id,$message);

			$settings = getSettings();
			$url = $settings['web_url']."/dashboard?status=success&tab=appointment&ref=".$ref;
			header("Location: ".$url);
		}

		public function orderPlacedSuccess($ref=''){
			$settings = getSettings();
			$url = $settings['web_url']."/track?ref=".$ref;
			header("Location: ".$url);
		}

		//Search Products
		public function productSearch(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			
			$total = 0;
			$per_page = 10;
		    $page = (isset($postData['page']) && $postData['page'] != 1) ?$postData['page'] :'1'; 
		    $page_limit = ($page - 1) * $per_page;

			$result = $this->Webservice_model->productSearch($postData,0,0);
			$prodList = $this->Webservice_model->productSearch($postData,$page_limit,$per_page);
			
			if($result['status'] == 'success'){
				$total = count($result['data']);	
			}
			
			if($total >= $per_page){
				$totalPages = (int)($total%$per_page == 0?$total/$per_page:($total/$per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			
			if($prodList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => $prodList['data'],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' =>  [],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}

		//Get Brands
		public function getBrands(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$result = $this->Webservice_model->getBrands();
			echo json_encode($result);exit;
		}

		//Search Product By Brand
		public function productSearchbyBrand(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->productSearchbyBrand($postData);
			echo json_encode($result);exit;
		}

		//Single Product Search
		public function SingleProductSearch(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->SingleProductSearch($postData);
			echo json_encode($result);exit;
		}

		//Save User Address
		public function saveUserAddress(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->saveUserAddress($postData);
			echo json_encode($result);exit;
		}

		//Initiate Order Booking
		public function initOrderBooking(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->initOrderBooking($postData);
			echo json_encode($result);exit;
		}

		//Get User Address
		public function getUserAddress(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->getUserAddress($postData);
			echo json_encode($result);exit;
		}

		//Get User Address By Id
		public function getUserAddressById(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->getUserAddressById($postData);
			echo json_encode($result);exit;
		}

		//Update User Address
		public function updateUserAddress(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->updateUserAddress($postData);
			echo json_encode($result);exit;
		}

		//Get Order Details
		public function getOrderDetail(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->getOrderDetail($postData);
			echo json_encode($result);exit;
		}

		public function rateProduct(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->rateProduct($postData);
			echo json_encode($result);exit;
		}

		public function get_latest_product_list(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$per_page = 10;
			
			$page = (isset($_GET['page']) && $_GET['page'] >= 1)?(int)$_GET['page']:1; 
		    $start = ($page - 1) * $per_page; 

			$productResult = $this->Webservice_model->get_latest_product_list(0,0);
			$productList = $this->Webservice_model->get_latest_product_list($start,$per_page);
			
			$product = array();
			$total = 0;
			
			if($productResult['status'] == 'success'){
				$total = count($productResult['data']);	
			}
			
			if($total >= $per_page){
				$totalPages = (int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			
			if($productList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'latest_products' => $productList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'latest_products' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}

		public function get_trending_product_list(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$per_page = 10;
			
			$page = (isset($_GET['page']) && $_GET['page'] >= 1)?(int)$_GET['page']:1; 
		    $start = ($page - 1) * $per_page; 
			
			$productResult = $this->Webservice_model->get_trending_product_list(0,0);
			$productList = $this->Webservice_model->get_trending_product_list($start,$per_page);
			
			$product = array();
			$total = 0;
			
			if($productResult['status'] == 'success'){
				$total = count($productResult['data']);	
			}
			
			if($total >= $per_page){
				$totalPages = (int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			
			if($productList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'trending_products' => $productList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'trending_products' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}

		public function product_details(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->SingleProductSearch($postData);
			echo json_encode($result);exit;
		}

		public function add_address(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$postData['customer_id'] = $authRes['data']['customer_id'];
			$result = $this->Webservice_model->saveUserAddress($postData);
			echo json_encode($result);exit;
		}

		public function address_details(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$postData['user_id'] = $authRes['data']['customer_id'];

			$result = $this->Webservice_model->getUserAddress($postData);
			echo json_encode($result);exit;
		}

		public function getLatestPrdts(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$per_page = 10;
		    $page = (isset($postData['page']) && $postData['page'] != 1) ?$postData['page'] :'1';  
		    $page_limit = ($page - 1) * $per_page;  

			$latestResult = $this->Webservice_model->get_latest_product_list(0,0);
			$latestList = $this->Webservice_model->get_latest_product_list($page_limit,$per_page);
			
			if($latestResult['status'] == 'success'){
				$total = count($latestResult['data']);	
			}
			
			if($total >= $per_page){
				$totalPages = (int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			
			if($latestList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => $latestList['data'],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => [],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}

		public function getTrendingPrdts(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$total = 0;
			$per_page = 10;
		    $page = (isset($postData['page']) && $postData['page'] != 1) ?$postData['page'] :'1'; 
		    $page_limit = ($page - 1) * $per_page;

			$trendResult = $this->Webservice_model->get_trending_product_list(0,0);
			$trendList = $this->Webservice_model->get_trending_product_list($page_limit,$per_page);
			
			if($trendResult['status'] == 'success'){
				$total = count($trendResult['data']);	
			}
			
			if($total >= $per_page){
				$totalPages = (int)($total%$per_page == 0?$total/$per_page:($total/$per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			
			if($trendList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => $trendList['data'],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' =>  [],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}

		public function getMyOrders(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$total = 0;
			$per_page = 10;
		    $page = (isset($postData['page']) && $postData['page'] != 1) ?$postData['page'] :'1'; 
		    $page_limit = ($page - 1) * $per_page;
			
			$result = $this->Webservice_model->getMyOrders($postData,0,0);
			$resultList = $this->Webservice_model->getMyOrders($postData,$page_limit,$per_page);

			if($result['status'] == 'success'){
				$total = count($result['data']);	
			}
			
			if($total >= $per_page){
				$totalPages = (int)($total%$per_page == 0?$total/$per_page:($total/$per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			
			if($resultList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => $resultList['data'],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' =>  [],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}

		public function cancelOrder(){
			header('Content-type:application/json');
			$headers = apache_request_headers();

			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			$result = $this->Webservice_model->cancelOrder($postData);
			echo json_encode($result);exit;
		}
	}

	
?>
