<div class="content-wrapper">
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php 
        $url = (!isset($product_id) || empty($product_id))?'Product/createproduct':'Product/updateproduct/'.$product_id;
        if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
            <button class="close" data-dismiss="alert" type="button">×</button>
            <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-body">
            <form name="productAddForm" role="form" action="<?= base_url($url) ?>" method="post" 
              class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <!-- Basic Details -->
              <div class="col-md-12">  
                <div class="box-header with-border padUnset">
                  <h3 class="box-title">Basic Details</h3>
                </div><br>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Choose Brand</label>
                  <select name="brand_id" class="form-control required" placeholder="Select Brand" required="">
                    <option selected disabled>Choose a Brand</option>
                    <?php 
                      foreach ($brand_data as $brand) {
                        $select = (isset($brand->brand_id) && $brand->brand_id==$brand_id)?'selected':'';
                        echo '<option '.$select.' value="'.$brand->brand_id.'">'.
                                $brand->brand_name.
                             '</option>';
                      }
                    ?>
                  </select> 
                </div>
                <div class="form-group">
                  <label>Short Description</label>
                  <textarea type="text" class="form-control required" data-parsley-trigger="change"
                  data-parsley-minlength="2" name="short_description" required="" value="<?= (isset($product_data->short_description))?$product_data->short_description:'' ?>"
                  data-parsley-pattern="^[a-zA-Z0-9\ . _ @  \/]+$" placeholder="Enter Short Description"><?= (isset($product_data->short_description))?$product_data->short_description:'' ?></textarea>
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Product Name</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change" data-parsley-minlength="2" name="product_name" required="" 
                  placeholder="Enter Product Name" value="<?= (isset($product_data->product_name))?$product_data->product_name:'' ?>">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
                <div class="form-group">
                  <label>Amount</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change"
                  data-parsley-minlength="2" name="amount" required="" value="<?= (isset($product_data->amount))?$product_data->amount:'' ?>"
                  data-parsley-pattern="^[0-9\ . \/]+$" placeholder="Enter Amount">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <!-- Mechanic Data -->
              <div class="col-md-12">  
                <div class="box-header with-border padUnset">
                  <h3 class="box-title">Product Details</h3>
                </div><br>
              </div>
              <div class="col-md-12">
                <div class="form-group">
                  <label>Product Images</label>
                  <div id="multipleImageInputCntr">
                    <?php 
                      $count = 1;
                      if(isset($product_image) && !empty($product_image)){ 
                        foreach($product_image AS $photos){ ?>
                          <div class="dropZoneContainer" id="multiImageCntr_<?= $count ?>">
                            <input type="hidden" name="existingImages[]" value="<?= $photos['id'] ?>">
                            <div id="multiImageClose_<?= $count ?>" class="close_custom cpoint" 
                                 onclick="removeImage('<?= $count ?>');">&times;</div>
                            <input disabled type="file" name="product_image[]" class="multiFileUpload" 
                                   accept="image/*" onchange="setMultiImg(this,jQuery(this));" 
                                   count="<?= $count ?>" />
                            <img class="multiDropZoneOverlay" id="multiImageImg_<?= $count ?>" 
                                 src="<?= base_url($photos['image']) ?>" onerror="this.src='<?=base_url("assets/images/add-image.png")?>';" />
                          </div>
                    <?php 
                          $count += 1; 
                        } 
                      }
                    ?>
                    <div class="dropZoneContainer" id="multiImageCntr_<?= $count ?>">
                      <div id="multiImageClose_<?= $count ?>" class="close_custom cpoint hide" 
                           onclick="removeImage('<?= $count ?>');">&times;</div>
                      <input type="file" name="product_image[]" class="multiFileUpload" accept="image/*" 
                             onchange="setMultiImg(this,jQuery(this));" count="<?= $count ?>" />
                      <img class="multiDropZoneOverlay" id="multiImageImg_<?= $count ?>" 
                           src="<?=base_url("assets/images/add-image.png")?>" />
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-12">  
                <div class="box-header with-border padUnset">
                  <h3 class="box-title">Product Details</h3>
                </div><br>
              </div>

              <div class="form-group">
                <div class="col-md-4">
                  <label>Vehicle Model Year</label>
                  <select name="vehYear" class="form-control required" input="search_params" 
                    data-parsley-trigger="change" required="">
                    <option selected disabled value="">Choose Vehicle Model Year</option>
                    <?php 
                      for($year=date('Y'); $year>=1950; $year--){
                        $cond = (isset($product_data) && isset($product_data->year) && 
                                 !empty($product_data->year) && 
                                 $product_data->year == $year)?'selected':'';
                        echo '<option '.$cond.' value="'.$year.'">'.$year.'</option>'; 
                      }
                    ?>
                  </select>
                </div>
                <div class="col-md-4">
                  <label>Vehicle Make</label>
                  <select name="vehMake" class="form-control required" input="search_params" 
                    data-parsley-trigger="change" required="">
                    <option selected disabled value="">Choose Vehicle Make</option>
                    <option <?= ($product_data->make == 'Toyota') ? 'selected' : ''?> value="Toyota">Toyota</option>
                    <option <?= ($product_data->make == 'Alto') ? 'selected' : ''?> value="Alto">Alto</option>
                    <option <?= ($product_data->make == 'Hyundai') ? 'selected' : ''?> value="Hyundai">Hyundai</option>
                    <option <?= ($product_data->make == 'Hyundai') ? 'selected' : ''?> value="Hyundai">Hyundai</option>
                    <option <?= ($product_data->make == 'Hyundai') ? 'selected' : ''?> value="Hyundai">Hyundai</option>
                    <option <?= ($product_data->make == 'Hyundai') ? 'selected' : ''?> value="Hyundai">Hyundai</option>
                    <option <?= ($product_data->make == 'Hyundai') ? 'selected' : ''?> value="Hyundai">Hyundai</option>
                    <option <?= ($product_data->make == 'Hyundai') ? 'selected' : ''?> value="Hyundai">Hyundai</option>
                    <option <?= ($product_data->make == 'Hyundai') ? 'selected' : ''?> value="Hyundai">Hyundai</option>
                    <option <?= ($product_data->make == 'Hyundai') ? 'selected' : ''?> value="Hyundai">Hyundai</option>
                    <option <?= ($product_data->make == 'Hyundai') ? 'selected' : ''?> value="Hyundai">Hyundai</option>
                    <option <?= ($product_data->make == 'Hyundai') ? 'selected' : ''?> value="Hyundai">Hyundai</option>
                    <option <?= ($product_data->make == 'Ford') ? 'selected' : ''?> value="Ford">Ford</option>
                    <option <?= ($product_data->make == 'Ford') ? 'selected' : ''?> value="Ford">Ford</option>
                    <option <?= ($product_data->make == 'Honda') ? 'selected' : ''?> value="Honda">Honda</option>
                    <option <?= ($product_data->make == 'Honda') ? 'selected' : ''?> value="Honda">Honda</option>
                    <option <?= ($product_data->make == 'Honda') ? 'selected' : ''?> value="Honda">Honda</option>
                  </select>
                </div>
                <div class="col-md-4">
                  <label>Vehicle Model</label>
                  <select name="vehModel" class="form-control required" input="search_params" 
                    data-parsley-trigger="change" required="">
                    <option selected="" disabled="" value="">Choose Vehicle Model</option>
                    <option <?= ($product_data->model == 'Corolla') ? 'selected' : ''?> value="Corolla">Corolla</option>
                    <option <?= ($product_data->model == '800') ? 'selected' : ''?> value="800">800</option>
                    <option <?= ($product_data->model == 'Eon') ? 'selected' : ''?>value="Eon">Eon</option>
                    <option <?= ($product_data->model == 'Eon') ? 'selected' : ''?> value="Eon">Eon</option>
                    <option <?= ($product_data->model == 'i10') ? 'selected' : ''?> value="i10">i10</option>
                    <option <?= ($product_data->model == 'i20') ? 'selected' : ''?> value="i20">i20</option>
                    <option <?= ($product_data->model == 'i10 Grand') ? 'selected' : ''?>value="i10 Grand">i10 Grand</option>
                    <option <?= ($product_data->model == 'i20 Grand') ? 'selected' : ''?> value="i20 Grand">i20 Grand</option>
                    <option <?= ($product_data->model == 'i10 Magna') ? 'selected' : ''?> value="i10 Magna">i10 Magna</option>
                    <option <?= ($product_data->model == 'i20 Magna') ? 'selected' : ''?> value="i20 Magna">i20 Magna</option>
                    <option <?= ($product_data->model == 'Sonata') ? 'selected' : ''?> value="Sonata">Sonata</option>
                    <option <?= ($product_data->model == 'Creta') ? 'selected' : ''?> value="Creta">Creta</option>
                    <option <?= ($product_data->model == 'Aspair') ? 'selected' : ''?> value="Aspair">Aspair</option>
                    <option <?= ($product_data->model == 'Eco-sport') ? 'selected' : ''?> value="Eco-sport">Eco-sport</option>
                    <option <?= ($product_data->model == 'City') ? 'selected' : ''?> value="City">City</option>
                    <option <?= ($product_data->model == 'Amaze') ? 'selected' : ''?> value="Amaze">Amaze</option>
                    <option <?= ($product_data->model == 'Sonata') ? 'selected' : ''?> value="Sonata">Sonata</option>
                  </select>
                </div>
              </div>

              <div class="col-md-6 padTop20">
                <div class="form-group">
                 <label>Product Description</label>
                  <textarea id="rich_editor" type="text" class="ip_reg_form_input form-control reset-form-custom" placeholder="Product Description" name="description" 
                  style="height:108px;" data-parsley-trigger="change" data-parsley-minlength="2"><?= (isset($product_data->description))?$product_data->description:'' ?></textarea>
                </div> 
              </div>
              <div class="col-md-6 padTop20">
                <div class="form-group">
                  <label>About</label>
                  <textarea id="rich_editor1" type="text" class="ip_reg_form_input form-control reset-form-custom" placeholder="About" name="about" 
                  style="height:108px;" data-parsley-trigger="change" data-parsley-minlength="2"><?= (isset($product_data->about))?$product_data->about:'' ?></textarea>
                </div>
              </div>

              <div class="col-md-12">      
                <div class="box-footer textCenterAlign">
                  <button id="addProductButton" type="submit" class="btn btn-primary">Submit</button>
                  <a href="<?= base_url('Product/viewProducts') ?>" class="btn btn-primary">Cancel</a>
                </div>        
              </div>        
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>


<div id="multipleImageInput" class="hide">
  <div class="dropZoneContainer" id="multiImageCntr_{:count}"  count="{:count}">
    <div id="multiImageClose_{:count}" class="close_custom hide" onclick="removeImage('{:count}');">&times;</div>
    <input id="event_image_{:count}" type="file" name="product_image[]" class="multiFileUpload" accept="image/*"
           onchange="setMultiImg(this,jQuery(this));" count="{:count}" />
    <img class="multiDropZoneOverlay" id="multiImageImg_{:count}" src="" 
           onerror="this.src='<?=base_url("assets/images/add-image.png")?>';" />
  </div>
</div>