<div class="content-wrapper" >
  <section class="content-header">
    <h1>
      <?= $pTitle ?><small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
      <li><?= $menu ?></li>
      <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
            <button class="close" data-dismiss="alert" type="button">×</button>
            <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-xs-12">
        <div class="box box-warning">     
          <div class="box-header with-border">
            <div class="col-md-6"><h3 class="box-title">Issues List</h3></div>
            <div class="col-md-6" align="right">
              <a class="btn btn-sm btn-primary" href="<?= base_url('Issue/addIssue') ?>">Add New General Issue</a>
              <a class="btn btn-sm btn-primary" href="<?= base_url() ?>">Back</a>
           </div>
          </div>
          <div class="box-body">
            <table id="mechanicUsers" class="table table-bordered table-striped datatable ">
              <thead>
                <tr>
                  <th class="hidden">ID</th>
                  <th width="10%;">Issue Icon </th>
                  <th width="40%;">Issue Category</th>
                  <th width="10%;">Status</th>
                  <th width="40%;">Action</th>
               </tr>
              </thead> 
              <tbody>
                <?php
                if(!empty($issue_data)){
                  foreach($issue_data as $issue) { ?>
                    <tr>
                      <th class="hidden"><?= $issue->issue_id ?></th>
                      <th class="center">
                        <img class="small-icon" src="<?=base_url($issue->issue_image)?>" onerror="this.src='<?=base_url("assets/images/no_image.png")?>';" />
                      </th>
                      <th class="center"><?= $issue->issue ?></th>
                      <th class="center"><?= ($issue->status == 1)?'Active':'De-activate' ?></th>
                      <td class="center float-right">   
                        <?php if(!empty($issue->issue_cat_id)){ ?>
                          <a class="btn btn-sm btn-info cpoint" onclick="viewIssueDetls('<?= encode_param($issue->issue_id) ?>');">
                            <i class="fa fa-fw fa-eye"></i>View Issue Sub Categories
                          </a>
                        <?php } ?>
                        <a class="btn btn-sm btn-primary" 
                            href="<?= base_url('Issue/editIssue/'.encode_param($issue->issue_id)) ?>">
                          <i class="fa fa-fw fa-edit"></i>Edit
                        </a>
                        <a class="btn btn-sm btn-danger" 
                            href="<?= base_url("Issue/changeStatus/".encode_param($issue->issue_id))."/2" ?>" 
                            onClick="return doconfirm()">
                          <i class="fa fa-fw fa-trash"></i>Delete
                        </a>    
                        <?php if($issue->status == 1){ ?>
                          <a class="btn btn-sm btn-success" style="background-color:#ac2925" href="<?= base_url("Issue/changeStatus/".encode_param($issue->issue_id))."/0" ?>">
                            <i class="fa fa-cog"></i> De-activate
                          </a>
                        <?php } else { ?>
                          <a class="btn btn-sm btn-success" href="<?= base_url("Issue/changeStatus/".encode_param($issue->issue_id))."/1" ?>">
                            <i class="fa fa-cog"></i> Activate
                          </a>
                        <?php } ?>
                      </td>
                    </tr>
                <?php } } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>