<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	header('Content-Type: text/html; charset=utf-8');
	
	if(isset($_SERVER['HTTP_ORIGIN'])) {
		header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
		header('Access-Control-Allow-Credentials: true');
		header('Access-Control-Max-Age: 86400'); // cache for 1 day
	}
	
	if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
		header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
		exit(0);
	}
	
	class Webservices extends CI_Controller {
		
		public function __construct() {
			parent::__construct();
			$this->load->model('Webservice_model');
			$this->load->library('form_validation');
			
			//define("PAYSTACK_SECRET_KEY", "sk_live_ac1f5350a42852fd3439fdac8ba1d434f1c42360");
			define("PAYSTACK_SECRET_KEY", "sk_test_dae3d816baeeabcab5063def4aad5fe546e9758d");
    		date_default_timezone_set('Asia/Kolkata');
		}
		// customer_login
		public function customer_login(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			//pr($postData);
			$this->load->model('Customer_model');
			$respArr = array('status'=>'0','message'=>'Required Fields are empty.');
			if(!isset($postData['email']) || empty($postData['email']) || 
			!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
				echo json_encode($respArr);exit;
			}
			$custResp = $this->Customer_model->checkCustomerLogin($postData);
			if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
				echo json_encode($respArr);exit;
			}
			if($custResp['status'] == '1'){
				$respArr['data'] = $custResp['data'];
				$respArr['status'] = '1';
				$respArr['message'] = 'Success';
				echo json_encode($respArr);exit;
			}
			if($custResp['status'] == '2'){
				$respArr['status'] = '2';
				$respArr['message'] = 'Invalid Email Address';
				echo json_encode($respArr);exit;
			}
			if($custResp['status'] == '3'){
				$respArr['status'] = '3';
				$respArr['message'] = 'Invalid Password';
				echo json_encode($respArr);exit;
			}
			echo json_encode($respArr); exit;
		}
		// customer_forgot_password
		public function customer_forgot_password(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Customer_model');
			$respArr = array('status'=>'0','message'=>'Required Fields are empty.');
			if(empty($postData) || !isset($postData['email']) || empty($postData['email'])){
				echo json_encode($respArr);exit;
			}
			$custResp = $this->Customer_model->genCustForgotPassLink($postData);
			if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
				echo json_encode($respArr);exit;
			}
			if($custResp['status'] == '2'){
				$respArr['status'] = '2';
				$respArr['message'] = 'Invalid Email Address';
				echo json_encode($respArr);exit;
			}
			if($custResp['status'] == '1'){
				/*
					MAIL SENT CONFIGARATION -- TODO
				*/
				$respArr['status'] = '1';
				$respArr['message'] = 'Password Reset Email has been sent';
			}
			echo json_encode($respArr); exit;
		}
		// customer_registration
		public function customer_registration(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Customer_model');
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData)){
				echo json_encode($respArr);exit;
			}
			$err = 0;
			$msg = '';
			if(!isset($postData['email']) || empty($postData['email'])){
				$err = 1;
				$msg = 'Provide a valid Email ID';
			} 
			else if(!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
				$err = 1;
				$msg = 'Provide a Password';
			}
			else if(!isset($postData['first_name']) || empty($postData['first_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['last_name']) || empty($postData['last_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			if(isset($postData['phone']) && empty($postData['phone'])){
				unset($postData['phone']);
			}
			unset($postData['promocode']);
			$custResp = $this->Customer_model->createCustomer($postData);
			if(empty($custResp)){
				echo json_encode($respArr);exit;
			}
			if($custResp == '1'){
				$custResp = $this->Customer_model->checkCustomerLogin($postData);
				if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
					echo json_encode($respArr);exit;
				}
				if($custResp['status'] == '1'){
					$respArr['data'] = $custResp['data'];
					$respArr['status'] = '1';
					$respArr['message'] = 'Success';
					echo json_encode($respArr);exit;
				}
			} else if($custResp == '2'){
				$respArr['status'] = '2';
				$respArr['message'] = 'Email Address already in use';
				echo json_encode($respArr);exit;
				} else if($custResp == '3'){
				$respArr['status'] = '2';
				$respArr['message'] = 'Phone already in use';
				echo json_encode($respArr);exit;
			}
			echo json_encode($respArr); exit;
		}
		// Service Provider registration
		public function service_provider_registration(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData)){
				echo json_encode($respArr);exit;
			}
			$err = 0;
			$msg = '';
			if(!isset($postData['email']) || empty($postData['email'])){
				$err = 1;
				$msg = 'Provide a valid Email ID';
			} 
			else if(!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
				$err = 1;
				$msg = 'Provide a Password';
			}
			else if(!isset($postData['first_name']) || empty($postData['first_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['last_name']) || empty($postData['last_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['phone']) || empty($postData['phone'])){
				$err = 1;
				$msg = 'Provide valid Phone Number';
			}
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			$custResp = $this->Webservice_model->createServiceProvider($postData);
			if($custResp == '0'){
				$respArr['message'] = 'Something went wrong.';
			} else if($custResp == '1'){
				$respArr['status'] = '1';
				$respArr['message'] = 'Success';
			} else if($custResp == '2'){
				$respArr['message'] = 'Email Address already in use';
			} else if($custResp == '3'){
				$respArr['message'] = 'Phone already in use';
			}
			echo json_encode($respArr); exit;
		}
		// getGeneralIssues
		public function getGeneralIssues(){
			header('Content-type: application/json');
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			$this->load->model('Issue_model');
			$issue_data = $this->Issue_model->getGeneralIssues();
			if(!empty($issue_data)){
				$respArr['status'] = '1';
				$respArr['message'] = 'Success';
				$respArr['issue_data'] = $issue_data;
			}
			echo json_encode($respArr); exit;
		}
		// getNearByMechanics
		public function getNearByMechanics(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Mechanic_model');
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || !isset($postData['pickup_data']) || !isset($postData['sub_issues']) 
				|| empty($postData['pickup_data']) || empty($postData['sub_issues']) ){
				echo json_encode($respArr); exit;
			}
			$mechanic_data = $this->Mechanic_model->getNearByMechanics($postData['pickup_data'],$postData['sub_issues']);
			if(!empty($mechanic_data)){
				$respArr['status'] = '1';
				$respArr['message'] = 'Success';
				$respArr['mechanic_data'] = $mechanic_data;
			}
			echo json_encode($respArr); exit;
		}	
		// scheduleNow
		public function scheduleNow(){
			header('Content-type: application/json');
			$postData = $_POST;
			$optionalData=array('optionlaDescription'=>'','optionalImages'=>array(),'optionalVideos'=>array());
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || empty($postData = json_decode($postData['data'],true)) || 
			!isset($postData['cost']) || empty($postData['cost']) || 
			!isset($postData['customer_id']) || empty($postData['customer_id']) || 
			!isset($postData['mechanic_id']) || empty($postData['mechanic_id']) || 
			!isset($postData['pickup_data']) || empty($postData['pickup_data']) || 
			!isset($postData['vechile_info']) || empty($postData['vechile_info']) || 
			!isset($postData['schedule_date']) || empty($postData['schedule_date']) || 
			!isset($postData['selected_issues']) || empty($postData['selected_issues'])){
				echo json_encode($respArr);exit;
			}
			$optionalData['optionlaDescription'] = (isset($postData['optionalDescription']) && 
			!empty($postData['optionalDescription']))?
			$postData['optionalDescription']:'';
			if(isset($_FILES) && !empty($_FILES)){
				foreach ($_FILES as $fileIndex => $optImgs) {
					if(empty($optImgs) || !isset($optImgs['name']) || empty($optImgs['name'])){
						continue;
					}
					$this->load->library('upload');
					$config = set_upload_service("assets/uploads/services");
					$config['file_name'] = 'optionalImages'.$postData['customer_id'].date('dmYHis');
					$this->upload->initialize($config);
					if($this->upload->do_upload($fileIndex)){
						$upload_data = $this->upload->data();
						$optionalData['optionalImages'][] = $config['upload_path']."/".$upload_data['file_name'];
					}
				}
			}
			$this->load->model('Booking_model');
			$postData['optionalData'] = $optionalData;
			$status = $this->Booking_model->scheduleBooking($postData);
			if($status){
				$respArr['status'] = '1';
				$respArr['message'] = 'Success';
			}
			echo json_encode($respArr); exit;
		}
		// edit_customer_profile
		public function edit_customer_profile(){
			header('Content-type: application/json');
			$postData = $_POST;
			$this->load->model('Customer_model');
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || empty($postData = json_decode($postData['data'],true)) || 
			!isset($postData['customer_id']) || empty($postData['customer_id'])){
				echo json_encode($respArr);exit;
			}
			$err = 0;
			$msg = '';
			if(!isset($postData['email']) || empty($postData['email'])){
				$err = 1;
				$msg = 'Provide a valid Email ID';
			}
			else if(!isset($postData['first_name']) || empty($postData['first_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['last_name']) || empty($postData['last_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['phone']) || empty($postData['phone'])){
				$err = 1;
				$msg = 'Provide valid Phone';
			}
			else if(!isset($postData['address']) || empty($postData['address'])){
				$err = 1;
				$msg = 'Provide valid Address';
			}
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			if(isset($_FILES) && !empty($_FILES) && 
			isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])){
				$config = set_upload_service("assets/uploads/services");
				$this->load->library('upload');
				$config['file_name'] = $postData['customer_id']."_".$_FILES['profile_image']['name'];
				$this->upload->initialize($config);
				if($this->upload->do_upload('profile_image')){
					$upload_data = $this->upload->data();
					$postData['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
				}
			}
			$customer_id = $postData['customer_id'];
			if(isset($postData['password']) && !empty($postData['password']) && 
				isset($postData['cpassword']) && !empty($postData['cpassword']) && 
				$postData['password'] == $postData['cpassword']){
				$postData['password'] = md5($postData['password']);
			} else {
				unset($postData['password']);
			}
			unset($postData['cpassword']);
			unset($postData['customer_id']);
			$custResp = $this->Customer_model->updateCustomer($customer_id,$postData);
			if(empty($custResp)){
				echo json_encode($respArr);exit;
			}
			if($custResp == '1'){
				$respArr['status'] = '1';
				$respArr['message'] = 'Profile successfully updated';
				$respArr['profile_image'] = (isset($postData['profile_image']) && !empty($postData['profile_image']))?$postData['profile_image']:'';
				echo json_encode($respArr);exit;
			} else if($custResp == '2'){
				$respArr['status'] = '2';
				$respArr['message'] = 'Email Address already in use';
				echo json_encode($respArr);exit;
			} else if($custResp == '3'){
				$respArr['status'] = '3';
				$respArr['message'] = 'Phone Number already in use';
				echo json_encode($respArr);exit;
			}
			echo json_encode($respArr); exit;
		}
		// customerVechiles
		public function customerVechiles(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Vehicle_model');
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
				echo json_encode($respArr);exit;
			}
			$vehData = $this->Vehicle_model->getCustVechiles($postData);
			if($vehData != '0'){
				$respArr['status'] = 1;
				$respArr['message'] = 'success';
				$respArr['vehData'] = $vehData;
			}
			echo json_encode($respArr);exit;
		}
		// getCustBookDetails
		public function getCustBookDetails(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Booking_model');
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
				echo json_encode($respArr);exit;
			}
			$status =(isset($postData['status']) && !empty($postData['status']))?$postData['status']:'';
			$bookingDetails = $this->Booking_model->getCustBookDetails($postData,$status);
			if($bookingDetails != '0'){
				$respArr['status'] = 1;
				$respArr['message'] = 'success';
				$respArr['bookData'] = $bookingDetails;
			}
			echo json_encode($respArr);exit;
		}
		// cancelBooking
		public function cancelBooking(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Booking_model');
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id']) 
				|| !isset($postData['booking_id']) || empty($postData['booking_id'])){
				echo json_encode($respArr);exit;
			}
			$status=$this->Booking_model->changeBookStatus($postData['customer_id'],$postData['booking_id'],'4');
			if($status){
				$respArr['status'] = 1;
				$respArr['message'] = 'success';
			}
			echo json_encode($respArr);exit;
		}
		// deleteCustomerCar
		public function deleteCustomerCar(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Vehicle_model');
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id']) 
				|| !isset($postData['customer_veh_id']) || empty($postData['customer_veh_id'])){
				echo json_encode($respArr);exit;
			}
			$status = $this->Vehicle_model->changeCustomerCarStatus($postData['customer_id'],
			$postData['customer_veh_id'],'2');
			if($status){
				$respArr['status'] = 1;
				$respArr['message'] = 'success';
			}
			echo json_encode($respArr);exit;
		}

		// addCustomerCar
		public function addCustomerCar(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Vehicle_model');
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
				echo json_encode($respArr);exit;
			}
			$vehTrim = $vehEngine = '';
	        if(isset($postData['vehicleData']['trim']) && !empty($postData['vehicleData']['trim'])){
	            $vehTrim = $postData['vehicleData']['trim'];
	        }
	        if(isset($postData['vehicleData']['engine']) && !empty($postData['vehicleData']['engine'])){
	            $vehEngine = $postData['vehicleData']['engine'];
	        }
			$url = "";
			$searchType = $postData['type'];
			$locationData = $postData['location'];
			$vehicle_data['status'] = '1';
			$vehicle_data['customer_id'] = $postData['customer_id'];
			$vehicle_data['car_loc_lat'] = $locationData['location_lat'];
			$vehicle_data['car_loc_lng'] = $locationData['location_lng'];
			$vehicle_data['car_location'] = $locationData['location'];
			$last_date ='';
		    if(isset($postData['vehicleData']['lastMaintanceDate']) && !empty($postData['vehicleData']['lastMaintanceDate'])){
		    	$vehicle_data['last_maintenance_date'] = $postData['vehicleData']['lastMaintanceDate'];
		    }
		    $last_maintanence_date ='';
		    if(isset($postData['vehicleData']['maintanence_interval']) && !empty($postData['vehicleData']['maintanence_interval'])){
		      $vehicle_data['maintanence_interval'] = $postData['vehicleData']['maintanence_interval'];
		    }
			$this->load->model('Settings_model');
			$settings = $this->Settings_model->settings_viewing();
			$searchData = $postData['vehicleData'];
			if($searchType == 1 && isset($searchData['car_maker']) && !empty($searchData['car_maker']) 
				&& isset($searchData['modelName']) && !empty($searchData['modelName']) && 
				isset($searchData['modelYear']) && !empty($searchData['modelYear'])){
				$vehicle_data['car_maker'] = $searchData['car_maker'];
				$vehicle_data['car_model'] = $searchData['modelName'];
				$vehicle_data['car_model_year'] = $searchData['modelYear'];
				$url = "https://specifications.vinaudit.com/v3/selections?format=json&key=".
                    urlencode($settings['vin_audit_api'])."&id=".urlencode($searchData['modelYear'])."_".urlencode($searchData['car_maker'])."_".urlencode($searchData['modelName']);
			}
			else if($searchType == 2 && isset($searchData['vin']) && !empty($searchData['vin'])){
				$vehicle_data['car_vin'] = $searchData['vin'];
				$url = "https://specifications.vinaudit.com/v3/specifications?format=json&key=".urlencode($settings['vin_audit_api'])."&vin=".urlencode($searchData['vin']);
			}
			if(!empty($url)){
				$vehData=file_get_contents($url);
				if(empty($vehData) || empty($vehData = json_decode($vehData,true))){
					echo json_encode($return_arr);exit;
				}
				if(!isset($vehData['success']) || empty($vehData['success']) || $vehData['success'] == false || ((!isset($vehData['attributes']) || empty($vehData['attributes'])) && 
                	(!isset($vehData['selections']) || empty($vehData['selections'])))){
					$return_arr['status'] = 2;
					$return_arr['message'] = 'No Data Found.';
					echo json_encode($return_arr);exit;
				}
				if($searchType == 2){
					$vehDetails['vehicle'] = $vehData['attributes']['year'].' '.
                                         	 $vehData['attributes']['make'].' '.
                                         	 $vehData['attributes']['model'].' '.
                                         	 $vehData['attributes']['trim'];
	                $vehDetails['year']    = $vehData['attributes']['year'];
	                $vehDetails['make']    = $vehData['attributes']['make'];
	                $vehDetails['trim']    = $vehData['attributes']['trim'];
	                $vehDetails['model']   = $vehData['attributes']['model'];
	                $vehDetails['engine']  = $vehData['attributes']['engine'];
	                $vehicle_data['car_maker']      = $vehDetails['make'];
	                $vehicle_data['car_model']      = $vehDetails['model'];
	                $vehicle_data['car_model_year'] = $vehDetails['year'];
				} else if($searchType == 1){
	                $vehSele = $vehData['selections'];
	                $vehDetails['year']    = $vehSele['years'][0]['name'];
	                $vehDetails['make']    = $vehSele['years'][0]['makes'][0]['name'];
	                $vehDetails['model']   = $vehSele['years'][0]['makes'][0]['models'][0]['name'];
	                $vehDetails['vehicle'] = $vehDetails['year'].' '.$vehDetails['make'].' '.
	                                         $vehDetails['model'].' '.$vehTrim;
	                $vehDetails['trim']             = $vehTrim;
	                $vehDetails['engine']           = $vehEngine;
	                $vehicle_data['car_maker']      = $vehDetails['make'];
	                $vehicle_data['car_model']      = $vehDetails['model'];
	                $vehicle_data['car_model_year'] = $vehDetails['year'];
	            }
				$vehicle_data['car_name'] = $vehDetails['vehicle'];
				$vehicle_data['vehicle_data'] = json_encode($vehDetails);
				$car_id = $this->Vehicle_model->addVehicle($vehicle_data);
				if(!empty($car_id)){
					$return_arr['status'] = '1';
					$return_arr['car_id'] = $car_id;
					$return_arr['veh_data'] = $vehDetails;
				}
			}
			echo json_encode($return_arr);exit;
		}
		/*********************************************************************************/
		/************************************Mobile API's*********************************/
		//Mobile Number Availability	
		public function mobile_number_availability(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$respArr = array('status'=>'error','error'=>'901','message'=>'Something went wrong.');
			if(!isset($postData['phone']) || empty($postData['phone']) && !isset($postData['country_code']) || empty($postData['country_code'])){
				$respArr = array('status'=>'0','error'=>'903','message'=>'Required Fields are empty.');
				echo json_encode($respArr);exit;
			}
			$custResp = $this->Webservice_model->checkMobAvailability($postData);
			if(!empty($custResp)){
				$respArr = $custResp;
			}
			echo json_encode($respArr);exit;
		}
		//User Login	
		public function user_login(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$respArr = array('status'=>'0','message'=>'Required Fields are empty.');
			if(!isset($postData['email']) || empty($postData['email']) || 
			!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
				echo json_encode($respArr);exit;
			}
			$custResp = $this->Webservice_model->checkCustomerLogin($postData);
			if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
				echo json_encode($respArr);exit;
			}
			if($custResp['status'] == '1'){
				$respArr['data'] = $custResp['data'];
				$respArr['status'] = 'success';
				$respArr['message'] = 'Success';
				echo json_encode($respArr);exit;
			}
			if($custResp['status'] == '2'){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Invalid Email Address';
				echo json_encode($respArr);exit;
			}
			if($custResp['status'] == '3'){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Invalid Password';
				echo json_encode($respArr);exit;
			}
			echo json_encode($respArr); exit;
		}
		// customer_registration
		public function user_registration(){
			header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData)){
				echo json_encode($respArr);exit;
			}
			$err = 0;
			$msg = '';
			if(!isset($postData['email']) || empty($postData['email'])){
				$err = 1;
				$msg = 'Provide a valid Email ID';
			} 
			else if(!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
				$err = 1;
				$msg = 'Provide a Password';
			}
			else if(!isset($postData['name']) || empty($postData['name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['country_code']) || empty($postData['country_code'])){
				$err = 1;
				$msg = 'Provide a Country Code';
			}
			else if(!isset($postData['phone']) && empty($postData['phone'])){
				$err = 1;
				$msg = 'Provide a Phone Number';
			}
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			$custResp = $this->Webservice_model->createCustomer($postData);
			if(empty($custResp)){
				echo json_encode($respArr);exit;
			}
			if($custResp['status'] == '1'){
				$respArr['data'] = $custResp['data'];
				$respArr['status'] = 'success';
				$respArr['message'] = 'Success';
				echo json_encode($respArr);exit;
			} else if($custResp['status'] == '2'){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Email Address already in use';
				echo json_encode($respArr);exit;
			} else if($custResp['status'] == '3'){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Phone already in use';
				echo json_encode($respArr);exit;
			}
			echo json_encode($respArr); exit;
		}
		//Get Booked Services	
		public function get_allocated_services(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$postData = $_GET;
			$currentpage = $start = $total = 0;
			$per_page = 10;
			if(isset($postData['page']) && strlen(trim($postData['page']," ")) > 0 ) {
				$currentpage =  (int)$postData['page'];
				$currentpage = $currentpage==0 ? $currentpage : $currentpage-1;
				$start = $currentpage * $per_page;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$bookDataRslt = $this->Webservice_model->getBookedService($authRes['data']['customer_id'],0,0);
			$bookDataList = $this->Webservice_model->getBookedService($authRes['data']['customer_id'],$start,$per_page);
			if($bookDataRslt['status'] == 'success'){
				$total = count($bookDataRslt['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($bookDataList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'services_data' => $bookDataList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'services_data' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}
		//Get booked Service
		public function get_booked_services(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
	   			$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$bookData = $this->Webservice_model->get_booked_services($authRes['data']['customer_id']);
			echo json_encode($bookData);exit;
		}
		//Add Vehicle Details	
		public function add_vehicle_details(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$err = 0;$msg = '';
			if(empty($postData)){
				$respArr = array('status'=>0,'error'=>'901','message'=>'All Field is Required');
				echo json_encode($respArr);exit;
			}
			if(!isset($postData['vehicle_id']) && empty($postData['vehicle_id'])){
				if(!isset($postData['vehicle_year']) || empty($postData['vehicle_year'])){
					$err = 1;
					$msg = 'Provide a Vehicle year';
				} 
				else if(!isset($postData['vehicle_make']) || empty($postData['vehicle_make'])){
					$err = 1;
					$msg = 'Provide a Vehicle Make';
				}
				else if(!isset($postData['vehicle_model']) || empty($postData['vehicle_model'])){
					$err = 1;
					$msg = 'Provide a Vehicle Model';
				}
				else if(!isset($postData['engine_no']) || empty($postData['engine_no'])){
					$err = 1;
					$msg = 'Provide an Engine Number';
				}
				else if(!isset($postData['vehicle_trim']) && empty($postData['vehicle_trim'])){
					$err = 1;
					$msg = 'Provide a Vehicle Trim';
				}
				else if(!isset($postData['mileage']) && empty($postData['mileage'])){
					$err = 1;
					$msg = 'Provide a Mileage';
				}
				else if(!isset($postData['car_loc_lat']) && empty($postData['car_loc_lat'])){
					$err = 1;
					$msg = 'Car Location is Required';
				}
				else if(!isset($postData['car_loc_lng']) && empty($postData['car_loc_lng'])){
					$err = 1;
					$msg = 'Car Location is Required';
				}
				else if(!isset($postData['car_location']) && empty($postData['car_location'])){
					$err = 1;
					$msg = 'Car Location is Required';
				}
			}
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			$respData = $this->Webservice_model->addVehicleDetails($postData,$authRes['data']['customer_id']);
			echo json_encode($respData);exit;
		}
		//Get Services
		public function get_services(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			$postData = $_GET;
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']);
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$currentpage = 0;
			$start = 0;
			$per_page = 10;
			if(isset($postData['page']) && strlen(trim($postData['page']," ")) > 0 ) {
				$currentpage =  (int)$postData['page'];
				$currentpage = $currentpage==0 ? $currentpage : $currentpage-1;
				$start = $currentpage * $per_page;
			}
			$serviceresult = $this->Webservice_model->get_service_list($postData,0,0);
			$serviceList = $this->Webservice_model->get_service_list($postData,$start,$per_page);
			$service = array();
			$total = 0;
			if($serviceresult['status'] == 'success'){
				$total = count($serviceresult['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($serviceList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'services' => $serviceList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'services' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}
		//Get Vehicle Details
		public function get_vehicle_details(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$respArr = array('status'=>'error','message'=>'Something Went Wrong.');
			if(empty($postData)){
				echo json_encode($respArr);exit;
			}
			else if(!isset($postData['bar_code']) && !empty($postData['bar_code'])){
				$respArr['message'] = 'Barcode is Required.';
				echo json_encode($respArr);exit;
			}
			$settings = getSettings();
			$param = "?format=json&key=".urlencode($settings['vin_audit_api']).
			"&vin=".urlencode($postData['bar_code']);
			$vehData=file_get_contents("https://specifications.vinaudit.com/getspecifications.php".$param);
			if(empty($vehData) || empty($vehData = json_decode($vehData,true))){
				echo json_encode($respArr);exit;
			}
			if(!isset($vehData['success']) || empty($vehData['success']) || $vehData['success'] == false || !isset($vehData['attributes']) || empty($vehData['attributes'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Invalid Vin Number.';
				echo json_encode($respArr);exit;
			}
			$respArr['status'] = 'success';
			$respArr['data'] = $vehData['attributes'];
			$respArr['message'] = 'Success';
			echo json_encode($respArr);exit;
		}
		//Search Sub Services
		public function search_sub_services(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			$postData = $_GET;
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$currentpage = 0;
			$start = 0;
			$per_page = 10;
			if(isset($postData['page']) && strlen(trim($postData['page']," ")) > 0 ) {
				$currentpage =  (int)$postData['page'];
				$currentpage = $currentpage==0 ? $currentpage : $currentpage-1;
				$start = $currentpage * $per_page;
			}
			$subserviceresult = $this->Webservice_model->search_sub_services($postData,0,0);
			$subserviceList = $this->Webservice_model->search_sub_services($postData,$start,$per_page);
			$service = array();
			$total = 0;
			if($subserviceresult['status'] == 'success'){
				$total = count($subserviceresult['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($subserviceList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'sub_services' => $subserviceList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page
					)
				);
			}else if($subserviceList['status'] == 'error'){
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'sub_services' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = $subserviceList;
				$respArr['status'] = 'error';
			}
			echo json_encode($respArr);exit;
		}
		//Book Service
		public function book_service(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			if(empty($postData)){
				$respArr = array('status'=>'error','message'=>'All Field is Required');
				echo json_encode($respArr);exit;
			}
			$err = 0;
			if(!isset($postData['is_emergency']) || empty($postData['is_emergency']))
			{
				if(!isset($postData['date']) || empty($postData['date'])){
					$err = 1;
					$msg = 'Date is Required';
				}
				else if(!isset($postData['time']) && empty($postData['time'])){
					$err = 1;
					$msg = 'Time is Required';
				}
				else if(!isset($postData['total_cost']) || empty($postData['total_cost'])){
					$err = 1;
					$msg = 'Total Cost is Required';
				}
			}
			if(!isset($postData['booking_id']) || empty($postData['booking_id'])){
				$err = 1;
				$msg = 'Booking Id is Required';
			} 
			else if(!isset($postData['mechanic_id']) || empty($postData['mechanic_id'])){
				$err = 1;
				$msg = 'Mechanic Id is Required';
			}
			
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			$respData = $this->Webservice_model->book_service($postData);
			if((isset($postData['is_emergency']) && !empty($postData['is_emergency']))){
				if($respData['status'] == 'success'){
					$fcm_data['title'] = 'Carfixxers';
					$fcm_data['message'] = "Emergency booking";
					$fcm_data['booking_id'] = $postData['booking_id'];
					$fcm_data['device_id'] = $respData['data']['device_id'];
					$fcm_data['service_type'] = $respData['data']['service_type'];
					$this->push_sent_cancel($fcm_data);
				}
			}
			echo json_encode($respData);exit;
		}
		//Allocated service details
		public function allocated_service_details(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			$postData = $_GET;
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			if(empty($postData)){
				$respArr = array('status'=>'error','message'=>'All Field is Required');
				echo json_encode($respArr);exit;
			}
			$err = 0;
			if(!isset($postData['booking_id']) || empty($postData['booking_id'])){
				$err = 1;
				$msg = 'Booking Id is Required';
			}
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			$respData = $this->Webservice_model->getBookedService($postData['booking_id'],'','',1);
			echo json_encode($respData);exit;
		}
		//Get Booking Summary
		public function get_booking_summary(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			$postData = $_GET;
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$res = $this->Webservice_model->get_booking_summary($postData);
			echo json_encode($res);exit;
		}
		//Get Mechanics	
		public function get_mechanics(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			$postData = $_GET;
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$err = 0;
			if(!isset($postData['is_emergency']) || $postData['is_emergency'] != 1){
				if(!isset($postData['service_id']) || empty($postData['service_id'])){
					$err = 1;
					$msg = 'Service Id is Required';
				}
			}
			else if(!isset($postData['location']) || empty($postData['location'])){
				$err = 1;
				$msg = 'Location is Required';
			}
			else if(!isset($postData['location_lat']) || empty($postData['location_lat'])){
				$err = 1;
				$msg = 'Location is Required';
			}
			else if(!isset($postData['location_lng']) || empty($postData['location_lng'])){
				$err = 1;
				$msg = 'Location is Required';
			}
			if($err == 1){
				$respArr['status'] = 'error';
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			$currentpage = 0;
			$start = 0;
			$per_page = 10;
			if(isset($postData['page']) && strlen(trim($postData['page']," ")) > 0 ) {
				$currentpage =  (int)$postData['page'];
				$currentpage = $currentpage==0 ? $currentpage : $currentpage-1;
				$start = $currentpage * $per_page;
			}
			if(isset($postData['is_emergency']) && $postData['is_emergency'] == 1){
				$mechanicsListcount = $this->Webservice_model->getNearMechanics($postData,0,0,1);
				$mechanicsList =$this->Webservice_model->getNearMechanics($postData,$start,$per_page,1);
			} else {
				$mechanicsListcount = $this->Webservice_model->getNearMechanics($postData,0,0);
				$mechanicsList = $this->Webservice_model->getNearMechanics($postData,$start,$per_page);
			}
			$total = 0;
			if($mechanicsList['status'] == 'success'){
				$total = count($mechanicsListcount['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($mechanicsList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'mechanics' => $mechanicsList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page)
					);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'mechanics' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => $currentpage+1,
						'per_page' => $per_page)
					);
			}
			echo json_encode($respArr);exit;
		}
		//Add Service Details
		public function add_service_details(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			$postData = $_POST;
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			if(isset($_FILES['images']) && !empty($_FILES['images'])){
				$files = $_FILES;
				$config = set_upload_service('assets/uploads/services'); 
				$this->load->library('upload');
				for ($i=0; $i < count($files['images']['name']) ; $i++){ 
					$config['file_name'] = 'optionalImages'.date('dmYHis').$files['images']['name'][$i];
					$this->upload->initialize($config);
					$_FILES['images']['name'] = $files['images']['name'][$i];
					$_FILES['images']['type'] = $files['images']['type'][$i];
					$_FILES['images']['tmp_name'] = $files['images']['tmp_name'][$i];
					$_FILES['images']['error'] = $files['images']['error'][$i];
					$_FILES['images']['size'] = $files['images']['size'][$i];    
					if($this->upload->do_upload('images'))
					{
						$imagedata= $this->upload->data();
						$new[$i] = 'assets/uploads/services/'.$imagedata['file_name'];
					}
					else
					{
						$display_error = array('error' => $this->upload->display_errors('', '')); 
						$res = array(
						"status"=> "error",
						"error"=> "Upload Error",
						"msg"=> "Sorry! Images not uploaded. ".$display_error['error']
						);	
						print json_encode($res);
						exit();
					}
				}
				$postData['image'] = $new;
			}
			if(isset($_FILES['videos']) && !empty($_FILES['videos'])){
				$files = $_FILES;
				$config = set_upload_service('assets/uploads/services'); 
				$this->load->library('upload');
				for ($i=0; $i < count($files['videos']['name']) ; $i++){ 
					$config['file_name'] ='optionalImages'.date('dmYHis').$_FILES['videos']['name'][$i];
					$this->upload->initialize($config);
					$_FILES['videos']['name'] = $files['videos']['name'][$i];
					$_FILES['videos']['type'] = $files['videos']['type'][$i];
					$_FILES['videos']['tmp_name'] = $files['videos']['tmp_name'][$i];
					$_FILES['videos']['error'] = $files['videos']['error'][$i];
					$_FILES['videos']['size'] = $files['videos']['size'][$i];    
					if($this->upload->do_upload('videos'))
					{
						$imagedata= $this->upload->data();
						$video[$i] = 'assets/uploads/services/'.$imagedata['file_name'];
					}
					else
					{
						$display_error = array('error' => $this->upload->display_errors('', '')); 
						$res = array(
						"status"=> "error",
						"error"=> "Upload Error",
						"msg"=> "Sorry! Images not uploaded. ".$display_error['error']
						);	
						echo json_encode($res);
						exit();
					}
				}
				$postData['video'] = $video;
			}
			$addServiceDetails = $this->Webservice_model->add_service_details($postData);
			echo json_encode($addServiceDetails);exit();
		}
		//Remove Booking
		public function remove_booking(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$removed = $this->Webservice_model->remove_booking($postData);
			echo json_encode($removed);
		}
		//Get Service
		public function get_service(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']);
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$getServices = $this->Webservice_model->get_service($postData);
			echo json_encode($getServices);exit;
		}
		//Mechanic Rating
		public function rate_mechanic(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']);
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$postData['customer_id'] = $authRes['data']['customer_id'];
			$result = $this->Webservice_model->rate_mechanic($postData);
			echo json_encode($result);exit;
		}
		//Accept Mechanic Quote
		public function acceptMechanicQuote(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->acceptMechanicQuote($postData);
			echo json_encode($result);exit;
		}
		//Payment Integration of Mechanic Booking
		public function payNow($transId=''){
			if(empty($transId)){
				$this->fail();
			}
            $mechData = $this->Webservice_model->getMechAmount($transId);
            $amount   = $mechData['data']['amount'] * 100;
            $callback = base_url().'Webservices/verify_payment/'.$transId.'/1';
            $postdata = array('email' => $mechData['emailId'], 
            				  'amount' => $amount,
            				  'reference' => $transId, 
            				  'callback_url' => $callback);
            $this->payStackPayment($postdata,1);
		}
		//Payment Integration of Order Booking
		public function orderPayNow($orderId='',$cartId=''){
			if(empty($orderId)){
				$this->fail();
			}
			$orderData = $this->Webservice_model->getOrderPayDetails($orderId);
			if($orderData['status'] == 'success'){
				$amount   = $orderData['data']->amount * 100;
	            $callback = base_url().'Webservices/verify_payment/'.$orderId.'/2/'.$cartId;
	            $postdata = array('email' => $orderData['data']->email, 
	            				  'amount' => $amount,
	            				  'reference' => $orderId, 
	            				  'callback_url' => $callback);
	            $this->payStackPayment($postdata,2);
			}
		}
		//PayStack Payment
	    public function payStackPayment($postdata=array(),$payFor='1') {
            $url = "https://api.paystack.co/transaction/initialize";
            $ch  = curl_init();
            curl_setopt($ch, CURLOPT_URL,$url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($postdata)); 
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            $headers = [
                'Authorization: Bearer '.PAYSTACK_SECRET_KEY,
                'Content-Type: application/json',
            ];
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $request = curl_exec($ch);
            curl_close ($ch);
            if(!empty($result = json_decode($request,true)) && 
               isset($result['data']) && !empty($result['data']) && 
               isset($result['data']['authorization_url']) && 
               !empty($result['data']['authorization_url'])){
               	$redir = $result['data']['authorization_url'];
				header("Location: ".$redir);
            }else{
            	$ref = $postdata['reference'];
            	$status = $this->Webservice_model->transactionResp($ref,$result,$payFor);
            	$this->fail();
            }
		}
		//Verify Payment
		public function verify_payment($ref='',$payFor='1',$cartId='') {
			if(empty($ref)){
				$this->fail();
			}
	        $result = array();
	        $url = 'https://api.paystack.co/transaction/verify/'.$ref;
	        $ch = curl_init();
	        curl_setopt($ch, CURLOPT_URL, $url);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	        curl_setopt(
	            $ch, CURLOPT_HTTPHEADER, [
	            'Authorization: Bearer '.PAYSTACK_SECRET_KEY]
	        );
	        $request = curl_exec($ch);
	        curl_close($ch);
	        if ($request) {
	            $result = json_decode($request, true);
	            $status = $this->Webservice_model->transactionResp($ref,$result,$payFor);
	            if($status){
	            	if($result){
		                if($result['data']){
		                    if($result['data']['status'] == 'success'){
		                    	if($payFor ==2 && !empty($cartId)){
		                    		$this->Webservice_model->removeCartPrdt($cartId);
		                    	}
		                        header("Location:".base_url('Webservices/success/'.$ref.'/'.$payFor));
		                    }else{
		                        header("Location:".base_url('Webservices/fail/'.$ref.'/'.$payFor));
		                    }
		                }
		                else{
		                    header("Location: ".base_url('Webservices/fail/'.$ref.'/'.$payFor));
		                }
		            }else{
		                header("Location: ".base_url('Webservices/fail/'.$ref.'/'.$payFor));
		            }
	            }
	        }else{
	            header("Location: ".base_url('Webservices/fail/'.$ref.'/'.$payFor));
	        }
	    }
	    //Payment fail
		public function fail($ref='',$payFor='1',$mobile='0'){
			if($mobile == '0'){
				$settings = getSettings();
				if($payFor == '1'){
					$url = $settings['web_url']."/dashboard?status=failure&tab=appointment&ref=".$ref;
					header("Location:".$url);
				}else{
					$url = $settings['web_url']."/purchaseHome?status=failure&ref=".$ref;
					header("Location:".$url);
				}
			} else {
				redirect('Webservices/mobPayFailed');
			}
		}

		public function mobPayFailed(){}
		public function mobPaySuccess(){}
		//Payment Success
		public function success($ref='',$payFor='1',$mobile='0'){
			if($payFor == '1'){
				$this->db->select('customer_vehicle.car_name,bookings.scheduled_date,
								   bookings.scheduled_time,customers.email,bookings.cost');
			    $this->db->from('transaction');
			    $this->db->join('bookings','transaction.booking_id = bookings.booking_id');
			    $this->db->join('customer_vehicle',
			    				'customer_vehicle.customer_veh_id = bookings.customer_veh_id');
			    $this->db->join('customers','customers.customer_id = bookings.customer_id');
			    $this->db->where('transaction.id',$ref);
			    $bookData   = $this->db->get()->row();
				$subject    = "DcarFixxers, Payment Successfull";
				$email_id   = $bookData->email;
				$message    = "<html>
								<body>
								  Hi,\n\r Welcome to DcarFixxers. \r\n Your Payment for the vehicle ".$bookData->car_name." on date ".$bookData->scheduled_date." at ".$bookData->scheduled_time." for amount ".$bookData->cost." is Success
								</body>
							   </html>";
				$template = getNotifTemplate();
		        if(isset($template['success_booking']) && !empty($template['success_booking'])){
		            $message = str_replace(array('{:car_name}','{:book_date}','{:amount}'),array($bookData->car_name,$bookData->scheduled_date,$bookData->cost),$template['success_booking']);
		        }
				send_mail($subject,$email_id,$message);
			}
			$fcm_data = $this->Webservice_model->getfcmData($ref,$mobile);
			if($fcm_data['status'] == "success"){	
				$fcm_data['data']['title'] = "CarFixxers";
				$fcm_data['data']['message'] = "A New Service Available";
				$this->push_sent_cancel($fcm_data['data']);
			}
			if($mobile == '1'){
				redirect('Webservices/mobPaySuccess');
			} else {
				$settings = getSettings();
				if($payFor == '1'){
					$url = $settings['web_url']."/dashboard?status=success&tab=appointment&ref=".$ref;
					header("Location: ".$url);
				} else {
					$url = $settings['web_url']."/track?ref=".$ref;
					header("Location: ".$url);
				}
			}
		}
		//Push Notification
		public  function push_sent_cancel($fcm_data=array()) {
			$settings = getSettings();
			$key = $settings['app_id'];

			if(empty($key) || empty($fcm_data)){
				return;
			}
			 $data = "{ \"notification\": { \"title\": \"".$fcm_data['title']."\", \"text\": \"".$fcm_data['message']."\", \"sound\": \"default\" }, \"time_to_live\": 60, \"data\" : {\"response\" : {\"status\" : \"success\", \"data\" : {\"service_id\" : \"".$fcm_data['booking_id']."\", \"type\" : \"".$fcm_data['service_type']."\"}}}, \"collapse_key\" : \"trip\", \"priority\":\"high\", \"to\" : \"".$fcm_data['device_id']."\"}";

			$ch = curl_init("https://fcm.googleapis.com/fcm/send");
			$header = array('Content-Type: application/json', 'Authorization: key='.$key);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

			$out = curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_exec($ch);
			curl_close($ch);
	  	}
		//Search Products
		public function productSearch(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$total = 0;
			$per_page = 10;
		    $page = (isset($postData['page']) && $postData['page'] != 1) ?$postData['page'] :'1'; 
		    $page_limit = ($page - 1) * $per_page;
			$result = $this->Webservice_model->productSearch($postData,0,0);
			$prodList = $this->Webservice_model->productSearch($postData,$page_limit,$per_page);
			if($result['status'] == 'success'){
				$total = count($result['data']);	
			}
			if($total >= $per_page){
				$totalPages = (int)($total%$per_page == 0?$total/$per_page:($total/$per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($prodList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => $prodList['data'],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' =>  [],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}
		//Get Brands
		public function getBrands(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$result = $this->Webservice_model->getBrands();
			echo json_encode($result);exit;
		}
		//Brand Details
		public function brand_details(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$result = $this->Webservice_model->getBrands('1');
			echo json_encode($result);exit;
		}
		//Search Product By Brand
		public function productSearchbyBrand(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->productSearchbyBrand($postData);
			echo json_encode($result);exit;
		}
		//Single Product Search
		public function SingleProductSearch(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->SingleProductSearch($postData);
			echo json_encode($result);exit;
		}
		//Save User Address
		public function saveUserAddress(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->saveUserAddress($postData);
			echo json_encode($result);exit;
		}
		//Initiate Order Booking
		public function initOrderBooking(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->initOrderBooking($postData);
			echo json_encode($result);exit;
		}
		//Get User Address
		public function getUserAddress(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->getUserAddress($postData);
			echo json_encode($result);exit;
		}
		//Get User Address By Id
		public function getUserAddressById(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->getUserAddressById($postData);
			echo json_encode($result);exit;
		}

		//Update User Address
		public function updateUserAddress(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->updateUserAddress($postData);
			echo json_encode($result);exit;
		}
		//Get Order Details
		public function getOrderDetail(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->getOrderDetail($postData);
			echo json_encode($result);exit;
		}
		//Rate Product
		public function rateProduct(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->rateProduct($postData);
			echo json_encode($result);exit;
		}
		//Get Latest Product List
		public function get_latest_product_list(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$postData['user_id'] = $authRes['data']['customer_id'];
			$per_page = 10;
			$page = (isset($_GET['page']) && $_GET['page'] >= 1)?(int)$_GET['page']:1; 
		    $start = ($page - 1) * $per_page; 
			$productResult = $this->Webservice_model->get_latest_product_list(0,0);
			$productList = $this->Webservice_model->get_latest_product_list($start,$per_page,$postData);
			$product = array();
			$total = 0;
			if($productResult['status'] == 'success'){
				$total = count($productResult['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($productList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'latest_products' => $productList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'latest_products' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}
		//Get Trending Product List
		public function get_trending_product_list(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$postData['user_id'] = $authRes['data']['customer_id'];
			$per_page = 10;
			$page = (isset($_GET['page']) && $_GET['page'] >= 1)?(int)$_GET['page']:1; 
		    $start = ($page - 1) * $per_page; 
			$productResult = $this->Webservice_model->get_trending_product_list(0,0);
			$productList=$this->Webservice_model->get_trending_product_list($start,$per_page,$postData);
			$product = array();
			$total = 0;
			if($productResult['status'] == 'success'){
				$total = count($productResult['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($productList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'trending_products' => $productList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'trending_products' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}
		//Product Details
		public function product_details(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$postData['user_id'] = $authRes['data']['customer_id'];
			$result = $this->Webservice_model->SingleProductSearch($postData);
			echo json_encode($result);exit;
		}
		//Add Address
		public function add_address(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$postData['customer_id'] = $authRes['data']['customer_id'];
			$result = $this->Webservice_model->saveUserAddress($postData);
			echo json_encode($result);exit;
		}
		//Address Details
		public function address_details(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$postData['user_id'] = $authRes['data']['customer_id'];
			$result = $this->Webservice_model->getUserAddress($postData);
			echo json_encode($result);exit;
		}
		//Get Latest Products
		public function getLatestPrdts(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$per_page = 10;
			$total = 0;
		    $page = (isset($postData['page']) && $postData['page'] != 1) ?$postData['page'] :'1';  
		    $page_limit = ($page - 1) * $per_page;  
			$latestResult = $this->Webservice_model->get_latest_product_list(0,0);
			$latestList = $this->Webservice_model->get_latest_product_list($page_limit,$per_page);
			if($latestResult['status'] == 'success'){
				$total = count($latestResult['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($latestList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => $latestList['data'],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => [],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}
		//Get Trending Products
		public function getTrendingPrdts(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$total = 0;
			$per_page = 10;
		    $page = (isset($postData['page']) && $postData['page'] != 1) ?$postData['page'] :'1'; 
		    $page_limit = ($page - 1) * $per_page;
			$trendResult = $this->Webservice_model->get_trending_product_list(0,0);
			$trendList = $this->Webservice_model->get_trending_product_list($page_limit,$per_page);
			if($trendResult['status'] == 'success'){
				$total = count($trendResult['data']);	
			}
			if($total >= $per_page){
				$totalPages = (int)($total%$per_page == 0?$total/$per_page:($total/$per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($trendList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => $trendList['data'],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' =>  [],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}
		//Get ny Orders
		public function getMyOrders(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$total = 0;
			$per_page = 10;
		    $page = (isset($postData['page']) && $postData['page'] != 1) ?$postData['page'] :'1'; 
		    $page_limit = ($page - 1) * $per_page;
			$result = $this->Webservice_model->getMyOrders($postData,0,0);
			$resultList = $this->Webservice_model->getMyOrders($postData,$page_limit,$per_page);
			if($result['status'] == 'success'){
				$total = count($result['data']);	
			}
			if($total >= $per_page){
				$totalPages = (int)($total%$per_page == 0?$total/$per_page:($total/$per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($resultList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => $resultList['data'],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' =>  [],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}
		//Cancel Order for web
		public function cancelOrder(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->cancelOrder($postData);
			echo json_encode($result);exit;
		}
		//Cancel Order For App
		public function cancel_order(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->cancelOrder($postData);
			echo json_encode($result);exit;
		}
		//Get Cart Data
		public function getCartData(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$total = 0;
			$per_page = 10;
		    $page = (isset($postData['page']) && $postData['page'] != 1) ?$postData['page'] :'1'; 
		    $page_limit = ($page - 1) * $per_page;
			$result = $this->Webservice_model->getCartData($postData,0,0);
			$cartList = $this->Webservice_model->getCartData($postData,$page_limit,$per_page);
			if($result['status'] == 'success'){
				$total = count($result['data']);	
			}
			if($total >= $per_page){
				$totalPages = (int)($total%$per_page == 0?$total/$per_page:($total/$per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($cartList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => $cartList['data'],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' =>  [],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}
		//Remove Cart Product
		public function removeCartPrdt(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->removeCartPrdt($postData['cart_id']);
			echo json_encode($result);exit;
		}
		//Add to Cart for Web
		public function addToCart(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->addToCart($postData);
			echo json_encode($result);exit;
		}
		//Add to Cart for App
		public function add_to_cart(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$postData['customer_id'] = $authRes['data']['customer_id'];
			$prd_data = $this->Webservice_model->SingleProductSearch($postData);
			if($prd_data['status'] == 'error'){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Amount is Required';
				echo json_encode($respArr);exit;
			}
			$postData['amount'] = $prd_data['data']->amount * $postData['quantity'];
			$result = $this->Webservice_model->addToCart($postData);
			echo json_encode($result);exit;
		}
		//Remove Product
		public function remove_product(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->removeCartPrdt($postData['cart_id']);
			echo json_encode($result);exit;
		}
		//Cart Details
	 	public function cart_details(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$per_page = 10;
			$page = (isset($_GET['page']) && $_GET['page'] >= 1)?(int)$_GET['page']:1; 
		    $start = ($page - 1) * $per_page; 
			$postData['customer_id'] = $authRes['data']['customer_id'];
			$cartResult = $this->Webservice_model->getCartData($postData,0,0);
			$cartList = $this->Webservice_model->getCartData($postData,$start,$per_page);
			$product = array();
			$total = 0;
			if($cartResult['status'] == 'success'){
				$total = count($cartResult['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($cartList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'cart_products' => $cartList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'cart_products' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
	  	}
	  	//My Order Details
	  	public function my_order_details(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$per_page = 10;
			$page = (isset($_GET['page']) && $_GET['page'] >= 1)?(int)$_GET['page']:1; 
		    $start = ($page - 1) * $per_page; 
			$postData['customer_id'] = $authRes['data']['customer_id'];
			$orderResult = $this->Webservice_model->getMyOrders($postData,0,0);
			$orderList = $this->Webservice_model->getMyOrders($postData,$start,$per_page);
			$product = array();
			$total = 0;
			if($orderResult['status'] == 'success'){
				$total = count($orderResult['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($orderList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'order_details' => $orderList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'order_details' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
	  	}
	  	//Search Product 
	  	public function search_product(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$postData['user_id'] = $authRes['data']['customer_id'];
			$per_page = 10;
			$page = (isset($postData['page']) && $postData['page'] >= 1)?(int)$postData['page']:1; 
		    $start = ($page - 1) * $per_page; 
			$searchResult = $this->Webservice_model->productSearch($postData,0,0);
			$searchList = $this->Webservice_model->productSearch($postData,$start,$per_page);
			$product = array();
			$total = 0;
			if($searchResult['status'] == 'success'){
				$total = count($searchResult['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($searchList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'search_products' => $searchList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'search_products' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
	  	}
	  	//Filter Product
	  	public function filter_product(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$postData['user_id'] = $authRes['data']['customer_id'];
			$per_page = 10;
			$page = (isset($postData['page']) && $postData['page'] >= 1)?(int)$postData['page']:1; 
		    $start = ($page - 1) * $per_page; 
			$filterResult = $this->Webservice_model->productSearch($postData,0,0);
			$filterList = $this->Webservice_model->productSearch($postData,$start,$per_page);
			$product = array();
			$total = 0;
			if($filterResult['status'] == 'success'){
				$total = count($filterResult['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($filterList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'sorted_products' => $filterList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'sorted_products' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
	  	}
	  	//Get Mechanic Shops
	  	public function getMechanicShops(){
	  		header('Content-type:application/json');
			$headers = apache_request_headers();
			$result = $this->Webservice_model->getMechanicShops();
			echo json_encode($result);exit;
	  	}
	  	//Get Vehicle Brands in Web
	  	public function getVehicleBrand(){
	  		header('Content-type:application/json');
			$headers = apache_request_headers();
			$result = $this->Webservice_model->getVehicleBrand();
			echo json_encode($result);exit;
	  	}
	  	//Get Vehicle Beands for app
	  	public function get_vehicle_brand(){
	  		header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$result = $this->Webservice_model->getVehicleBrand();
			echo json_encode($result);exit;
	  	}
	  	//Get Vehicle Model
	  	public function getVehicleModel(){
	  		header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$result = $this->Webservice_model->getVehicleModel($postData);
			echo json_encode($result);exit;
	  	}
		//Get Vehicle Trim  	
		public function getVehicleTrim(){
	  		header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$result = $this->Webservice_model->getVehicleTrim($postData);
			echo json_encode($result);exit;
	  	}
	  	//Get Vehicle Model
	  	public function get_vehicle_model(){
	  		header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$result = $this->Webservice_model->getVehicleModel($postData);
			echo json_encode($result);exit;
	  	}
	  	//Get User address By Id
		public function get_userAddress_by_id(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$postData = $_GET;
			$postData['customer_id'] = $authRes['data']['customer_id'];
			$result = $this->Webservice_model->getUserAddressById($postData);
			echo json_encode($result);exit;
		}
		//Update Address
	  	public function update_address(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$result = $this->Webservice_model->update_user_address($postData);
			echo json_encode($result);exit;
		}
		// Bulk Order Booking
	  	public function bulkOrderBooking(){
			header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			if(empty($post) || empty($postData = json_decode($post,true)) || 
			   !isset($postData['Auth']) || empty($postData['Auth']) || 
			   !isset($postData['data']) || empty($postData['data'])){
				$this->fail('','','1');
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($postData['Auth']); 
			if($authRes['status'] == 'error'){
				$this->fail('','','1');
			}
			$postData['customer_id'] = $authRes['data']['customer_id'];
			$result = $this->Webservice_model->bulkOrderBooking($postData);
			if($result['status'] == 'success'){
				$this->orderPayNowApi($result['data'],$authRes['data']['customer_id']);
			}
			$this->fail('','','1');
		}
		// Payment for App
		public function PayNowApi($transId=''){
			if(empty($transId)){
				$this->fail('','','1');
			}
            $mechData = $this->Webservice_model->getMechAmount($transId);
            if(empty($mechData)){
            	$this->fail('','','1');
            }
            $amount   = $mechData['data']['amount'] * 100;
            $callback = base_url().'Webservices/verify_payment_api/'.$transId.'/1';
            $postdata = array('email' => $mechData['emailId'], 
            				  'amount' => $amount,
            				  'reference' => $transId, 
            				  'callback_url' => $callback);
            $this->payStackPaymentApi($postdata);
		}
		//Payment for Product Api for App
	  	public function orderPayNowApi($transId='',$customer_id=''){
			if(empty($transId)){
				$this->fail('','','1');
			}
			$orderData = $this->Webservice_model->getOrderPayDetailsApi($transId);
			if($orderData['status'] == 'success'){
				$amount   = $orderData['data']->bulk_amount * 100;
	            $callback = base_url().'Webservices/verify_payment_api/'.$transId.'/2/'.$customer_id;
	            $postdata = array('email' => $orderData['data']->email, 
	            				  'amount' => $amount,
	            				  'reference' => $transId, 
	            				  'callback_url' => $callback);
	            $this->payStackPaymentApi($postdata);
			}
		}
		//Paymentfor PaystackPaymentApi
	    public function payStackPaymentApi($postdata=array()) {
            $url = "https://api.paystack.co/transaction/initialize";
            $ch  = curl_init();
            curl_setopt($ch, CURLOPT_URL,$url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            $headers = [
                'Authorization: Bearer '.PAYSTACK_SECRET_KEY,
                'Content-Type: application/json',
            ];
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $request = curl_exec ($ch);
            curl_close ($ch);
            $result = array();
            if ($request) {
                $result = json_decode($request, true);
            }
            if(empty($result) || !isset($result['data']) || 
               !isset($result['data']['authorization_url']) || empty($result['data']['authorization_url'])){
            	$this->fail('','','1');
            }
            $redir = $result['data']['authorization_url'];
            redirect($redir);
		}
		//Verify Payment Api
		public function verify_payment_api($transId='',$payFor='1',$customer_id='') {
			if(empty($transId)){
				$this->fail('','','1');
			}
	        $result = array();
	        $url = 'https://api.paystack.co/transaction/verify/'.$transId;
	        $ch = curl_init();
	        curl_setopt($ch, CURLOPT_URL, $url);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	        curl_setopt(
	            $ch, CURLOPT_HTTPHEADER, [
	            'Authorization: Bearer '.PAYSTACK_SECRET_KEY]
	        );
	        $request = curl_exec($ch);
	        curl_close($ch);
	        if ($request) {
	          $result = json_decode($request, true);
	          $status = $this->Webservice_model->transactionRespApi($transId,$result,$payFor);
	          if($status){
	            if($result){
		          if($result['data']){
		            if($result['data']['status'] == 'success'){
		            	if($payFor ==2 && !empty($customer_id)){
                    		$this->Webservice_model->removeCartPrdtAPI($customer_id);
                    	}
		              header("Location:".base_url('Webservices/success/'.$transId.'/'.$payFor.'/1'));
		            } else {
		              header("Location:".base_url('Webservices/fail/'.$transId.'/'.$payFor.'/1'));
		            }
		          } else {
		            header("Location: ".base_url('Webservices/fail/'.$transId.'/'.$payFor.'/1'));
		          }
		        } else {
		          header("Location: ".base_url('Webservices/fail/'.$transId.'/'.$payFor.'/1'));
		        }
	          }
	        }else{
	          header("Location: ".base_url('Webservices/fail/'.$transId.'/'.$payFor.'/1'));
	        }
	    }
	    //Social login
	    public function socialLogin(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->socialLogin($postData);
			echo json_encode($result);exit;
	    }
	    //Get Customer remainders
	    public function getCustRemainders(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->getCustRemainders($postData);
			echo json_encode($result);exit;
	    }
	    //Change Remainder Status
	    public function changeReminderStatus(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$this->load->model('Vehicle_model');
			$result = $this->Vehicle_model->changeReminderStatus($postData);
			echo json_encode($result);exit;
	    }
	    //Download Order Details
	    public function downloadOrdrDtls($order_id = ''){
	    	if(empty($order_id)){
	    		return;
	    	}
        	$this->load->library("Pdf");
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			$product_data = $this->Webservice_model->getOrderData($order_id);
			$time = explode(' ',$product_data->datetime);
			$html = '';
			$template = getNotifTemplate();
	        if(isset($template['invoice_template']) && !empty($template['invoice_template'])){
	            $html = str_replace(array('{:order_id}','{:order_date}','{:invoice_date}','{:shipping_address}','{:product_name}','{:brand_name}','{:quantity}','{:price}','{:total}','{:name}'),array($product_data->format_order_id,$time[0],date('Y-m-d'),$product_data->shipping_address,$product_data->product_name,$product_data->brand_name,$product_data->quantity,$product_data->prd_amount,$product_data->amount,$product_data->name),$template['invoice_template']);
	        }
		    $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		    $pdf->SetCreator(PDF_CREATOR);
		    $pdf->SetAuthor('DcarFixers');
		    $pdf->SetTitle('Product Details');
		    $pdf->SetSubject('Summary');
		    $pdf->SetKeywords('PDF, record, Summary');
		    $pdf->setPrintHeader(false);
		    $pdf->setPrintFooter(false);
		    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
		    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
		    if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		        require_once(dirname(__FILE__).'/lang/eng.php');
		        $pdf->setLanguageArray($l);
		    }
		    $pdf->setFontSubsetting(true);
		    $pdf->SetFont('times', '', 10, '', true);
		    $pdf->AddPage();
		    $pdfConfig = array('enabled'=>true,'depth_w'=>0.2,'depth_h'=>0.2,
		    	               'color'=>array(196,196,196),'opacity'=>1,'blend_mode'=>'Normal');
		    $pdf->setTextShadow($pdfConfig);
		    $pdf->writeHTML($html, true, false, true, false, '');
		    ob_end_clean();
		    $pdf->Output('Record.pdf', 'I');
	    }
	    //Give Review
	    public function giveReview(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$postData['customer_id'] = $authRes['data']['customer_id'];
			$result = $this->Webservice_model->rateProduct($postData);
			echo json_encode($result);exit;
	    }
	    //Get my Vehicles
	    public function get_my_vehicles(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			$this->load->model('Vehicle_model');
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$postData['customer_id'] = $authRes['data']['customer_id'];
			$result = $this->Vehicle_model->getCustVechiles($postData);
			$respArr['status'] = "success";
			$respArr['data'] = $result;
			echo json_encode($respArr);exit;
	    }
	    //Get Customer Vehicle Details
	    public function getCustVehDetails(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->getCustVehDetails($postData);
			echo json_encode($result);exit;
	    }
	    //Remove Vehicle
	    public function remove_vehicle(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$result = $this->Webservice_model->remove_vehicle($postData);
			echo json_encode($result);exit;
	    }
	    //Get Mechanic Review
	    public function get_mechanics_reviews(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);
			$postData['user_id'] = $authRes['data']['customer_id'];
			$per_page = 10;
			$page = (isset($postData['page']) && $postData['page'] >= 1)?(int)$postData['page']:1; 
		    $start = ($page - 1) * $per_page; 
			$reviewResult = $this->Webservice_model->get_mechanics_reviews($postData,0,0);
			$reviewList = $this->Webservice_model->get_mechanics_reviews($postData,$start,$per_page);
			$total = 0;
			if($reviewResult['status'] == 'success'){
				$total = count($reviewResult['data']);	
			}
			if($total >= $per_page){
				$totalPages =(int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			if($reviewList['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => array(
						'reviews' => $reviewList['data']
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => array(
						'reviews' => []
					),
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
	    }
	    //Forgot Password
	    public function forgot_password(){
	    	header('Content-Type:application/json');
	    	$headers = apache_request_headers();
	    	$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			if(!isset($postData['email']) || empty($postData['email'])){
				$respArr['status'] = "error";
				$respArr['message'] = "Email Id is Required";
				echo json_encode($respArr);exit;
			}
			$respArr = $this->Webservice_model->forgot_password($postData['email']);
			echo json_encode($respArr);exit;
	    }
	    //Change Password
	    public function change_password(){
	    	header('Content-type:application/json');
	    	$headers = apache_request_headers();

	    	$post = file_get_contents("php://input");
	    	$postData = json_decode($post, true);

	    	if(!isset($postData['email']) || empty($postData['email'])){
	    		$respArr['status'] = "error";
	    		$respArr['message'] = "Email Id is Required";
	    		echo json_encode($respArr);exit;
	    	}
	    	else if(!isset($postData['password']) || empty($postData['password'])){
	    		$respArr['status'] = "error";
	    		$respArr['message'] = "Password is Required";
	    		echo json_encode($respArr);exit;
	    	}
	    	$respArr = $this->Webservice_model->change_password($postData);
	    	echo json_encode($respArr);exit;
	    }

	    public function trim_list(){
	    	header('Content-type:application/json');
			$headers = apache_request_headers();
			if(!isset($headers['auth']) || empty($headers['auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			$authRes = $this->Webservice_model->get_customer_authtoken($headers['auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}
			$post = file_get_contents("php://input");
			$postData = json_decode($post,true);

			if(empty($postData)){
				$respArr = array('status'=>0,'error'=>'901','message'=>'All Field is Required');
				echo json_encode($respArr);exit;
			}
			$respArr = $this->Webservice_model->getVehicleTrim($postData);
			echo json_encode($respArr);exit;
	    }

	    public function social_login(){
	    	header('Content-type: application/json');
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$this->load->model('Customer_model');
			$respArr = array('status'=>'0','message'=>'Something went wrong.');
			if(empty($postData)){
				echo json_encode($respArr);exit;
			}
			$err = 0;
			$msg = '';
			if(!isset($postData['email']) || empty($postData['email'])){
				$err = 1;
				$msg = 'Provide a valid Email ID';
			}
			else if(!isset($postData['first_name']) || empty($postData['first_name'])){
				$err = 1;
				$msg = 'Provide valid Name';
			}
			else if(!isset($postData['registration_type'])){
				$err = 1;
				$msg = 'Provide Social Type';
			}
			if(!isset($postData['isRegistration'])){
				$err = 1;
				$msg = 'Provide Registartion type';
			}
			if($postData['isRegistration'] == '1'){
				if(!isset($postData['phone']) || empty($postData['phone'])){
					$err = 1;
					$msg = 'Provide a Phone Number';
				} 
				else if(!isset($postData['country_code']) || empty($postData['country_code'])){
					$err = 1;
					$msg = 'Provide a Country code';
				}
			}
			if($err == 1){
				$respArr['message'] = $msg;
				echo json_encode($respArr);exit;
			}
			$postData['profile_image'] = NULL;
			$postData['phone'] = (isset($postData['phone']) && !empty($postData['phone']))?$postData['phone']:'';
	        $postData['country_code'] = (isset($postData['country_code']) && !empty($postData['country_code']))?$postData['country_code']:'';
	        if(isset($postData['data']['profileImg']) && !empty($postData['data']['profileImg'])){
		        $imageData = file_get_contents($postData['data']['profileImg']);
		        $userlImg  = 'assets/uploads/services/userImg_'.time().'.jpg';
		        file_put_contents($userlImg, $imageData);
		        $postData['data']['profile_image'] = $userlImg;
	        }
	        if(isset($postData['data']) && !empty($postData['data'])){
	        	unset($postData['data']);
	        }
	        if($postData['isRegistration'] == '1'){
	        	unset($postData['isRegistration']);
	        	$custReg = $this->Customer_model->createCustomer($postData,'');
	        	if(empty($custReg)){
					echo json_encode($respArr);exit;
				}
				if($custReg == '2'){
					$respArr['status'] = '0';
					$respArr['message'] = 'Email Id Already Exist';
					echo json_encode($respArr);exit;
				} else if($custReg == '3'){
					$respArr['status'] = '0';
					$respArr['message'] = 'Phone Number Already Exist';
					echo json_encode($respArr);exit;
				}
				else if($custReg == '1'){
	        		$respArr = $this->getUserDetails($postData);
				}
	        }else{
	        	unset($postData['isRegistration']);
	        	$respArr = $this->getUserDetails($postData);
	        }
	        echo json_encode($respArr);exit;
	    }

	    public function getUserDetails($postData){
			$custResp = $this->Webservice_model->checkSocialCustomerLogin($postData);
			if(isset($custResp['status']) && $custResp['status'] == '2'){
				$respArr['message'] = 'User Not Registered Yet';
				$respArr['status'] = '0';
				return $respArr ;
			}
			if($custResp['status'] == '1'){
				$respArr['data'] = $custResp['data'];
				$respArr['status'] = '1';
				$respArr['message'] = 'Success';
				return $respArr;
			}
	    }

	    public function crone_job(){
	    	$result = $this->db->get_where('transaction',array('status'=>'2'));
	    	if(!empty($result) && $result->num_rows() >= 1 && !empty($result = $result->result_array())){
	    		$current_time = date('Y-m-d H:m:s');
	    		foreach ($result as $key => $value) {
	    			$new_time = date("Y-m-d H:i:s",strtotime("+10 minutes", strtotime($value['datetime'])));
	    			if(strtotime($current_time) > strtotime($new_time)){
	    				if($this->db->update('transaction',array('status'=>'0'),array('id'=>$value['id']))){
	    					if($value['payment_for'] == '1'){
	    						$this->db->update('bookings',array('status'=>'7'),array('booking_id'=>$value['booking_id']));
	    					}else{
	    						$this->db->update('orders',array('status'=>'9'),array('booking_id'=>$value['booking_id']));
	    					}
	    				}
	    			}
	    		}
	    	}
	    }
	}
?>
