<?php 
class Dashboard_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
 	}
 	//Get Booking Count
 	public function getBookingCount(){
 		if($this->session->userdata('user_type') == 1){	
 			$result = $this->db->get_where('bookings')->result();
 		}else{
 			$id = $this->session->userdata('id');
 			$this->db->join('mechanic_booking','mechanic_booking.booking_id = bookings.booking_id','left');
 			$result = $this->db->get_where('bookings',array('mechanic_booking.mechanic_id'=>$id))->result();
 		}
 		return count($result);
 	}
 	//Get Mechanic Shop Count
 	public function getMechShpCount(){
 		if($this->session->userdata('user_type') == 1){	
 			$result = $this->db->get_where('mechanic_shop',array('status'=>'1'))->result();
 		}else{
 			return 0;
 		}
 		return count($result);
 	}
 	//Get Completed Booking Count 
 	public function getCompletedBookingCount(){
 		if($this->session->userdata('user_type') == 1){	
 			$result = $this->db->get_where('bookings',array('status'=>'3'))->result();
 		}else{
 			$id = $this->session->userdata('id');
 			$this->db->join('mechanic_booking','mechanic_booking.booking_id = bookings.booking_id','left');
 			$result = $this->db->get_where('bookings',array('mechanic_booking.mechanic_id'=>$id,'bookings.status'=>'3'))->result();
 		}
 		return count($result);
 	}
 	//Get Pending Booking Count
 	public function getPendingBookingCount(){
 		if($this->session->userdata('user_type') == 1){	
 			$result = $this->db->get_where('bookings',array('status'=>'1'))->result();
 		}else{
 			$id = $this->session->userdata('id');
 			$this->db->join('mechanic_booking','mechanic_booking.booking_id = bookings.booking_id','left');
 			$result = $this->db->get_where('bookings',array('mechanic_booking.mechanic_id'=>$id,'bookings.status'=>'1'))->result();
 		}
 		return count($result);
 	}
 	//Get Mobile Vendors Count
 	public function getMbleVndrsCount(){
 		if($this->session->userdata('user_type') == 1){	
 			$result = $this->db->get_where('mechanic',array('shop_id'=>'1'))->result();
 		}else{
 			return 0;
 		}
 		return count($result);
 	}
 	//Get Mobile Mechanics Count
 	public function getMbleMchnsCount(){
 		if($this->session->userdata('user_type') == 1){	
 			$result = $this->db->get_where('mechanic',array('shop_id'=>'0'))->result();
 		}else{
 			return 0;
 		}
 		return count($result);
 	}
 	//Get Customer Count
 	public function getCustomerCount(){
 		if($this->session->userdata('user_type') == 1){	
 			$result = $this->db->get_where('customers',array('status'=>'1'))->result();
 		}else{
 			return 0;
 		}
 		return count($result);
 	}
 	//Get Product Count
 	public function getProductCount(){
 		if($this->session->userdata('user_type') == 1){	
 			$result = $this->db->get_where('products',array('status'=>'1'))->result();
 		}else{
 			$id = $this->session->userdata('id');
 			$result = $this->db->get_where('products',array('status'=>'1','created_by'=>$id))->result();
 		}
 		return count($result);
 	}
 	//Get Product Sold Count
 	public function getProductSoldCount(){
 		if($this->session->userdata('user_type') == 1){	
 			$result = $this->db->query("SELECT SUM(`quantity`) as count FROM `orders` WHERE status IN('2,3,4,5')")->row();
 		}else{
 			$id = $this->session->userdata('id');
 			$result = $this->db->query("SELECT SUM(`quantity`) as count FROM `orders` INNER JOIN products ON products.product_id = orders.product_id WHERE orders.status IN('2,3,4,5') AND products.created_by='$id'")->row();
 		}
 		return $result->count;
 	}
	//Get Sales Report Count 
 	public function getSalesReportCount(){
 		$query = $this->db->query("
 			SELECT COUNT(ORDS.order_id) AS count, SUBSTRING_INDEX(TRANS.datetime, '-', 1) AS year 
 			FROM `orders` AS `ORDS` 
 			INNER JOIN `transaction` AS `TRANS` ON (`TRANS`.`booking_id` = `ORDS`.`order_id`)
 			WHERE `TRANS`.`payment_for`='2' AND `TRANS`.`status` = '1'
 			GROUP BY SUBSTRING_INDEX(TRANS.datetime,'-',1)");
 		$result = array();
 		if(empty($query) || $query->num_rows < 0 || empty($query = $query->result_array())){
 			return $result;
 		}
 		foreach($query as $value){
 		    $result[] = array('y'=>$value['year'],'item1'=>$value['count']);
 		}
        return json_encode($result);
 	}
 	//Get booking Report Count
	public function getBookingReportCount(){
 		$query = $this->db->query("
 			SELECT COUNT(BUK.booking_id) AS count, SUBSTRING_INDEX(TRANS.datetime, '-', 1) AS year 
 			FROM `bookings` AS `BUK` 
 			INNER JOIN `transaction` AS `TRANS` ON (`TRANS`.`booking_id` = `BUK`.`booking_id`)
 			WHERE `TRANS`.`payment_for`='1' AND `TRANS`.`status` = '1'
 			GROUP BY SUBSTRING_INDEX(TRANS.datetime,'-',1)");
 		$result = array();
 		if(empty($query) || $query->num_rows < 0 || empty($query = $query->result_array())){
 			return $result;
 		}
 		foreach($query as $value){
 		    $result[] = array('y'=>$value['year'],'item1'=>$value['count']);
 		}
        return json_encode($result);
 	}
}
?>