<?php 
class Product_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
 	}

 	public function addProduct($product_data = array()){
 		if(empty($product_data)){
 			return 0;
 		}
 		$prdYear = $product_data['prdVehYear'];
 		$prdVehModel = $product_data['prdVehModel'];
 		$prdVehicle_id = $product_data['prdVehicle_id'];
 		unset($product_data['prdVehModel'],$product_data['prdVehYear'],$product_data['vehModel'],$product_data['prdVehicle_id']);
 		$status = $this->db->insert('products',$product_data);
 		$last_id = $this->db->insert_id();
 		foreach ($prdYear as $key => $value) {
 			$this->db->insert('product_cars',array('product_id'=>$last_id,'veh_model_id'=>$prdVehicle_id[$key]));
 		}
		return $last_id;
 	}

 	function getProduct($product_id = '',$view_all = 0,$mechanic_id = ''){
 		$cond = ($view_all != 0)?' products.status IN (0,1) ':' products.status IN (1) ';
 		$cond .= (!empty($product_id))?" AND products.product_id = '$product_id'":"";
 		$cond .= (!empty($mechanic_id))?" AND products.created_by = '$mechanic_id'":"";

		$result = $this->db->query("SELECT products.*,product_brand.brand_name
									FROM products
									JOIN product_brand on product_brand.brand_id = products.brand_id
									WHERE $cond");
		if(empty($result)){return;}

		if(!empty($product_id)){
			$result = $result->row();
			$sql = "SELECT PC.prd_car_id,VEH.year,VM.model_name as model,VEH.trim,VEH.engine,VB.maker,VM.veh_model_id,VEH.veh_id
					FROM products AS PRD
					LEFT JOIN product_cars AS PC ON (PRD.product_id=PC.product_id AND PC.status='1')
					LEFT JOIN vehicles AS VEH ON (PC.veh_model_id=VEH.veh_id AND VEH.status='1')
					LEFT JOIN vehicle_models AS VM ON (VM.veh_model_id=VEH.model_id AND VM.status='1')
					LEFT JOIN vehicles_brand AS VB ON (VB.veh_brand_id=VEH.veh_brand_id AND VB.status='1')
					WHERE PC.product_id='$product_id' AND PRD.status='1'";
			$carData = $this->db->query($sql);
			$carData = (!empty($carData))?$carData->result():[];
			$result->carData = $carData;
			return $result;
		}
		return $result->result();
 	}

 	function changeStatus($product_id = '', $status = '0'){
 		if(empty($product_id)){
 			return 0;
 		}
 		$this->db->update('product_images',array('status'=>$status),array('product_id'=>$product_id));
 		$status = $this->db->update('products',array('status'=>$status), array('product_id'=>$product_id));
 		return $status;
 	}

 	function updateProduct($product_id = '', $product_data = array()){
 		if(empty($product_id) || empty($product_data)){
 			return 0;
 		}
 		$this->db->delete('product_cars',array('product_id'=>$product_id));
 		foreach ($product_data['prdVehYear'] as $key => $value) {
			$this->db->insert('product_cars',array('product_id'=>$product_id,'veh_model_id'=>$product_data['prdVehicle_id'][$key]));
 		}
 		unset($product_data['prdVehModel'],$product_data['prdVehYear'],$product_data['vehModel'],$product_data['prdVehicle_id']);
 		$status = $this->db->update('products',$product_data,array('product_id'=>$product_id));
		return ($status)?1:0;
 	}

 	function addProductImage($imagearray = array()){
 		if(empty($imagearray)){
 			return 0;
 		}
 		$status = $this->db->insert_batch('product_images',$imagearray);
 		return ($status)?1:0;
 	}

 	function updateProductImage($product_id = '', $imagearray = array(), $existingImages = array()){
 		if(empty($product_id)){
 			return 0;
 		}
 		if(!empty($existingImages)){
 			$this->db->query("DELETE FROM product_images 
 							  WHERE id NOT IN (".implode(",",$existingImages).") AND product_id=$product_id");
 		} else {
 			$this->db->query("DELETE FROM product_images WHERE product_id='$product_id'");
 		}

 		if(!empty($imagearray)){
			$status = $this->db->insert_batch('product_images',$imagearray);
 		}
		return $status;
 	}

 	function getProductImage($product_id = ''){
 		if(empty($product_id)){
 			return 0;
 		}
 		$status = $this->db->get_where('product_images',array('product_id'=>$product_id))->result_array();
 		return $status;
 	}

}
?>