<div class="content-wrapper">
  <section class="content-header">
    <h1><?= $pTitle ?><small><?= $pDescription ?></small></h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php 
        $url = (!isset($vehicle_id) || empty($vehicle_id))?'Vehicle/createModel':'Vehicle/updateVehModel/'.$vehicle_id;
        if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
            <button class="close" data-dismiss="alert" type="button">×</button>
            <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-body">
            <form role="form" action="<?= base_url($url) ?>" method="post" 
              class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <div class="col-md-4">
                <div class="form-group">
                  <label>Vehicle Model Year</label>
                    <select name="vehYear" class="form-control required" input="search_params" 
                      data-parsley-trigger="change" required="" onchange="setYear()">
                      <option selected disabled value="">Choose Vehicle Model Year</option>
                      <?php 
                        for($year=date('Y'); $year>=1950; $year--){
                          $cond = (isset($vehModel_datas) && isset($vehModel_datas->year) && 
                                   !empty($vehModel_datas->year) && 
                                   $vehModel_datas->year == $year)?'selected':'';
                          echo '<option '.$cond.' value="'.$year.'">'.$year.'</option>'; 
                        }
                      ?>
                    </select>
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>Select Brand</label>
                  <select name="veh_brand_id" id="veh_make" class="form-control required" placeholder="Select Brand" required="" type="1">
                    <option selected disabled value="-1">Choose a Brand</option>
                    <?php 
                      foreach ($vehBrand_data as $brand) {
                        $select = (isset($vehModel_datas->veh_brand_id) && $brand->veh_brand_id==
                          $vehModel_datas->veh_brand_id)?'selected':'';
                        echo '<option '.$select.' value="'.$brand->veh_brand_id.'" maker="'.$brand->veh_brand_id.'">'.
                                $brand->maker.
                             '</option>';
                      }
                    ?>
                  </select> 
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <?php
                $text = (isset($vehModel_datas->veh_model_id) && !empty($vehModel_datas->veh_model_id))?'':'hide';
              ?>
              <div class="col-md-4 <?php echo $text ?> " id="vehicle_model_div">
                <div class="form-group">
                  <label>Model Name</label>
                  <select name="model" class="form-control required " placeholder="Select Model" required="" id="veh_model">
                    <option selected disabled>Choose a Model</option>
                    <?php 
                      foreach ($vehModel_data as $model) {
                        $select = (isset($vehModel_datas->veh_model_id) && $model->veh_model_id==
                          $vehModel_datas->veh_model_id)?'selected':'';
                        echo '<option '.$select.' value="'.$model->veh_model_id.'">'.
                                $model->model.
                             '</option>';
                      }
                    ?>
                  </select> 
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Trim</label>
                  <input type="text" class="form-control required" name="trim" required="" value="<?= (isset($vehModel_datas->trim))?$vehModel_datas->trim:'' ?>"placeholder="Enter Vehicle Trim">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Engine</label>
                  <input type="text" class="form-control required" name="engine" required="" value="<?= (isset($vehModel_datas->engine))?$vehModel_datas->engine:'' ?>"placeholder="Enter Vehicle Engine">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-12">      
                <div class="box-footer textCenterAlign">
                  <button type="submit" class="btn btn-primary">Submit</button>
                  <a href="<?= base_url('Vehicle/viewVehModel') ?>" class="btn btn-primary">Cancel</a>
                </div>        
              </div>        
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>