<?php
	defined('BASEPATH')OR exit('No direct script access allowed');
	header('Content-Type: text/html; charset=utf-8');
	
	// Allow from any origin
	if(isset($_SERVER['HTTP_ORIGIN'])) {
		header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
		header('Access-Control-Allow-Credentials: true');
		header('Access-Control-Max-Age: 86400'); // cache for 1 day
	}
	
	// Access-Control headers are received during OPTIONS requests
	if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
		header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
		exit(0);
	}
	
	class Webservices_mechanic extends CI_Controller {
		
		public function __construct() {
			parent::__construct();
			$this->load->model('Webservice_mechanic_model');
			$this->load->library('form_validation');
			
			$auth = '';
			$class = $this->router->fetch_class();
			$method = $this->router->fetch_method();
			
			if($this->input->server('REQUEST_METHOD') == 'GET')
			$postdata = json_encode($_GET);
			
			else if ($this->input->server('REQUEST_METHOD') == 'POST')
			$postdata = file_get_contents("php://input");
			
			if (isset(apache_request_headers()['Auth'])) {
				$auth = apache_request_headers()['Auth'];
			}

			define("PAYSTACK_SECRET_KEY", "sk_test_36658e3260b1d1668b563e6d8268e46ad6da3273");
		}
		
		// customer_login
		public function sign_in_mechanic(){
			header('Content-type: application/json');
			
			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);

			$respArr = array('status'=>'error','message'=>'Required Fields are empty.');
			if(!isset($postData['user_name']) || empty($postData['user_name']) || 
			!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
				echo json_encode($respArr);exit;
			}
			$respArr = $this->Webservice_mechanic_model->checkMechanicLogin($postData);
			echo json_encode($respArr); exit;
		}
		
	//Get Booked Services	
		public function get_todays_services(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_mechanic_model->get_mechanic_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);

			$per_page = 10;
			
			$page = (isset($postData['page']) && $postData['page'] >= 1)?(int)$postData['page']:1; 
		    $start = ($page - 1) * $per_page; 

		    $postData['mechanic_id'] = $authRes['data']['mechanic_id'];
			$bookDataCount = $this->Webservice_mechanic_model->getBookedService($postData,0,0,1);
			
			$bookDataResult = $this->Webservice_mechanic_model->getBookedService($postData,$start,$per_page,1);

			$total = 0;
			if($bookDataCount['status'] == 'success'){
				$total = count($bookDataCount['data']);	
			}
			
			if($total >= $per_page){
				$totalPages = (int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			
			if($bookDataResult['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => $bookDataResult['data'],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => [],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}

		public function services_details(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_mechanic_model->get_mechanic_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
			$postData['mechanic_id'] = $authRes['data']['mechanic_id'];

			if(!isset($postData['service_id']) || empty($postData['service_id'])){
				$respArr['message'] = "Service Id is Required";
				return $respArr;
			}

			$respArr = $this->Webservice_mechanic_model->getBookedService($postData);

			echo json_encode($respArr);exit;
		}

		// public function get_pending_services(){
		// 	header('Content-type: application/json');
		// 	$headers = apache_request_headers();
			
		// 	if(!isset($headers['Auth']) || empty($headers['Auth'])){
		// 		$respArr['status'] = 'error';
		// 		$respArr['message'] = 'Authtoken is Required';
		// 		echo json_encode($respArr);exit;
		// 	}
			
		// 	$authRes = $this->Webservice_mechanic_model->get_mechanic_authtoken($headers['Auth']); 
		// 	if($authRes['status'] == 'error'){
		// 		echo json_encode($authRes);exit;
		// 	}

		// 	$per_page = 10;
			
		// 	$page = (isset($postData['page']) && $postData['page'] >= 1)?(int)$postData['page']:1; 
		//     $start = ($page - 1) * $per_page; 

		// 	$post = file_get_contents("php://input");
		// 	$postData = json_decode($post, true);
		//     $postData['mechanic_id'] = $authRes['data']['mechanic_id'];

		// 	$bookDataCount = $this->Webservice_mechanic_model->getBookedService($postData,0,0,2);
		// 	$bookDataResult = $this->Webservice_mechanic_model->getBookedService($postData,$start,$per_page,2);

		// 	$total = 0;
		// 	if($bookDataCount['status'] == 'success'){
		// 		$total = count($bookDataCount['data']);	
		// 	}
			
		// 	if($total >= $per_page){
		// 		$totalPages = (int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
		// 	}
		// 	else{
		// 		$totalPages = 1;
		// 	}
			
		// 	if($bookDataResult['status'] == 'success'){
		// 		$respArr = array(
		// 			'status' => 'success',
		// 			'message'=>'success',
		// 			'data' => $bookDataResult['data'],
		// 			'meta' => array(
		// 				'total_pages' => $totalPages,
		// 				'total' => $total,
		// 				'current_page' => ($page == 0)?1:$page,
		// 				'per_page' => $per_page
		// 			)
		// 		);
		// 	}else{
		// 		$respArr = array(
		// 			'status' => 'error',
		// 			'message'=>'No data',
		// 			'data' => [],
		// 			'meta' => array(
		// 				'total_pages' => $totalPages,
		// 				'total' => $total,
		// 				'current_page' => ($page == 0)?1:$page,
		// 				'per_page' => $per_page
		// 			)
		// 		);
		// 	}
		// 	echo json_encode($respArr);exit;
		// }

		public function get_service_history(){
			header('Content-type: application/json');
			$headers = apache_request_headers();
			
			if(!isset($headers['Auth']) || empty($headers['Auth'])){
				$respArr['status'] = 'error';
				$respArr['message'] = 'Authtoken is Required';
				echo json_encode($respArr);exit;
			}
			
			$authRes = $this->Webservice_mechanic_model->get_mechanic_authtoken($headers['Auth']); 
			if($authRes['status'] == 'error'){
				echo json_encode($authRes);exit;
			}

			$per_page = 10;
			
			$page = (isset($postData['page']) && $postData['page'] >= 1)?(int)$postData['page']:1; 
		    $start = ($page - 1) * $per_page; 

			$post = file_get_contents("php://input");
			$postData = json_decode($post, true);
		    $postData['mechanic_id'] = $authRes['data']['mechanic_id'];

			$bookDataCount = $this->Webservice_mechanic_model->getBookedService($postData,0,0,0,3);
			$bookDataResult = $this->Webservice_mechanic_model->getBookedService($postData,$start,$per_page,0,3);

			$total = 0;
			if($bookDataCount['status'] == 'success'){
				$total = count($bookDataCount['data']);	
			}
			
			if($total >= $per_page){
				$totalPages = (int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
			}
			else{
				$totalPages = 1;
			}
			
			if($bookDataResult['status'] == 'success'){
				$respArr = array(
					'status' => 'success',
					'message'=>'success',
					'data' => $bookDataResult['data'],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}else{
				$respArr = array(
					'status' => 'error',
					'message'=>'No data',
					'data' => [],
					'meta' => array(
						'total_pages' => $totalPages,
						'total' => $total,
						'current_page' => ($page == 0)?1:$page,
						'per_page' => $per_page
					)
				);
			}
			echo json_encode($respArr);exit;
		}
	}
?>
