<?php 
class Booking_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
 	}

 	public function scheduleBooking($postData = array()){
      	if(empty($postData) || 
      	  !isset($postData['customer_id']) || empty($postData['customer_id']) || 
      	  !isset($postData['pickup_data']) || empty($postData['pickup_data']) || 
      	  !isset($postData['vechile_info']) || empty($postData['vechile_info']) || 
      	  !isset($postData['mechanic_id']) || empty($postData['mechanic_id']) || 
      	  !isset($postData['selected_issues']) || empty($postData['selected_issues'])){
        	return 0;
      	}

		$vehData = $postData['vechile_info'];
		$car_name = $vehData['modelYear'].' '.$vehData['maker'].' '.$vehData['modelName'];

      	$vehJson = array('vehicle' => $car_name,
                         'attributes' => 
							array('Year'      => $vehData['modelYear'],
								  'Make'      => $vehData['maker'],
								  'Trim'      => $vehData['trim'],
								  'Model'     => $vehData['modelName'],
								  'Engine'    => $vehData['emgine']));

      	$insert_array = array('customer_id'   => $postData['customer_id'],
	                          'car_name'      => $car_name,
	                          'car_model'     => $vehData['modelName'],
	                          'car_maker'     => $vehData['maker'],
	                          'car_loc_lat'   => $postData['pickup_data']['pickup_lat'],
	                          'car_loc_lng'   => $postData['pickup_data']['pickup_lng'],
	                          'car_location'  => $postData['pickup_data']['pickup_loc'],
	                          'vehicle_data'  => json_encode($vehJson),
	                          'car_model_year'=> $vehData['modelYear'],
	                          'status'        => '3');

      	$selected_issues = array();
      	foreach($postData['selected_issues'] AS $selIssue){
      		$selected_issues[] = array('issue'			=>$selIssue['issue'],
      								   'issue_id'		=>$selIssue['issue_id'],
      								   'sub_issue_id'	=>$selIssue['sub_issue_id'],
      								   'issue_category' =>$selIssue['issue_category']);
      	}

		if($this->db->insert('customer_vehicle',$insert_array)){

			$last_id = $this->db->insert_id();

			$book_data = array('cost'			  => $postData['cost'],
							   'mileage'          => $vehData['milage'],
							   'customer_id'      => $postData['customer_id'],
							   'mechanic_id'      => $postData['mechanic_id'],
							   'scheduled_date'   => $postData['schedule_date']['date'],
							   'scheduled_time'   => $postData['schedule_date']['time'],
							   'issues_selected'  => json_encode($selected_issues),
							   'customer_veh_id'  => $last_id,
							   'custom_issue_data'=> json_encode($postData['optionalData']),
							   'status'           => '0');

			if($this->db->insert('bookings',$book_data)){
			  	return 1;
			}
		}
      	return 0;
    }

    function getCustBookDetails($postData = array(), $status = ''){
        $cond = array();
        if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
        	return 0;
        }
    	$cond  = "BK.customer_id='".$postData['customer_id']."' ";
        $cond .= (!empty($status))?"AND BK.status IN (".$status.") ":'';

    	$sql = "SELECT BK.booking_id,BK.customer_id,BK.mechanic_id,BK.customer_veh_id,BK.scheduled_date,
    				   BK.scheduled_time,BK.cost,BK.status,MECH.first_name,MECH.last_name,VEH.car_name,
    				   BK.status
			    FROM bookings AS BK
			    INNER JOIN mechanic AS MECH ON (MECH.mechanic_id = BK.mechanic_id)
			    INNER JOIN customer_vehicle AS VEH ON (VEH.customer_veh_id = BK.customer_veh_id)
			    WHERE $cond 
			    GROUP BY BK.booking_id";

	    $bookData = $this->db->query($sql);

	    if(!empty($bookData)){
	    	return $bookData->result();
	    }
	    return 0;
    }

    function changeBookStatus($customer_id = '', $booking_id = '', $status = ''){
    	if(empty($customer_id) || empty($booking_id) || $status == ''){
    		return 0;
    	}

    	$status = $this->db->update('bookings',
    									array('status'=>$status),
									    array('customer_id'=>$customer_id,'booking_id'=>$booking_id));

    	return $status;
    }

    function getMechBookings($mechanic_id = '', $booking_id = '', $status = '1'){
    	if($this->session->userdata('user_type') != 1 && empty($mechanic_id)){
    		return 0;
    	}

        $cond  = " BK.status IN (".$status.") ";
    	$cond .= (!empty($booking_id))?" AND BK.booking_id='".$booking_id."' ":"";
    	$cond .= (!empty($mechanic_id))?" AND BK.mechanic_id='".$mechanic_id."' ":"";

        $sql = "SELECT BK.booking_id,BK.customer_id,BK.mechanic_id,BK.customer_veh_id,BK.scheduled_date,
    				   BK.scheduled_time,BK.cost,BK.status,BK.mileage,BK.issues_selected,VEH.car_name,
    				   BK.custom_issue_data,MECH.first_name AS mechFirstName,VEH.car_model,
    				   MECH.last_name AS mechLastName,VEH.car_maker,VEH.car_model_year,VEH.car_vin,
    				   VEH.vehicle_data,VEH.car_location,VEH.car_loc_lat,VEH.car_loc_lng,
    				   CUST.first_name AS custFirstName,CUST.last_name AS custLastName,CUST.phone,
    				   CUST.email,CUST.address,CUST.profile_image,CUST.date_of_birth,CUSQTE.custom_id
			    FROM bookings AS BK
			    INNER JOIN mechanic AS MECH ON (MECH.mechanic_id=BK.mechanic_id)
			    INNER JOIN customers AS CUST ON (CUST.customer_id=BK.customer_id)
			    INNER JOIN admin_users AS ADM ON (ADM.id=BK.mechanic_id)
			    INNER JOIN customer_vehicle AS VEH ON (VEH.customer_veh_id=BK.customer_veh_id)
          LEFT JOIN custom_quote AS CUSQTE on (CUSQTE.booking_id = BK.booking_id)
			    WHERE $cond AND ADM.status='1' AND CUST.status='1' 
			    GROUP BY BK.booking_id";

	    $bookData = $this->db->query($sql);
	    if(!empty($bookData)){
	    	$bookData = (!empty($booking_id))?$bookData->row():$bookData->result();
	    	return $bookData;
	    }
	    return 0;
    }

    function changeStatus($booking_id = '', $status = '0'){
 		if(empty($booking_id)){
 			return 0;
 		}
 		$status=$this->db->update('bookings',array('status'=>$status),array('booking_id'=>$booking_id));
 		return $status;
    }

    function insertCustomQuote($data){
    	$custData = array();$total=0;
    	$book_id = decode_param($data['booking_id']);
    	unset($data['booking_id']);
    	for($i=0 ; $i < count($data['description']);$i++){
    		$custData[$i]['issue_id']=$data['issue_id'][$i];
    		$custData[$i]['sub_issue_id']=$data['sub_issue_id'][$i];
    		$custData[$i]['description']=$data['description'][$i];
    		$custData[$i]['amount']=$data['amount'][$i];
    		$total += $data['amount'][$i];
    	}
    	$book_data = $this->db->get_where('custom_quote',array('booking_id'=>$book_id));

    	if(!empty($book_data) && $book_data->num_rows() > 0){
    		$this->db->update('custom_quote',array('custom_service_quote'=>json_encode($custData),'custom_amount'=>$total),array('booking_id'=>$book_id));
    		$res = array('status'=>'success');
    	}else{
    		if($this->db->insert('custom_quote',array('booking_id'=>$book_id,'custom_service_quote'=>json_encode($custData),'custom_amount'=>$total))){
          $last_id = $this->db->insert_id();
	    		$res = array('status'=>'success','data'=>encode_param($last_id));
	    	}
    	}
    	return $res;
    }

    public function getCustomData($customid){
      $this->db->select('custom_quote.custom_service_quote,custom_quote.custom_amount,bookings.issues_selected');
      $this->db->join('bookings','bookings.booking_id = custom_quote.booking_id');
      $this->db->where('custom_quote.custom_id',$customid);
      $custData = $this->db->get('custom_quote');

      if(!empty($custData) && $custData->num_rows() > 0){
        $custData = $custData->row_array();
        return $custData;
      }
      return 0;
    }
}
?>
