<div class="content-wrapper">
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-sm-12">
        <?php if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
           <button class="close" data-dismiss="alert" type="button">×</button>
           <?= $flashdata['message'] ?>
         </div>
       <?php } ?>
      </div>
    
      <?php if($this->session->userdata['user_type'] == 1 && !empty($mechanic_data)){ ?>
        <div class="col-sm-12">
          <div class="box box-warning">
            <div class="box-header with-border">
              <div class="col-md-6">
                <h3 class="box-title">Booking Management</h3>
              </div>
            </div>
            <div class="box-body">
              <form id="chooseMechForm" role="form" action="<?=base_url('Bookings/listBookings')?>" 
                method="post" class="validate" data-parsley-validate="" enctype="multipart/form-data">
                <div class="col-sm-12">
                  <div class="form-group">
                    <label>Choose a Mechanic</label>
                    <select name="mechanic_id" class="form-control required" data-parsley-trigger="change" 
                    onchange="changeMechanic()" dmClick="0" required>
                    <?php if($this->session->userdata['user_type'] == 1){?>
                        <option>View All</option>
                      <?php }else{ ?>
                          <option selected disabled>Select Mechanic</option>
                      <?php }
                        if(!empty($mechanic_data)){
                          foreach ($mechanic_data as $mechanic) {
                            $chkFlg = ($mechanic_id == $mechanic->mechanic_id)?'selected':'';
                            echo '<option value="'.encode_param($mechanic->mechanic_id).'" '.$chkFlg.'>
                                  '.$mechanic->first_name.' '.$mechanic->last_name.
                                '</option>';
                          } 
                        }
                      ?>
                    </select> 
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
        <?php  }
        if($this->session->userdata['user_type'] != 1 || ($this->session->userdata['user_type'] == 1 && !empty($mechanic_id))){ ?>
        <div class="col-xs-12">
          <div class="box box-warning">     
            <div class="box-body">
              <table id="mechanicUsers" class="table table-bordered table-striped datatable ">
                <thead>
                  <tr>
                    <th class="hidden">ID</th>
                    <th width="18%;">Car Name</th>
                    <th width="12%;">Mechanic</th>
                    <th width="12%;">Customer</th>
                    <th width="15%;">Scheduled Date</th>
                    <th width="11%;">Service Fee</th>
                    <th width="7%;">Status</th>
                    <th width="26%;">Action</th>
                 </tr>
                </thead> 
                <tbody>
                  <?php if(!empty($bookingData)){
                    $mapIssueData = $bookingData;
                    foreach($bookingData as $bookData) { ?>
                      <tr>
                        <th class="hidden"><?= $bookData->booking_id ?></th>
                        <th class="center"><?= $bookData->car_name ?></th>
                        <th class="center"><?= $bookData->mechFirstName.' '.$bookData->mechLastName ?></th>
                        <th class="center"><?= $bookData->custFirstName.' '.$bookData->custLastName ?></th>
                        <th class="center">
                          <?= $bookData->scheduled_date.' '.$bookData->scheduled_time ?>
                        </th>
                        <th class="center"><?= $bookData->cost ?></th>
                        <th class="center">
                          <?php
                            switch($bookData->status){
                              case 0: echo 'Pending'; break;
                              case 1: echo 'Accepted'; break;
                              case 3: echo 'Completed'; break;
                              case 4: echo 'Cancelled'; break;
                            }
                          ?>
                        </th>
                        <td class="center float-right">
                          <button class="btn btn-sm btn-primary" booking_id="<?= encode_param($bookData->booking_id) ?>" id="showBookinDetails">
                            <i class="fa fa-fw fa-edit"></i>View Quote
                          </button> 
                          <?php if($bookData->status == 1){ ?>
                            <a class="btn btn-sm btn-success" style="background-color:#ac2925" href="<?= base_url("Bookings/changeBookingStatus/".encode_param($bookData->booking_id)."/3/".encode_param($mechanic_id)) ?>">
                              <i class="fa fa-cog"></i> Cancel
                            </a>
                          <?php } ?>
                          <?php if($bookData->status == 0 || $bookData->status == 3){ ?>
                            <a class="btn btn-sm btn-success" href="<?= base_url("Bookings/changeBookingStatus/".encode_param($bookData->booking_id)."/1/".encode_param($mechanic_id)) ?>">
                              <i class="fa fa-cog"></i> Accept
                            </a>
                          <?php } ?>
                          <a class="btn btn-sm btn-danger" 
                              href="<?= base_url("Bookings/changeBookingStatus/".encode_param($bookData->booking_id)."/2/".encode_param($mechanic_id))?>"
                              onClick="return doconfirm()">
                            <i class="fa fa-fw fa-trash"></i>Delete
                          </a>
                          <?php if($bookData->custom_id == ''){
                            if($this->session->userdata['user_type'] != 1 ){
                            ?>
                          <button class="btn btn-sm btn-primary" style="margin-top:3px;" booking_id="<?= encode_param($bookData->booking_id) ?>" id="customQuote" view="0">
                            <i class="fa fa-fw fa-edit"></i><span>Generate Custom Quote</span>
                          </button> 
                        <?php } } else{ ?>
                         <button class="btn btn-sm btn-primary" style="margin-top:3px;" booking_id="<?= encode_param($bookData->custom_id) ?>" id="customQuote"  view="1">
                            <i class="fa fa-fw fa-edit"></i><span>View Custom Quote</span>
                          </button> 
                        <?php } ?>
                        </td>
                      </tr>
                  <?php } } ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <?php } ?>
    </div>
  </section>
</div>