<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Shop extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Shop_model');

		if(!$this->session->userdata('logged_in')) {
			redirect(base_url());
		}
	}

	public function addShop(){
		$template['page'] = 'Shop/shopForm';
        $template['menu'] = 'Shop Management';
        $template['smenu'] = 'Add Shop';
        $template['pTitle'] = "Add Shop";
        $template['pDescription'] = "Create New Shop";

        $template['shop_data'] = $this->Shop_model->getShop();
		$this->load->view('template',$template);
	}

	public function viewShops(){
		$template['page'] = 'Shop/viewShops';
        $template['menu'] = 'Shop Management';
        $template['smenu'] = 'View Shops';
        $template['pTitle'] = "View Shops";
        $template['pDescription'] = "View and Manage Shops";

        $template['shop_data'] = $this->Shop_model->getShop('',1);
		$this->load->view('template',$template);
	}

	function changeStatus($shop_id = '',$status = '1'){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($shop_id) || !is_numeric($shop_id = decode_param($shop_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Shop/viewShops'));
		}
		$status = $this->Shop_model->changeStatus($shop_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Shop/viewShops'));
	}

	public function createShop(){
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Shop/addShop'));
		}
		if($err == 0 && (!isset($_POST['shop_name']) || empty($_POST['shop_name']))){
			$err = 1;
			$errMsg = 'Provide a Shop Name';
		}else if($err == 0 && (!isset($_POST['email_id']) || empty($_POST['email_id']))){
			$err = 1;
			$errMsg = 'Provide a Email ID';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide a Phone Number';
		}else if($err == 0 && (!isset($_POST['address']) || empty($_POST['address']))){
			$err = 1;
			$errMsg = 'Provide an Address';
		}

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Shop/addShop'));
		}

        $status = $this->Shop_model->addShop($_POST);
        if($status == 1){
            $flashMsg =array('message'=>'Successfully Updated Shop Details..!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Shop/viewShops'));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Shop/addShop'));
        }
	}

	public function editShop($shop_id){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($shop_id) || !is_numeric($shop_id = decode_param($shop_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Shop/viewShops'));
		}

		$template['page'] = 'Shop/shopForm';
        $template['menu'] = 'Shop Management';
        $template['smenu'] = 'Edit Shop';
        $template['pTitle'] = "Edit Shop";
        $template['pDescription'] = "Update Shop Data";

        $template['shop_id'] = encode_param($shop_id);
        $template['shop_data'] = $this->Shop_model->getShop($shop_id,1);
		$this->load->view('template',$template);
	}

	public function updateShop($shop_id = ''){
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($shop_id) || !isset($_POST) || empty($_POST) || !is_numeric(decode_param($shop_id))){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Shop/viewShops'));
		}
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Shop/addShop'));
		}
		if($err == 0 && (!isset($_POST['shop_name']) || empty($_POST['shop_name']))){
			$err = 1;
			$errMsg = 'Provide a Shop Name';
		}else if($err == 0 && (!isset($_POST['email_id']) || empty($_POST['email_id']))){
			$err = 1;
			$errMsg = 'Provide a Email ID';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide a Phone Number';
		}else if($err == 0 && (!isset($_POST['address']) || empty($_POST['address']))){
			$err = 1;
			$errMsg = 'Provide an Address';
		}

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Shop/addShop'));
		}

        $status = $this->Shop_model->updateShop(decode_param($shop_id),$_POST);
        if($status == 1){
            $flashMsg =array('message'=>'Successfully Updated Shop Details..!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Shop/viewShops'));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Shop/editShop/'.$shop_id));
        }
	}
}
?>