<?php
defined('BASEPATH')OR exit('No direct script access allowed');
header('Content-Type: text/html; charset=utf-8');

// Allow from any origin
if(isset($_SERVER['HTTP_ORIGIN'])) {
	header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
	header('Access-Control-Allow-Credentials: true');
	header('Access-Control-Max-Age: 86400'); // cache for 1 day
}

// Access-Control headers are received during OPTIONS requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
	if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
	  header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
	if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
	  header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
	exit(0);
}

class Webservices extends CI_Controller {

	public function __construct() {
	  parent::__construct();
	  $this->load->model('Webservice_model');
	  $this->load->library('form_validation');

	  $auth = '';
	  $class = $this->router->fetch_class();
	  $method = $this->router->fetch_method();

	  if($this->input->server('REQUEST_METHOD') == 'GET')
	     $postdata = json_encode($_GET);

	  else if ($this->input->server('REQUEST_METHOD') == 'POST')
	     $postdata = file_get_contents("php://input");

	  if (isset(apache_request_headers()['Auth'])) {
	     $auth = apache_request_headers()['Auth'];
	  }
	  // $this->last_id = set_log($class, $method, $postdata, $auth);
	}

	// customer_login
	public function customer_login(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Customer_model');

	  $respArr = array('status'=>'0','message'=>'Required Fields are empty.');
	  if(!isset($postData['email']) || empty($postData['email']) || 
	     !isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
	      echo json_encode($respArr);exit;
	  }

	  $custResp = $this->Customer_model->checkCustomerLogin($postData);
	  if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '1'){
	     $respArr['data'] = $custResp['data'];
	     $respArr['status'] = '1';
	     $respArr['message'] = 'Success';
	     echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '2'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Invalid Email Address';
	     echo json_encode($respArr);exit;
	  }
	  
	  if($custResp['status'] == '3'){
	     $respArr['status'] = '3';
	     $respArr['message'] = 'Invalid Password';
	     echo json_encode($respArr);exit;
	  }
	  echo json_encode($respArr); exit;
	}

	// customer_forgot_password
	public function customer_forgot_password(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Customer_model');

	  $respArr = array('status'=>'0','message'=>'Required Fields are empty.');
	  if(empty($postData) || !isset($postData['email']) || empty($postData['email'])){
	      echo json_encode($respArr);exit;
	  }

	  $custResp = $this->Customer_model->genCustForgotPassLink($postData);
	  if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '2'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Invalid Email Address';
	     echo json_encode($respArr);exit;
	  }
	  
	  if($custResp['status'] == '1'){
	     /*
	        MAIL SENT CONFIGARATION -- TODO
	     */

	     $respArr['status'] = '1';
	     $respArr['message'] = 'Password Reset Email has been sent';
	  }
	  echo json_encode($respArr); exit;
	}

	// customer_registration
	public function customer_registration(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Customer_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData)){
	      echo json_encode($respArr);exit;
	  }

	  $err = 0;
	  $msg = '';
	  if(!isset($postData['email']) || empty($postData['email'])){
	     $err = 1;
	     $msg = 'Provide a valid Email ID';
	  } 
	  else if(!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
	     $err = 1;
	     $msg = 'Provide a Password';
	  }
	  else if(!isset($postData['first_name']) || empty($postData['first_name'])){
	     $err = 1;
	     $msg = 'Provide valid Name';
	  }
	  else if(!isset($postData['last_name']) || empty($postData['last_name'])){
	     $err = 1;
	     $msg = 'Provide valid Name';
	  }

	  if($err == 1){
	     $respArr['message'] = $msg;
	     echo json_encode($respArr);exit;
	  }
	  
	  if(isset($postData['phone']) && empty($postData['phone'])){
	     unset($postData['phone']);
	  }
	  unset($postData['promocode']);

	  $custResp = $this->Customer_model->createCustomer($postData);
	  if(empty($custResp)){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp == '1'){
	     $custResp = $this->Customer_model->checkCustomerLogin($postData);

	     if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
	         echo json_encode($respArr);exit;
	     }

	     if($custResp['status'] == '1'){
	        $respArr['data'] = $custResp['data'];
	        $respArr['status'] = '1';
	        $respArr['message'] = 'Success';
	        echo json_encode($respArr);exit;
	     }
	  } else if($custResp == '2'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Email Address already in use';
	     echo json_encode($respArr);exit;
	  } else if($custResp == '3'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Phone already in use';
	     echo json_encode($respArr);exit;
	  }

	  
	  echo json_encode($respArr); exit;
	}

	// getGeneralIssues
	public function getGeneralIssues(){
	  header('Content-type: application/json');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  $this->load->model('Issue_model');
	  $issue_data = $this->Issue_model->getGeneralIssues();

	  if(!empty($issue_data)){
	     $respArr['status'] = '1';
	     $respArr['message'] = 'Success';
	     $respArr['issue_data'] = $issue_data;
	  }
	  
	  echo json_encode($respArr); exit;
	}

	// getNearByMechanics
	public function getNearByMechanics(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Mechanic_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  pr($postData);
	  if(empty($postData) || !isset($postData['pickup_data']) || !isset($postData['sub_issues']) || 
	  	 empty($postData['pickup_data']) || empty($postData['sub_issues']) ){
	  	echo json_encode($respArr); exit;
	  }

	  $mechanic_data = $this->Mechanic_model->getNearByMechanics($postData['pickup_data'],$postData['sub_issues']);

	  if(!empty($mechanic_data)){
	     $respArr['status'] = '1';
	     $respArr['message'] = 'Success';
	     $respArr['mechanic_data'] = $mechanic_data;
	  }
	  echo json_encode($respArr); exit;
	}

	// scheduleNow
	public function scheduleNow(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');

	  if(empty($postData)){
	  	echo json_encode($respArr); exit;
	  }
	  $this->load->model('Booking_model');
	  $status = $this->Booking_model->scheduleBooking($postData);
	  if($status){
	  	$respArr['status'] = '1';
	    $respArr['message'] = 'Success';
	  }
	  echo json_encode($respArr); exit;
	}

	// edit_customer_profile
	public function edit_customer_profile(){
	  header('Content-type: application/json');

	  $postData = $_POST;
	  $this->load->model('Customer_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData) || empty($postData = json_decode($postData['data'],true)) || 
	  	!isset($postData['customer_id']) || empty($postData['customer_id'])){
	      echo json_encode($respArr);exit;
	  }

	  $err = 0;
	  $msg = '';
	  if(!isset($postData['email']) || empty($postData['email'])){
	     $err = 1;
	     $msg = 'Provide a valid Email ID';
	  }
	  else if(!isset($postData['first_name']) || empty($postData['first_name'])){
	     $err = 1;
	     $msg = 'Provide valid Name';
	  }
	  else if(!isset($postData['last_name']) || empty($postData['last_name'])){
	     $err = 1;
	     $msg = 'Provide valid Name';
	  }
	  else if(!isset($postData['phone']) || empty($postData['phone'])){
	     $err = 1;
	     $msg = 'Provide valid Phone';
	  }
	  else if(!isset($postData['address']) || empty($postData['address'])){
	     $err = 1;
	     $msg = 'Provide valid Address';
	  }

	  if($err == 1){
	     $respArr['message'] = $msg;
	     echo json_encode($respArr);exit;
	  }

	  if(isset($_FILES) && !empty($_FILES) && 
		 isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])){
		$config = set_upload_service("assets/uploads/services");
		$this->load->library('upload');
		$config['file_name'] = $postData['customer_id']."_".$_FILES['profile_image']['name'];
		$this->upload->initialize($config);
		if($this->upload->do_upload('profile_image')){
			$upload_data = $this->upload->data();
			$postData['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
		}
	  }

	  $customer_id = $postData['customer_id'];
	  if(isset($postData['password']) && !empty($postData['password']) && 
		 isset($postData['cpassword']) && !empty($postData['cpassword']) && 
		 $postData['password'] == $postData['cpassword']){
	     $postData['password'] = md5($postData['password']);
	  } else {
	  	unset($postData['password']);
	  }
	  unset($postData['cpassword']);
	  unset($postData['customer_id']);
	  
	  $custResp = $this->Customer_model->updateCustomer($customer_id,$postData);
	  if(empty($custResp)){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp == '1'){
	     $respArr['status'] = '1';
	     $respArr['message'] = 'Profile successfully updated';
	     $respArr['profile_image'] = $postData['profile_image'];
	     echo json_encode($respArr);exit;
	  } else if($custResp == '2'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Email Address already in use';
	     echo json_encode($respArr);exit;
	  } else if($custResp == '3'){
	     $respArr['status'] = '3';
	     $respArr['message'] = 'Phone Number already in use';
	     echo json_encode($respArr);exit;
	  }

	  echo json_encode($respArr); exit;
	}

	// customerVechiles
	function customerVechiles(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Vehicle_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
	      echo json_encode($respArr);exit;
	  }

	  $vehData = $this->Vehicle_model->getCustVechiles($postData);
	  if($vehData != '0'){
	  	$respArr['status'] = 1;
	  	$respArr['message'] = 'success';
	  	$respArr['vehData'] = $vehData;
	  }
	  echo json_encode($respArr);exit;
	}

	// getCustBookDetails
	function getCustBookDetails(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Booking_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
	    echo json_encode($respArr);exit;
	  }

	  $status = (isset($postData['status']) && !empty($postData['status']))?$postData['status']:'';
	  $bookingDetails = $this->Booking_model->getCustBookDetails($postData,$status);
	  if($bookingDetails != '0'){
	  	$respArr['status'] = 1;
	  	$respArr['message'] = 'success';
	  	$respArr['bookData'] = $bookingDetails;
	  }
	  echo json_encode($respArr);exit;
	}

	// cancelBooking
	function cancelBooking(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Booking_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id']) || 
	  	!isset($postData['booking_id']) || empty($postData['booking_id'])){
	    echo json_encode($respArr);exit;
	  }

	  $status=$this->Booking_model->changeBookStatus($postData['customer_id'],$postData['booking_id'],'3');
	  
	  if($status){
	  	$respArr['status'] = 1;
	  	$respArr['message'] = 'success';
	  }
	  echo json_encode($respArr);exit;
	}

	// deleteCustomerCar
	function deleteCustomerCar(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Vehicle_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id']) || 
	  	!isset($postData['customer_veh_id']) || empty($postData['customer_veh_id'])){
	    echo json_encode($respArr);exit;
	  }

	  $status = $this->Vehicle_model->changeCustomerCarStatus($postData['customer_id'],
	  												   $postData['customer_veh_id'],'2');
	  
	  if($status){
	  	$respArr['status'] = 1;
	  	$respArr['message'] = 'success';
	  }
	  echo json_encode($respArr);exit;
	}

	// addCustomerCar
	function addCustomerCar(){
		header('Content-type: application/json');
		$post = file_get_contents("php://input");
		$postData = json_decode($post, true);
		$this->load->model('Vehicle_model');

		$respArr = array('status'=>'0','message'=>'Something went wrong.');
		if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
            echo json_encode($respArr);exit;
        }

        $param = "";
        $searchType = $postData['type'];
        $searchData = $postData['vehicleData'];
        $locationData = $postData['location'];

        $vehicle_data['status'] = '1';
        $vehicle_data['customer_id'] = $postData['customer_id'];
        $vehicle_data['car_loc_lat'] = $locationData['location_lat'];
        $vehicle_data['car_loc_lng'] = $locationData['location_lng'];
        $vehicle_data['car_location'] = $locationData['location'];

        $this->load->model('Settings_model');
        $settings = $this->Settings_model->settings_viewing();

        $searchData = $postData['vehicleData'];
        if($searchType == 1 && 
           isset($searchData['car_maker']) && !empty($searchData['car_maker']) && 
    	   isset($searchData['modelName']) && !empty($searchData['modelName']) && 
    	   isset($searchData['modelYear']) && !empty($searchData['modelYear'])){
            $vehicle_data['car_maker'] = $searchData['car_maker'];
            $vehicle_data['car_model'] = $searchData['modelName'];
            $vehicle_data['car_model_year'] = $searchData['modelYear'];

            $param = "?format=json&key=".urlencode($settings['vin_audit_api'])."&year=".
                      urlencode($searchData['modelYear'])."&make=".urlencode($searchData['car_maker']).
                      "&model=".urlencode($searchData['modelName']);
        }
        else if($searchType == 2 && isset($searchData['vin']) && !empty($searchData['vin'])){
            $vehicle_data['car_vin'] = $searchData['vin'];

            $param = "?format=json&key=".urlencode($settings['vin_audit_api']).
                     "&vin=".urlencode($searchData['vin']);
        }

        if(!empty($param)){
            $vehData=file_get_contents("https://specifications.vinaudit.com/getspecifications.php".$param);
            if(empty($vehData) || empty($vehData = json_decode($vehData,true))){
                echo json_encode($return_arr);exit;
            }

            if(!isset($vehData['success']) || empty($vehData['success']) || $vehData['success'] == false){
                $return_arr['status'] = 2;
                $return_arr['message'] = 'No Data Found.';
                echo json_encode($return_arr);exit;
            }

            if($searchType == 2){
            	$vehicle_data['car_model'] = $vehData['attributes']['Model'];
            	$vehicle_data['car_maker'] = $vehData['attributes']['Make'];
            	$vehicle_data['car_model_year'] = $vehData['attributes']['Year'];
                $vehData['vehicle']= $vehData['attributes']['Year'].' '.$vehData['attributes']['Make'].' '.
                                     $vehData['attributes']['Model'].' '.$vehData['attributes']['Trim'];
            }

            $vehicle_data['car_name'] = $vehData['vehicle'];
            $vehicle_data['vehicle_data'] = json_encode($vehData);

            $car_id = $this->Vehicle_model->addVehicle($vehicle_data);
            if(!empty($car_id)){
                $return_arr['status'] = '1';
                $return_arr['car_id'] = $car_id;
                $return_arr['veh_data'] = $vehData;
            }
        }
        echo json_encode($return_arr);exit;
	}
}
?>