<?php 
class Booking_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
 	}

 	public function scheduleBooking($postData = array()){
      	if(empty($postData)){
        	return 0;
      	}
		$vehData = $postData['vechile_info'];
		$car_name = $vehData['modelYear'].' '.$vehData['maker'].' '.$vehData['modelName'];

      	$vehJson = array('vehicle' => $car_name,
                         'attributes' => 
							array(
								'Year'      => $vehData['modelYear'],
								'Make'      => $vehData['maker'],
								'Trim'      => $vehData['trim'],
								'Model'     => $vehData['modelName'],
								'Engine'    => $vehData['emgine']
							));

      	$insert_array = array(
	  						'customer_id'   => $postData['customer_id'],
	                        'car_name'      => $car_name,
	                        'car_model'     => $vehData['modelName'],
	                        'car_maker'     => $vehData['maker'],
	                        'car_loc_lat'   => $postData['pickup_data']['pickup_lat'],
	                        'car_loc_lng'   => $postData['pickup_data']['pickup_lng'],
	                        'car_location'  => $postData['pickup_data']['pickup_loc'],
	                        'vehicle_data'  => json_encode($vehJson),
	                        'car_model_year'=> $vehData['modelYear'],
	                        'status'        => '3');

		if($this->db->insert('customer_vehicle',$insert_array)){
			$last_id = $this->db->insert_id();

			$book_data = array(
								'customer_veh_id'  => $last_id,
								'customer_id'      => $postData['customer_id'],
								'mechanic_id'      => $postData['mechanic_id'],
								'scheduled_date'   => $postData['schedule_date']['date'],
								'scheduled_time'   => $postData['schedule_date']['time'],
								'mileage'          => $vehData['milage'],
								'status'           => '0');

			if($this->db->insert('bookings',$book_data)){
			  	return 1;
			}
		}
      	return 0;
    }

    function getCustBookDetails($postData = array(), $status = ''){
        $cond = array();
        if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
        	return 0;
        }
    	$cond  = "BK.customer_id='".$postData['customer_id']."' ";
        $cond .= (!empty($status))?"AND BK.status IN (".$status.") ":'';

    	$sql = "SELECT BK.booking_id,BK.customer_id,BK.mechanic_id,BK.customer_veh_id,BK.scheduled_date,
    				   BK.scheduled_time,BK.cost,BK.status,MECH.first_name,MECH.last_name,VEH.car_name,
    				   BK.status
			    FROM bookings AS BK
			    INNER JOIN mechanic AS MECH ON (MECH.mechanic_id AND BK.mechanic_id)
			    INNER JOIN customer_vehicle AS VEH ON (VEH.customer_veh_id AND BK.customer_veh_id)
			    WHERE $cond 
			    GROUP BY BK.booking_id";

	    $bookData = $this->db->query($sql);

	    if(!empty($bookData)){
	    	return $bookData->result();
	    }
	    return 0;
    }

    function changeBookStatus($customer_id = '', $booking_id = '', $status = ''){
    	if(empty($customer_id) || empty($booking_id) || $status == ''){
    		return 0;
    	}

    	$status = $this->db->update('bookings',
    									array('status'=>$status),
									    array('customer_id'=>$customer_id,'booking_id'=>$booking_id));

    	return $status;
    }
}
?>