jQuery(document).ready(function(){
    jQuery('<div class="overlay"></div>').insertBefore(".content-wrapper");
});

function setImg(input,id) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();

        reader.onload = function (e) {
            $('#'+id).attr('src', e.target.result);
        };
        reader.readAsDataURL(input.files[0]);
    }
}

function setModal(header_msg,body_msg){
    jQuery('[id="modal_body_msg"]').html(body_msg);
    jQuery('[id="modal_header_msg"]').html(header_msg);
    jQuery('[id="errModal"]').modal('show');
}

function slideTo(id){
    jQuery('html, body').animate({
        scrollTop: jQuery('[id="'+id+'"]').offset().top
    }, 800);
}

function modalTrigger(header,body_html){
    jQuery('[id="modal_content"]').html(body_html);
    jQuery('[id="modal_header"]').html(header);

    jQuery('[id="popup_modal"]').modal('show');
}

function modalHide(){
    jQuery('[id="popup_modal"]').modal('hide');
}

function addModalLoader(){
    jQuery("[id='modal_content']").addClass('relative height_200');
    jQuery("[id='modal_content']").prepend("<div id='modal_loader_body' class='loader'></div>");
}

function remModalLoader(){
    jQuery("[id='modal_loader_body']").remove();
    jQuery("[id='modal_content']").removeClass('relative height_200');
}

function showFullScreenLoader(){
    var thisObj = jQuery('.overlay');
    thisObj.css("display",'block');

    thisObj.addClass('relative');
    thisObj.prepend("<div id='fullScreenLoaderBody' class='loader'></div>");
}

function remFullScreenLoader(){
    var thisObj = jQuery('.overlay');
    thisObj.css("display",'none');

    jQuery('[id="fullScreenLoaderBody"]').remove();
    thisObj.removeClass('relative');
}

function viewImageModal(title,img_src){
	if(title=='' || title==undefined || title=='undefined' || title==null || title=='null'||
	   img_src=='' || img_src==undefined || img_src=='undefined' || img_src==null || img_src=='null'){
		return false;
	}
	body_html = '<div style="text-align:center">'+
				  '<img src="'+img_src+'" onerror="this.src=\''+base_url+'assets/images/no_image.png\';" height="400px" width="auto">'+
   		  		'</div>';
	modalTrigger(title,body_html);
}

function initLocSearch_1() {
 var input = document.getElementById('loc_search_1');
 var options = {componentRestrictions: {country: country_flag}};
 var autocomplete = new google.maps.places.Autocomplete(input, options);
}
google.maps.event.addDomListener(window,'load',initLocSearch_1);
function initLocSearch_2() {
 var input = document.getElementById('loc_search_2');
 var options = {componentRestrictions: {country: country_flag}};
 var autocomplete = new google.maps.places.Autocomplete(input, options);
}
google.maps.event.addDomListener(window,'load',initLocSearch_2);
function initLocSearch_3() {
 var input = document.getElementById('loc_search_3');
 var options = {componentRestrictions: {country: country_flag}};
 var autocomplete = new google.maps.places.Autocomplete(input, options);
}
google.maps.event.addDomListener(window,'load',initLocSearch_3);

jQuery('[id="viewMechanic"]').on('click',function() {
    var mechanic_id = jQuery(this).attr('mechanic_id');

    if(mechanic_id=='' || mechanic_id==undefined || mechanic_id=='undefined' || mechanic_id==null || mechanic_id=='null'){
        return true;
    }
    modalTrigger('Mechanic Details','');
    addModalLoader();
    jQuery.ajax({
        url  : base_url+"Mechanic/getMechanicData", 
        type : 'POST',
        data : {'mechanic_id':mechanic_id,'view_all':'1'},
        success: function(resp){
            if(resp == '' || resp == undefined || resp == 'undefined' || resp == null || resp == 'null'){
                remModalLoader();
                jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
                return false;
            }
            var resp_data = jQuery.parseJSON(resp);
            if(resp_data['status'] == '0'){
                remModalLoader();
                jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
                return false;
            }
            var mechanic_data = resp_data['data'];
            jQuery.each(mechanic_data, function (index, value) {
                if(value == '' || value == null || value == undefined || value == 'null' || value == 'undefined'){
                    mechanic_data[index] = ' -- ';
                }
            });

            var shopHtml = '';
            if(mechanic_data['shop_id'] != 0){
                shopHtml = '<br><div class="row"><label>Shop Details</label></div>'+
                            '<div class="row">'+
                              '<div class="col-md-4">Shop Name</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['shop_name']+'</label></div>'+
                            '</div>'+
                            '<div class="row">'+
                              '<div class="col-md-4">Shop Phone</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['shop_phone']+'</label></div>'+
                            '</div>'+
                            '<div class="row">'+
                              '<div class="col-md-4">Shop Email</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['shop_email']+'</label></div>'+
                            '</div>'+
                            '<div class="row">'+
                              '<div class="col-md-4">Shop Address</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['shop_address']+'</label></div>'+
                            '</div>';
            }

            var html = '<div class="col-xs-12">'+
                          '<div class="col-md-2">'+
                            '<div class="row">'+
                              '<img  id="driverProfileImg" src="'+base_url+mechanic_data['profile_image']+'" height="100" width="100" />'+
                            '</div>'+
                          '</div>'+
                          '<div class="col-md-5">'+
                            '<div class="row"><label>Basic Details</label></div>'+
                            '<div class="row">'+
                              '<div class="col-md-4">Display Name</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+ mechanic_data['display_name']+'</label></div>'+
                            '</div> '+
                            '<div class="row">'+
                              '<div class="col-md-4">User Name</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+ mechanic_data['username']+'</label></div>'+
                            '</div> '+
                            '<div class="row">'+
                              '<div class="col-md-4">First Name</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['first_name']+'</label></div>'+
                            '</div> '+
                            '<div class="row">'+
                              '<div class="col-md-4">Last Name</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['last_name']+'</label></div>'+
                            '</div> '+
                            '<div class="row"> '+
                              '<div class="col-md-4">Email ID</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['email_id']+'</label></div>'+
                            '</div> '+
                            '<div class="row"> '+
                              '<div class="col-md-4">Phone</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['phone']+'</label></div> '+
                            '</div> '+
                            '<div class="row"> '+
                              '<div class="col-md-4">Address</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['address']+'</label></div> '+
                            '</div> '+
                            '<div class="row"> '+
                              '<div class="col-md-4">City</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['city']+'</label></div> '+
                            '</div> '+
                            '<div class="row"> '+
                              '<div class="col-md-4">State</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['state']+'</label></div> '+
                            '</div> '+
                            '<div class="row"> '+
                              '<div class="col-md-4">Working Hours</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6">'+
                                '<label>'+
                                  mechanic_data['start_time']+' - '+mechanic_data['end_time']+
                                '</label>'+
                              '</div> '+
                            '</div> '+
                            '<div class="row"> '+
                              '<div class="col-md-4">Location</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['location']+'</label></div> '+
                            '</div> '+
                            shopHtml+
                          '</div> '+
                          '<div class="col-md-5"> '+
                            '<div class="row"><label>Licence Details</label></div>'+
                            '<div class="row"> '+
                              '<div class="col-md-4">Licence No.</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['licence_number']+' </label></div>'+
                            '</div> '+
                            '<div class="row"> '+
                              '<div class="col-md-4">Licence Expiry</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-6"><label>'+mechanic_data['licence_exp_date']+'</label></div>'+
                            '</div> '+
                            '<div class="row"> '+
                              '<div class="col-md-4">Licence Proof</div>'+
                              '<div class="col-md-1">:</div>'+
                              '<div class="col-md-5" style="text-align:center;"> '+
                                '<img id="driverLicenceImg" src="'+base_url+mechanic_data['licence']+'"'+
                                  'style="margin-top:10px;max-width:205px;height:auto;max-height:130px;" />'+
                              '</div> '+
                            '</div> '+
                          '</div> '+
                        '</div>';

                remModalLoader();
                jQuery('[id="modal_content"]').html(html);

                jQuery('[id="driverLicenceImg"]').error(function() {
                    jQuery('[id="driverLicenceImg"]').attr('src',base_url+'assets/images/no_image.png');
                });

                jQuery('[id="driverProfileImg"]').error(function() {
                    jQuery('[id="driverProfileImg"]').attr('src',base_url+'assets/images/user_avatar.jpg');
                });

            },
            fail: function(xhr, textStatus, errorThrown){
                remModalLoader();
                jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
            },
            error: function (ajaxContext) {
                remModalLoader();
                jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
        }
    });
});

function changeMechanic(){
    jQuery('[id="chooseMechForm"]').submit();
}

jQuery('[id="viewCustomer"]').on('click',function() {
  customer_id = jQuery(this).attr('customer_id');

  if(customer_id=='' || customer_id==undefined || customer_id=='undefined' || customer_id==null || customer_id=='null'){
    return true;
  }
  modalTrigger('Customer Details','');
  addModalLoader();
  jQuery.ajax({
    url  : base_url+"Customer/getCustomerData", 
    type : 'POST',
    data : {'customer_id':customer_id},
    success: function(resp){
      if(resp == '' || resp == undefined || resp == 'undefined' || resp == null || resp == 'null'){
        remModalLoader();
        jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
        return false;
      }
      var resp_data = jQuery.parseJSON(resp);
      if(resp_data['status'] == '0'){
        remModalLoader();
        jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
        return false;
      }
      var customer_data = resp_data['customer_data'], html = '', veh_html = '',
          vehicle_data = resp_data['customer_data']['vehicle_data'];

      if(vehicle_data != '' && vehicle_data != undefined && vehicle_data != 'undefined' && vehicle_data != null && vehicle_data != 'null'){

        jQuery.each(vehicle_data, function (index, value) {
          veh_html += '<span class="vechile-body disp-block marginBottom-5">'+
                        '<i class="fa fa-fw fa-car padRight-8p"></i>'
                          +value['car_name']+
                      '</span>';
        });
        if(veh_html != ''){
          veh_html =  '<div class="col-xs-12"><div class="col-xs-2"></div><div class="col-xs-9">'+
                      '<label>Vehicles Added</label>'+veh_html+'</div></div>';
        }
      }

      html = '<div class="col-xs-12">'+
              '<div class="col-md-2"> '+
                '<div class="form-group has-feedback"> '+
                  '<img id="customerProfileImg" src="'+base_url+customer_data['profile_image']+'"'+
                    'height="100" width="100" /> '+
                '</div> '+
              '</div> '+
              '<div class="col-md-5"> '+
                '<div class="form-group has-feedback"> '+
                  '<span style="padding-right: 38px;">First Name </span> : '+
                  '<label style="padding-left: 10px;">'+
                    customer_data['first_name']+
                  '</label> '+
                '</div> '+
                '<div class="form-group has-feedback"> '+
                  '<span style="padding-right: 68px;">Email </span> : '+
                  '<label style="padding-left: 10px;">'+
                    customer_data['email']+
                  '</label> '+
                '</div> '+
                '<div class="form-group has-feedback"> '+
                  '<span style="padding-right: 55px;">Address </span> : '+
                  '<label style="padding-left: 10px;">'+
                    customer_data['address']+
                  '</label> '+
                '</div> '+
              '</div> '+
              '<div class="col-md-5"> '+
                '<div class="form-group has-feedback"> '+
                  '<span style="padding-right: 56px;">Last Name </span> : '+
                  '<label style="padding-left: 10px;">'+
                    customer_data['last_name']+
                  '</label> '+
                '</div> '+
                '<div class="form-group has-feedback"> '+
                  '<span style="padding-right: 80px;">Phone </span> : '+
                  '<label style="padding-left: 10px;">'+
                    customer_data['phone']+
                  '</label> '+
                '</div> '+
                '<div class="form-group has-feedback"> '+
                  '<span style="padding-right: 43px;">Date Of Dirth </span> : '+
                  '<label style="padding-left: 10px;">'+
                    customer_data['date_of_birth']+
                  '</label> '+
                '</div> '+
              '</div> '+
            '</div>'+veh_html;

      remModalLoader();
      jQuery('[id="modal_content"]').html(html);

      jQuery('[id="customerProfileImg"]').error(function() {
        jQuery('[id="customerProfileImg"]').attr('src',base_url+'assets/images/user_avatar.jpg');
      });

    },
    fail: function(xhr, textStatus, errorThrown){
      remModalLoader();
      jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
    },
    error: function (ajaxContext) {
      remModalLoader();
      jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
    }
  });
});

jQuery('[name="search_key_type"]').on('change',function() {
    var searchTypId = jQuery(this).val(); 
    if(searchTypId == '' || searchTypId == null || searchTypId == 'null' || searchTypId == undefined || searchTypId == 'undefined'){
        return false;
    }
    jQuery('[id^="searchTyp_"]').addClass('hide');
    jQuery('[id="searchTyp_'+searchTypId+'"]').removeClass('hide');

    jQuery('[id^="searchTyp_"]').find('[input="search_params"]').each(function (index,element) {
        jQuery(this).val('');
        jQuery(this).removeAttr('required');
        jQuery(this).removeClass('required');
    });

    jQuery('[id="searchTyp_'+searchTypId+'"]').find('[input="search_params"]').each(function (index,element) {
        jQuery(this).attr('required','');
        jQuery(this).addClass('required');
    });
});

jQuery('[id="createCustomerSubmit"]').on('click',function() {
  jQuery('[id="createCustomerForm"]').submit();
});

jQuery('[id="vehSearch"]').on('click',function(event) {
  event.preventDefault();
  if(!jQuery('[id="CarSearchForm"]').parsley().validate()){
    return false;
  }
  var searchTypId = jQuery('input[name=search_key_type]:checked').val(),
      passArr = {'searchType':'','vehModel':'','vehMaker':'','vehYear':'','vehVin':''};

  if(searchTypId == '' || searchTypId == null || searchTypId == 'null' || searchTypId == undefined || searchTypId == 'undefined'){
      modalTrigger('Vechile Search Failed','Vechile Search Failed, Provide proper data and try again..!');
      return false;
  }
  var vehVin = jQuery('[name="vehVin"]').val(),
      vehYear = jQuery('[name="vehYear"]').val(),
      vehModel = jQuery('[name="vehModel"]').val(),
      vehMaker = jQuery('[name="vehMaker"]').val();
      vehLocVin = jQuery('[name="vehLocationVin"]').val();
      vehLocDetls = jQuery('[name="vehLocationDetails"]').val();

  if((searchTypId == 1 && (vehLocDetls == '' || vehLocDetls == null || vehLocDetls == 'null' || vehLocDetls == undefined || vehLocDetls == 'undefined') && 
        (vehYear == '' || vehYear == null || vehYear == 'null' || vehYear == undefined || vehYear == 'undefined' || 
         vehModel == '' || vehModel == null || vehModel == 'null' || vehModel == undefined || vehModel == 'undefined' || 
         vehMaker == '' || vehMaker == null || vehMaker == 'null' || vehMaker == undefined || vehMaker == 'undefined')
     ) || 
     (searchTypId == 2 && (vehLocVin == '' || vehLocVin == null || vehLocVin == 'null' || vehLocVin == undefined || vehLocVin == 'undefined') &&
        (vehVin == '' || vehVin == null || vehVin == 'null' || vehVin == undefined || vehVin == 'undefined')
     )){
    return false;
  }
  showFullScreenLoader();

  passArr.vehVin = vehVin;
  passArr.vehYear = vehYear;
  passArr.vehModel = vehModel;
  passArr.vehMaker = vehMaker;
  passArr.searchType = searchTypId;
  passArr.vehLocation = (searchTypId == 1)?vehLocDetls:vehLocVin;

  jQuery.ajax({
    url  : base_url+"Vehicle/vehicleSearch", 
    type : 'POST',
    data : passArr,
    success: function(resp){
      if(resp == '' || resp == undefined || resp == 'undefined' || resp == null || resp == 'null'){
        remFullScreenLoader();
        setModal('Vechile Search','Something went wrong, please try again later...!');
        return false;
      }
      var resp_data = jQuery.parseJSON(resp);
      if(resp_data['status'] != '1' || (resp_data['status'] == 1 && resp_data['veh_data'] == '' || resp_data['veh_data'] == null || resp_data['veh_data'] == undefined || resp_data['veh_data'] == 'null' || resp_data['veh_data'] == 'undefined' || resp_data['car_id'] == '' || resp_data['car_id'] == null || resp_data['car_id'] == undefined || resp_data['car_id'] == 'null' || resp_data['car_id'] == 'undefined')){
        var msg = 'Something went wrong, please try again later...!';
        if(resp_data['status'] == '2')
          msg = 'No Data Found, Try again with proper search parameters..!';
        if(resp_data['status'] == '3')
          msg = 'Provide a valid Location..!';
        remFullScreenLoader();
        setModal('Vechile Search',msg);
        return false;
      }
      var vehHtmlBody = '', car_id = resp_data['car_id'], vehicleData = resp_data['veh_data'];
      vehHtmlBody = '<span class="vechile-body disp-block marginBottom-10">'
                      +vehicleData['vehicle']+
                      '<div onclick="searchAction('+car_id+',3,0,\''+vehicleData['vehicle']+'\');" class="float-right">'+
                        '<i class="fa fa-fw fa-close cpoint"></i>'+
                      '</div>'+
                    '</span>';
      jQuery.each(vehicleData['attributes'], function (index, value) {
        if(value == '' || value == undefined || value == 'undefined' || value == null || value == 'null'){
          return true;
        }
          vehHtmlBody += '<div class="col-xs-4">'+
                           '<div class="col-xs-6"><span class="info-box-text">'+index+'</span></div>'+
                           '<div class="col-xs-6"><span class="info-box-text">'+value+'</span></div>'+
                         '</div>';
      });
      vehHtmlBody += '<div class="col-md-12">'+
                       '<button onclick="searchAction('+car_id+',3,0,\''+vehicleData['vehicle']+'\');" type="button" class="btn btn-danger float-right margin-all">Remove</button>'+
                       '<button onclick="searchAction('+car_id+',2,0,\''+vehicleData['vehicle']+'\');" type="button" class="btn btn-primary float-right margin-all">Add</button>'+
                     '</div>';

      jQuery('[id="carSearchResult"]').html('<div id="search_result_'+car_id+'" class="box-body border marginTop10">'+vehHtmlBody+'</div>');
      jQuery('[id="carSearchResult"]').removeClass('hide');
      remFullScreenLoader();
      slideTo('carSearchResult');
    },
    fail: function(xhr, textStatus, errorThrown){
      remFullScreenLoader();
      setModal('Vechile Search','Something went wrong, please try again later...!');
    },
    error: function (ajaxContext) {
      remFullScreenLoader();
      setModal('Vechile Search','Something went wrong, please try again later...!');
    }
  });
});

function searchAction(car_id, action, saved, name){
  if(car_id == '' || car_id == null || car_id == 'null' || car_id == undefined || car_id == 'undefined' || action == '' || action == null || action == 'null' || action == undefined || action == 'undefined'){
    return false;
  }
  var html = '';
  if(action == 0 || action == 1 || action == 3){
    if(saved == 1){
      jQuery('[id="saved_vehicle_'+car_id+'"]').remove();
      if(jQuery('[id="savedVehiclesCntr"]').children().length <= 0){
        jQuery('[id="savedVehicleBox"]').addClass('hide');
      }
    }
    slideTo('CarSearchForm');
    jQuery.ajax({
      url  : base_url+"Vehicle/updateUserCarStatus", 
      type : 'POST',
      data : {'car_id':car_id,'action':action}
    });
  }
  if(action == 2){
    html = '<span id="saved_vehicle_'+car_id+'" class="vechile-body disp-block marginBottom-5">'+
              '<i class="fa fa-fw fa-car padRight-8p"></i>'
              +name+
              '<div id="remove_saved_'+car_id+'" car_id="'+car_id+'" class="float-right">'+
                '<i class="fa fa-fw fa-close cpoint"></i>'+
              '</div>'+
              '<input type="hidden" name="saved_vehicles[]" value="'+car_id+'" >'+
            '</span>';
    jQuery('[id="savedVehicleBox"]').removeClass('hide');
    jQuery('[id="savedVehiclesCntr"]').append(html);
    slideTo('createCustomerForm');
  }
  jQuery('[id="search_result_'+car_id+'"]').remove();
}

jQuery('div').on('click','[id^="remove_saved_"]',function(event) {
  var thisObj = jQuery(this), car_id = thisObj.attr('car_id');
  searchAction(car_id,'3','1','');
});

jQuery('[id^="addSubIssue_"]').on('click',function(event) {
  var thisObj = jQuery(this), 
      count = thisObj.attr('count'),
      html = jQuery('[id="subIssueAdd"]').html();

  if(count == '' || count == null || count == 'null' || count == undefined || count == 'undefined' || html == '' || html == null || html == 'null' || html == undefined || html == 'undefined'){
    return false;
  }
  count = parseInt(count)+1;
  thisObj.attr('count',count);
  html = html.replace(/{:count}/g, count);
  jQuery('[id="subIssueCntr"]').append('<div id="newSubIssue_'+count+'">'+html+'</div>');
});

function remSubIssue(count){
  if(count == '' || count == null || count == 'null' || count == undefined || count == 'undefined'){
    return false;
  }
  jQuery('[id="newSubIssue_'+count+'"]').remove();
}

function viewIssueDetls(issue_id){
  if(issue_id == '' || issue_id == null || issue_id == 'null' || issue_id == undefined || issue_id == 'undefined'){
    return false;
  }
  var head = '', body = '', 
      msg = 'Something went wrong, please try again later...!';

  jQuery('.modal-dialog').css('width', '60%');
  modalTrigger('Issue Sub Types','');
  addModalLoader();

  jQuery.ajax({
    url  : base_url+"Issue/getIssueDetails", 
    type : 'POST',
    data : {'issue_id':issue_id},
    success: function(resp){
      if(resp == '' || resp == undefined || resp == 'undefined' || resp == null || resp == 'null'){
        remModalLoader();
        jQuery('[id="modal_content"]').html(msg);
        return false;
      }
      var resp_data = jQuery.parseJSON(resp);
      if(resp_data['status'] != '1' || (resp_data['status'] == 1 && resp_data['data'] == '' || resp_data['data'] == null || resp_data['data'] == undefined || resp_data['data'] == 'null' || resp_data['data'] == 'undefined')){
        remModalLoader();
        jQuery('[id="modal_content"]').html(msg);
        return false;
      }
      if(resp_data['data']['sub_issue'] == '' || resp_data['data']['sub_issue'] == undefined || resp_data['data']['sub_issue'] == 'undefined' || resp_data['data']['sub_issue'] == null || resp_data['data']['sub_issue'] == 'null'){
        remModalLoader();
        jQuery('[id="modal_content"]').html('Current Issue doesn\'t have a sub category...');
        return false;
      }

      head = '<ul class="list_custom">'+
               '<li class="marginTop10" style="width:25%;"><label>Type</label></li>'+
               '<li class="marginTop10" style="width:40%;"><label>Description</label></li>'+
               '<li class="marginTop10" style="width:15%;"><label>Service Fee</label></li>'+
               '<li class="padBottom10 padLeft50"><label>Image</label></li>'+
             '</ul>';

      
      jQuery.each(resp_data['data']['sub_issue'], function (index, value) {
        body += '<ul class="list_custom">'+   
                  '<li class="issue-box" style="width:25%;"><label>'+value['issue_category']+'</label></li>'+
                  '<li class="issue-box" style="width:40%;">'+value['default_description']+'</li>'+
                  '<li class="issue-box padLeft40" style="width:15%;"><label>'+value['default_service_fee']+'</label></li>'+
                  '<li class="padBottom10 padLeft20 issue-box">'+
                    '<img src="'+base_url+value['issue_cat_image']+'" height="75" width="auto" style="max-width: 125px;"'+
                      'onerror="this.src=\''+base_url+'assets/images/no_image_text.png\'";/>'+
                  '</li>'+
                '</ul>';
      });
      jQuery('[id="modal_content"]').html('<div class="subIssueCntr">'+head+body+'</div>');
      remModalLoader();
      return false;
    },
    fail: function(xhr, textStatus, errorThrown){
      remModalLoader();
      jQuery('[id="modal_content"]').html(msg);
      return false;
    },
    error: function (ajaxContext) {
      remModalLoader();
      jQuery('[id="modal_content"]').html(msg);
      return false;
    }
  });
}

jQuery('[name="issue_id"]').on('change',function() {
  var issue_id = jQuery(this).val();
  getIssueDetails(issue_id);
});

function getIssueDetails(issue_id){
  if(issue_id == '' || issue_id == null || issue_id == 'null' || issue_id == undefined || issue_id == 'undefined'){
    return false;
  }
  showFullScreenLoader();
  var head = '', body = '', 
      msg = 'Something went wrong, please try again later...!';

  jQuery.ajax({
    url  : base_url+"Issue/getIssueDetails", 
    type : 'POST',
    data : {'issue_id':issue_id},
    success: function(resp){
      if(resp == '' || resp == undefined || resp == 'undefined' || resp == null || resp == 'null'){
        remFullScreenLoader();
        modalTrigger('Issue Mapping',msg);
        return false;
      }
      var resp_data = jQuery.parseJSON(resp);
      if(resp_data['status'] != '1' || (resp_data['status'] == 1 && resp_data['data'] == '' || resp_data['data'] == null || resp_data['data'] == undefined || resp_data['data'] == 'null' || resp_data['data'] == 'undefined')){
        remFullScreenLoader();
        modalTrigger('Issue Mapping',msg);
        return false;
      }
      if(resp_data['data']['sub_issue'] == '' || resp_data['data']['sub_issue'] == undefined || resp_data['data']['sub_issue'] == 'undefined' || resp_data['data']['sub_issue'] == null || resp_data['data']['sub_issue'] == 'null'){
        jQuery('[id="showNoSubTypeMsg"]').removeClass('hide');
        jQuery('[id="mapTypeCntr"],[id="subTypeDtlsCntr"]').addClass('hide');
        jQuery('[id="subTypeDtlsCntrData"]').html('');
        remFullScreenLoader();
        return false;
      }
      var html = '';
      jQuery.each(resp_data['data']['sub_issue'], function (index, value) {
        html += '<div class="col-md-12">'+
                  '<div class="col-md-1"></div>'+
                  '<div class="col-md-1 marginTop5">'+
                    '<i class="fa fa-arrow-circle-right fav-add-icon"></i>'+
                  '</div>'+
                  '<div class="col-md-2">'+
                    '<label>'+value['issue_category']+'</label>'+
                  '</div>'+
                  '<div class="col-md-2 marginBottom-10">'+
                    '<img class="small-icon" src="'+base_url+value['issue_cat_image']+'"'+
                      'onerror="this.src=\''+base_url+'assets/images/no_image_text.png\'";/>'+
                  '</div>'+
                  '<div class="col-md-4 marginBottom-10">'+
                    '<textarea name="default_description_'+value['issue_cat_id']+'" disabled required class="custom-textarea custom-textarea-style">'+value['default_description']+'</textarea>'+
                  '</div>'+
                  '<div class="col-md-2">'+
                    'Service Fee : '+
                    '<input name="default_service_fee_'+value['issue_cat_id']+'" disabled required data-parsley-pattern="^[0-9\ . \/]+$" class="custom-input custom-input-style" maxlength="6" value="'+value['default_service_fee']+'">'+
                  '</div>'+
                '</div>'+
                '<input type="hidden" name="issue_cat_ids[]" value="'+value['issue_cat_id']+'">';
      });
      jQuery('[id="showNoSubTypeMsg"]').addClass('hide');
      jQuery('[id="mapTypeCntr"],[id="subTypeDtlsCntr"]').removeClass('hide');
      jQuery('[id="subTypeDtlsCntrData"]').html(html);
      remFullScreenLoader();
      return false;
    },
    fail: function(xhr, textStatus, errorThrown){
      remFullScreenLoader();
      modalTrigger('Issue Mapping',msg);
      return false;
    },
    error: function (ajaxContext) {
      remFullScreenLoader();
      modalTrigger('Issue Mapping',msg);
      return false;
    }
  });
}

jQuery('[name="mapping_type"]').on('click',function() {
  var issue_id = '',
      mapping_type = jQuery(this).val();

  if(mapping_type == 1){
    jQuery('[name^="default_description_"]').removeClass('custom-textarea');
    jQuery('[name^="default_service_fee_"]').removeClass('custom-input');
    jQuery('[name^="default_description_"],[name^="default_service_fee_"]').prop("disabled",false);
  } else if(mapping_type == 0){
    jQuery('[name^="default_description_"]').addClass('custom-textarea');
    jQuery('[name^="default_service_fee_"]').addClass('custom-input');
    jQuery('[name^="default_description_"],[name^="default_service_fee_"]').prop("disabled",true);

    issue_id = jQuery('[name="issue_id"]').val();
    getIssueDetails(issue_id);
  }
});

function viewMapIssueDetails(issue_id) {
  if(issue_id == '' || issue_id == null || issue_id == 'null' || issue_id == undefined || issue_id == 'undefined'){
    return false;
  }
  var head = '', body = '', issueData = jQuery.parseJSON(mapIssueData);

  jQuery('.modal-dialog').css('width', '60%');
  modalTrigger('Issue Sub Types','');
  addModalLoader();

  head = '<ul class="list_custom">'+
               '<li class="marginTop10" style="width:25%;"><label>Type</label></li>'+
               '<li class="marginTop10" style="width:40%;"><label>Description</label></li>'+
               '<li class="marginTop10" style="width:15%;"><label>Service Fee</label></li>'+
               '<li class="padBottom10 padLeft50"><label>Image</label></li>'+
             '</ul>';

  jQuery.each(issueData[issue_id]['sub_issue'], function (index, value) {
    body += '<ul class="list_custom">'+   
              '<li class="issue-box" style="width:25%;"><label>'+value['issue_category']+'</label></li>'+
              '<li class="issue-box" style="width:40%;">'+value['description']+'</li>'+
              '<li class="issue-box padLeft40" style="width:15%;"><label>'+value['service_fee']+'</label></li>'+
              '<li class="padBottom10 padLeft20 issue-box">'+
                '<img src="'+base_url+value['issue_cat_image']+'" height="75" width="auto" style="max-width: 125px;"'+
                  'onerror="this.src=\''+base_url+'assets/images/no_image_text.png\'";/>'+
              '</li>'+
            '</ul>';
  });
  jQuery('[id="modal_content"]').html('<div class="subIssueCntr">'+head+body+'</div>');
  remModalLoader();
  return false;
}