<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Brand extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Brand_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}

    public function addbrand(){
        $template['page'] = 'Brand/addBrand';
        $template['pTitle'] = "Add Brand";
        $template['pDescription'] = "Add Brand"; 
        $template['menu'] = "Brand Management";
        $template['smenu'] = "View Brands";

        $template['brand_data'] = $this->Brand_model->getbrand();
        $this->load->view('template',$template);
    }

    public function viewBrand(){
        $template['page'] = 'brand/viewBrands';
        $template['menu'] = 'brand Management';
        $template['smenu'] = 'View brands';
        $template['pTitle'] = "View brands";
        $template['pDescription'] = "View and Manage brands";

        $template['brand_data'] = $this->Brand_model->getbrand('',1);
        $this->load->view('template',$template);
    }

    function changeStatus($brand_id = '',$status = '1'){
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
        if(empty($brand_id) || !is_numeric($brand_id = decode_param($brand_id))){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('brand/viewBrand'));
        }
        $status = $this->Brand_model->changeStatus($brand_id,$status);
        if(!$status){
            $this->session->set_flashdata('message',$flashMsg);
        }
        redirect(base_url('brand/viewBrand'));
    }

    public function createbrand(){
        $err = 0;
        $errMsg = '';
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
        if(!isset($_POST) || empty($_POST)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('brand/addbrand'));
        }
        if($err == 0 && (!isset($_POST['brand_name']) || empty($_POST['brand_name']))){
            $err = 1;
            $errMsg = 'Provide a brand Name';
        }

        if($err == 0){
            $config = set_upload_service("assets/uploads/brands");
            $this->load->library('upload');
            $config['file_name'] = time()."_".$_FILES['brand_logo']['name'];
            $this->upload->initialize($config);
            if(!$this->upload->do_upload('brand_logo')){
                $err = 1;
                $errMsg = $this->upload->display_errors();
            }else{
                $upload_data = $this->upload->data();
                $_POST['brand_logo'] = $config['upload_path']."/".$upload_data['file_name'];
            }
        }

        if($err == 1){
            $flashMsg['message'] = $errMsg;
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('brand/addbrand'));
        }

        $status = $this->Brand_model->addbrand($_POST);
        if($status == 1){
            $flashMsg =array('message'=>'Successfully Updated brand Details..!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('brand/viewBrand'));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('brand/addbrand'));
        }
    }

    public function editbrand($brand_id){
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
        if(empty($brand_id) || !is_numeric($brand_id = decode_param($brand_id))){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('brand/viewBrand'));
        }

        $template['page'] = 'brand/addBrand';
        $template['menu'] = 'brand Management';
        $template['smenu'] = 'Edit brand';
        $template['pTitle'] = "Edit brand";
        $template['pDescription'] = "Update brand Data";

        $template['brand_id'] = encode_param($brand_id);
        $template['brand_data'] = $this->Brand_model->getbrand($brand_id,1);
        $this->load->view('template',$template);
    }

    public function updatebrand($brand_id = ''){
        $err = 0;
        $errMsg = '';
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
        if(empty($brand_id) || !isset($_POST) || empty($_POST) || !is_numeric(decode_param($brand_id))){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('brand/viewBrand'));
        }
        if(!isset($_POST) || empty($_POST)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('brand/addbrand'));
        }
        if($err == 0 && (!isset($_POST['brand_name']) || empty($_POST['brand_name']))){
            $err = 1;
            $errMsg = 'Provide a brand Name';
        }

        if($err == 0){
            $config = set_upload_service("assets/uploads/brands");
            $this->load->library('upload');
            $config['file_name'] = time()."_".$_FILES['brand_logo']['name'];
            $this->upload->initialize($config);
            if(!$this->upload->do_upload('brand_logo')){
                $err = 1;
                $errMsg = $this->upload->display_errors();
            }else{
                $upload_data = $this->upload->data();
                $_POST['brand_logo'] = $config['upload_path']."/".$upload_data['file_name'];
            }
        }

        if($err == 1){
            $flashMsg['message'] = $errMsg;
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('brand/addbrand'));
        }

        $status = $this->Brand_model->updateBrand(decode_param($brand_id),$_POST);
        if($status == 1){
            $flashMsg =array('message'=>'Successfully Updated brand Details..!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('brand/viewBrand'));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('brand/editbrand/'.$brand_id));
        }
    }


}
?>