<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Product extends CI_Controller {

    public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Brand_model');
        $this->load->model('Product_model');
        
        if(!$this->session->userdata('logged_in')) {
            redirect(base_url('Login'));
        }
    }

    public function addProduct(){
        $template['page'] = 'Product/addproduct';
        $template['pTitle'] = "Add Product";
        $template['pDescription'] = "Add Product"; 
        $template['menu'] = "Product Management";
        $template['smenu'] = "View Product";
        $template['brand_id'] = '';

        $template['product_data'] = $this->Product_model->getProduct();
        $template['brand_data'] = $this->Brand_model->getbrand('',1);
        $this->load->view('template',$template);
    }

    public function viewProducts(){
        $template['page'] = 'Product/viewProduct';
        $template['menu'] = 'Product Management';
        $template['smenu'] = 'View Product';
        $template['pTitle'] = "View Product";
        $template['pDescription'] = "View and Manage Product";

        $template['product_data'] = $this->Product_model->getProduct('',1);
        $this->load->view('template',$template);
    }

    function changeStatus($brand_id = '',$status = '1'){
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
        if(empty($brand_id) || !is_numeric($brand_id = decode_param($brand_id))){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('brand/viewProducts'));
        }
        $status = $this->Product_model->changeStatus($brand_id,$status);
        if(!$status){
            $this->session->set_flashdata('message',$flashMsg);
        }
        redirect(base_url('Product/viewProducts'));
    }

    public function createproduct(){
        $err = 0;
        $errMsg = '';
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
        if(!isset($_POST) || empty($_POST)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Product/addProduct'));
        }
        if($err == 0 && (!isset($_POST['brand_id']) || empty($_POST['brand_id']))){
            $err = 1;
            $errMsg = 'Please Select a Brand';
        }else if($err == 0 && (!isset($_POST['short_description']) || empty($_POST['short_description']))){
            $err = 1;
            $errMsg = 'Provide a short Description';
        }else if($err == 0 && (!isset($_POST['product_name']) || empty($_POST['product_name']))){
            $err = 1;
            $errMsg = 'Provide a Product Name';
        }else if($err == 0 && (!isset($_POST['description']) || empty($_POST['description']))){
            $err = 1;
            $errMsg = 'Provide a Description';
        }else if($err == 0 && (!isset($_POST['about']) || empty($_POST['about']))){
            $err = 1;
            $errMsg = 'Provide a About';
        }else if($err == 0 && (!isset($_POST['amount']) || empty($_POST['amount']))){
            $err = 1;
            $errMsg = 'Provide a Amount';
        }

        if($err == 1){
            $flashMsg['message'] = $errMsg;
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Product/addProduct'));
        }

        $product_id = $this->Product_model->addProduct($_POST);
        if($product_id){
            $evtMediaData = array();
            if(!empty($files = $_FILES)){
                $images = array();
                $this->load->library('upload');
                $config = set_upload_service("assets/uploads/products");
                for ($typ = 0; $typ < count($files['product_image']['name']); $typ++) { 
                    $_FILES['file']['name'] = $files['product_image']['name'][$typ];
                    $_FILES['file']['type'] = $files['product_image']['type'][$typ];
                    $_FILES['file']['size'] = $files['product_image']['size'][$typ]; 
                    $_FILES['file']['error'] = $files['product_image']['error'][$typ];
                    $_FILES['file']['tmp_name'] = $files['product_image']['tmp_name'][$typ];

                    $config['file_name'] = time()."_".$_FILES['file']['name'];
                    $this->upload->initialize($config);
                    if($this->upload->do_upload('file')){
                        $imgData = $this->upload->data();
                        $evtMediaData[] = array(
                                            'product_id'=>$product_id,
                                            'image'=>"assets/uploads/products/".$imgData['file_name']);
                    }
                }
                $status = $this->Product_model->addProductImage($evtMediaData);
            }
            if($status == 1 || $product_id){
                $flashMsg =array('message'=>'Successfully Updated brand Details..!','class'=>'success');
                $this->session->set_flashdata('message', $flashMsg);
                redirect(base_url('Product/viewProducts'));
            }else {
                $this->session->set_flashdata('message', $flashMsg);
                redirect(base_url('Product/addProduct'));
            }
        }
    }

    public function editproduct($brand_id){
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
        if(empty($brand_id) || !is_numeric($brand_id = decode_param($brand_id))){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Product/viewProducts'));
        }

        $template['page'] = 'Product/addProducts';
        $template['menu'] = 'brand Management';
        $template['smenu'] = 'Edit brand';
        $template['pTitle'] = "Edit brand";
        $template['pDescription'] = "Update brand Data";

        $template['brand_id'] = encode_param($brand_id);
        $template['brand_data'] = $this->Product_model->getbrand($brand_id,1);
        $this->load->view('template',$template);
    }

    public function updateproduct($brand_id = ''){
        $err = 0;
        $errMsg = '';
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
        if(empty($brand_id) || !isset($_POST) || empty($_POST) || !is_numeric(decode_param($brand_id))){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Product/viewProducts'));
        }
        if(!isset($_POST) || empty($_POST)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Product/addProduct'));
        }
        if($err == 0 && (!isset($_POST['brand_name']) || empty($_POST['brand_name']))){
            $err = 1;
            $errMsg = 'Provide a brand Name';
        }

        if($err == 0){
            $config = set_upload_service("assets/uploads/brands");
            $this->load->library('upload');
            $config['file_name'] = time()."_".$_FILES['brand_logo']['name'];
            $this->upload->initialize($config);
            if(!$this->upload->do_upload('brand_logo')){
                $err = 1;
                $errMsg = $this->upload->display_errors();
            }else{
                $upload_data = $this->upload->data();
                $_POST['brand_logo'] = $config['upload_path']."/".$upload_data['file_name'];
            }
        }

        if($err == 1){
            $flashMsg['message'] = $errMsg;
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Product/addProduct'));
        }

        $status = $this->Product_model->updateProducts(decode_param($brand_id),$_POST);
        if($status == 1){
            $flashMsg =array('message'=>'Successfully Updated brand Details..!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Product/viewProducts'));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Product/editproduct/'.$brand_id));
        }
    }


}
?>