<div class="content-wrapper">
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php 
        $url = (!isset($product_id) || empty($product_id))?'Product/createproduct':'Product/updateproduct/'.$mechanic_id;
        if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
            <button class="close" data-dismiss="alert" type="button">×</button>
            <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-body">
            <form name="productAddForm" role="form" action="<?= base_url($url) ?>" method="post" 
              class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <!-- Basic Details -->
              <div class="col-md-12">  
                <div class="box-header with-border padUnset">
                  <h3 class="box-title">Basic Details</h3>
                </div><br>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Choose Brand</label>
                  <select name="brand_id" class="form-control required" placeholder="Select Brand" required="">
                    <option selected disabled>Choose a Brand</option>
                    <?php 
                      foreach ($brand_data as $brand) {
                        $select = (isset($brand->brand_id) && $brand->brand_id==$brand_id)?'selected':'';
                        echo '<option '.$select.' value="'.$brand->brand_id.'">'.
                                $brand->brand_name.
                             '</option>';
                      }
                    ?>
                  </select> 
                </div>
                <div class="form-group">
                  <label>Short Description</label>
                  <textarea type="text" class="form-control required" data-parsley-trigger="change"
                  data-parsley-minlength="2" name="short_description" required="" value="<?= (isset($user_data->username))?$user_data->username:'' ?>"
                  data-parsley-pattern="^[a-zA-Z0-9\ . _ @  \/]+$" placeholder="Enter Short Description"></textarea>
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Product Name</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change" data-parsley-minlength="2" name="product_name" required="" 
                  placeholder="Enter Product Name" value="<?= (isset($user_data->display_name))?$user_data->display_name:'' ?>">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
                <div class="form-group">
                  <label>Amount</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change"
                  data-parsley-minlength="2" name="amount" required="" value="<?= (isset($user_data->username))?$user_data->username:'' ?>"
                  data-parsley-pattern="^[0-9\ . \/]+$" placeholder="Enter Amount">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <!-- Mechanic Data -->
              <div class="col-md-12">  
                <div class="box-header with-border padUnset">
                  <h3 class="box-title">Product Details</h3>
                </div><br>
              </div>
              <div class="col-md-12">
                <div class="form-group">
                  <label>Product Images</label>
                  <div id="multipleImageInputCntr">
                    <div class="dropZoneContainer" id="multiImageCntr_1" count="1">
                      <div id="multiImageClose_1" class="close_custom hide" onclick="removeImage('1');">&times;</div>
                      <input id="product_image_1" type="file" name="product_image[]" accept="image/*" class="multiFileUpload" onchange="setMultiImg(this,jQuery(this));" count="1" />
                      <img class="multiDropZoneOverlay" id="multiImageImg_1" src="<?=base_url("assets/images/add-image.png")?>" />
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                 <label>Product Description</label>
                  <textarea id="rich_editor" type="text" class="ip_reg_form_input form-control reset-form-custom" placeholder="Product Description" name="description" 
                  style="height:108px;" data-parsley-trigger="change" data-parsley-minlength="2"></textarea>
                </div> 
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>About</label>
                  <textarea id="rich_editor1" type="text" class="ip_reg_form_input form-control reset-form-custom" placeholder="About" name="about" 
                  style="height:108px;" data-parsley-trigger="change" data-parsley-minlength="2"></textarea>
                </div>
              </div>
              <div class="col-md-12">      
                <div class="box-footer textCenterAlign">
                  <button id="addProductButton" type="submit" class="btn btn-primary">Submit</button>
                  <a href="<?= base_url('Product/viewProducts') ?>" class="btn btn-primary">Cancel</a>
                </div>        
              </div>        
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>


<div id="multipleImageInput" class="hide">
  <div class="dropZoneContainer" id="multiImageCntr_{:count}"  count="{:count}">
    <div id="multiImageClose_{:count}" class="close_custom hide" onclick="removeImage('{:count}');">&times;</div>
    <input id="event_image_{:count}" type="file" name="product_image[]" class="multiFileUpload" accept="image/*"
           onchange="setMultiImg(this,jQuery(this));" count="{:count}" />
    <img class="multiDropZoneOverlay" id="multiImageImg_{:count}" src="" 
           onerror="this.src='<?=base_url("assets/images/add-image.png")?>';" />
  </div>
</div>