<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Vehicle extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Vehicle_model');

		if(!$this->session->userdata('logged_in')) {
			redirect(base_url());
		}
	}

	public function vehicleSearch(){
		$return_arr = array('status'=>'0');
        if(!isset($_POST) || empty($_POST) || !isset($_POST['searchType']) || empty($_POST['searchType']) || 
           !isset($_POST['vehLocation']) || empty($vehLocation = $_POST['vehLocation'])){
            echo json_encode($return_arr);exit;
        }
        $param = "";
        $searchType = $_POST['searchType'];
        $vehicle_data = array('car_location'=>$vehLocation);

        $this->load->model('Settings_model');
        $settings = $this->Settings_model->settings_viewing();

        if($searchType == 1 && 
           isset($_POST['vehYear']) && !empty($_POST['vehYear']) && 
    	   isset($_POST['vehModel']) && !empty($_POST['vehModel']) && 
    	   isset($_POST['vehMaker']) && !empty($_POST['vehMaker'])){
            $vehicle_data['car_maker'] = $_POST['vehMaker'];
            $vehicle_data['car_model'] = $_POST['vehModel'];
            $vehicle_data['car_model_year'] = $_POST['vehYear'];

            $param = "?format=json&key=".urlencode($settings['vin_audit_api'])."&year=".
                      urlencode($_POST['vehYear'])."&make=".urlencode($_POST['vehMaker'])."&model=".
                      urlencode($_POST['vehModel']);
        }
        else if($searchType == 2 && isset($_POST['vehVin']) && !empty($_POST['vehVin'])){
            $vehicle_data['car_vin'] = $_POST['vehVin'];

            $param = "?format=json&key=".urlencode($settings['vin_audit_api']).
                     "&vin=".urlencode($_POST['vehVin']);
        }
        if(!empty($param)){
            $vehData=file_get_contents("https://specifications.vinaudit.com/getspecifications.php".$param);
            if(empty($vehData) || empty($vehData = json_decode($vehData,true))){
                echo json_encode($return_arr);exit;
            }
            if(!isset($vehData['success']) || empty($vehData['success']) || $vehData['success'] == false){
                $return_arr['status'] = 2;
                echo json_encode($return_arr);exit;
            }
            $lat_lng = getLocationLatLng($vehLocation);
            if(empty($lat_lng)){
                $return_arr['status'] = 3;
                echo json_encode($return_arr);exit;
            }
            if($searchType == 2){
                $vehicle_data['car_model'] = $vehData['attributes']['Model'];
                $vehicle_data['car_maker'] = $vehData['attributes']['Make'];
                $vehicle_data['car_model_year'] = $vehData['attributes']['Year'];
                $vehData['vehicle'] = $vehData['attributes']['Year'].' '.$vehData['attributes']['Make'].' '.
                                      $vehData['attributes']['Model'].' '.$vehData['attributes']['Trim'];
            }
            $vehicle_data['car_name'] = $vehData['vehicle'];
            $vehicle_data['car_loc_lat'] = $lat_lng['lat'];
            $vehicle_data['car_loc_lng'] = $lat_lng['lng'];
            $vehicle_data['vehicle_data'] = json_encode($vehData);

            $car_id = $this->Vehicle_model->addVehicle($vehicle_data);
            if(!empty($car_id)){
                $return_arr['status'] = '1';
                $return_arr['car_id'] = $car_id;
                $return_arr['veh_data'] = $vehData;
            }
        }
        echo json_encode($return_arr);exit;
	}

    function updateUserCarStatus(){
        $return_arr = array('status'=>'0');
        if(!isset($_POST) || empty($_POST) || 
           !isset($_POST['car_id']) || empty($car_id = $_POST['car_id']) || 
           !isset($_POST['action']) || empty($action = $_POST['action'])){
            echo json_encode($return_arr); exit;
        }
        $return_arr['status'] = $this->Vehicle_model->changeStatus($car_id,$action);
        echo json_encode($return_arr); exit;
    }
}
?>