<?php
defined('BASEPATH')OR exit('No direct script access allowed');
header('Content-Type: text/html; charset=utf-8');

// Allow from any origin
if(isset($_SERVER['HTTP_ORIGIN'])) {
	header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
	header('Access-Control-Allow-Credentials: true');
	header('Access-Control-Max-Age: 86400'); // cache for 1 day
}

// Access-Control headers are received during OPTIONS requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
	if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
	  header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
	if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
	  header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
	exit(0);
}

class Webservices extends CI_Controller {

	public function __construct() {
	  parent::__construct();
	  $this->load->model('Webservice_model');
	  $this->load->library('form_validation');

	  $auth = '';
	  $class = $this->router->fetch_class();
	  $method = $this->router->fetch_method();

	  if($this->input->server('REQUEST_METHOD') == 'GET')
	     $postdata = json_encode($_GET);

	  else if ($this->input->server('REQUEST_METHOD') == 'POST')
	     $postdata = file_get_contents("php://input");

	  if (isset(apache_request_headers()['Auth'])) {
	     $auth = apache_request_headers()['Auth'];
	  }
	  // $this->last_id = set_log($class, $method, $postdata, $auth);
	}

	// customer_login
	public function customer_login(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Customer_model');

	  $respArr = array('status'=>'0','message'=>'Required Fields are empty.');
	  if(!isset($postData['email']) || empty($postData['email']) || 
	     !isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
	      echo json_encode($respArr);exit;
	  }

	  $custResp = $this->Customer_model->checkCustomerLogin($postData);
	  if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '1'){
	     $respArr['data'] = $custResp['data'];
	     $respArr['status'] = '1';
	     $respArr['message'] = 'Success';
	     echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '2'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Invalid Email Address';
	     echo json_encode($respArr);exit;
	  }
	  
	  if($custResp['status'] == '3'){
	     $respArr['status'] = '3';
	     $respArr['message'] = 'Invalid Password';
	     echo json_encode($respArr);exit;
	  }
	  echo json_encode($respArr); exit;
	}

	// customer_forgot_password
	public function customer_forgot_password(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Customer_model');

	  $respArr = array('status'=>'0','message'=>'Required Fields are empty.');
	  if(empty($postData) || !isset($postData['email']) || empty($postData['email'])){
	      echo json_encode($respArr);exit;
	  }

	  $custResp = $this->Customer_model->genCustForgotPassLink($postData);
	  if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '2'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Invalid Email Address';
	     echo json_encode($respArr);exit;
	  }
	  
	  if($custResp['status'] == '1'){
	     /*
	        MAIL SENT CONFIGARATION -- TODO
	     */

	     $respArr['status'] = '1';
	     $respArr['message'] = 'Password Reset Email has been sent';
	  }
	  echo json_encode($respArr); exit;
	}

	// customer_registration
	public function customer_registration(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Customer_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData)){
	      echo json_encode($respArr);exit;
	  }

	  $err = 0;
	  $msg = '';
	  if(!isset($postData['email']) || empty($postData['email'])){
	     $err = 1;
	     $msg = 'Provide a valid Email ID';
	  } 
	  else if(!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
	     $err = 1;
	     $msg = 'Provide a Password';
	  }
	  else if(!isset($postData['first_name']) || empty($postData['first_name'])){
	     $err = 1;
	     $msg = 'Provide valid Name';
	  }
	  else if(!isset($postData['last_name']) || empty($postData['last_name'])){
	     $err = 1;
	     $msg = 'Provide valid Name';
	  }

	  if($err == 1){
	     $respArr['message'] = $msg;
	     echo json_encode($respArr);exit;
	  }
	  
	  if(isset($postData['phone']) && empty($postData['phone'])){
	     unset($postData['phone']);
	  }
	  unset($postData['promocode']);

	  $custResp = $this->Customer_model->createCustomer($postData);
	  if(empty($custResp)){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp == '1'){
	     $custResp = $this->Customer_model->checkCustomerLogin($postData);

	     if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
	         echo json_encode($respArr);exit;
	     }

	     if($custResp['status'] == '1'){
	        $respArr['data'] = $custResp['data'];
	        $respArr['status'] = '1';
	        $respArr['message'] = 'Success';
	        echo json_encode($respArr);exit;
	     }
	  } else if($custResp == '2'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Email Address already in use';
	     echo json_encode($respArr);exit;
	  } else if($custResp == '3'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Phone already in use';
	     echo json_encode($respArr);exit;
	  }

	  
	  echo json_encode($respArr); exit;
	}

	// getGeneralIssues
	public function getGeneralIssues(){
	  header('Content-type: application/json');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  $this->load->model('Issue_model');
	  $issue_data = $this->Issue_model->getGeneralIssues();

	  if(!empty($issue_data)){
	     $respArr['status'] = '1';
	     $respArr['message'] = 'Success';
	     $respArr['issue_data'] = $issue_data;
	  }
	  
	  echo json_encode($respArr); exit;
	}

	// getNearByMechanics
	public function getNearByMechanics(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Mechanic_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');

	  if(empty($postData) || !isset($postData['pickup_data']) || !isset($postData['sub_issues']) || 
	  	 empty($postData['pickup_data']) || empty($postData['sub_issues']) ){
	  	echo json_encode($respArr); exit;
	  }

	  $mechanic_data = $this->Mechanic_model->getNearByMechanics($postData['pickup_data'],$postData['sub_issues']);

	  if(!empty($mechanic_data)){
	     $respArr['status'] = '1';
	     $respArr['message'] = 'Success';
	     $respArr['mechanic_data'] = $mechanic_data;
	  }
	  echo json_encode($respArr); exit;
	}

	// scheduleNow
	public function scheduleNow(){
	  header('Content-type: application/json');

	  $postData = $_POST;
	  $optionalData = array('optionlaDescription'=>'','optionalImages'=>array(),'optionalVideos'=>array());
	  $respArr = array('status'=>'0','message'=>'Something went wrong.');

	  if(empty($postData) || empty($postData = json_decode($postData['data'],true)) || 
	   	!isset($postData['cost']) || empty($postData['cost']) || 
	  	!isset($postData['customer_id']) || empty($postData['customer_id']) || 
	  	!isset($postData['mechanic_id']) || empty($postData['mechanic_id']) || 
	  	!isset($postData['pickup_data']) || empty($postData['pickup_data']) || 
	  	!isset($postData['vechile_info']) || empty($postData['vechile_info']) || 
	  	!isset($postData['schedule_date']) || empty($postData['schedule_date']) || 
	  	!isset($postData['selected_issues']) || empty($postData['selected_issues'])){
	      echo json_encode($respArr);exit;
	  }

	  $optionalData['optionlaDescription'] = (isset($postData['optionalDescription']) && 
	  										  !empty($postData['optionalDescription']))?
	  											$postData['optionalDescription']:'';

	  if(isset($_FILES) && !empty($_FILES)){
	  	foreach ($_FILES as $fileIndex => $optImgs) {
	  	  if(empty($optImgs) || !isset($optImgs['name']) || empty($optImgs['name'])){
	  	  	continue;
	  	  }
		  $this->load->library('upload');
  		  $config = set_upload_service("assets/uploads/services");
		  $config['file_name'] = 'optionalImages'.$postData['customer_id'].date('dmYHis');
		  $this->upload->initialize($config);
		  if($this->upload->do_upload($fileIndex)){
		   	$upload_data = $this->upload->data();
			$optionalData['optionalImages'][] = $config['upload_path']."/".$upload_data['file_name'];
		  }
	  	}
	  }
	  $this->load->model('Booking_model');
	  
	  $postData['optionalData'] = $optionalData;
	  $status = $this->Booking_model->scheduleBooking($postData);
	  if($status){
	  	$respArr['status'] = '1';
	    $respArr['message'] = 'Success';
	  }
	  echo json_encode($respArr); exit;
	}

	// edit_customer_profile
	public function edit_customer_profile(){
	  header('Content-type: application/json');

	  $postData = $_POST;
	  $this->load->model('Customer_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData) || empty($postData = json_decode($postData['data'],true)) || 
	  	!isset($postData['customer_id']) || empty($postData['customer_id'])){
	      echo json_encode($respArr);exit;
	  }

	  $err = 0;
	  $msg = '';
	  if(!isset($postData['email']) || empty($postData['email'])){
	     $err = 1;
	     $msg = 'Provide a valid Email ID';
	  }
	  else if(!isset($postData['first_name']) || empty($postData['first_name'])){
	     $err = 1;
	     $msg = 'Provide valid Name';
	  }
	  else if(!isset($postData['last_name']) || empty($postData['last_name'])){
	     $err = 1;
	     $msg = 'Provide valid Name';
	  }
	  else if(!isset($postData['phone']) || empty($postData['phone'])){
	     $err = 1;
	     $msg = 'Provide valid Phone';
	  }
	  else if(!isset($postData['address']) || empty($postData['address'])){
	     $err = 1;
	     $msg = 'Provide valid Address';
	  }

	  if($err == 1){
	     $respArr['message'] = $msg;
	     echo json_encode($respArr);exit;
	  }

	  if(isset($_FILES) && !empty($_FILES) && 
		 isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])){
		$config = set_upload_service("assets/uploads/services");
		$this->load->library('upload');
		$config['file_name'] = $postData['customer_id']."_".$_FILES['profile_image']['name'];
		$this->upload->initialize($config);
		if($this->upload->do_upload('profile_image')){
			$upload_data = $this->upload->data();
			$postData['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
		}
	  }

	  $customer_id = $postData['customer_id'];
	  if(isset($postData['password']) && !empty($postData['password']) && 
		 isset($postData['cpassword']) && !empty($postData['cpassword']) && 
		 $postData['password'] == $postData['cpassword']){
	     $postData['password'] = md5($postData['password']);
	  } else {
	  	unset($postData['password']);
	  }
	  unset($postData['cpassword']);
	  unset($postData['customer_id']);
	  
	  $custResp = $this->Customer_model->updateCustomer($customer_id,$postData);
	  if(empty($custResp)){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp == '1'){
	     $respArr['status'] = '1';
	     $respArr['message'] = 'Profile successfully updated';
     	 $respArr['profile_image'] = (isset($postData['profile_image']) && !empty($postData['profile_image']))?$postData['profile_image']:'';
	     echo json_encode($respArr);exit;
	  } else if($custResp == '2'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Email Address already in use';
	     echo json_encode($respArr);exit;
	  } else if($custResp == '3'){
	     $respArr['status'] = '3';
	     $respArr['message'] = 'Phone Number already in use';
	     echo json_encode($respArr);exit;
	  }

	  echo json_encode($respArr); exit;
	}

	// customerVechiles
	function customerVechiles(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Vehicle_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
	      echo json_encode($respArr);exit;
	  }

	  $vehData = $this->Vehicle_model->getCustVechiles($postData);
	  if($vehData != '0'){
	  	$respArr['status'] = 1;
	  	$respArr['message'] = 'success';
	  	$respArr['vehData'] = $vehData;
	  }
	  echo json_encode($respArr);exit;
	}

	// getCustBookDetails
	function getCustBookDetails(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Booking_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
	    echo json_encode($respArr);exit;
	  }

	  $status = (isset($postData['status']) && !empty($postData['status']))?$postData['status']:'';
	  $bookingDetails = $this->Booking_model->getCustBookDetails($postData,$status);
	  if($bookingDetails != '0'){
	  	$respArr['status'] = 1;
	  	$respArr['message'] = 'success';
	  	$respArr['bookData'] = $bookingDetails;
	  }
	  echo json_encode($respArr);exit;
	}

	// cancelBooking
	function cancelBooking(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Booking_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id']) || 
	  	!isset($postData['booking_id']) || empty($postData['booking_id'])){
	    echo json_encode($respArr);exit;
	  }

	  $status=$this->Booking_model->changeBookStatus($postData['customer_id'],$postData['booking_id'],'3');
	  
	  if($status){
	  	$respArr['status'] = 1;
	  	$respArr['message'] = 'success';
	  }
	  echo json_encode($respArr);exit;
	}

	// deleteCustomerCar
	function deleteCustomerCar(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Vehicle_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id']) || 
	  	!isset($postData['customer_veh_id']) || empty($postData['customer_veh_id'])){
	    echo json_encode($respArr);exit;
	  }

	  $status = $this->Vehicle_model->changeCustomerCarStatus($postData['customer_id'],
	  												   $postData['customer_veh_id'],'2');
	  
	  if($status){
	  	$respArr['status'] = 1;
	  	$respArr['message'] = 'success';
	  }
	  echo json_encode($respArr);exit;
	}

	// addCustomerCar
	function addCustomerCar(){
		header('Content-type: application/json');
		$post = file_get_contents("php://input");
		$postData = json_decode($post, true);
		$this->load->model('Vehicle_model');

		$respArr = array('status'=>'0','message'=>'Something went wrong.');
		if(empty($postData) || !isset($postData['customer_id']) || empty($postData['customer_id'])){
            echo json_encode($respArr);exit;
        }

        $param = "";
        $searchType = $postData['type'];
        $searchData = $postData['vehicleData'];
        $locationData = $postData['location'];

        $vehicle_data['status'] = '1';
        $vehicle_data['customer_id'] = $postData['customer_id'];
        $vehicle_data['car_loc_lat'] = $locationData['location_lat'];
        $vehicle_data['car_loc_lng'] = $locationData['location_lng'];
        $vehicle_data['car_location'] = $locationData['location'];

        $this->load->model('Settings_model');
        $settings = $this->Settings_model->settings_viewing();

        $searchData = $postData['vehicleData'];
        if($searchType == 1 && 
           isset($searchData['car_maker']) && !empty($searchData['car_maker']) && 
    	   isset($searchData['modelName']) && !empty($searchData['modelName']) && 
    	   isset($searchData['modelYear']) && !empty($searchData['modelYear'])){
            $vehicle_data['car_maker'] = $searchData['car_maker'];
            $vehicle_data['car_model'] = $searchData['modelName'];
            $vehicle_data['car_model_year'] = $searchData['modelYear'];

            $param = "?format=json&key=".urlencode($settings['vin_audit_api'])."&year=".
                      urlencode($searchData['modelYear'])."&make=".urlencode($searchData['car_maker']).
                      "&model=".urlencode($searchData['modelName']);
        }
        else if($searchType == 2 && isset($searchData['vin']) && !empty($searchData['vin'])){
            $vehicle_data['car_vin'] = $searchData['vin'];

            $param = "?format=json&key=".urlencode($settings['vin_audit_api']).
                     "&vin=".urlencode($searchData['vin']);
        }

        if(!empty($param)){
            $vehData=file_get_contents("https://specifications.vinaudit.com/getspecifications.php".$param);
            if(empty($vehData) || empty($vehData = json_decode($vehData,true))){
                echo json_encode($return_arr);exit;
            }

            if(!isset($vehData['success']) || empty($vehData['success']) || $vehData['success'] == false){
                $return_arr['status'] = 2;
                $return_arr['message'] = 'No Data Found.';
                echo json_encode($return_arr);exit;
            }

            if($searchType == 2){
            	$vehicle_data['car_model'] = $vehData['attributes']['Model'];
            	$vehicle_data['car_maker'] = $vehData['attributes']['Make'];
            	$vehicle_data['car_model_year'] = $vehData['attributes']['Year'];
                $vehData['vehicle']= $vehData['attributes']['Year'].' '.$vehData['attributes']['Make'].' '.
                                     $vehData['attributes']['Model'].' '.$vehData['attributes']['Trim'];
            }

            $vehicle_data['car_name'] = $vehData['vehicle'];
            $vehicle_data['vehicle_data'] = json_encode($vehData);

            $car_id = $this->Vehicle_model->addVehicle($vehicle_data);
            if(!empty($car_id)){
                $return_arr['status'] = '1';
                $return_arr['car_id'] = $car_id;
                $return_arr['veh_data'] = $vehData;
            }
        }
        echo json_encode($return_arr);exit;
	}



/*****************************************************************************************/
/****************************************Mobile API's*************************************/


	public function mobile_number_availability(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);

	  $respArr = array('status'=>'error','error'=>'901','message'=>'Something went wrong.');
	  if(!isset($postData['phone']) || empty($postData['phone'])){
	  	$respArr = array('status'=>'0','error'=>'903','message'=>'Required Fields are empty.');
	    echo json_encode($respArr);exit;
	  }

	  $custResp = $this->Webservice_model->checkMobAvailability($postData);
	  if(!empty($custResp)){
	      $respArr = $custResp;
	  }
	  echo json_encode($respArr);exit;
	}

	public function user_login(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);

	  $respArr = array('status'=>'0','message'=>'Required Fields are empty.');
	  if(!isset($postData['email']) || empty($postData['email']) || 
	     !isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
	      echo json_encode($respArr);exit;
	  }

	  $custResp = $this->Webservice_model->checkCustomerLogin($postData);
	  if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '1'){
	     $respArr['data'] = $custResp['data'];
	     $respArr['status'] = 'success';
	     $respArr['message'] = 'Success';
	     echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '2'){
	     $respArr['status'] = 'error';
	     $respArr['message'] = 'Invalid Email Address';
	     echo json_encode($respArr);exit;
	  }
	  
	  if($custResp['status'] == '3'){
	     $respArr['status'] = 'error';
	     $respArr['message'] = 'Invalid Password';
	     echo json_encode($respArr);exit;
	  }
	  echo json_encode($respArr); exit;
	}

		// customer_registration
	public function user_registration(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');

	  if(empty($postData)){
	      echo json_encode($respArr);exit;
	  }

	  $err = 0;
	  $msg = '';
	  if(!isset($postData['email']) || empty($postData['email'])){
	     $err = 1;
	     $msg = 'Provide a valid Email ID';
	  } 
	  else if(!isset($postData['password']) || empty($postData['password'] = md5($postData['password']))){
	     $err = 1;
	     $msg = 'Provide a Password';
	  }
	  else if(!isset($postData['name']) || empty($postData['name'])){
	     $err = 1;
	     $msg = 'Provide valid Name';
	  }
	  else if(!isset($postData['country_code']) || empty($postData['country_code'])){
	     $err = 1;
	     $msg = 'Provide a Country Code';
	  }

	  else if(!isset($postData['phone']) && empty($postData['phone'])){
	     $err = 1;
	     $msg = 'Provide a Phone Number';
	  }

	  if($err == 1){
	     $respArr['message'] = $msg;
	     echo json_encode($respArr);exit;
	  }

	  $custResp = $this->Webservice_model->createCustomer($postData);
	  if(empty($custResp)){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '1'){
        $respArr['data'] = $custResp['data'];
        $respArr['status'] = 'success';
        $respArr['message'] = 'Success';
        echo json_encode($respArr);exit;
	  } else if($custResp['status'] == '2'){
	     $respArr['status'] = 'error';
	     $respArr['message'] = 'Email Address already in use';
	     echo json_encode($respArr);exit;
	  } else if($custResp['status'] == '3'){
	     $respArr['status'] = 'error';
	     $respArr['message'] = 'Phone already in use';
	     echo json_encode($respArr);exit;
	  }

	  echo json_encode($respArr); exit;
	}

	public function get_booked_services(){
		header('Content-type: application/json');
		$headers = apache_request_headers();
	  	
		if(!isset($headers['Auth']) || empty($headers['Auth'])){
		    $respArr['status'] = '0';
		    $respArr['message'] = 'Authtoken is Required';
		    echo json_encode($respArr);exit;
		}

		$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 

		if($authRes['status'] == 'error'){
			echo json_encode($authRes);exit;
		}
		$bookData = $this->Webservice_model->getBookedService($authRes['data']['customer_id']);
		echo json_encode($bookData);exit;
	}

	public function add_vehicle_details(){
		header('Content-type: application/json');
		$headers = apache_request_headers();

		$post = file_get_contents("php://input");
	  	$postData = json_decode($post, true);

		if(!isset($headers['Auth']) || empty($headers['Auth'])){
		    $respArr['status'] = '0';
		    $respArr['message'] = 'Authtoken is Required';
		    echo json_encode($respArr);exit;
		}

		$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 

		if($authRes['status'] == 'error'){
			echo json_encode($authRes);exit;
		}

		$err = 0;
		$msg = '';

		if(empty($postData)){
			$respArr = array('status'=>0,'error'=>'901','message'=>'All Field is Required');
			echo json_encode($respArr);exit;
		}

		if(!isset($postData['vehicle_year']) || empty($postData['vehicle_year'])){
		    $err = 1;
		    $msg = 'Provide a Vehicle year';
		} 
		else if(!isset($postData['vehicle_make']) || empty($postData['vehicle_make'])){
		    $err = 1;
		    $msg = 'Provide a Vehicle Make';
		}
		else if(!isset($postData['vehicle_model']) || empty($postData['vehicle_model'])){
		    $err = 1;
		    $msg = 'Provide a Vehicle Model';
		}
		else if(!isset($postData['engine_no']) || empty($postData['engine_no'])){
		    $err = 1;
		    $msg = 'Provide an Engine Number';
		}
		else if(!isset($postData['vehicle_trim']) && empty($postData['vehicle_trim'])){
		    $err = 1;
		    $msg = 'Provide a Vehicle Trim';
		}
		else if(!isset($postData['mileage']) && empty($postData['mileage'])){
		    $err = 1;
		    $msg = 'Provide a Mileage';
		}
		else if(!isset($postData['car_loc_lat']) && empty($postData['car_loc_lat'])){
		    $err = 1;
		    $msg = 'Car Location is Required';
		}
		else if(!isset($postData['car_loc_lng']) && empty($postData['car_loc_lng'])){
		    $err = 1;
		    $msg = 'Car Location is Required';
		}
		else if(!isset($postData['car_location']) && empty($postData['car_location'])){
		    $err = 1;
		    $msg = 'Car Location is Required';
		}

		if($err == 1){
		    $respArr['message'] = $msg;
		    echo json_encode($respArr);exit;
		}

		$respData = $this->Webservice_model->addVehicleDetails($postData,$authRes['data']['customer_id']);
		echo json_encode($respData);exit;
	}

	public function get_services(){
		header('Content-type: application/json');
		$headers = apache_request_headers();

		$postData = $_GET;

	  	if(!isset($headers['Auth']) || empty($headers['Auth'])){
		    $respArr['status'] = '0';
		    $respArr['message'] = 'Authtoken is Required';
		    echo json_encode($respArr);exit;
		}

		$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 

		if($authRes['status'] == 'error'){
			echo json_encode($authRes);exit;
		}

		$currentpage = 0;
		$start = 0;
		$per_page = 10;

		if(isset($postData['page']) && strlen(trim($postData['page']," ")) > 0 ) {
			$currentpage =  (int)$postData['page'];
			$currentpage = $currentpage==0 ? $currentpage : $currentpage-1;
			$start = $currentpage * $per_page;
		}

		$serviceresult = $this->Webservice_model->get_service_list($postData,0,0);
		$serviceList = $this->Webservice_model->get_service_list($postData,$start,$per_page);
		
		$service = array();
		$total = 0;


		if($serviceresult['status'] == 1){
			$total = count($serviceresult['data']);	
		}

		if($total >= $per_page){

			$totalPages = (int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
		}
		else{
			$totalPages = 1;
		}

		if($serviceList['status'] == '1'){
			$respArr = array('status' => 'success',
						 'message'=>'success',
								'data' => array(
									'services' => $serviceList['data']
									),
								'meta' => array(
									'total_pages' => $totalPages,
									'total' => $total,
									'current_page' => $currentpage+1,
									'per_page' => $per_page)
								);
		}else{
			$respArr = array('status' => 'error',
						 'message'=>'No data',
								'data' => array(
									'services' => []
									),
								'meta' => array(
									'total_pages' => $totalPages,
									'total' => $total,
									'current_page' => $currentpage+1,
									'per_page' => $per_page)
								);
		}
		echo json_encode($respArr);exit;
	}

	public function get_vehicle_details(){
		header('Content-type: application/json');
		$headers = apache_request_headers();

		$post = file_get_contents("php://input");
	  	$postData = json_decode($post, true);

		if(!isset($headers['Auth']) || empty($headers['Auth'])){
		    $respArr['status'] = '0';
		    $respArr['message'] = 'Authtoken is Required';
		    echo json_encode($respArr);exit;
		}

		$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 

		if($authRes['status'] == 'error'){
			echo json_encode($authRes);exit;
		}

		$respArr = array('status'=>'error','message'=>'Something Went Wrong.');

	    if(empty($postData)){
	      echo json_encode($respArr);exit;
	    }
	    else if(!isset($postData['bar_code']) && !empty($postData['bar_code'])){
	      $respArr['message'] = 'Barcode is Required.';
	      echo json_encode($respArr);exit;
	    }

	    $settings = getSettings();
	    $param = "?format=json&key=".urlencode($settings['vin_audit_api']).
	                     "&vin=".urlencode($postData['bar_code']);

	    $vehData=file_get_contents("https://specifications.vinaudit.com/getspecifications.php".$param);

	    if(empty($vehData) || empty($vehData = json_decode($vehData,true))){
	      echo json_encode($respArr);exit;
	    }

	    if(!isset($vehData['success']) || empty($vehData['success']) || $vehData['success'] == false || !isset($vehData['attributes']) || empty($vehData['attributes'])){
	        $respArr['status'] = 'error';
	        $respArr['message'] = 'Invalid Vin Number.';
	        echo json_encode($respArr);exit;
	    }
	    $respArr['status'] = 'success';
	    $respArr['data'] = $vehData['attributes'];
	    $respArr['message'] = 'Success';
	    echo json_encode($respArr);exit;
	}

	public function search_sub_services(){
		header('Content-type: application/json');
		$headers = apache_request_headers();

		$postData = $_GET;

	  	if(!isset($headers['Auth']) || empty($headers['Auth'])){
		    $respArr['status'] = '0';
		    $respArr['message'] = 'Authtoken is Required';
		    echo json_encode($respArr);exit;
		}

		$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 

		if($authRes['status'] == 'error'){
			echo json_encode($authRes);exit;
		}

		$currentpage = 0;
		$start = 0;
		$per_page = 10;

		if(isset($postData['page']) && strlen(trim($postData['page']," ")) > 0 ) {
			$currentpage =  (int)$postData['page'];
			$currentpage = $currentpage==0 ? $currentpage : $currentpage-1;
			$start = $currentpage * $per_page;
		}

		$subserviceresult = $this->Webservice_model->search_sub_services($postData,0,0);
		$subserviceList = $this->Webservice_model->search_sub_services($postData,$start,$per_page);
		
		$service = array();
		$total = 0;


		if($subserviceresult['status'] == 'success'){
			$total = count($subserviceresult['data']);	
		}

		if($total >= $per_page){

			$totalPages = (int)($total % $per_page ==0 ? $total / $per_page :($total / $per_page)+1);
		}
		else{
			$totalPages = 1;
		}

		if($subserviceList['status'] == 'success'){
			$respArr = array('status' => 'success',
						 'message'=>'success',
								'data' => array(
									'sub_services' => $subserviceList['data']
									),
								'meta' => array(
									'total_pages' => $totalPages,
									'total' => $total,
									'current_page' => $currentpage+1,
									'per_page' => $per_page)
								);
		}else if($subserviceList['status'] == 'error'){
			$respArr = array('status' => 'error',
						 'message'=>'No data',
								'data' => array(
									'sub_services' => []
									),
								'meta' => array(
									'total_pages' => $totalPages,
									'total' => $total,
									'current_page' => $currentpage+1,
									'per_page' => $per_page)
								);
		}else{
			$respArr = $subserviceList;
			$respArr['status'] = 'error';
		}
		echo json_encode($respArr);exit;
	}

	public function book_service(){
		header('Content-type: application/json');
		$headers = apache_request_headers();

		$post = file_get_contents("php://input");
	  	$postData = json_decode($post, true);

		if(!isset($headers['Auth']) || empty($headers['Auth'])){
		    $respArr['status'] = '0';
		    $respArr['message'] = 'Authtoken is Required';
		    echo json_encode($respArr);exit;
		}

		$authRes = $this->Webservice_model->get_customer_authtoken($headers['Auth']); 

		if($authRes['status'] == 'error'){
			echo json_encode($authRes);exit;
		}


		if(empty($postData)){
			$respArr = array('status'=>'error','message'=>'All Field is Required');
			echo json_encode($respArr);exit;
		}
		$err = 0;

		if(!isset($postData['booking_id']) || empty($postData['booking_id'])){
		    $err = 1;
		    $msg = 'Booking Id is Required';
		} 
		else if(!isset($postData['total_cost']) || empty($postData['total_cost'])){
		    $err = 1;
		    $msg = 'Total Cost is Required';
		}
		else if(!isset($postData['mechanic_id']) || empty($postData['mechanic_id'])){
		    $err = 1;
		    $msg = 'Mechanic Id is Required';
		}
		else if(!isset($postData['date']) || empty($postData['date'])){
		    $err = 1;
		    $msg = 'Date is Required';
		}
		else if(!isset($postData['time']) && empty($postData['time'])){
		    $err = 1;
		    $msg = 'Time is Required';
		}

		if($err == 1){
		    $respArr['message'] = $msg;
		    echo json_encode($respArr);exit;
		}

		$respData = $this->Webservice_model->book_service($postData);
		echo json_encode($respData);exit;

	}


}

?>