 <?php
class Webservice_model extends CI_Model {
  function __construct() {
    parent::__construct();
    date_default_timezone_set('Asia/Kolkata');
  }

  /*****************************************************************************************/
  /****************************************Mobile API's*************************************/

  public function checkMobAvailability($data = array()){
    $res = array('status'=>'success', 'message'=>'Mobile Number Available');
    if(empty($data)){
      $res = array('status'=>'error','error'=>'901','message'=>'Something went wrong.');
      return $res;
    }

    $result = $this->db->get_where('customers',array('phone'=>$data['phone']));
    
    if(!empty($result) && $result->num_rows() > 0){
      $res=array('status'=>'error','error'=>'902','message'=>'Mobile number already in use.');
    }
    return $res;
  }

  function checkCustomerLogin($userLogData){
    $respArr = array('status'=>0);
    if(empty($userLogData)){
      return $returnStatus;
    }
    $result = $this->db->get_where('customers',array('email'=>$userLogData['email'],'status'=>'1'));
    if(empty($result) || $result->num_rows() < 1 || empty($custData = $result->row())){
      $respArr['status'] = 2;
      return $respArr;
    }
    $this->db->select("customer_id as id,is_otp_verified,phone as phone_number,TRIM(CONCAT(first_name,' ' ,IFNULL(last_name,''))) as user_name");
    $result = $this->db->get_where('customers',array('email'=>$userLogData['email'],
     'password'=>$userLogData['password'],
     'status'=>'1'));
    $respArr['status'] = 3;
    if(!empty($result) && $result->num_rows() == 1 && !empty($custData = $result->row())){

      $authdata = $this->insert_auth($custData->id);
      if($authdata){
        $custData->auth_token = $authdata;
      }
    }
    $respArr['data'] = $custData;
    $respArr['status'] = 1;
    return $respArr;
  }

  function insert_auth($id){
    $static_string = time();
    $authToken = 'Dcarfixs'.sha1($static_string);
    $custData = $this->db->get_where('authtable',array('customer_id'=>$id));
    if(!empty($custData) && $custData->num_rows() > 0){
      $this->db->delete('authtable',array('customer_id'=>$id));
    }
    $this->db->insert('authtable',array('customer_id'=>$id,'authtoken'=>$authToken));
    return $authToken;
  }

  function createCustomer($customer_data = array()){
    $respArr = array('status'=>0);

    if(empty($customer_data)){
      $respArr['status'] = 0;
      return $respArr;
    }

    if(isset($customer_data['email']) && !empty($customer_data['email'])){
      $emailChk = $this->db->get_where('customers',array('email'=>$customer_data['email'],'status !='=>'2'));
      if(!empty($emailChk) && $emailChk->num_rows() > 0){
        $respArr['status'] = 2;
        return $respArr;
      }
    }

    if(isset($customer_data['phone']) && !empty($customer_data['phone'])){
      $phoneChk = $this->db->get_where('customers',array('phone'=>$customer_data['phone'],'status !='=>'2'));
      if(!empty($phoneChk) && $phoneChk->num_rows() > 0){
        $respArr['status'] = 3;
        return $respArr;
      }
    }

    $customer_data['first_name'] = $customer_data['name'];
    unset($customer_data['name']);

    if($this->db->insert('customers',$customer_data)){

      $last_id = $this->db->insert_id();
      $this->db->select("TRIM(CONCAT(first_name,' ' ,IFNULL(last_name,''))) as name,customer_id as user_id");
      $custData = $this->db->get_where('customers',array('customer_id'=>$last_id))->row();

      $authdata = $this->insert_auth($last_id);

      $custData->auth_token = $authdata;

      $respArr['data'] = $custData;
      $respArr['status'] = 1;
    }

    return $respArr;
  }

  public function get_customer_authtoken($auth = ''){
    $respArr = array('status'=>0,'error'=>'901','message'=>'Something Went Wrong.');

    if(empty($auth)){
      return $respArr;
    }

    $auth = $this->db->get_where('authtable',array('authtoken'=>$auth));
    if(!empty($auth) && $auth->num_rows() >= 1 && !empty($custAuth = $auth->row_array())){
      $respArr['status'] = 'success';
      $respArr['data'] = $custAuth;
    }else{
      $respArr['status'] = 'error';
      $respArr['error'] = '902';
      $respArr['message'] = 'Authtoken is not Valid';
    }
    return $respArr;
  }

  public function getBookedService($id = ''){
    $respArr = array('status'=>'error','message'=>'Something Went Wrong.');

    if(empty($id)){
      return $respArr;
    }

    $this->db->select('booking_id as id,scheduled_date as date,scheduled_time as time');
    $bookData = $this->db->get_where('bookings',array('customer_id'=>$id))->result_array();

    if(!empty($bookData) && (count($bookData) > 0)){
      $respArr['status'] = 'success';
      $respArr['data'] = $bookData;
      $respArr['message'] = 'success';
    }

    return $respArr;
  }

  public function addVehicleDetails($postData = array(),$customer_id = ''){
    $respArr = array('status'=>'error','message'=>'Something Went Wrong.');

    if(empty($postData)){
      return $respArr;
    }

    $car_name = $postData['vehicle_year'].' '.$postData['vehicle_make'].' '.$postData['vehicle_model'];

    $vehJson = array('vehicle'    => $car_name,
     'attributes' => 
     array(
      'Year'      => $postData['vehicle_year'],
      'Make'      => $postData['vehicle_make'],
      'Trim'      => $postData['vehicle_trim'],
      'Model'     => $postData['vehicle_model'],
      'Engine'    => $postData['engine_no'])
   );

    $insert_array = array('customer_id'   => $customer_id,
      'car_name'      => $car_name,
      'car_model'     => $postData['vehicle_model'],
      'car_maker'     => $postData['vehicle_make'],
      'car_loc_lat'   => $postData['car_loc_lat'],
      'car_loc_lng'   => $postData['car_loc_lng'],
      'car_location'  => $postData['car_location'],
      'vehicle_data'  => json_encode($vehJson),
      'car_model_year'=> $postData['vehicle_year'],
      'status'        => '3');

    if($this->db->insert('customer_vehicle',$insert_array)){
      $last_id = $this->db->insert_id();

      $book_data = array(
       'mileage'          => $postData['mileage'],
       'customer_id'      => $customer_id,
       'customer_veh_id'  => $last_id,
       'status'           => '5');

      if($this->db->insert('bookings',$book_data)){
        $book_id = $this->db->insert_id();

        $respArr['status'] = 'success';
        $respArr['message'] = 'success';
        $respArr['data']['booking_id'] = $book_id;
        return $respArr;
      }
    }
    return $respArr;
  }

  public function get_service_list($postData = '',$start,$per_page){

    $respArr = array('status'=>'error','message'=>'Something Went Wrong.');

    $this->db->select("issue_id as id,issue as service_name,IF(issue_image != NULL OR issue_image != '' , concat('".base_url()."',issue_image) , '') as icon");
    if(!empty($postData['query'])){
      $where = "issue LIKE '".$postData['query']."%'";
      $this->db->where($where);
    }
    $this->db->where('status','1');
    if($start != 0 || $per_page != 0){
      $this->db->limit($per_page,$start);
    }
    $service = $this->db->get('issues');

    if(!empty($service) && !empty($serviceData = $service->result_array())){
      $respArr['status'] = 'success';
      $respArr['message'] = 'success';
      $respArr['data']= $serviceData;
    }
    return $respArr;
  }

  public function search_sub_services($postData = '',$start,$per_page){

    $respArr = array('status'=>'error','message'=>'Something Went Wrong.');

    if(!isset($postData['service_id']) && empty($postData['service_id'])){
      $respArr['status'] = 1;
      $respArr['message'] = 'Service Id is Required';
      return $respArr;
    }

    $this->db->select("issue_cat_id as id,issue_category as sub_service_name,IF(issue_cat_image != NULL OR issue_cat_image != '' , concat('".base_url()."',issue_cat_image) , '') as icon");
    if(!empty($postData['query'])){
      $where = "issue_category LIKE '".$postData['query']."%'";
      $this->db->where($where);
    }

    if($start != 0 || $per_page != 0){
      $this->db->limit($per_page,$start);
    }
    $subservice = $this->db->get_where('issues_category',array('status'=>'1','issue_id'=>$postData['service_id']));

    if(!empty($subservice) && !empty($subserviceData = $subservice->result_array())){
      $respArr['status'] = 'success';
      $respArr['message'] = 'success';
      $respArr['data']= $subserviceData;
    }
    return $respArr;
  }

  public function book_service($postData){
    $respArr = array('status'=>'error','message'=>'Something Went Wrong.');

    if(empty($postData)){
      $respArr['message'] = 'All Field is required';
      return $respArr;
    }

    $insert_array = array('cost'=>$postData['total_cost'],'mechanic_id'=>$postData['mechanic_id'],'scheduled_date'=>$postData['date'],'scheduled_time'=>$postData['time']);

    if($this->db->update('bookings',$insert_array,array('booking_id'=>$postData['booking_id']))){
      $this->db->select("bookings.scheduled_time,bookings.scheduled_date,customer_vehicle.car_model as vehicle_model,customer_vehicle.car_maker as vehicle_make,customer_vehicle.car_model_year as vehicle_year,customer_vehicle.vehicle_data,TRIM(concat(mechanic.first_name,' ',IFNULL(mechanic.last_name,''))) as mechanic_name,mechanic_shop.shop_name as mechanic_shop,mechanic.address,mechanic.phone,admin_users.profile_image as image,bookings.mileage,bookings.issues_selected");
      $this->db->join('customer_vehicle','customer_vehicle.customer_veh_id = bookings.customer_veh_id');
      $this->db->join('mechanic','bookings.mechanic_id = mechanic.mechanic_id');
      $this->db->join('admin_users','admin_users.id = mechanic.mechanic_id');
      $this->db->join('mechanic_shop','mechanic_shop.shop_id = mechanic.shop_id','left');
      $mech_data = $this->db->get_where('bookings',array('booking_id'=>$postData['booking_id']));

      if(!empty($mech_data) && !empty($mechanic_data = $mech_data->row_array())){

        $mech_veh_data = json_decode($mechanic_data['vehicle_data']);
        $mechanic_data['engine_no'] = $mech_veh_data->attributes->Engine;
        $mechanic_data['vehicle_trim'] = $mech_veh_data->attributes->Trim;
        unset($mechanic_data['vehicle_data']);

        $mechanic_data['services'] = json_decode($mechanic_data['issues_selected']);
        unset($mechanic_data['issues_selected']);
        $respArr['status'] = 'success';
        $respArr['message'] = 'success';
        $respArr['data'] = $mechanic_data;
      }
      $respArr['message'] = 'Booking Id does\'t Exist';
    } 
    return $respArr;
  }
}

?>