<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bookings extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Booking_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}

    public function listBookings($mechanic_id = ''){
        if(!empty($mechanic_id)){
            $mechanic_id = (!is_numeric($mechanic_id))?decode_param($mechanic_id):$mechanic_id;
        }
        $mechanic_data = '';
        if($this->session->userdata('user_type') == 1){
            $this->load->model('Mechanic_model');
            $mechanic_data = $this->Mechanic_model->getMechanic('',0);
            if(isset($_POST['mechanic_id']) && !empty($_POST['mechanic_id'])){
                $mechanic_id = $_POST['mechanic_id'];
                $mechanic_id = (!is_numeric($mechanic_id))?decode_param($mechanic_id):$mechanic_id;
            }
        } else {
            $mechanic_id = $this->session->userdata('id');
        }

        $template['page'] = 'Bookings/list-booking';
        $template['pTitle'] = "View Bookings";
        $template['pDescription'] = "View and Manage Bookings"; 

        $template['menu'] = "Bookings Management";
        $template['smenu'] = "View Bookings";

        $template['mechanic_id'] = ($this->session->userdata('user_type')==1 && 
                                    empty($mechanic_id))?'':$mechanic_id;
        $template['mechanic_data'] = $mechanic_data;
        $template['bookingData'] = $this->Booking_model->getMechBookings($mechanic_id,'','0,1,3,4');
        //pr($template['bookingData']);
        $this->load->view('template',$template);
    }

    public function changeBookingStatus($booking_id = '', $status = '', $mechanic_id = ''){
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
        $mechanic_id = ($this->session->userdata('user_type') == 1 && !empty($mechanic_id))?$mechanic_id:'';

        if(empty($booking_id) || $status == ''){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Bookings/listBookings/'.$mechanic_id));
        }

        $booking_id = decode_param($booking_id);
        $status = $this->Booking_model->changeStatus($booking_id,$status);
        if(!$status){
            $this->session->set_flashdata('message',$flashMsg);
        }
        redirect(base_url('Bookings/listBookings/'.$mechanic_id));
    }

    public function getBooking(){
        $return_arr = array('status'=>'0');
        if(!isset($_POST) || empty($_POST) || !isset($_POST['booking_id']) || empty($_POST['booking_id']) ||
           empty(decode_param($_POST['booking_id']))){
            echo json_encode($return_arr);exit;
        }
        $booking_id = decode_param($_POST['booking_id']);
        $mechanic_id = ($this->session->userdata('user_type')==2)?$this->session->userdata('id'):'';
        $bookingData = $this->Booking_model->getMechBookings($mechanic_id,$booking_id,'0,1,3,4');
        
        if(!empty($bookingData)){
            $return_arr['status'] = 1;
            $return_arr['data'] = $bookingData;
            echo json_encode($return_arr);exit;
        }
        echo json_encode($return_arr);exit;
    }

    public function insertCustomQuote(){
        $return_arr = array('status'=>'error');
        parse_str($_POST['data'], $output);

        if(!isset($output) || empty($output)){
            echo json_encode($return_arr);exit;
        }

        $return_arr = $this->Booking_model->insertCustomQuote($output);
        echo json_encode($return_arr);exit;
    }

    public function getCustomData(){
        $return_arr = array('status'=>'0');
        if(!isset($_POST) || empty($_POST) || !isset($_POST['custom_id']) || empty($_POST['custom_id']) ||
           empty(decode_param($_POST['custom_id']))){
            echo json_encode($return_arr);exit;
        }
        $custom_booking_id = decode_param($_POST['custom_id']);
        $CustData = $this->Booking_model->getCustomData($custom_booking_id);
        if(!empty($CustData)){
            $return_arr['status'] = 1;
            $return_arr['data'] = $CustData;
            echo json_encode($return_arr);exit;
        }
        echo json_encode($return_arr);exit;
    }

    public function exportBookingData($mechanic_id = ''){
        $bookingData = $this->Booking_model->getMechBookings($mechanic_id,'','0,1,3,4');
        if(empty($bookingData)){
            return;
        }

        $header = array('Booking ID','Name','Current Milage','Service Free','Scheduled Date','Scheduled Time','Customer Phone','Customer Mail','Car Name','Car Model','Car Model Year','Car Location','Selected Issue','Status','Mechanic Name');

        $file = 'bookData_'.time().'.csv';
        $fpoint = fopen('php://memory', 'w');
        fputcsv($fpoint, $header, ',');

        foreach($bookingData AS $mechanic){
            $new = array();
            $bookData = $this->Booking_model->getMechBookings($mechanic_id,$mechanic->booking_id,'0,1,3,4');
            foreach (json_decode($bookData->issues_selected) as $key => $value) {
                $new[] = $value->issue_category;
            }
            $status = 'Pending';
            switch ($bookData->status) {
                case '0': $status = 'Pending';break;
                case '1': $status = 'Accepted ';break;
                case '2': $status = 'Deleted';break;
                case '3': $status = 'Completed';break;
                case '4': $status = 'Cancelled';break;
                case '5': $status = 'Payment Processing';break;
            }

            $data = array();
            $data[] = $mechanic->booking_id;
            $data[] = $bookData->custFirstName.' '.$mechanic->custLastName;
            $data[] = $mechanic->mileage;
            $data[] = $bookData->cost;
            $data[] = $bookData->scheduled_date;
            $data[] = $bookData->scheduled_time;
            $data[] = $bookData->phone;
            $data[] = $bookData->email;
            $data[] = $bookData->car_model.' '.$bookData->car_maker.' '.$bookData->car_model_year;
            $data[] = $bookData->car_maker;
            $data[] = $bookData->car_model_year;
            $data[] = $bookData->car_location;
            $data[] = implode(',',$new);
            $data[] =  $status;
            if($bookData->status == '1'){
                $data[] = $bookData->mechanic_data[0]->first_name.' '.$bookData->mechanic_data[0]->last_name;
            }
            
            fputcsv($fpoint, $data, ',');
        }
        fseek($fpoint, 0);
        header('Content-Type: application/csv');
        header('Content-Disposition: attachement; filename="' . $file . '";');
        fpassthru($fpoint);
    }
}
?>