<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Orders extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Order_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}

    public function listOrders(){

        $template['page'] = 'Orders/list_orders';
        $template['pTitle'] = "View Orders";
        $template['pDescription'] = "View and Manage Orders"; 

        $template['menu'] = "Order Management";
        $template['smenu'] = "View Orders";

        $template['orderData'] = $this->Order_model->getOrders();
        $this->load->view('template',$template);
    }

    public function getOrderData(){
        $return_arr = array('status'=>'0');
        if(!isset($_POST) || empty($_POST) || !isset($_POST['order_id']) || empty($_POST['order_id']) || empty(decode_param($_POST['order_id']))){
            echo json_encode($return_arr);exit;
        }
        $order_id = decode_param($_POST['order_id']);
        $return_arr['order_data'] = $this->Order_model->getOrderDetails($order_id);
        $return_arr['product_image'] = $this->Order_model->getProductImage($order_id);
        
        if(!empty($return_arr)){
            $return_arr['status'] = 1;
            echo json_encode($return_arr);exit;
        }
        echo json_encode($return_arr);exit;
    }

    public function changeOrderStatus(){
        $status = 0;
        $return_arr = array('status'=>'0');
        if(!isset($_POST) || empty($_POST) || !isset($_POST['order_id']) || empty($_POST['order_id']) || empty(decode_param($_POST['order_id']))){
            echo json_encode($return_arr);exit;
        }
        $status = $this->Order_model->changeOrderStatus($_POST);
        
        $return_arr['status'] = $status;
        echo json_encode($return_arr);exit;
    }

    public function exportOrderData(){
        $orderData = $this->Order_model->getOrders();
        if(empty($orderData)){
            return;
        }

        $header = array('Order ID','Name','Product Name','Brand Name','Short Description','Quantity','Amount','Status','Expected Delivery','Delivered');

        $file = 'orderData_'.time().'.csv';
        $fpoint = fopen('php://memory', 'w');
        fputcsv($fpoint, $header, ',');

        foreach($orderData AS $order){
            $new = array();
            $odrData = $this->Order_model->getOrderDetails($order->order_id);

            $data = array();
            $data[] = $odrData->format_order_id;
            $data[] = $odrData->customer_name;
            $data[] = $odrData->product_name;
            $data[] = $odrData->brand_name;
            $data[] = $odrData->short_description;
            $data[] = $odrData->quantity;
            $data[] = $odrData->amount;
            $data[] = $odrData->ord_status;
            if($odrData->status == '2' || $odrData->status == '3' || $odrData->status == '4'){
                $data[] = $odrData->expected_delivery;
            }
            if($odrData->status == '5' || $odrData->status == '6'){    
                $data[] = $odrData->delivered;
            }
            fputcsv($fpoint, $data, ',');
        }
        fseek($fpoint, 0);
        header('Content-Type: application/csv');
        header('Content-Disposition: attachement; filename="' . $file . '";');
        fpassthru($fpoint);
    }
}
?>