 <?php
 class Webservice_mechanic_model extends CI_Model {
  function __construct() {
    parent::__construct();
    date_default_timezone_set('Asia/Kolkata');
}

/***************************************************************************************/
/****************************************Mobile API's***********************************/

function checkMechanicLogin($userLogData){
    $respArr = array('status'=>'error');
    if(empty($userLogData)){
      return $respArr;
  }
  $this->db->select("MCH.mechanic_id as user_id,TRIM(CONCAT(MCH.first_name,' ' ,IFNULL(MCH.last_name,''))) as name,MCH.email_id,MCH.phone as phone_number,IFNULL(MCHSHP.shop_name,'') as workshop_name,MCH.city,MCH.location as place");
  $this->db->from('admin_users as AU');
  $this->db->join('mechanic as MCH','MCH.mechanic_id = AU.id');
  $this->db->join('mechanic_shop as MCHSHP','MCHSHP.shop_id = MCH.shop_id','LEFT');
  $this->db->where(array('AU.username'=>$userLogData['user_name'],'AU.password'=>$userLogData['password']));
  $result = $this->db->get();

  if(empty($result) || $result->num_rows() < 0 || empty($mechData = $result->row())){
      $respArr['message'] = "Username or Password is Incorrect";
      return $respArr;
  }

  $authdata = $this->insert_auth($mechData->user_id);
  if($authdata){
      $mechData->auth_token = $authdata;
      $respArr['data'] = $mechData;
      $respArr['status'] = 'success';
  }
  return $respArr;
}

public function insert_auth($id){
    $static_string = time();
    $authToken = 'Dcarfixs'.sha1($static_string);
    $mechData = $this->db->get_where('authtable_mechanic',array('mechanic_id'=>$id));
    if(!empty($mechData) && $mechData->num_rows() > 0){
      $mechData = $mechData->row();
      $authToken = $mechData->authtoken;
  } else {
      $this->db->insert('authtable_mechanic',array('mechanic_id'=>$id,'authtoken'=>$authToken));
  }

  return $authToken;
}

public function get_mechanic_authtoken($auth = ''){
    $respArr = array('status'=>0,'error'=>'901','message'=>'Something Went Wrong.');
    if(empty($auth)){
      return $respArr;
  }
  $auth = $this->db->get_where('authtable_mechanic',array('authtoken'=>$auth));
  if(!empty($auth) && $auth->num_rows() >= 1 && !empty($mechAuth = $auth->row_array())){
      $respArr['status'] = 'success';
      $respArr['data'] = $mechAuth;
  }else{
      $respArr['status'] = 'error';
      $respArr['error'] = '902';
      $respArr['message'] = 'Authtoken is not Valid';
  }
  return $respArr;
}

public function getBookedService($postData = array(),$start = '',$per_page = '',$type=0,$status=1){
    $respArr = array('status'=>'error','message'=>'Something Went Wrong.. Try Again Later');
    if(empty($postData)){
      $respArr['message'] = "All Field is Required";
      return $respArr;
  }

  $where = array('BUK.status'=>$status,'MCHBUK.mechanic_id'=>$postData['mechanic_id']);
  if(isset($postData['service_id']) && !empty($postData['service_id'])){
      $where['BUK.booking_id'] = $postData['service_id'];
  }

  if($type == 1){
      //$where['BUK.scheduled_date'] = date('Y-m-d');
      $this->db->where('BUK.scheduled_date >=', date('Y-m-d'));
      $this->db->order_by('BUK.scheduled_date','ASC');
  }
    // else if($type == 2){
    //   $where['BUK.scheduled_date'] = date("Y-m-d", strtotime('tomorrow'));
    // }

  $this->db->select("BUK.scheduled_date as date,BUK.scheduled_time as time,BUK.booking_id as service_id,CSTVEH.car_name,BUK.mileage,BUK.issues_selected,BUK.custom_issue_data,BUK.service_type as type,MCHBUK.amount as total_amount,TRIM(CONCAT(CUST.first_name,' ' ,IFNULL(CUST.last_name,''))) as customer_name,CUST.phone as phone_number,CSTVEH.vehicle_data");
  $this->db->from('bookings as BUK');
  $this->db->join('customers as CUST','CUST.customer_id = BUK.customer_id');
  $this->db->join('customer_vehicle as CSTVEH','CSTVEH.customer_veh_id = BUK.customer_veh_id');
  $this->db->join('mechanic_booking as MCHBUK','MCHBUK.booking_id = BUK.booking_id');
  $this->db->join('mechanic AS MCH','MCHBUK.mechanic_id=MCH.mechanic_id');
  $this->db->where($where);
  if($start != 0 || $per_page != 0){
      $this->db->limit($per_page,$start);
  }
  $bookData = $this->db->get();
  if(!empty($bookData) && $bookData->num_rows() > 0){
      $bookData = $bookData->result_array();
      foreach ($bookData as $key => $value) {
        $issues_selected = json_decode($value['issues_selected']);
        $custom_issue_data = json_decode($value['custom_issue_data']);
        $bookData[$key]['service_image'] = $custom_issue_data->optionalImages;
        $bookData[$key]['service_message'] = $custom_issue_data->optionlaDescription;
        unset($bookData[$key]['issues_selected'],$bookData[$key]['custom_issue_data']);
        $new = array();

        foreach ($issues_selected as $issue_key => $issue_value) {
          $sql = "SELECT IC.*, MI.custom_description, MI.custom_service_fee
          FROM issues_category AS IC
          LEFT JOIN mechanic_issues AS MI ON (MI.issue_cat_id=IC.issue_cat_id AND 
          MI.mechanic_id='".$postData['mechanic_id']."' AND MI.status='1')
          WHERE IC.status='1' AND IC.issue_cat_id='".$issue_value->sub_issue_id."'";
          $issue_data = $this->db->query($sql)->row();
          if(!empty($issue_data)){
            if($issue_data->custom_description != '' && $issue_data->custom_service_fee != ''){
              $new[$issue_key]['description'] = $issue_data->custom_description;
              $new[$issue_key]['service_fee'] = $issue_data->custom_service_fee;
          }else{
              $new[$issue_key]['description'] = $issue_data->default_description;
              $new[$issue_key]['service_fee'] = $issue_data->default_service_fee;
          }
          $new[$issue_key]['issue_name'] =  $issue_data->issue_category;
      }

      $bookData[$key]['service_name'] = $new; 
  }
}
$respArr['status'] = 'success';
$respArr['message'] = 'success';
$respArr['data'] = $bookData;
}
return $respArr;
}

public function mechanic_logout($mechanic_id){
    $respArr = array('status'=>'error');

    $status = $this->db->delete('authtable_mechanic',array('mechanic_id'=>$mechanic_id));
    if($status){
      $respArr['status'] = "success";
      $respArr['message'] = "Logged Out Successfully";
  }
  return $status;
}

public function forgot_password($username){
    $respArr = array('status'=>'error');

    $result = $this->db->query("SELECT MCH.phone as phone_number,AU.username as user_name FROM admin_users AS AU INNER JOIN mechanic AS MCH ON MCH.mechanic_id = AU.id WHERE AU.username LIKE '$username'");
    if(empty($result) || $result->num_rows() < 0 || empty($result = $result->row())){
      $respArr['message'] = "Username Doesnot Exist";
      return $respArr;
  }
  $respArr['status'] = "success";
  $respArr['message'] = "success";
  $respArr['data'] = $result;
  return $respArr;
}

public function change_password($postData = array())
{
    $respArr = array('status'=>'error');

    $result = $this->db->query("SELECT * FROM admin_users WHERE username LIKE '".$postData['user_name']."'");
    if(empty($result) || $result->num_rows() < 0 || empty($result = $result->row())){
        $respArr['message'] = "Username doesnot Exist";
        return $respArr;
    } 

    if($this->db->update('admin_users',array('password'=>md5($postData['password'])),array('id'=>$result->id))){
        $respArr['status'] = "success";
        $respArr['message'] = "Password Updated Successfully";
    }
    return $respArr;
}

public function start_service($postData = array(),$type = 0){
    $respArr = array('status'=>'error');
    if(empty($postData)){
        return $respArr;
    }

    $status = ($type == '1')?3:1;
    $cost = ($postData['emergency'] == '2')?$postData['amount']:'';
    if($this->db->update('bookings',array('service_type'=>$postData['emergency'],'cost'=>$cost,'status'=>$status),array('booking_id'=>$postData['service_id']))){
        $respArr['status'] = "success";
        $respArr['message'] = ($type == '1')?"Service Completed Successfully":"Service Started Successfully";
    }
    return $respArr;
}

}
?>
