<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
    <h1> <?= $page_title ?>
        <small><?= $page_desc ?></small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="javascript:void(0);" ><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Dashboard</li>
    </ol>
    </section>
    <?php 
        if($this->session->flashdata('message')) { 
        $flashdata = $this->session->flashdata('message'); ?>
        <br><div class="alert alert-<?= $flashdata['class'] ?>">
           <button class="close" data-dismiss="alert" type="button">×</button>
           <?= $flashdata['message'] ?>
        </div>
    <?php } ?>  
    <section class="content">
        <div class="row">
            <?php if(isset($customerCount) && !empty($customerCount)){ ?>
                <div class="col-lg-3 col-xs-6">
                    <div class="small-box bg-yellow">
                        <div class="inner">
                            <h4>Users</h4>
                            <p><?php 
                                    echo 'Total : '. $customerCount ?></p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                        <a href="<?= base_url('Customer/listCustomerUsers') ?>" class="small-box-footer ">More info <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            <?php } ?>

            <?php if(isset($bookingCount) && !empty($bookingCount)){ ?>
                <div class="col-lg-3 col-xs-6">
                    <div class="small-box bg-green">
                        <div class="inner">
                            <h4>Total Bookings</h4> 
                            <p>
                                <?php 
                                    echo 'Total : '.$bookingCount; 
                                ?>
                            </p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-pie-graph"></i>
                        </div>
                        <a href="<?= base_url('Bookings/listBookings') ?>" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            <?php } ?>

            <?php if(isset($completeBukngCnt) && !empty($completeBukngCnt)){ ?>
                <div class="col-lg-3 col-xs-6">
                    <div class="small-box bg-aqua">
                        <div class="inner">
                            <h4>Completed Bookings</h4>
                            <p><?php 
                                    echo 'Total : '. $completeBukngCnt ?></p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-bag"></i>
                        </div>
                        <a href="<?= base_url('Bookings/listBookings') ?>" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            <?php } ?>

            <?php if(isset($pendingBukngCnt) && !empty($pendingBukngCnt)){ ?>
                <div class="col-lg-3 col-xs-6">
                    <div class="small-box bg-blue">
                        <div class="inner">
                            <h4>Pending Bookings</h4>
                            <p><?php 
                                    echo 'Total : '. $pendingBukngCnt ?></p>
                        </div>
                        <div class="icon">
                            <i class="ion  ion-stats-bars"></i>
                        </div>
                        <a href="<?= base_url('Bookings/listBookings') ?>" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            <?php } ?>

            <?php if(isset($shopCount) && !empty($shopCount)){ ?>
                <div class="col-lg-3 col-xs-6">
                    <div class="small-box bg-blue">
                        <div class="inner">
                            <h4>Mechanic Shops</h4>
                            <p><?php 
                                    echo 'Total : '. $shopCount ?></p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-bag"></i>
                        </div>
                        <a href="<?= base_url('Shop/viewShops') ?>" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            <?php } ?>


            <?php if(isset($mobileVendors) && !empty($mobileVendors)){ ?>
                <div class="col-lg-3 col-xs-6">
                    <div class="small-box bg-yellow">
                        <div class="inner">
                            <h4> Mobile Vendors</h4>
                            <p><?php 
                                    echo 'Total : '. $mobileVendors ?></p>
                        </div>
                        <div class="icon">
                            <i class="ion  ion-stats-bars"></i>
                        </div>
                        <a href="<?= base_url('Mechanic/viewMechanics') ?>" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            <?php } ?>

            <?php if(isset($mobileMechanics) && !empty($mobileMechanics)){ ?>
                <div class="col-lg-3 col-xs-6">
                    <div class="small-box bg-red">
                        <div class="inner">
                            <h4>Mobile Mechanics</h4>
                            <p><?php 
                                    echo 'Total : '. $mobileMechanics ?></p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-pie-graph"></i>
                        </div>
                        <a href="<?= base_url('Mechanic/viewMechanics') ?>" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            <?php } ?>

            <?php if(isset($productCount) && !empty($productCount)){ ?>
                <div class="col-lg-3 col-xs-6">
                    <div class="small-box bg-green">
                        <div class="inner">
                            <h4>Product Count</h4>
                            <p><?php 
                                    echo 'Total : '. $productCount ?></p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-bag"></i>
                        </div>
                        <a href="<?= base_url('Product/viewProducts') ?>" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            <?php } ?>

             <?php if(isset($productSold) && !empty($productSold)){ ?>
                <div class="col-lg-3 col-xs-6">
                    <div class="small-box bg-red">
                        <div class="inner">
                            <h4>Product Sold</h4>
                            <p><?php 
                                    echo 'Total : '. $productSold ?></p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                        <a href="<?= base_url('Orders/listOrders') ?>" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            <?php } ?>

            <div class="col-md-6" id="order_report">
                <div class="box box-info">
                    <div class="box-header with-border">
                      <h3 class="box-title">Order Sales Report</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <div class="box-body chart-responsive">
                        <div class="chart" id="line-chart" style="height: 300px;"></div>
                    </div>
                </div>
            </div>

            <div class="col-md-6" id="booking_report">
                <div class="box box-info">
                    <div class="box-header with-border">
                      <h3 class="box-title">Booking Sales Report</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <div class="box-body chart-responsive">
                        <div class="chart" id="line-chart-booking" style="height: 300px;"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script type="text/javascript">
$(function () {
  jQuery.ajax({
    type: "POST",
    url: base_url + 'Dashboard/getOrderSalesReportCount',
    success: function (data) {
      if(data == '1' || data == ''){
        $('#order_report').addClass('hide');
        return false;
      }
      var data = jQuery.parseJSON(data);
      var line = new Morris.Line({
        element: 'line-chart',
        resize: true,
        data: data,
        xkey: 'y',
        ykeys: ['item1'],
        labels: ['Total Orders'],
        lineColors: ['#3c8dbc'],
        hideHover: 'auto'
      });
    }
  })
})

$(function () {
  jQuery.ajax({
    type: "POST",
    url: base_url + 'Dashboard/getBookingReportCount',
    success: function (data) {
      if(data == '1'){
        $('#booking_report').addClass('hide');
        return false;
      }
      var data = jQuery.parseJSON(data);
      var line = new Morris.Line({
        element: 'line-chart-booking',
        resize: true,
        data: data,
        xkey: 'y',
        ykeys: ['item1'],
        labels: ['Total Bookings'],
        lineColors: ['#701d9a'],
        hideHover: 'auto'
      });
    }
  })
})
</script>