<div class="content-wrapper">
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php 
        $url = (!isset($model_id) || empty($model_id))?'Vehicle/createModel':'Vehicle/updateVehModel/'.$model_id;
        if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
            <button class="close" data-dismiss="alert" type="button">×</button>
            <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-body">
            <form role="form" action="<?= base_url($url) ?>" method="post" 
              class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Select Brand</label>
                  <select name="veh_brand_id" class="form-control required" placeholder="Select Brand" required="">
                    <option selected disabled>Choose a Brand</option>
                    <?php 
                      foreach ($vehBrand_data as $brand) {
                        $select = (isset($vehModel_data->veh_brand_id) && $brand->veh_brand_id==
                          $vehModel_data->veh_brand_id)?'selected':'';
                        echo '<option '.$select.' value="'.$brand->veh_brand_id.'">'.
                                $brand->maker.
                             '</option>';
                      }
                    ?>
                  </select> 
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Model Name</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change"
                  data-parsley-minlength="2" data-parsley-pattern="^[a-zA-Z0-9\ . _ - ' \/]+$" 
                  name="model" required="" value="<?= (isset($vehModel_data->model))?$vehModel_data->model:'' ?>"placeholder="Enter Vehicle Model">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Trim</label>
                  <input type="text" class="form-control required" name="trim" required="" value="<?= (isset($vehModel_data->trim))?$vehModel_data->trim:'' ?>"placeholder="Enter Vehicle Trim">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Engine</label>
                  <input type="text" class="form-control required" name="engine" required="" value="<?= (isset($vehModel_data->engine))?$vehModel_data->engine:'' ?>"placeholder="Enter Vehicle Engine">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-12">      
                <div class="box-footer textCenterAlign">
                  <button type="submit" class="btn btn-primary">Submit</button>
                  <a href="<?= base_url('Vehicle/viewVehModel') ?>" class="btn btn-primary">Cancel</a>
                </div>        
              </div>        
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>