<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Dashboard_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}
	
	public function index() {
		$template['page'] = 'Dashboard/Dashboard';
        $template['page_desc'] = "Control Panel";
        $template['page_title'] = "Dashboard";
        $template['bookingCount'] = $this->Dashboard_model->getBookingCount();
        $template['shopCount'] = $this->Dashboard_model->getMechShpCount();
        $template['completeBukngCnt'] = $this->Dashboard_model->getCompletedBookingCount();
        $template['pendingBukngCnt'] = $this->Dashboard_model->getPendingBookingCount();
        $template['mobileVendors'] = $this->Dashboard_model->getMbleVndrsCount();
        $template['mobileMechanics'] = $this->Dashboard_model->getMbleMchnsCount();
        $template['customerCount'] = $this->Dashboard_model->getCustomerCount();
        $template['productCount'] = $this->Dashboard_model->getProductCount();
        $template['productSold'] = $this->Dashboard_model->getProductSoldCount();
		$this->load->view('template',$template);
	}

	public function getOrderSalesReportCount(){
		$result = $this->Dashboard_model->getSalesReportCount();
		if(count($result) > 0){	
			echo $result;
		}else{
			echo 1;
		}
	}

	public function getBookingReportCount(){
		$result = $this->Dashboard_model->getBookingReportCount();
		if(count($result) > 0){	
			echo $result;
		}else{
			echo 1;
		}
	}
	
	
}
?>
