<div class="content-wrapper">
  <section class="content-header">
    <h1><?= $pTitle ?><small><?= $pDescription ?></small></h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php 
        $url = (!isset($mechanic_id) || empty($mechanic_id))?'Mechanic/createMechanic':'Mechanic/updateMechanic/'.$mechanic_id;
        if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
            <button class="close" data-dismiss="alert" type="button">×</button>
            <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-body">
            <form role="form" action="<?= base_url($url) ?>" method="post" 
              class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <div class="col-md-12">  
                <div class="box-header with-border padUnset">
                  <h3 class="box-title">Basic Details</h3>
                </div><br>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Display Name</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change" data-parsley-minlength="2" name="display_name" required="" 
                  placeholder="Enter Display Name" value="<?= (isset($user_data->display_name))?$user_data->display_name:'' ?>">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
                <div class="form-group">
                  <label>User Name</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change"
                  data-parsley-minlength="2" name="username" required="" value="<?= (isset($user_data->username))?$user_data->username:'' ?>"
                  data-parsley-pattern="^[a-zA-Z0-9\ . _ @  \/]+$" placeholder="Enter User Name">
                  <span class="glyphicon  form-control-feedback"></span>
                </div>
                <?php if(!isset($mechanic_id)){ ?>
                <div class="form-group">
                  <label>Password</label>
                  <input type="password" class="form-control required" name="password" placeholder="Password" required="">
                  <span class="glyphicon  form-control-feedback"></span>
                </div>  
              <?php } ?>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Profile Picture</label>
                  <div class="col-md-12" style="padding-bottom:10px;">
                    <div class="col-md-3">
                      <img id="image_id" src="<?= (isset($user_data->profile_image))?base_url($user_data->profile_image):'' ?>" onerror="this.src='<?=base_url("assets/images/user_avatar.jpg")?>';" height="75" width="75" />
                    </div>
                    <div class="col-md-9" style="padding-top: 25px;">
                      <input name="profile_image" type="file" accept="image/*" onchange="setImg(this,'image_id');" />
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-12">  
                <div class="box-header with-border padUnset">
                  <h3 class="box-title">Personal Details</h3>
                </div><br>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>First Name</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change"
                  data-parsley-minlength="2" data-parsley-pattern="^[a-zA-Z0-9\ . _ - ' \/]+$" 
                  name="first_name" required="" value="<?= (isset($user_data->first_name))?$user_data->first_name:'' ?>"placeholder="Enter First Name">
                  <span class="glyphicon form-control-feedback"></span>
                </div>  
                <div class="form-group">
                  <label>Email</label>
                  <input type="email" class="form-control required" data-parsley-trigger="change"  
                  data-parsley-minlength="2" required="" name="email_id" placeholder="Enter email ID"  value="<?= (isset($user_data->email_id))?$user_data->email_id:'' ?>">
                  <span class="glyphicon form-control-feedback"></span>
                </div> 
                <div class="form-group">
                  <label>Address</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change" 
                  data-parsley-pattern="^[a-zA-Z0-9\ , # - . _ @  \/]+$" required="" 
                  data-parsley-minlength="2" name="address" placeholder="Enter Address" 
                  value="<?= (isset($user_data->address))?$user_data->address:'' ?>">
                  <span class="glyphicon form-control-feedback"></span>
                </div> 
                <div class="form-group">
                  <label>City</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change"  
                  data-parsley-minlength="2" data-parsley-pattern="^[a-zA-Z0-9\ , - . _ ' \/]+$" 
                  required="" name="city" placeholder="Enter City" value="<?= (isset($user_data->city))?$user_data->city:'' ?>">
                  <span class="glyphicon form-control-feedback"></span>
                </div> 
                <div class="form-group">
                  <label>State</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change"  
                  data-parsley-minlength="2" data-parsley-pattern="^[a-zA-Z\ - ' \/]+$" 
                  required=""  name="state" placeholder="Enter email ID" value="<?= (isset($user_data->state))?$user_data->state:'' ?>">
                  <span class="glyphicon form-control-feedback"></span>
                </div> 
                <div class="form-group">
                  <label>Functional Area</label>
                  <input type="text" class="form-control" data-parsley-trigger="change" 
                  id="loc_search_1" name="location" placeholder="Choose Functional Area" value="<?= (isset($user_data->location))?$user_data->location:'' ?>">
                  <span class="glyphicon  form-control-feedback"></span>
                </div>
                <?php if(!empty($shop_data)){ ?>
                  <div class="form-group">
                    <label>Workshop</label>
                    <select name="shop_id" class="form-control" placeholder="Select Workshop">
                      <option selected value="0">Choose a Workshop</option>
                      <?php 
                        foreach ($shop_data as $shop) {
                          $select = (isset($user_data->shop_id) && $user_data->shop_id == $shop->shop_id)?'selected':'';
                          echo '<option '.$select.' value="'.$shop->shop_id.'">'.
                                  $shop->shop_name.
                               '</option>';
                        }
                      ?>
                    </select> 
                  </div>
                <?php } ?> 
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Last Name</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change"
                  data-parsley-minlength="2" name="last_name" required=""
                  data-parsley-pattern="^[a-zA-Z0-9\ . _ @  \/]+$" placeholder="Enter Last Name" 
                  value="<?= (isset($user_data->last_name))?$user_data->last_name:'' ?>">
                  <span class="glyphicon  form-control-feedback"></span>
                </div>
                <div class="form-group">
                  <label>Phone</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change" 
                  data-parsley-minlength="2"  data-parsley-pattern="^[0-9\ , - + \/]+$" required=""
                  value="<?= (isset($user_data->phone))?$user_data->phone:'' ?>" name="phone" placeholder="Enter Phone Number" >
                  <span class="glyphicon  form-control-feedback"></span>
                </div>
                <div class="form-group" style="display:inline-flex;">
                  <div style="width:250px;" class="clockpicker"  data-autoclose="true">
                    <label>Working Hours</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change" 
                    data-parsley-minlength="2" required name="start_time" placeholder="Work Start Time"
                    value="<?= (isset($user_data->start_time))?$user_data->start_time:'' ?>"  
                    id="start_time" autocomplete="off" >
                    <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <div style="width:250px;padding-left:10px;padding-top:25px;" class="clockpicker"  data-autoclose="true">
                    <input type="text" class="form-control required" data-parsley-trigger="change" 
                    data-parsley-minlength="2" required="" placeholder="Work End Time" autocomplete="off"
                    value="<?= (isset($user_data->end_time))?$user_data->end_time:'' ?>" id="end_time" 
                    name="end_time">
                    <span class="glyphicon  form-control-feedback"></span>
                  </div>
                </div>
                <div class="form-group">
                  <label>Licence Number</label>
                  <input type="text" class="form-control" data-parsley-trigger="change" 
                  data-parsley-minlength="2" name="licence_number" data-parsley-pattern="^[a-zA-Z0-9\ , - . _ \/]+$" placeholder="Enter Licence Number" value="<?= (isset($user_data->licence_number))?$user_data->licence_number:'' ?>">
                  <span class="glyphicon  form-control-feedback"></span>
                </div>
                <div class="form-group">
                  <label>Licence Exp Date</label>
                  <div class="input-group date" data-provide="datepicker">
                    <input id="date" type="text" class="form-control" data-parsley-trigger="change" data-parsley-minlength="2" name="licence_exp_date" placeholder="Pick Licence Expiry Date" autocomplete="off">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar"></i>
                    </div>
                  </div>
                  <span class="glyphicon  form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Licence Proof Image</label>
                  <div class="col-md-12" style="padding-bottom:10px;">
                    <div class="col-md-3">
                      <img id="licence_image" src="<?= (isset($user_data->licence))?base_url($user_data->licence):'' ?>" onerror="this.src='<?=base_url("assets/images/no_image.png")?>';" height="75" width="75" />
                    </div>
                    <div class="col-md-9" style="padding-top: 25px;">
                      <input name="licence" type="file" accept="image/*" onchange="setImg(this,'licence_image');" />
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-12">      
                <div class="box-footer textCenterAlign">
                  <button type="submit" class="btn btn-primary">Submit</button>
                  <a href="<?= base_url('Mechanic/viewMechanics') ?>" class="btn btn-primary">Cancel</a>
                </div>        
              </div>        
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>