<div class="content-wrapper">
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php 
          $redirectUrl = (isset($customer_id) && !empty($customer_id))
                            ?'Customer/updateCustomer/'.$customer_id
                            :'Customer/createCustomer';
          if($this->session->flashdata('message')) { 
            $flashdata = $this->session->flashdata('message'); ?>
            <div class="alert alert-<?= $flashdata['class'] ?>">
             <button class="close" data-dismiss="alert" type="button">×</button>
             <?= $flashdata['message'] ?>
           </div>
       <?php } ?>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-header with-border">
            <h3 class="box-title">Personal Details</h3>
          </div>
          <div class="box-body">
            <form id="createCustomerForm" role="form" action="<?=base_url($redirectUrl)?>" method="post" class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <div class="col-md-12">
                <div class="col-md-6">
                  <div class="form-group has-feedback">
                     <label>First Name</label>
                     <input type="text" class="form-control required" data-parsley-trigger="change"  
                      data-parsley-minlength="2" data-parsley-pattern="^[a-zA-Z\ . ! @ # $ % ^ & * () + = , \/]+$"
                      required="" name="first_name"  placeholder="Enter First Name" 
                      value="<?= (isset($customer_data) && isset($customer_data->first_name))?$customer_data->first_name:'' ?>">
                     <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <div class="form-group has-feedback">
                     <label>Email</label>
                     <input type="email" class="form-control required" data-parsley-trigger="change"  
                     data-parsley-minlength="2" required="" name="email"  placeholder="Enter Email"
                      value="<?= (isset($customer_data) && isset($customer_data->email))?$customer_data->email:'' ?>">
                     <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <div class="form-group has-feedback">
                     <label>Date Of Birth</label>
                      <div class="input-group date" data-provide="datepicker">
                        <input id="datepicker" type="text" class="form-control required" data-parsley-trigger="change" data-parsley-minlength="2" required="" name="date_of_birth" placeholder="Pick Date Of Birth" autocomplete="off" value="<?= (isset($customer_data) && isset($customer_data->date_of_birth))?$customer_data->date_of_birth:'' ?>" style="z-index: 1;">
                        <div class="input-group-addon">
                          <i class="fa fa-calendar"></i>
                        </div>
                      </div>
                  </div>
                  <div class="form-group has-feedback">
                     <label>Address</label>
                     <textarea class="form-control required" data-parsley-trigger="change"  
                     data-parsley-minlength="2" required="" name="address" placeholder="Enter Address"><?= (isset($customer_data) && isset($customer_data->address))?trim($customer_data->address):'' ?></textarea>
                     <span class="glyphicon  form-control-feedback"></span>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group has-feedback">
                     <label>Last Name</label>
                     <input type="text" class="form-control required" data-parsley-trigger="change"  
                     data-parsley-minlength="2"  data-parsley-pattern="^[a-zA-Z\ . ! @ # $ % ^ & * () + = , \/]+$" required="" name="last_name"  placeholder="Enter Last Name"
                      value="<?= (isset($customer_data) && isset($customer_data->last_name))?$customer_data->last_name:'' ?>">
                     <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <div class="form-group has-feedback">
                     <label>Phone</label>
                     <input type="number" class="form-control required" data-parsley-trigger="change"  
                     data-parsley-minlength="2" required="" name="phone" placeholder="Enter Phone"
                      value="<?= (isset($customer_data) && isset($customer_data->phone))?$customer_data->phone:'' ?>">
                     <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <div class="form-group">
                    <label>Profile Picture</label>
                    <div class="col-md-12">
                      <div class="col-md-3">
                        <img id="profile_image" src="<?= (isset($customer_data) && isset($customer_data->profile_image))?base_url($customer_data->profile_image):'' ?>" onerror="this.src='<?=base_url("assets/images/user_avatar.jpg")?>'" height="75" width="75" />
                      </div>
                      <div class="col-md-9" style="padding-top: 25px;">
                        <input name="profile_image" type="file" accept="image/*" 
                        class="<?= (isset($customer_id) && !empty($customer_id))?'':'required' ?>" 
                        onchange="setImg(this,'profile_image')" />
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div id="savedVehicleBox" class="<?= (!isset($customer_data->vehicle_data) || empty($customer_data->vehicle_data))?'hide':'' ?>">
                <label style="padding-left:30px;">Vehicles Added</label>
                <div class="col-md-12">
                  <div class="col-md-6" id="savedVehiclesCntr">
                    <?php
                      if(isset($customer_data->vehicle_data) && !empty($customer_data->vehicle_data)){
                        foreach ($customer_data->vehicle_data AS $vehicle) { ?>
                          <span id="saved_vehicle_<?= $vehicle->customer_veh_id ?>" 
                                class="vechile-body disp-block marginBottom-5">
                            <i class="fa fa-fw fa-car padRight-8p"></i>
                            <?= $vehicle->car_name ?>
                            <div id="remove_saved_<?= $vehicle->customer_veh_id ?>" 
                                 car_id="<?= $vehicle->customer_veh_id ?>" class="float-right">
                              <i class="fa fa-fw fa-close cpoint"></i>
                            </div>
                            <input type="hidden" name="saved_vehicles[]" 
                                   value="<?= $vehicle->customer_veh_id ?>" >
                          </span>
                    <?php
                        }
                      }
                    ?>
                  </div>
                </div>
              </div>
            </form>
          </div>
          <div class="box-body">
            <div class="box-header with-border">
              <h3 class="box-title">Add New Vehicles</h3>
            </div>
            <br>
            <!-- Vehicle Details START -->
            <form id="CarSearchForm">
              <div class="col-md-12">
                <div class="col-md-3">
                  <label>
                    <input id="search_key_type" type="radio" name="search_key_type" value='1' checked>
                    <span class="padAll-20">Vechile Details</span>
                  </label>
                </div>
                <div class="col-md-9">
                  <label>
                    <input id="search_key_type" type="radio" name="search_key_type" value='2'>
                    <span class="padAll-20">VIN Number</span>
                  </label>
                </div>
              </div>
              <!-- Search Box START -->
              <div class="col-md-12 padAll-20">
                <div class="col-md-8">
                  <!-- Vehicle Details Search START -->
                  <div id="searchTyp_1">
                    <div class="col-md-12">
                      <div class="col-md-6">
                        <label>Vehicle Maker</label>
                       <!--  <input type="text" class="form-control required" name="vehMaker" input="search_params" placeholder="Enter Vehicle Maker" required> -->
                          <select name="vehMaker" class="form-control required" data-parsley-trigger="change" required="" id="veh_make" input="search_params">
                            <option selected disabled value="">Choose Vehicle Make</option>
                            <?php
                              foreach ($veh_data['make'] as $key => $value) {
                               // $cond = (isset($product_data) && isset($product_data->veh_brand_id) && 
                                         //!empty($product_data->veh_brand_id) && 
                                        // $product_data->veh_brand_id == $value->veh_brand_id)?'selected':'';
                                echo '<option maker="'.$value->veh_brand_id.'" value="'.$value->maker.'">'.$value->maker.'</option>'; 
                              }
                            ?>
                          </select>
                      </div>
                      <div class="col-md-6">
                        <label>Vehicle Model</label>
                        <!-- <input type="text" class="form-control required" name="vehModel" input="search_params" placeholder="Enter Vehicle Model" required=""> -->
                        <select name="vehModel" class="form-control required" data-parsley-trigger="change" required="" id="veh_model" input="search_params">
                          <option selected="" disabled="" value="">Choose Vehicle Model</option>
                          <?php
                            if((isset($customer_id) || !empty($customer_id))){
                              foreach ($veh_data['model'] as $key => $value) { 
                               // $cond = (isset($product_data) && isset($product_data->veh_modal_id) && 
                                         //!empty($product_data->veh_modal_id) && 
                                        // $product_data->veh_modal_id == $value->veh_modal_id)?'selected':'';
                                echo '<option  value="'.$value->model.'" model="'.$value->model.'">'.$value->model.'</option>'; 
                              }
                            }
                          ?>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-12 padTop10">
                      <div class="col-md-6">
                        <label>Vehicle Model Year</label>
                        <select name="vehYear" class="form-control required" input="search_params" 
                          data-parsley-trigger="change" required="">
                          <option selected disabled value="">Choose Vehicle Model Year</option>
                          <?php 
                            for($year=date('Y'); $year>=1950; $year--){
                              $cond = (isset($vehicle_data) && isset($vehicle_data->model) && 
                                       !empty($vehicle_data->model) && 
                                       $vehicle_data->model == $year)?'selected':'';
                              echo '<option '.$cond.' value="'.$year.'">'.$year.'</option>'; 
                            }
                          ?>
                        </select>
                      </div>
                      <div class="col-md-6">
                        <label>Vehicle Location</label>
                        <input type="text" class="form-control required" name="vehLocationDetails" 
                         id="loc_search_1" input="search_params" placeholder="Enter Vehicle Location" required>
                      </div>
                    </div>
                  </div>
                  <!-- Vehicle Details Search END -->

                  <!-- Vehicle Vin Search START -->
                  <div id="searchTyp_2" class="hide">
                    <div class="col-md-12">
                      <div class="col-md-12">
                        <label>Vehicle VIN Number</label>
                        <input type="text" class="form-control" name="vehVin" input="search_params"
                         placeholder="Enter Vehicle VIN Number">
                      </div>
                      <div class="col-md-12 padTop10">
                        <label>Vehicle Location</label>
                          <input type="text" class="form-control" name="vehLocationVin" 
                           id="loc_search_2" input="search_params" placeholder="Enter Vehicle Location">
                      </div>
                    </div>
                  </div>
                  <!-- Vehicle Vin Search END -->
                </div>
                <!-- Search Box END -->
                <div class="col-md-4">
                  <button id="vehSearch" type="button" class="btn btn-info" style="margin-top:18%;">Search</button>
                </div>
              </div>
              <!-- Vehicle Details END -->
            </form>
            <!-- View Car DEtails START -->
            <div class="col-md-12 padBottom20 hide" id="carSearchResult"></div>
            <!-- View Car DEtails END -->

            <div class="col-md-12">          
              <div class="box-footer">
                <div style="text-align: center;">
                  <button id="createCustomerSubmit" type="submit" class="btn btn-primary">Submit</button>
                  <a href="<?=base_url('Customer/listCustomerUsers')?>" class="btn btn-primary">Cancel</a>
                </div>
              </div>        
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>