<div class="content-wrapper" >
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
          <?php if($this->session->flashdata('message')) { 
              $flashdata = $this->session->flashdata('message'); ?>
              <div class="alert alert-<?= $flashdata['class'] ?>">
                 <button class="close" data-dismiss="alert" type="button">×</button>
                 <?= $flashdata['message'] ?>
              </div>
          <?php } ?>
      </div>
      <div class="col-xs-12">
      <div class="box box-warning"> 
        <div class="box-header with-border">
          <div class="col-md-6"><h3 class="box-title">Customers List</h3></div>
          <div class="col-md-6" align="right">
            <?php
            if(!empty($customerData)){ ?>
              <a class="btn btn-sm btn-success" href="<?= base_url('Customer/exportCustomerData')?>">Generate Report</a>
            <?php } ?>
            <a class="btn btn-sm btn-primary" href="<?= base_url('Customer/addCustomerUser')?>">Add New Customer</a>
            <a class="btn btn-sm btn-primary" href="<?= base_url() ?>">Back</a>
          </div>
        </div>
      <div class="box-body">
        <table id="driverTable" class="table table-bordered table-striped datatable ">
          <thead>
            <tr>
              <th class="hidden">ID</th>
              <th width="13%;">Name</th> 
              <th width="10%;">Phone</th>
              <th width="13%;">Email ID</th> 
              <th width="14%;">Address</th> 
              <th width="12%;">Date Of Birth</th>
              <th width="5%;">Status</th>
              <th width="33%;">Action</th>
            </tr>
          </thead> 
          <tbody>
            <?php
            if(!empty($customerData)){
              foreach($customerData as $customer) {
               ?>
               <tr>
                 <th class="hidden"><?= $customer->customer_id ?></th>
                 <td class="center"><?= $customer->first_name.' '.$customer->last_name ?></th> 
                 <td class="center"><?= $customer->phone ?></th>
                 <td class="center"><?= $customer->email ?></th> 
                 <td class="center"><?= $customer->address ?></th> 
                 <td class="center"><?= $customer->date_of_birth ?></th> 
                 <td class="center"><?= ($customer->status == '1')?'Active':'Inactive'?></td>
                 <td class="center">	 
                    <a class="btn btn-sm btn-primary" id="viewCustomer" customer_id="<?= encode_param($customer->customer_id) ?>">
                      <i class="fa fa-fw fa-edit"></i>View
                    </a>
                    <a class="btn btn-sm btn-danger" 
                      href="<?= base_url('Customer/editCustomer/'.encode_param($customer->customer_id)) ?>">
                      <i class="fa fa-fw fa-trash"></i>Edit
                    </a> 
                    <a class="btn btn-sm btn-danger" 
                      href="<?= base_url("Customer/changeStatus/".encode_param($customer->customer_id))."/2" ?>" 
                      onClick="return doconfirm()">
                      <i class="fa fa-fw fa-trash"></i>Delete
                    </a>    
                    <?php if($customer->status == 1){ ?>
                      <a class="btn btn-sm btn-success" style="background-color:#ac2925" href="<?= base_url("Customer/changeStatus/".encode_param($customer->customer_id))."/0" ?>">
                        <i class="fa fa-cog"></i> De-activate
                      </a>
                    <?php } else { ?>
                      <a class="btn btn-sm btn-success" href="<?= base_url("Customer/changeStatus/".encode_param($customer->customer_id))."/1" ?>">
                        <i class="fa fa-cog"></i> Activate
                      </a>
                    <?php } ?>
                  </td>
                </tr>
            <?php 
              } 
            }?>
          </tbody>
        </table>
      </div>
    </div>
  </section>
</div>