<?php 
  $mapIssueData = ''; 
?>
<div class="content-wrapper">
  <section class="content-header">
    <h1><?= $pTitle ?><small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-sm-12">
        <?php if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
           <button class="close" data-dismiss="alert" type="button">×</button>
           <?= $flashdata['message'] ?>
         </div>
       <?php } ?>
      </div>
    
      <?php if($this->session->userdata['user_type'] == 1 && !empty($mechanic_data)){ ?>
        <div class="col-sm-12">
          <div class="box box-warning">
            <div class="box-header with-border">
              <div class="col-md-6">
                <h3 class="box-title">Mapped Issues Management</h3>
              </div>
              <div class="col-md-6" align="right">
                <a class="btn btn-sm btn-primary" href="<?= base_url('Issue/addIssue') ?>">Add New General Issue</a>
                <a class="btn btn-sm btn-primary" href="<?= base_url() ?>">Back</a>
              </div>
            </div>
            <div class="box-body">
              <form id="chooseMechForm" role="form" action="<?=base_url('Issue/viewMappedIssues')?>" 
                method="post" class="validate" data-parsley-validate="" enctype="multipart/form-data">
                <div class="col-sm-12">
                  <div class="form-group">
                    <label>Choose a Mechanic</label>
                    <select name="mechanic_id" class="form-control required" data-parsley-trigger="change" 
                    onchange="changeMechanic()" dmClick="0" required>
                      <option selected disabled>Select Mechanic</option>
                      <?php 
                        if(!empty($mechanic_data)){
                          foreach ($mechanic_data as $mechanic) {
                            $chkFlg = ($mechanic_id == $mechanic->mechanic_id)?'selected':'';
                            echo '<option value="'.encode_param($mechanic->mechanic_id).'" '.$chkFlg.'>
                                  '.$mechanic->first_name.' '.$mechanic->last_name.
                                '</option>';
                          } 
                        }
                      ?>
                    </select> 
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
        <?php  }
        if($this->session->userdata['user_type'] != 1 || ($this->session->userdata['user_type'] == 1 && !empty($mechanic_id))){ ?>
        <div class="col-xs-12">
          <div class="box box-warning">     
            <div class="box-body">
              <table id="mechanicUsers" class="table table-bordered table-striped datatable ">
                <thead>
                  <tr>
                    <th class="hidden">ID</th>
                    <th width="10%;">Issue Icon</th>
                    <th width="25%;">Issue Category</th>
                    <th width="13%;">Mapping Type</th>
                    <th width="10%;">Status</th>
                    <th width="43%;">Action</th>
                 </tr>
                </thead> 
                <tbody>
                  <?php if(!empty($mechanicIssueData)){
                    $mapIssueData = $mechanicIssueData;
                    foreach($mechanicIssueData as $mechIssueData) { ?>
                      <tr>
                        <th class="hidden"><?= $mechIssueData['issue_id'] ?></th>
                        <th class="center">
                          <img class="small-icon" src="<?=base_url($mechIssueData['issue_image'])?>" onerror="this.src='<?=base_url("assets/images/no_image.png")?>';" />
                        </th>
                        <th class="center"><?= $mechIssueData['issue'] ?></th>
                        <th class="center">
                          <?= ($mechIssueData['custom_enable'] == 1)?'Custom':'Default' ?>
                        </th>
                        <th class="center">
                          <?= ($mechIssueData['status'] == 1)?'Active':'De-activate' ?>
                        </th>
                        <td class="center float-right">
                          <?php if(!empty($mechIssueData['sub_issue'])){ ?>
                            <a class="btn btn-sm btn-info cpoint" 
                               onclick="viewMapIssueDetails('<?= $mechIssueData['issue_id'] ?>');">
                              <i class="fa fa-fw fa-eye"></i>View Issue Sub Categories
                            </a>
                          <?php } ?>
                          <a class="btn btn-sm btn-primary" 
                              href="<?= base_url('Issue/editMechanicIssues/'.encode_param($mechIssueData['mechanic_id']).'/'.encode_param($mechIssueData['issue_id']).'/2') ?>">
                            <i class="fa fa-fw fa-edit"></i>Edit
                          </a> 
                          <a class="btn btn-sm btn-danger" 
                              href="<?= base_url("Issue/changeMappedIssueStatus/".encode_param($mechIssueData['mechanic_id'])."/".encode_param($mechIssueData['issue_id'])."/2")?>"
                              onClick="return doconfirm()">
                            <i class="fa fa-fw fa-trash"></i>Delete
                          </a>    
                          <?php if($mechIssueData['status'] == 1){ ?>
                            <a class="btn btn-sm btn-success" style="background-color:#ac2925" href="<?= base_url("Issue/changeMappedIssueStatus/".encode_param($mechIssueData['mechanic_id'])."/".encode_param($mechIssueData['issue_id'])."/0") ?>">
                              <i class="fa fa-cog"></i> De-activate
                            </a>
                          <?php } else { ?>
                            <a class="btn btn-sm btn-success" href="<?= base_url("Issue/changeMappedIssueStatus/".encode_param($mechIssueData['mechanic_id'])."/".encode_param($mechIssueData['issue_id'])."/1") ?>">
                              <i class="fa fa-cog"></i> Activate
                            </a>
                          <?php } ?>
                        </td>
                      </tr>
                  <?php } } ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <?php } ?>
    </div>
  </section>
</div>

<script type="text/javascript">
  var mapIssueData = '<?= json_encode($mapIssueData) ?>';
</script>