<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ImportData extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Import_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}

    public function import_data(){
        $template['page'] = 'Import/importdata';
        $template['menu'] = 'Import Data';
        $template['smenu'] = 'Import Data';
        $template['pTitle'] = "Import Data";
        $template['import_id'] = '';
        $template['pDescription'] = "Import Data";
         $this->load->view('template',$template);

    }

    public function importCsvData(){
        if($_POST['import_id'] == '1'){
            $status = $this->addMechanic($_FILES);
        }
    }

    public function addMechanic($files =array()){

        $this->load->model('Mechanic_model');
        if(isset($files) && !empty($files)){

            $filename=$_FILES["file"]["name"];
            $ext=pathinfo($filename, PATHINFO_EXTENSION);
            if($ext=="csv")
            {
                $file = fopen($filename, "r");
                $err = 0;
                $errMsg = '';
                $count = 0;
                $new = array();
                while (($mechData = fgetcsv($file, 10000, ",")) !== FALSE){
                    $count++;
                    if($count == 1){
                        continue;
                    }

                    if($err == 0 && (!isset($mechData[0]) || empty($mechData[0]))){
                        $err = 1;
                        $errMsg = 'Provide a First Name';
                    }else if($err == 0 && (!isset($mechData[1]) || empty($mechData[1]))){
                        $err = 1;
                        $errMsg = 'Provide a Last Name';
                    }else if($err == 0 && (!isset($mechData[2]) || empty($mechData[2]))){
                        $err = 1;
                        $errMsg = 'Provide a Password';
                    }else if($err == 0 && (!isset($mechData[3]) || empty($mechData[3]))){
                        $err = 1;
                        $errMsg = 'Provide a Phone Number';
                    }else if($err == 0 && (!isset($mechData[4]) || empty($mechData[4]))){
                        $err = 1;
                        $errMsg = 'Provide an Email ID';
                    }else if($err == 0 && (!isset($mechData[5]) || empty($mechData[5]))){
                        $err = 1;
                        $errMsg = 'Provide a Display Name';
                    }else if($err == 0 && (!isset($mechData[6]) || empty($mechData[6]))){
                        $err = 1;
                        $errMsg = 'Provide a city';
                    }else if($err == 0 && (!isset($mechData[7]) || empty($mechData[7]))){
                        $err = 1;
                        $errMsg = 'Provide a state';
                    }else if($err == 0 && (!isset($mechData[8]) || empty($mechData[8]))){
                        $err = 1;
                        $errMsg = 'Provide an address';
                    }else if($err == 0 && (!isset($mechData[9]) || empty($mechData[9]))){
                        $err = 1;
                        $errMsg = 'Provide a Functional Area';
                    }else if($err == 0 && (!isset($mechData[10]) || empty($mechData[10]))){
                        $err = 1;
                        $errMsg = 'Provide Work Start Time';
                    }else if($err == 0 && (!isset($mechData[11]) || empty($mechData[11]))){
                        $err = 1;
                        $errMsg = 'Provide Work End Time';
                    }else if($err == 0 && (!isset($mechData[12]) || empty($mechData[12]))){
                        $err = 1;
                        $errMsg = 'Provide a Username';
                    }else if($err == 0 && ($mechData[10] >= $mechData[11])){
                        $err = 1;
                        $errMsg = 'Provide proper Working Hours';
                    }
                    
                    $fnLocation = getLocationLatLng($mechData[9]);
                    if(empty($fnLocation)){
                        $err = 1;
                        $errMsg = 'Provide a Valid Functional Area';
                    }

                    $mechData[2] = md5($mechData[2]);
                    $new = array(
                        'first_name'=>$mechData[0],
                        'last_name'=>$mechData[1],
                        'password'=>$mechData[2],
                        'phone'=>$mechData[3],
                        'email_id'=>$mechData[4],
                        'display_name'=>$mechData[5],
                        'city'=>$mechData[6],
                        'state'=>$mechData[7],
                        'address'=>$mechData[8],
                        'location'=>$mechData[9],
                        'start_time'=>$mechData[10],
                        'end_time'=>$mechData[11],
                        'username'=>$mechData[12],
                        'location_lat'=>$fnLocation['lat'],
                        'location_lng'=>$fnLocation['lng'],
                        'licence'=>$fnLocation['lng'],
                        'licence_number'=>'',
                        'licence_exp_date'=>'',
                        'profile_image'=>'',
                        'shop_id'=>0
                    );

                    $status = $this->Mechanic_model->addMechanic($new);
                }
                if($count > 0){
                    $flashMsg = array('message'=>($count -1).' Data Inserted Successfully','class'=>'success');
                    $this->session->set_flashdata('message', $flashMsg);
                    redirect(base_url('ImportData/import_data'));
                }
            }
        }
    }





        // $filename=$_FILES["brand_logo"]["name"];
        // $ext=pathinfo($filename, PATHINFO_EXTENSION);
        // if($ext=="csv")
        // {
        //   $file = fopen($filename, "r");
          
        //          while (($emapData = fgetcsv($file, 10000, ",")) !== FALSE)
        //          {
        //             $sql = "INSERT into import(product_id,name,brand_name,short_description,part_id,vehicle_model,amount,status) values('$emapData[0]','$emapData[1]','$emapData[2]','$emapData[3]','$emapData[4]','$emapData[5]','$emapData[6]','$emapData[7]')";
        //             $this->db->query($sql);
        //          }
        //          fclose($file);
        //          echo "CSV File has been successfully Imported.";
        // }


}

