<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mechanic extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Mechanic_model');

		if(!$this->session->userdata('logged_in')) {
			redirect(base_url());
		}
	}

	public function addMechanic(){
        $this->load->model('Shop_model');

		$template['page'] = 'Mechanic/mechanicForm';
        $template['menu'] = 'Mechanic Management';
        $template['smenu'] = 'Add Mechanic';
        $template['pTitle'] = "Add Mechanic";
        $template['pDescription'] = "Create New Mechanic";

        $template['shop_data'] = $this->Shop_model->getShop();
		$this->load->view('template',$template);
	}

	public function viewMechanics(){
        $this->load->model('Shop_model');

		$template['page'] = 'Mechanic/viewMechanic';
        $template['menu'] = 'Mechanic Management';
        $template['smenu'] = 'View Mechanics';
        $template['pTitle'] = "View Mechanics";
        $template['pDescription'] = "View and Manage Mechanics";
        $template['page_head'] = "Mechanic Management";

        $template['user_data'] = $this->Mechanic_model->getMechanic('',1);
		$this->load->view('template',$template);
	}

	public function getMechanicData(){
		$resArr = array('status'=>0);
		if(!isset($_POST)||empty($_POST)||!isset($_POST['mechanic_id'])||empty($_POST['mechanic_id']) || 
		   !is_numeric($mechanic_id = decode_param($_POST['mechanic_id']))){
			echo json_encode($resArr);exit;
		}
		$view_all = (isset($_POST['view_all']) && $_POST['view_all'] == 1)?1:0;
		$mechData = $this->Mechanic_model->getMechanic($mechanic_id,$view_all);

		if(empty($mechData)){
			echo json_encode($resArr);exit;
		}

		$resArr['status'] = 1;
		$resArr['data'] = $mechData;
		echo json_encode($resArr);exit;
	}

	function changeStatus($mechanic_id = '',$status = '1'){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($mechanic_id) || !is_numeric($mechanic_id = decode_param($mechanic_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Mechanic/viewMechanics'));
		}
		$status = $this->Mechanic_model->changeStatus($mechanic_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Mechanic/viewMechanics'));
	}

	public function createMechanic(){
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Mechanic/addMechanic'));
		}
		if($err == 0 && (!isset($_POST['first_name']) || empty($_POST['first_name']))){
			$err = 1;
			$errMsg = 'Provide a First Name';
		}else if($err == 0 && (!isset($_POST['last_name']) || empty($_POST['last_name']))){
			$err = 1;
			$errMsg = 'Provide a Last Name';
		}else if($err == 0 && (!isset($_POST['password']) || empty($_POST['password']))){
			$err = 1;
			$errMsg = 'Provide a Password';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide a Phone Number';
		}else if($err == 0 && (!isset($_POST['email_id']) || empty($_POST['email_id']))){
			$err = 1;
			$errMsg = 'Provide an Email ID';
		}else if($err == 0 && (!isset($_POST['display_name']) || empty($_POST['display_name']))){
            $err = 1;
			$errMsg = 'Provide a Display Name';
        }else if($err == 0 && (!isset($_FILES['profile_image']) || empty($_FILES['profile_image']))){
            $err = 1;
			$errMsg = 'Provide a Profile Photo';
        }else if($err == 0 && (!isset($_POST['city']) || empty($_POST['city']))){
            $err = 1;
			$errMsg = 'Provide a city';
        }else if($err == 0 && (!isset($_POST['state']) || empty($_POST['state']))){
            $err = 1;
			$errMsg = 'Provide a state';
        }else if($err == 0 && (!isset($_POST['address']) || empty($_POST['address']))){
            $err = 1;
			$errMsg = 'Provide an address';
        }else if($err == 0 && (!isset($_POST['location']) || empty($_POST['location']))){
            $err = 1;
			$errMsg = 'Provide a Functional Area';
        }else if($err == 0 && (!isset($_POST['start_time']) || empty($_POST['start_time']))){
            $err = 1;
			$errMsg = 'Provide Work Start Time';
        }else if($err == 0 && (!isset($_POST['end_time']) || empty($_POST['end_time']))){
            $err = 1;
			$errMsg = 'Provide Work End Time';
        }else if($err == 0 && ($_POST['start_time'] >= $_POST['end_time'])){
            $err = 1;
			$errMsg = 'Provide proper Working Hours';
        }
        
        $fnLocation = getLocationLatLng($_POST['location']);
    	if(empty($fnLocation)){
    		$err = 1;
			$errMsg = 'Provide a Valid Functional Area';
    	}

        if($err == 0){
	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
	        $this->upload->initialize($config);
	        if(!$this->upload->do_upload('profile_image')){
	        	$err = 1;
				$errMsg = $this->upload->display_errors();
	        }else{
	            $upload_data = $this->upload->data();
	            $_POST['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
	        }

        	$_POST['licence'] = '';
	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['licence']['name'];
	        $this->upload->initialize($config);
	        if($this->upload->do_upload('licence')){
	        	$upload_data = $this->upload->data();
	            $_POST['licence'] = $config['upload_path']."/".$upload_data['file_name'];
	        }
	    }
		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Mechanic/addMechanic'));
		}
		$_POST['password'] = md5($_POST['password']);
		$_POST['location_lat'] = $fnLocation['lat'];
		$_POST['location_lng'] = $fnLocation['lng'];

        $status = $this->Mechanic_model->addMechanic($_POST);
        if($status == 1){
            $flashMsg =array('message'=>'Successfully Updated User Details..!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Mechanic/viewMechanics'));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Mechanic/addMechanic'));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Mechanic/addMechanic'));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Mechanic/addMechanic'));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Mechanic/addMechanic'));
        }
	}

	public function editMechanics($mechanic_id){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($mechanic_id) || !is_numeric($mechanic_id = decode_param($mechanic_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Mechanic/viewMechanics'));
		}
        $this->load->model('Shop_model');

		$template['page'] = 'Mechanic/mechanicForm';
        $template['menu'] = 'Mechanic Management';
        $template['smenu'] = 'Edit Mechanic';
        $template['pTitle'] = "Edit Mechanics";
        $template['pDescription'] = "Update Mechanic Data";

        $template['user_data'] = $this->Mechanic_model->getMechanic($mechanic_id,1);
        $template['mechanic_id'] = encode_param($mechanic_id);
		$this->load->view('template',$template);
	}

	public function updateMechanic($mechanic_id = ''){
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($mechanic_id)||!isset($_POST)||empty($_POST)||!is_numeric(decode_param($mechanic_id))){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Mechanic/viewMechanics'));
		}
		if($err == 0 && (!isset($_POST['first_name']) || empty($_POST['first_name']))){
			$err = 1;
			$errMsg = 'Provide a First Name';
		}else if($err == 0 && (!isset($_POST['last_name']) || empty($_POST['last_name']))){
			$err = 1;
			$errMsg = 'Provide a Last Name';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide a Phone Number';
		}else if($err == 0 && (!isset($_POST['email_id']) || empty($_POST['email_id']))){
			$err = 1;
			$errMsg = 'Provide an Email ID';
		}else if($err == 0 && (!isset($_POST['display_name']) || empty($_POST['display_name']))){
            $err = 1;
			$errMsg = 'Provide a Display Name';
        }else if($err == 0 && (!isset($_POST['city']) || empty($_POST['city']))){
            $err = 1;
			$errMsg = 'Provide a city';
        }else if($err == 0 && (!isset($_POST['state']) || empty($_POST['state']))){
            $err = 1;
			$errMsg = 'Provide a state';
        }else if($err == 0 && (!isset($_POST['address']) || empty($_POST['address']))){
            $err = 1;
			$errMsg = 'Provide your address';
        }else if($err == 0 && (!isset($_POST['location']) || empty($_POST['location']))){
            $err = 1;
			$errMsg = 'Provide a Functional Area';
        }else if($err == 0 && (!isset($_POST['start_time']) || empty($_POST['start_time']))){
            $err = 1;
			$errMsg = 'Provide Work Start Time';
        }else if($err == 0 && (!isset($_POST['end_time']) || empty($_POST['end_time']))){
            $err = 1;
			$errMsg = 'Provide Work End Time';
        }else if($err == 0 && ($_POST['start_time'] >= $_POST['end_time'])){
            $err = 1;
			$errMsg = 'Provide proper Working Hours';
        }

        $fnLocation = getLocationLatLng($_POST['location']);
    	if(empty($fnLocation)){
    		$err = 1;
			$errMsg = 'Provide a Valid Functional Area';
    	}
    	
        if($err == 0){
	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
	        $this->upload->initialize($config);
	        if($this->upload->do_upload('profile_image')){
	            $upload_data = $this->upload->data();
	            $_POST['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
	        }

	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['licence']['name'];
	        $this->upload->initialize($config);
	        if($this->upload->do_upload('licence')){
	        	$upload_data = $this->upload->data();
	            $_POST['licence'] = $config['upload_path']."/".$upload_data['file_name'];
	        }
	    }
		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Mechanic/editMechanics/'.$mechanic_id));
		}
		
		$_POST['location_lat'] = $fnLocation['lat'];
		$_POST['location_lng'] = $fnLocation['lng'];
        $status = $this->Mechanic_model->updateMechanic(decode_param($mechanic_id),$_POST);
        if($status == 1){
            $flashMsg =array('message'=>'Successfully Updated User Details..!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Mechanic/viewMechanics'));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Mechanic/editMechanics/'.$mechanic_id));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Mechanic/editMechanics/'.$mechanic_id));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Mechanic/editMechanics/'.$mechanic_id));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Mechanic/editMechanics/'.$mechanic_id));
        }
	}

	public function exportMechanicData(){
		$mechData = $this->Mechanic_model->getMechanic();
        if(empty($mechData)){
            return;
        }
        $header = array('ID','Username','Name','Phone','Email','Address','City','State','Licence Number','Licence Exp Date','Start Time','End Time','Status','Shop Id','Shop Name','Shop Address',
        	'Shop Phone','Shop Email');

        $file = 'mechData_'.time().'.csv';
        $fpoint = fopen('php://memory', 'w');
        fputcsv($fpoint, $header, ',');

        foreach($mechData AS $mechanic){

        	$data = array();
            $data[] = $mechanic->mechanic_id;
            $data[] = $mechanic->username;
            $data[] = $mechanic->display_name;
            $data[] = $mechanic->phone;
            $data[] = $mechanic->email_id;
            $data[] = $mechanic->address;
            $data[] = $mechanic->city;
            $data[] = $mechanic->state;
            $data[] = $mechanic->licence_number;
            $data[] = $mechanic->licence_exp_date;
            $data[] = $mechanic->start_time;
            $data[] = $mechanic->end_time;
            $data[] = ($mechanic->status == 1)?'Active':'De-active';
            
            $data[] = $mechanic->shop_id;
            $data[] = $mechanic->shop_name;
            $data[] = $mechanic->shop_address;
            $data[] = $mechanic->shop_phone;
            $data[] = $mechanic->shop_email;
            fputcsv($fpoint, $data, ',');
        }
        fseek($fpoint, 0);
        header('Content-Type: application/csv');
        header('Content-Disposition: attachement; filename="' . $file . '";');
        fpassthru($fpoint);
	}
}
?>