<?php 
class Vehicle_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
 	}

 	function addVehicle($vehicle_data = array()){
 		if(empty($vehicle_data)){
 			return 0;
 		}
 		$status = $this->db->insert('customer_vehicle',$vehicle_data);
 		return ($status)?$this->db->insert_id():'0';
 	}

 	function changeStatus($vehicle_id = '', $action = '0'){
 		if(empty($vehicle_id)){
 			return 0;
 		}
 		if($action == 3){
			$status = $this->db->delete('customer_vehicle',array('customer_veh_id'=>$vehicle_id));
 		} else {
 			$status = $this->db->update('customer_vehicle',array('status'=>$action),
 														   array('customer_veh_id'=>$vehicle_id));
 		}
 		return $status;
 	}

    function getCustVechiles($searchData = array()){
        if(empty($searchData)){
        	return 0;
        }
        $cond = array();

        $cond['status'] = 1;
        if(isset($searchData['customer_id']) && !empty($searchData['customer_id'])){
        	$cond['customer_id'] = $searchData['customer_id'];
        }
		$vehData = $this->db->get_where('customer_vehicle',$cond);
		
		if(!empty($vehData)){
            $vehData = $vehData->result();
            foreach ($vehData as $key => $value) {
                $make = $this->db->get_where('vehicles_brand',array('maker'=>$value->car_maker))->row();
                $vehData[$key]->veh_brand_id = $make->veh_brand_id;

                $model = $this->db->get_where('vehicles_model',array('model'=>$value->car_model,'veh_brand_id'=>$make->veh_brand_id))->row();
                $vehData[$key]->veh_model_id = $model->veh_modal_id;
            }
			return $vehData;
		}
		return 0;
    }

    function changeCustomerCarStatus($customer_id = '', $customer_veh_id = '', $status = ''){
    	if(empty($customer_id) || empty($customer_veh_id) || $status == ''){
    		return 0;
    	}

    	$upStatus = $this->db->update('customer_vehicle',
    								array('status'=>$status),
    								array('customer_id'=>$customer_id,'customer_veh_id'=>$customer_veh_id));

    	return $upStatus;
    }
    public function addBrand($veh_data = array()){
        if(empty($veh_data)){
            return 0;
        }
        $result = $this->db->get_where('vehicles_brand',array('vehicles_brand.maker'=>$veh_data['maker']))->row();
        if($result){
            return 0;
        }
        $status = $this->db->insert('vehicles_brand',$veh_data);
        $last_id = $this->db->insert_id();
        return $last_id;
    }

    function getVehBrand($veh_brand_id = '',$view_all = 0){
        $cond = ($view_all != 0)?' vehicles_brand.status IN (0,1) ':' vehicles_brand.status IN (1) ';
        $cond .= (!empty($veh_brand_id))?" AND vehicles_brand.veh_brand_id = '$veh_brand_id'":"";

        $result = $this->db->query("SELECT * FROM vehicles_brand
                                    WHERE $cond ORDER BY vehicles_brand.maker");
        if(empty($result)){
            return;
        }
        return (empty($veh_brand_id))?$result->result():$result->row();
    }

    function changeVehicleStatus($brand_id = '', $status = '0',$type=''){
        if(empty($brand_id)){
            return 0;
        }
        if($type == '2'){
            $status = $this->db->update('vehicles_model',array('status'=>$status), array('veh_modal_id'=>$brand_id));
        }else{
            $status = $this->db->update('vehicles_brand',array('status'=>$status), array('veh_brand_id'=>$brand_id));   
        }
        return $status;
    }

    function updateVehBrand($brand_id = '', $brand_data = array()){
        if(empty($brand_id) || empty($brand_data)){
            return 0;
        }
        $status = $this->db->update('vehicles_brand',$brand_data,array('veh_brand_id'=>$brand_id));
        return ($status)?1:0;
    }


    function getVehModel($veh_model_id = '',$view_all = 0,$veh_brand_id=''){
        $cond = ($view_all != 0)?' vehicles_model.status IN (0,1) ':' vehicles_model.status IN (1) ';
        $cond .= (!empty($veh_model_id))?" AND vehicles_model.veh_modal_id = '$veh_model_id'":"";
        $cond .= (!empty($veh_brand_id))?" AND vehicles_model.veh_brand_id = '$veh_brand_id'":"";
        $result = $this->db->query("SELECT vehicles_model.*, vehicles_brand.maker
                                    FROM vehicles_model
                                    JOIN vehicles_brand ON vehicles_brand.veh_brand_id = vehicles_model.veh_brand_id
                                    WHERE $cond ORDER BY vehicles_model.model");
        if(empty($result)){
            return;
        }

        if(isset($veh_brand_id) && !empty($veh_brand_id)){
            return $result->result(); 
        }
        return (empty($veh_model_id))?$result->result():$result->row();
    }

    public function addModel($veh_data = array()){
        if(empty($veh_data)){
            return 0;
        }
        $result = $this->db->get_where('vehicles_model',array('vehicles_model.model'=>$veh_data['model'],'vehicles_model.veh_brand_id'=>$veh_data['veh_brand_id']))->row();
        if($result){
            return 0;
        }
        $status = $this->db->insert('vehicles_model',$veh_data);
        $last_id = $this->db->insert_id();
        return $last_id;
    }

    public function updateVehModel($model_id = '', $model_data = array()){
        if(empty($model_id) || empty($model_data)){
            return 0;
        }
        $status = $this->db->update('vehicles_model',$model_data,array('veh_modal_id'=>$model_id));
        return ($status)?1:0;
    }

    public function changeReminderStatus($postData = array()){
        $respArr = array('status'=>'error');
        if(empty($postData)){
            $respArr['message'] = 'All Field is Required';
        }
        if($this->db->update('customer_vehicle',array('enable_notification'=>$postData['status']),array('customer_veh_id'=>$postData['customer_veh_id']))){
            $respArr['status'] = 'success';
        }
        return $respArr;
        
    }
}
?>