<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
        $this->load->model('User_model');
		$this->load->model('Dashboard_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}
	
	public function viewProfile() {
        if(!isset($this->session->userdata['user']) || empty($this->session->userdata['user'])){
            redirect(base_url());
        }
        $template['shop_data'] = '';
        if($this->session->userdata('user_type') == 2 && isset($this->session->userdata['mechanic_data']) 
            && !empty($this->session->userdata['mechanic_data'])){ 
            $this->load->model('Shop_model');
            $mechanic_data = $this->session->userdata['mechanic_data'];

            if(!empty($mechanic_data->shop_id)){
                $template['shop_data'] = $this->Shop_model->getShop($mechanic_data->shop_id);
            }
        }
		$template['page'] = 'User/viewProfile';
        $template['menu'] = 'User';
        $template['smenu'] = 'View Profile';
        $template['pTitle'] = "User Profile";
        $template['pDescription'] = "Edit or View Profile";
		$this->load->view('template',$template);
	}

	public function editProfile() {
		$template['page'] = 'User/editProfile';
        $template['page_desc'] = "Edit Profile";
        $template['page_title'] = "Edit Profile";
		$template['user_data'] = $this->User_model->getUserData();

		$this->load->view('template',$template);
	}

	public function updateUser(){

 		$user_id = $this->session->userdata('id');
 		$user_type = $this->session->userdata('user_type');

		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
    	if(empty($user_id)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('User/editProfile'));
    	}
    	if(isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])){
            $config = set_upload_service("assets/uploads/services");
            $this->load->library('upload');

            $new_name = time()."_".$_FILES['profile_image']['name'];
            $config['file_name'] = $new_name;

            $this->upload->initialize($config);

            if($this->upload->do_upload('profile_image')){
                $upload_data = $this->upload->data();
                $_POST['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
            }
        } 
        if((isset($_POST['password']) || isset($_POST['cPassword'])) && 
           (!empty($_POST['password']) || !empty($_POST['cPassword']))){
            if($_POST['password'] != $_POST['cPassword']){
                $flashMsg = array('message'=>'Re-enter Password..!','class'=>'error');
                $this->session->set_flashdata('message', $flashMsg);
                redirect(base_url('User/editProfile'));
            }
            $password = $_POST['password'];
            unset($_POST['password']);
            unset($_POST['cPassword']);
            $_POST['password'] = md5($password);
        } else {
            unset($_POST['password']);
            unset($_POST['cPassword']);
        }
        if(!isset($_POST['company_name']) || empty($_POST['company_name'])){
            $flashMsg = array('message'=>'Provide a valid Display Name..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('User/editProfile'));
        } else if (!isset($_POST['email_id']) || empty($_POST['email_id'])){
            $flashMsg = array('message'=>'Provide a valid Email ID..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('User/editProfile')); 
        }
        if ($user_type == 2){
	        if (!isset($_POST['address']) || empty($_POST['address'])){
	            $flashMsg = array('message'=>'Provide a valid Address..!','class'=>'error');
	            $this->session->set_flashdata('message', $flashMsg);
	            redirect(base_url('User/editProfile'));
	        } else if (!isset($_POST['fax']) || empty($_POST['fax'])){
	            $flashMsg = array('message'=>'Provide a valid Fax Number..!','class'=>'error');
	            $this->session->set_flashdata('message', $flashMsg);
	            redirect(base_url('User/editProfile'));
	        } else if (!isset($_POST['phone']) || empty($_POST['phone'])){
	            $flashMsg = array('message'=>'Provide a valid Phone Number..!','class'=>'error');
	            $this->session->set_flashdata('message', $flashMsg);
	            redirect(base_url('User/editProfile'));
	        } else if (!isset($_POST['company_contact']) || empty($_POST['company_contact'])){
	            $flashMsg = array('message'=>'Provide a valid Contact Number..!','class'=>'error');
	            $this->session->set_flashdata('message', $flashMsg);
	            redirect(base_url('User/editProfile'));
	        } else if (!isset($_POST['company_info']) || empty($_POST['company_info'])){
	            $flashMsg = array('message'=>'Provide a valid Contact Info..!','class'=>'error');
	            $this->session->set_flashdata('message', $flashMsg);
	            redirect(base_url('User/editProfile'));
	        }
	    }
        $status = $this->User_model->updateUser($user_id,$user_type,$_POST);
        if($status == 1){
        		if(isset($_POST['profile_image']) && !empty($_POST['profile_image'])){
        			$this->session->set_userdata('profile_pic',$_POST['profile_image']);
        		}
                $flashMsg =array('message'=>'Successfully Upadated User Details..!','class'=>'success');
                $this->session->set_flashdata('message', $flashMsg);
                redirect(base_url('User/viewProfile'));
        } else if($status == 2){
                $flashMsg = array('message'=>'Email ID alrady exist..!','class'=>'error');
                $this->session->set_flashdata('message', $flashMsg);
                redirect(base_url('User/editProfile'));
        } else {
                $this->session->set_flashdata('message', $flashMsg);
                redirect(base_url('User/editProfile'));
        }
	}
}
?>