<?php
defined('BASEPATH')OR exit('No direct script access allowed');
header('Content-Type: text/html; charset=utf-8');

// Allow from any origin
if(isset($_SERVER['HTTP_ORIGIN'])) {
	header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
	header('Access-Control-Allow-Credentials: true');
	header('Access-Control-Max-Age: 86400'); // cache for 1 day
}

// Access-Control headers are received during OPTIONS requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
	if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
	  header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
	if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
	  header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
	exit(0);
}

class Webservices extends CI_Controller {

	public function __construct() {
	  parent::__construct();
	  $this->load->model('Webservice_model');
	  $this->load->library('form_validation');

	  $auth = '';
	  $class = $this->router->fetch_class();
	  $method = $this->router->fetch_method();

	  if($this->input->server('REQUEST_METHOD') == 'GET')
	     $postdata = json_encode($_GET);

	  else if ($this->input->server('REQUEST_METHOD') == 'POST')
	     $postdata = file_get_contents("php://input");

	  if (isset(apache_request_headers()['Auth'])) {
	     $auth = apache_request_headers()['Auth'];
	  }
	  // $this->last_id = set_log($class, $method, $postdata, $auth);
	}

	// customer_login
	public function customer_login(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Customer_model');

	  $respArr = array('status'=>'0','message'=>'Required Fields are empty.');
	  if(!isset($postData['email']) || empty($postData['email']) || 
	     !isset($postData['password']) || empty($postData['password'])){
	      echo json_encode($respArr);exit;
	  }

	  $custResp = $this->Customer_model->checkCustomerLogin($postData);
	  if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '1'){
	     $respArr['data'] = $custResp['data'];
	     $respArr['status'] = '1';
	     $respArr['message'] = 'Success';
	     echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '2'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Invalid Email Address';
	     echo json_encode($respArr);exit;
	  }
	  
	  if($custResp['status'] == '3'){
	     $respArr['status'] = '3';
	     $respArr['message'] = 'Invalid Password';
	     echo json_encode($respArr);exit;
	  }
	  echo json_encode($respArr); exit;
	}

	// customer_forgot_password
	public function customer_forgot_password(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Customer_model');

	  $respArr = array('status'=>'0','message'=>'Required Fields are empty.');
	  if(empty($postData) || !isset($postData['email']) || empty($postData['email'])){
	      echo json_encode($respArr);exit;
	  }

	  $custResp = $this->Customer_model->genCustForgotPassLink($postData);
	  if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '2'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Invalid Email Address';
	     echo json_encode($respArr);exit;
	  }
	  
	  if($custResp['status'] == '1'){
	     /*
	        MAIL SENT CONFIGARATION -- TODO
	     */

	     $respArr['status'] = '1';
	     $respArr['message'] = 'Password Reset Email has been sent';
	  }
	  echo json_encode($respArr); exit;
	}

	// customer_registration
	public function customer_registration(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Customer_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  if(empty($postData)){
	      echo json_encode($respArr);exit;
	  }

	  $err = 0;
	  $msg = '';
	  if(!isset($postData['email']) || empty($postData['email'])){
	     $err = 1;
	     $msg = 'Provide a valid Email ID';
	  } 
	  else if(!isset($postData['password']) || empty($postData['password'])){
	     $err = 1;
	     $msg = 'Provide a Password';
	  }
	  else if(!isset($postData['first_name']) || empty($postData['first_name'])){
	     $err = 1;
	     $msg = 'Provide valid Name';
	  }
	  else if(!isset($postData['last_name']) || empty($postData['last_name'])){
	     $err = 1;
	     $msg = 'Provide valid Name';
	  }

	  if($err == 1){
	     $respArr['message'] = $msg;
	     echo json_encode($respArr);exit;
	  }
	  
	  if(isset($postData['phone']) && empty($postData['phone'])){
	     unset($postData['phone']);
	  }
	  unset($postData['promocode']);

	  $custResp = $this->Customer_model->customer_registration($postData);
	  if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
	      echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '2'){
	     $respArr['status'] = '2';
	     $respArr['message'] = 'Email Address already in use';
	     echo json_encode($respArr);exit;
	  }

	  if($custResp['status'] == '1'){
	     $custResp = $this->Customer_model->checkCustomerLogin($postData);
	     if(empty($custResp) || !isset($custResp['status']) || empty($custResp['status'])){
	         echo json_encode($respArr);exit;
	     }

	     if($custResp['status'] == '1'){
	        $respArr['data'] = $custResp['data'];
	        $respArr['status'] = '1';
	        $respArr['message'] = 'Success';
	        echo json_encode($respArr);exit;
	     }
	  }
	  echo json_encode($respArr); exit;
	}

	// getGeneralIssues
	public function getGeneralIssues(){
	  header('Content-type: application/json');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');
	  $this->load->model('Issue_model');
	  $issue_data = $this->Issue_model->getGeneralIssues();

	  if(!empty($issue_data)){
	     $respArr['status'] = '1';
	     $respArr['message'] = 'Success';
	     $respArr['issue_data'] = $issue_data;
	  }
	  
	  echo json_encode($respArr); exit;
	}

	// getNearByMechanics
	public function getNearByMechanics(){
	  header('Content-type: application/json');
	  $post = file_get_contents("php://input");
	  $postData = json_decode($post, true);
	  $this->load->model('Mechanic_model');

	  $respArr = array('status'=>'0','message'=>'Something went wrong.');

	  $mechanic_data = $this->Mechanic_model->getNearByMechanics($postData);

	  if(!empty($issue_data)){
	     $respArr['status'] = '1';
	     $respArr['message'] = 'Success';
	     $respArr['mechanic_data'] = $mechanic_data;
	  }
	  
	  echo json_encode($respArr); exit;
	}
}
?>
